/*
 * startpcsc.c  - Calls SCardEstablishContext() then SCardReleaseContext
 * in order to prod the pcscd launcher to launch a pcscd -I instance if
 * one is not running for the  specified $DISPLAY
 *
 * This  primarily to ensure that the USB readers are fully enumerated
 * prior to invoking an application that needs to see all readers
 * present immediately at start-up.
 */ 
#include <stdio.h>
#include <stdlib.h>
#include "winscard.h"

int main(int argc, char **argv) 
{

	SCARDCONTEXT ctx;
	LONG rv;

	rv = SCardEstablishContext(SCARD_SCOPE_SYSTEM, NULL, NULL, &ctx);
	if (rv != SCARD_S_SUCCESS) {
		fprintf(stderr, "Error from SCardEstablishContext(): %s\n",
			pcsc_stringify_error(rv));
		exit(-1);
	}

	rv = SCardReleaseContext(ctx);
	if (rv != SCARD_S_SUCCESS) {
		fprintf(stderr, "Error from SCardReleaseContext(): %s\n",
			pcsc_stringify_error(rv));
		exit(-1);
	}

	sleep(5);
	exit(0);
}
