/*
 * rdrlist.c - auto-refreshing displays of current list of 
 * PC/SC lite readers vi SCardListReaders() call.
 *
 * Note: Uses VT100-compatible escape sequences
 */
#include <stdio.h>
#include <pcsclite.h>
#include <winscard.h>
#include <thread.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <sys/varargs.h>
#include <unistd.h>
#include <signal.h>
#include <strings.h>

SCARDCONTEXT ctx;
LPSTR readersList, reader;
DWORD readersLen;
int rv;
char *cp;
unsigned long readerlen = 256;

char *spin = "|/-\\";

void
chk(int rv, char *msg) 
{
	if (rv != SCARD_S_SUCCESS) {
		printf("%s error: %s\n", msg, pcsc_stringify_error(rv));
		exit(-1);
	}
}

int main(int argc, char **argv) {
int i = 0;
	
	chk(rv = SCardEstablishContext(SCARD_SCOPE_SYSTEM, 0, 0, &ctx),
		"SCardEstablishContext");

	printf("\033[H\033[J");
	for(;;) {
		chk(rv = SCardListReaders(ctx, 0, 0, &readersLen),
			"SCardListReaders");
	
		readersList = malloc(readersLen);
//		bzero(readersList, readersLen);

		if (readersList == NULL) {
			fprintf(stderr, "Out of memory in malloc()\n");
			exit(-1);
		}

		chk(rv = SCardListReaders(ctx, 0, readersList, &readersLen),
			"SCardListReaders");
	
		reader = readersList;	
		printf("\033[H\033[JCurrent reader list: %c\n\n", spin[i++ % 4]);
		while (strlen(reader) > 0) {
			printf("  %s\n", reader);
			reader += (strlen(reader) + 1);
		}
		free(readersList);
		usleep(100000);
	}
}
