/*
 * librdrselect.c 
 *
 * Interposes on PC/SC lite SCardListReaders() function allowing
 * a single reader to be extracted from a list of readers
 * and passed to the invoking application.
 *
 * A single reader can be selected using an index into the 
 * list of readers (zero based) specified via the -n flag.
 *
 * Alternatively one or more readers can be filtered out of
 * the main list using a regular expression via the -r flag.
 */

void regerr();

#define INIT            char *sp = instring;
#define GETC()          (*sp++)
#define PEEKC()         (*sp)
#define UNGETC(c)       (--sp);
#define RETURN(c)       return(c);
#define ERROR(val)      regerr();

extern char *loc1, *loc2, *locs;

#include <regexp.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <errno.h>
#include "pcsclite.h"

#define RDRNBR 0
#define REGEXP 1

int type, rdrnbr, verbose;
char *regexp, *cp;
LONG rv;

#define SETUP(f) \
   static LONG (*_##f)();\
   if (_##f == NULL) { \
           _##f = (LONG(*)())dlsym(RTLD_NEXT, #f); \
           if (_##f == NULL) { \
                   fprintf(stderr, \
                      "INTERPOSER: " #f "(): \n%s\n", dlerror()); \
                   exit(-1);\
           } \
	   if (strstr(getenv("LIBRDRSELECT"), "-v") != NULL) \
		   printf("librdrselect.so.1 loaded\n"); \
   }\

void
usage() {
	fprintf(stderr, "librdrselect.so: env var $LIBRDRSELECT un`defined\n");
        fprintf(stderr, "Usage: LIBRDRSELECT [-v] {-n <rdr#> | -r <regex> }\n");
        fprintf(stderr, "    -n <rdrnbr>     Zero based index of reader to selectt\n");
        fprintf(stderr, "    -r <regex>      Regular expression to match on\n");
	fprintf(stderr, "                    (optionally quoted with '/ /'");
	fprintf(stderr, "    -v              verbose (log matched readers)\n");
}

void 
regerr(char *val) {
	fprintf(stderr, "%s\n", val);
	return;
}

int
getInputArgs() {
        char buf[80];
        static char *argv[256];
        int i, j = 0, argc = 0, quotemode = 0, c;
        char *args = getenv("LIBRDRSELECT");
        bzero(buf, 80);
        argv[argc++] =  "librdrselect";

        if (args == NULL) {
		usage();
		return -1;
	}

        for (i = 0;i < strlen(args);i++) {
                if (args[i] == '/') {
                        if (quotemode)
                                quotemode = 0;
                        else
                                quotemode = 1;
                } if (args[i] == ' ' && !quotemode) {
                        argv[argc++] = strdup(buf);
                        bzero(buf, 80);
                        j = 0;
                } else {
                        buf[j++] = args[i];
                }
        }
        argv[argc++] = strdup(buf);
        optind = 1;
        while((c = getopt(argc, argv, "n:r:v")) != -1) {
                switch(c) {
                case 'n':
			type = RDRNBR;
                        rdrnbr = atoi(optarg);
                        break;
                case 'r':
			type = REGEXP;
			regexp = strdup(optarg);
                        break;
		case 'v':
			verbose = 1;
			break;
		default:
			usage();
			return -1;
                }
        }
}


LONG SCardListReaders(SCARDCONTEXT hContext, LPCSTR mszGroups,
	LPSTR mszReaders, LPDWORD pcchReaders)
{
	char *cp;
	static char tmpReaders[4096];
	char rg[256];
	static char readers[10][128];
	int i, rdrcnt = 0, which;

	
	SETUP(SCardListReaders);
	getInputArgs();
	bzero(readers, sizeof(readers));
	bzero(tmpReaders, sizeof(tmpReaders));
	rv = _SCardListReaders(hContext, mszGroups, tmpReaders, pcchReaders);
	if (mszReaders == NULL)
		return rv;

	cp = tmpReaders;
	while(*cp != '\0') {
		strcpy(readers[rdrcnt++], cp);
		cp += strlen(cp) + 1;
	}

	switch(type) {
	case RDRNBR:
		strcpy(mszReaders, readers[rdrnbr]);	
		if (verbose)
			printf("%s\n", readers[rdrnbr]);
		break;
	case REGEXP:
		(void) compile(regexp, rg, &rg[1024], '\0');
		cp = mszReaders;
		for(i = 0; i < rdrcnt; i++) {
			if (step(readers[i], rg)) {
				if (verbose)
					printf("+%s\n", readers[i]);
				strcpy(cp, readers[i]);	
				cp += strlen(cp) + 1;
			} else {
				if (verbose)
					printf("-%s\n", readers[i]);
			}
		}		
		break;
	}
	*pcchReaders = strlen(mszReaders) + 1;

	cp = mszReaders;
	return rv;
}

