/*
 * libregression.c 
 *
 * Interposes on PC/SC lite SCardStatus() function and emulates
 * broken behavior with regard to improper *pdwState values
 * being returned by earlier versions of PCSClite, because
 * unfortunately, some applications depend on that broken behavior.
 */

#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <errno.h>
#include "pcsclite.h"
#include <strings.h>

void *targetlib;
char *cp;
LONG rv;

#define SETUP(f) \
   static LONG (*_##f)();\
   if (_##f == NULL) { \
           if (targetlib != NULL) \
                   _##f = (LONG(*)())dlsym(targetlib, #f); \
           else \
                   _##f = (LONG(*)())dlsym(RTLD_NEXT, #f); \
           if (_##f == NULL) { \
                   fprintf(stderr, \
                      "INTERPOSER: " #f "(): \n%s\n", dlerror()); \
                   exit(-1);\
           } \
   }\


LONG SCardStatus(
   SCARDHANDLE hCard, LPSTR mszReaderNames, LPDWORD pcchReaderLen,
   LPDWORD pdwState, LPDWORD pdwProtocol, LPBYTE pbAtr, LPDWORD pcbAtrLen)
{
   LPDWORD origReaderLen = pcchReaderLen;
   LPSTR origReaderNames = mszReaderNames;

   SETUP(SCardStatus)
	
   rv = _SCardStatus(hCard, mszReaderNames, pcchReaderLen, pdwState, 
   	pdwProtocol, pbAtr, pcbAtrLen);

   if (/*rv == SCARD_S_SUCCESS && */
       (origReaderLen == 0 || origReaderNames == NULL)) {
	*pcbAtrLen = 0;
	*pdwState = 0;
 	*pdwProtocol = 0; 
   }
   return rv;
}
