#include <stdio.h>
#include <pcsclite.h>
#include <winscard.h>
#include <thread.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include <sys/varargs.h>
#include <unistd.h>
#include <signal.h>
#include <strings.h>

SCARDCONTEXT ctx;
SCARDHANDLE card;
DWORD protocol;
LPSTR rdrsList, reader;
DWORD rdrsLen;
char *pcReaders;
int i, rv;
char *cp;
unsigned long pdwState, prot, atrlen = MAX_ATR_SIZE, readerlen = 256;
unsigned char atr[MAX_ATR_SIZE];
char *spin = "|/-\\";

void
chk(int rv, char *msg) 
{
	if (rv != SCARD_S_SUCCESS)
		printf("%s error: %s\n", msg, pcsc_stringify_error(rv));

}

void 
ctrl_c(int signum) 
{
	printf("Control C pressed \n");
	printf("Exiting...\n");
	chk(rv = SCardDisconnect(card, SCARD_LEAVE_CARD), "SCardDisconnect");
//	chk(rv = SCardEndTransaction(card, SCARD_LEAVE_CARD), "SCardEndTransaction");
	chk(rv = SCardReleaseContext(ctx), "SCardReleaseContext");
	exit(-1);
}


void usage(char *name) {
	fprintf(stderr, "%s [-n] [-? | -h]\n", name);
	fprintf(stderr, "   -n  = Force null reader list into SCardStatus\n");
	fprintf(stderr, "   -?  = Display usage\n");	
	exit(-1);
}

int main(int argc, char **argv) {
	uint k = 0;
	unsigned long len = 0;
	int nullreaderlist = 0;
	int refreshmode = 1;
	char keywords[256];
	int c;
	pcReaders = malloc(256);

	while((c = getopt(argc, argv, ":nx?h")) != -1) {
		switch(c) {
		case 'x':
			refreshmode = 0;
			break;
		case 'n':
			nullreaderlist = 1;
			break;
		case '?':
		case 'h':
			usage(argv[0]);
			break;
		}	
	}
	signal(SIGINT, ctrl_c);
	
	chk(rv = SCardEstablishContext(SCARD_SCOPE_SYSTEM, 0, 0, &ctx),
		"SCardEstablishContext");
	
	chk(rv = SCardListReaders(ctx, 0, 0, &rdrsLen), "SCardListReaders");
	
	if ((rdrsList = malloc(rdrsLen)) == NULL) {
		fprintf(stderr, "Out of memory in malloc()\n");
		exit(-1);
	}

	chk(rv = SCardListReaders(ctx, 0, rdrsList, &rdrsLen),
		"SCardListReaders");
	
	reader = rdrsList;	
	chk(rv = SCardConnect(ctx, reader, SCARD_SHARE_SHARED,
		SCARD_PROTOCOL_ANY, &card, &protocol), "SCardConnect");

	chk(rv = SCardBeginTransaction(card), "SCardBeginTransaction");

	for(;;) {
//		len = 0;
		if (nullreaderlist)  {
			rv = SCardStatus(card, NULL, &len, &pdwState,
				&prot, atr, &atrlen);
		} else {
			rv = SCardStatus(card, pcReaders, &len, &pdwState, 
				&prot, atr, &atrlen);
		}
		if (refreshmode)
			printf("\033[H\033[J");
		printf("SCardStatus() results: %c\n", spin[k++ % 4]);
		printf(" retval:  %8.8x : %s\n", rv, pcsc_stringify_error(rv));
		strcpy(keywords, "");
		if (pdwState & SCARD_ABSENT)
			strcat(keywords, "ABSENT ");
		if (pdwState & SCARD_PRESENT)
			strcat(keywords, "PRESENT ");
		if (pdwState & SCARD_SWALLOWED)
			strcat(keywords, "SWALLOWED ");
		if (pdwState & SCARD_POWERED)
			strcat(keywords, "POWERED ");
		if (pdwState & SCARD_NEGOTIABLE)
			strcat(keywords, "NEGOTIABLE ");
		if (pdwState & SCARD_SPECIFIC)
			strcat(keywords, "SPECIFIC ");
		printf(" *pdwState:    0x%.4lx (%s)\n", pdwState, keywords);
		printf(" *pdwProtocol: T=%ld\n", prot);
		printf(" ATR len: %d\n ATR:", atrlen);
		for (i = 0; i < atrlen; i++) {
			printf("%02X ", atr[i]);
			if (i != 0 && i % 16 == 0)
				printf("\n     ");
		}
		usleep(100000);
	}
}
