#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               create_package.sh
## Application Name:     IT S9 Migration Tools
#
## Author:       BG
## Date Created: 17-NOV-2002
#
## General Description(Purpose): This script makes the package from
#     your base directory
#
## Usage:   create_package.sh
#
## Required Parameters: N/A
## Optional Parameters: N/A
########################################################################


l_prog_name="`whence $0`"
l_pkg_name="ITSMs9mig"
l_pkg_full_name="${l_pkg_name}.pkg"
l_work_dir="`pwd`/"
l_toc="$l_work_dir/toc"
l_spool_dir="/tmp/spool_pkg.`/usr/xpg4/bin/id -un`/"

make_package()
{
  test -d ${l_spool_dir} || mkdir ${l_spool_dir}
  if [ -d "${l_spool_dir}${l_pkg_name}" ]
  then
      /bin/rm -rf ${l_spool_dir}${l_pkg_name}
      if [ $? -ne 0 ]
      then
          echo " ERROR: Failed to remove ${l_spool_dir}${l_pkg_name}"
          exit 1
      fi
  fi

  if [ -f "${l_work_dir}${l_pkg_full_name}" ]
  then
      /bin/rm -rf ${l_work_dir}${l_pkg_full_name}
      if [ $? -ne 0 ]
      then
           echo " ERROR: Failed to remove ${l_work_dir}${l_pkg_full_name}" 
           exit 1
      fi
  fi

  # Create package map

  if [ -d "${l_base_dir}" ]
  then
      PSTAMP="$(TZ=PST9PDT ; date +'%Y%m%d%H%M%S')"
      /bin/pkgmk -d ${l_spool_dir} -b "${l_base_dir}" \
          -f ${l_base_dir}/tools/prototype -p "$PSTAMP" > /dev/null 
      l_rc=$?
      if [ $l_rc -eq 0 ]
      then
          echo "INFO: sucessfully created pkgmap for ${l_pkg_name}"
      else
          echo "ERROR: Failed to create pkgmap for ${l_pkg_name} [${l_rc}], exiting"
          /bin/rm -rf ${l_spool_dir}${l_pkg_name}
          exit 1
      fi
  else
      echo "ERROR: Directory ${l_base_dir} doesnot exists, exiting"
      exit 1
  fi

  #Translate package

  if [ -d "${l_work_dir}" -a -d "${l_spool_dir}" ]
  then
      /bin/pkgtrans -s ${l_spool_dir} \
          ${l_work_dir}${l_pkg_full_name} ${l_pkg_name} > /dev/null #2>&1
      l_rc=$?
      /bin/rm -rf ${l_spool_dir}${l_pkg_name}
      if [ $l_rc -eq 0 ]
      then
          echo "INFO: sucessfully created package ${l_pkg_full_name}"
      else
          echo "ERROR: Failed to create package ${l_pkg_full_name} [${l_rc}]"
          exit 1
      fi
  else
       echo "ERROR: work directory ${l_work_dir} not found"
       exit 1
  fi


}


# main

if test ! -f "${l_work_dir}tools/prototype"
then
    echo "ERROR: You must be in your working directory to run this script."
    exit 1
fi

l_pkg_info="$l_base_dir/$l_pkg_name/pkginfo"

l_base_tmp="`dirname $l_prog_name`"
l_base_tmp="`dirname ${l_base_tmp}`"

print "Enter Base directory for Source <default=${l_base_tmp}> ? \c"
read l_answer
if [ -z "$l_answer" ]
then
   l_base_dir="${l_base_tmp}"
else
   l_base_dir="${l_answer}"
fi

if [ ! -a "${l_base_dir}/${l_pkg_name}" ]
then
    (cd ${l_base_dir}; ln -s . ${l_base_dir}/${l_pkg_name})
fi

make_package
/bin/rm -rf ${l_base_dir}/${l_pkg_name} ${l_spool_dir}

exit 0
