#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               s9_premigration_install.sh
## Application Name:     IT S9 Migration Tools
#
## Author:        CH
## Date Created:  28-OCT-2002
#
## General Description(Purpose): 
#  	This script is the installer for premigration module.
#       Called from s9_premigration.sh module and will install
#       Live Upgrade Software and patches if needed.
#
## Usage:	Called from s9_premigration.sh.
#		s9_premigration_install.sh
#
## Required Parameters:   N/A
#
## Optional Parameters:   N/A
## Return Codes:          0 or 1
#
## Possible Points of Failure: This script could fail if the
#  steps associated in documents are not followed.
#
## Modification History:
#  -------------------------------------------------------------
#  Date           Name                     Comments
#  -------------------------------------------------------------
#  18-FEB-2003    CH            Updated patch install function
#  16-JAN-2003    CH            Unix cmd paths
#  09-JAN-2003    CH            Note on patch installation
#  08-JAN-2003    CH            Error logging RFE's
#  28-OCT-2002    CH            Initial Creation
#######################################################################

unalias rm
l_script_name=`basename $0 .sh`
l_pkg_dir="/opt"
l_search_file="/tmp/PATCH_Search"
l_s_env_file="${l_pkg_dir}/${p_pkg_name}/etc/set_migration_env"
l_g_env_file="${l_pkg_dir}/${p_pkg_name}/etc/set_prepare_env"
l_d_env_file="${l_pkg_dir}/${p_pkg_name}/etc/s9_`hostname`_env"
PATH="/usr/bin:/usr/sbin:${PATH}:${l_pkg_dir}/${p_pkg_name}/bin"
DATE="/usr/bin/date +%Y%m%d_%T"

#Verify for existence

if [ -x ${l_s_env_file} ]
then
    . ${l_s_env_file}
else
    echo "\n------------------------------------------------------------------------"
    echo "[`${DATE}`] ERROR: ${l_s_env_file} does not exist, exiting"
    exit 1
fi

if [ -x ${l_g_env_file} ]
then
    . ${l_g_env_file}
else
    echo "\n------------------------------------------------------------------------"
    echo "[`${DATE}`] ERROR: ${l_g_env_file} does not exist, exiting"
    exit 1
fi

if [ -f ${l_d_env_file} ]
then
    . ${l_d_env_file}
else
    echo "\n------------------------------------------------------------------------"
    echo "[`${DATE}`] ERROR: ${l_d_env_file} does not exist, exiting"
    exit 1
fi

Print_MSG START ${l_script_name}


patch_search()
{

  l_find=${1}

  if [[ ! -z ${l_find} ]]
  then
      l_check_patch=`echo ${l_find} | /usr/bin/cut -f1 -d '-'`
      l_check_patchrev=`echo ${l_find} | /usr/bin/cut -f2 -d '-'`
  else
      Print_MSG ERROR "No argument for patch search supplied."
      echo "  Contact S9 Support for further assistance."
      exit 1
  fi

  #Search for alternate patches in both ai3 server and default patch location 

  Print_MSG INFO "PATCH_Search is looking for an alternate patch . . .\n"

  l_dir_switch=start
 

  if [[ ${l_dir_switch} = "start" ]]
   then
       l_ptch_loc="${p_ossw_ptch_loc}"
       do_search
  fi
   
  if [[ ${l_dir_switch} != "done" ]]
  then
      l_ptch_loc="${p_default_ptch_loc}"
      do_search
  fi

  #After finding a usuable patch, make sure the rev is not to low
  if [[ ! -z ${l_found_it} ]]
  then
      if [[ ! -z ${l_found_patchrev} && ${l_found_patchrev} -gt ${l_check_patchrev} ]]
      then
          Print_MSG WARNING "PATCH_Search found newer patch rev for ${l_check_patch}."
          echo "  Revsion [-${l_found_patchrev}] will be installed."
          echo "  Please report this newer patch revision to the ITSM-PAR S9 Support Team\n"
          patch_install "${l_found_it}"
      elif [[ ! -z ${l_found_patchrev} && ${l_found_patchrev} -eq ${l_check_patchrev} ]]
      then
          Print_MSG INFO "PATCH_Search found same patch rev for ${l_check_patch}."
          echo "  Revsion [-${l_found_patchrev}] will be installed."
          patch_install "${l_found_it}"
      elif [[ ! -z ${l_found_patchrev} && ${l_found_patchrev} -lt ${l_check_patchrev} ]]
      then
      echo "[`${DATE}`] ERROR: PATCH_Search only found older revision for ${l_check_patch} [-${l_found_patchrev}]"
      Print_MSG ERROR "Please install latest patch revision manually"
      exit 1
      fi
  else
      echo "[`${DATE}`] ERROR: PATCH_Search could not find alternate patch for ${l_check_patch}."
      Print_MSG ERROR "Patch ${l_check_patch} not installed, please install manually"
      exit 1
  fi


}

do_search()

{
  let a=1
  l_search=FALSE
  let l_max_num=100

  # Re-initilize before each location search
  l_found_it=""
  l_found_patchrev=""
  /usr/bin/cp /dev/null ${l_search_file}

  until [[ ${a} -eq ${l_max_num} ]]
  do

    if [[ ${a} = [0-9] ]]
    then
        l_searchrev=0${a}
    else
        l_searchrev=${a}
    fi
    
    if [[ -f ${l_ptch_loc}/${l_check_patch}-${l_searchrev} || \
          -d ${l_ptch_loc}/${l_check_patch}-${l_searchrev} ]]
    then
        echo ${l_ptch_loc}/${l_check_patch}-${l_searchrev} >> ${l_search_file}
    fi
    let a=a+1
  done

  #Make sure that the AI patch location has a higher rev, if not keep searching
  if [[ -s ${l_search_file} ]]
  then
      l_found_it=`/usr/bin/cat ${l_search_file} | /usr/bin/sort -n | /usr/bin/tail -1`
      l_found_patchrev=`echo ${l_found_it} | cut -f2 -d '-'`

      if [[ ! -z ${l_found_patchrev} && ${l_found_patchrev} -ge ${l_check_patchrev} ]]
      then
          l_dir_switch=done 
      fi
  fi
}

check_error()
{
  l_c=`expr $1 + 0`
  l_s=$2
  l_s_desc=`echo ${l_s} |cut -f1,2 -d " "`
  if [ ${l_c} -ne "0" ]
  then
      if [[ ${l_c} -eq "8" && ${l_s_desc} =  "Installing Patch" ]] 
#  permissbile error from /usr/sbin/patchadd
      then
          continue
      else
          Print_MSG ERROR "Problem ${l_s}"
          exit 1
      fi
  fi
}


patch_install()
{

  l_patch=$1

  if [[ -f ${l_patch}.tar.Z ]]
  then
      rm -r /tmp/${l_apatch} > /dev/null 2>&1
      cd /tmp ; /usr/bin/zcat "${l_patch}.tar.Z"  | /usr/sbin/tar xvfp - 
      Print_MSG INFO "Installing patch ${l_patch}\n"
      /usr/sbin/patchadd /tmp/${l_apatch} 
      check_error $? "Installing Patch ${l_patch}"

   elif [[ -d ${l_patch} ]]
   then
       Print_MSG INFO "Installing patch ${l_patch}\n"
       cd /tmp ; /usr/sbin/patchadd ${l_patch} 
       check_error $? "Installing Patch ${l_patch}"

   else
      echo "[`${DATE}`] ERROR: Cannot find file or location for patch ${l_patch}."
      Print_MSG ERROR "Patch ${l_check_patch} not installed, please install manually"
      exit 1
   fi
}

package_remove()
{
  l_remove_pkg=$1
  l_pkg_check=`/usr/bin/pkginfo ${l_remove_pkg} | /usr/bin/awk '{print $2}'`
 
  
if [[ ${l_remove_pkg} = ${l_pkg_check} ]]
then
/usr/sbin/pkgrm -a ${p_etc_dir}/s9_adminfile ${l_remove_pkg} <<xEOF 2>&1 
y
xEOF
check_error $? "Remove Package ${l_remove_pkg}"
else
Print_MSG WARNING "Package ${l_remove_pkg} is not present"
fi
}

package_install()
{
  l_package=$1

  if [[ -d ${p_ossw_prdt_loc}/${l_package} ]]
  then
      /usr/sbin/pkgadd -d ${p_ossw_prdt_loc} -a ${p_etc_dir}/s9_adminfile ${l_package} 2>&1
      check_error $? "Installing Package ${l_package}"
  else
      Print_MSG ERROR "Cannot find location for package ${l_package}"
      exit 1
   fi
}

#Step - 1 Install Patches

  l_step_name="PATCH_INSTALL"

  Print_MSG BEGIN ${l_step_name}

  if [[ ! -z ${p_lupatch} ]]
  then

      Print_MSG INFO "ATTENTION!! ATTENTION !!"
      echo ""
      echo "  The S9 Migration Process will only install patches required by the Live Upgrade Software"
      echo "  Please address any errors that result from missing patch or pakcages requirements manually"
      echo ""
      echo "  After correcting the error, please refer to the S9 Migration Process Guide document"
      echo "  for instructions on re-running the s9_premigration step"
      echo ""
      sleep 2

      for l_apatch in ${p_lupatch}
      do
          if  [ -f "${p_ossw_ptch_loc}/${l_apatch}.tar.Z" -o -d "${p_ossw_ptch_loc}/${l_apatch}" ]
          then
              patch_install "${p_ossw_ptch_loc}/${l_apatch}"
          elif [ -f "${p_default_ptch_loc}/${l_apatch}.tar.Z" -o -d "${p_default_ptch_loc}/${l_apatch}" ]
          then  
              Print_MSG INFO "Patch ${l_apatch} Not found in selected location. Installing from central location."
              patch_install "${p_default_ptch_loc}/${l_apatch}"
          else
              Print_MSG WARNING "Patch ${l_apatch} is not available."
              echo "  Will now invoke PATCH_search to look for an alternate patch."
              patch_search ${l_apatch}
          fi
     done
  else
      Print_MSG INFO "There are no live upgrade patches required"
      sleep 2
  fi

  Print_MSG END ${l_step_name}

#Step - 2 Remove Packages

  l_step_name="VERIFY_LU_VERSION"

  Print_MSG BEGIN ${l_step_name}

  if [[ ! -z ${p_lupkgremove} ]]
  then
      Print_MSG INFO "Will remove older version of Live Upgrade Software"
      for l_aversion in ${p_lupkgremove}
      do
        package_remove ${l_aversion}
      done
  fi
  Print_MSG END ${l_step_name}

#Step - 3 Install Packages

  l_step_name="PACKAGE_INSTALL"

  Print_MSG BEGIN ${l_step_name}

  if [[ ! -z ${p_lupkginstall} ]]
  then
      Print_MSG INFO "Will install ${l_lu_pkg_version} version of Live Upgrade Software"
      for l_apackage in ${p_lupkginstall}
      do
        package_install ${l_apackage}
      done
  else
      Print_MSG INFO "There are no live upgrade packages required"
      sleep 2
  fi
  Print_MSG END ${l_step_name}

  Print_MSG FINISH "${l_script_name}"
  exit 0
