#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               s9_premigration.sh
## Application Name:     IT S9 Migration Tools
#
## Author:        CH
## Date Created:  28-OCT-2002
#
## General Description(Purpose): 
#	This script will validate the default environment setting
#  and the minimum system requirements and prompt the input of needed
#  S9 software loc/patch file loc/flash archive file loc. Then, install
#  the package and patch required if needed.  It will prompt for target
#  disk for S9 boot environment and break the mirror. Then, either
#  automatically or manually partition the disk to complete the module.
#
## Usage: This script must called by running Run_S9_migration_process.sh
#         Run_S9_migration_process.sh s9_premigration
#
## Required Parameters:   N/A 
#                         
## Optional Parameters:   N/A
## Return Codes:          0 or 1
#
## Possible Points of Failure: This script could fail if the
#  steps associated in documents are not followed.
#
## Modification History:
#  -------------------------------------------------------------
#  Date           Name                     Comments
#  -------------------------------------------------------------
#  28-FEB-2003	  SG			Removed VERSION hardcoding
#  17-FEB-2003    CH			Updated error logging
#  17-JAN-2003    CS			Mod to save of variables
#  16-JAN-2003    CH			Unix cmd paths
#  10-JAN-2003    CS			Save additional path variables to dynamic env
#  10-JAN-2003    CH			Error logging RFE's
#  28-OCT-2002    CH			Initial Creation
#######################################################################

l_status=""

if [[ -f "${p_etc_dir}/set_migration_env" ]]
then
    . ${p_etc_dir}/set_migration_env
else
      echo "ERROR: Env file [set_migration_env] not found! Exiting ..."
      exit 1
fi

clean_up()
{
  Print_MSG INFO "Auto Reset of Environment"

  l_clean_date="/usr/bin/date +%d%b20%y.%H%M%S"
  /usr/bin/rm -f ${p_etc_dir}/s9_`hostname`_env
  /usr/bin/rm -f /tmp/RUNS9*
}
check_migration_running()
{
    if [ $(ps -ef | /usr/bin/grep *premigration* | /usr/bin/grep -v grep | wc -l) -gt 0 ]
    then
        echo "\n*** ERROR: Pre-Upgrade and Valiadation Running for `/usr/bin/uname -n`, exiting ...\n"
        ps -ef | /usr/bin/grep *premigration* | /usr/bin/grep -v grep
        footer error

    fi
}

check_args()
{
  Print_MSG INFO "Checking default parameters"

  if [[ ! -d ${p_flash_loc} ]]
  then
     Print_MSG ERROR "${p_flash_loc} directory not found"
     l_status="error"
  fi

  if [[ ! -d ${p_ossw_loc} ]]
  then
      Print_MSG ERROR "${p_ossw_loc} directory not found"
      l_status="error"
  fi

  if [[ ! -d ${p_ossw_prdt_loc} ]]
  then
     Print_MSG ERROR "${p_ossw_prdt_loc} directory not found"
     l_status="error"
  fi

  if [[ ! -d ${p_ossw_ptch_loc} ]]
  then
     Print_MSG ERROR "${p_ossw_ptch_loc} directory not found"
     l_status="error"
  fi

  if [[ ${l_status} = "error" ]]
  then
     Print_MSG ERROR "Some of the validations have failed, exiting"
     footer error
  fi

}

signal()
{
  l_signal_flag=$(($1+0))

  if [[ ${l_signal_flag} -eq 1 ]]
  then
      set_var ${l_signal_flag}
  fi   
}

custom_config()
{

/usr/bin/cp /dev/null ${p_d_env_file}
if [[ -f ${p_d_env_file} ]]
then
    echo "###############################################" >> ${p_d_env_file}
    echo "## Custom Config File"                           >> ${p_d_env_file}
    echo "## Created: [`date '+%Y%m%d_%T'`]"               >> ${p_d_env_file}
    echo "###############################################\n" >> ${p_d_env_file}

    #Save sw/flash path variables in s9_premigration
    echo "p_ossw_loc=${p_ossw_loc}" >> ${p_d_env_file}
    echo "p_ossw_ptch_loc=${p_ossw_ptch_loc}" >> ${p_d_env_file}
    echo "p_flash_loc=${p_flash_loc}" >> ${p_d_env_file}
else
    Print_MSG ERROR "Can not create env file [${p_d_env_file}]"
    footer error
fi
}

pre_note()
{

  Print_MSG INFO "ATTENTION!! ATTENTION !!"
  echo "YOU ARE BEGINNING THE PRE-VALIDATION STEPS FOR THE S9 MIGRATION PROCESS"
  echo "PLEASE BE SURE YOU ARE FAMILIAR WITH THE AUTOMATED STEPS IN THIS VERSION.\n"

  echo "`/bin/pkginfo -l ${p_pkg_name} |/usr/bin/grep VERSION`"
  echo "`/bin/pkginfo -l ${p_pkg_name} |/usr/bin/grep INSTDATE`"
  
  echo "\nWould you like to continue, [y/n]"
  echo "Hit enter to accept default <n> \c"
  read l_response
  Print_RSP ${l_response}
 
  l_answer=`echo ${l_response} |tr "[A-Z]" "[a-z]"`

  case ${l_answer} in

  # Affirm
  'y'|'yes') echo "\nBegining Validation";;

  # Terminate
   'n'|'no') echo "\nExecution terminated"; footer kil;;

 # Invalid
         *) echo "\ninvalid choice \"$l_answer\"."; footer error;;
  esac
}

set_var()
{
   l_cp=$1

   case ${l_cp} in
   # Success
       0) l_var="Y" ;;
   #Error
       1) l_var="N" ;; 
   esac

  if [[ ${l_var} = "Y" ]]
  then
      echo "export p_premig_flag=\"${l_var}\"" >> ${p_d_env_file}
      footer success
  elif [[ ${l_var} = "N" ]]
  then
      echo "export p_premig_flag=\"${l_var}\"" >> ${p_d_env_file}
      footer error
  else
      Print_MSG ERROR "Setting premigration sequence flag in ${p_d_env_file}"
      footer error
  fi

}

show_greeting()
{
  Print_MSG INFO "PRE-MIGRATION SCRIPT WILL DO THE FOLLOWING:"
  echo " step 1: Validate Target Environment"
  echo " step 2: Install Live Upgrade Packages or Patches"
  echo " step 3: Auto Format Target Disk"
  echo " step 4: Record Key Variables"
  sleep 2
}

save_env()
{

  l_select=FALSE

# Get previous disk value

  if [[ ! -z "${p_alt_be_disk}" ]]
  then 
     l_be_disk_reuse=${p_alt_be_disk}
     l_select=TRUE
  fi

# Get previous sequence flags 

  if [[ ! -z "${p_premig_flag}" ]]
  then
     if [[ ${p_premig_flag} = "Y" ]]
     then
         l_premig_status=complete
     else
        l_premig_status=error
     fi
  else
     l_premig_status=pending
  fi

  if [[ ! -z "${p_mig_flag}" ]]
  then
     if [[ ${p_mig_flag} = "Y" ]]
     then
         l_mig_status=complete
     else
         l_mig_status=error
     fi
  else
     l_mig_status=pending
  fi

  if [[ ! -z "${p_postmig_flag}" ]]
  then
     if [[ ${p_postmig_flag} = "Y" ]]
     then
         l_postmig_status=pending
     else
         l_postmig_status=error
     fi
  else
    l_postmig_status=pending
  fi

}
reuse_desc()
{
 Print_MSG INFO "ATTENTION!! ATTENTION !!"
 
  print "The following s9_migration_process modules have been run previously\n"
  printf "seq#%2smodule-name%6sstatus%7sreset_required%12s\n"
  printf "-----%1s---------------%2s-----------%2s---------------\n"


  if [[ ${l_premig_status} = "complete" ]]
  then
      l_reset="Auto"
  else
      l_reset="Auto"
  fi
  printf "%-6d%-17s%-9s%13s%12s\n\n" 1 s9_premigration  ${l_premig_status} ${l_reset}
  
  if [[ ${l_mig_status} = "complete" ]]
  then
      l_reset="Yes"
  else
      l_reset="No"
  fi
  printf "%-6d%-17s%-9s%13s%12s\n\n" 2 s9_migration  ${l_mig_status} ${l_reset}

  if [[ ${l_postmig_status} = "complete" ]]
  then
      l_reset="Yes"
  else
      l_reset="No"
  fi
  printf "%-6d%-17s%-9s%13s%12s\n\n" 3 s9_postmigration  ${l_postmig_status} ${l_reset}

  echo "--------------------------------------------------"
}

footer()
{
  l_type=$1

  if [[ ${l_type} = "error" ]]
  then
      Print_MSG ERROR "ATTENTION - - ${p_script_name} was Unsuccessful"
      echo "  Please refer to the S9 Migration Process Guide document"
      echo "  for instructions on re-running the ${p_script_name} process"
      echo ""
      exit 1

  elif [[ ${l_type} = "kill" ]]
  then
      Print_MSG ERROR "ATTENTION - - ${p_script_name} was Terminated"
      echo "  Please refer to the S9 Migration Process Guide document"
      echo "  for instructions on re-running the ${p_script_name} process" 
      echo ""
      exit 1

  else
      Print_MSG FINISH 
      exit 0

  fi
}

main_processing()
{

# -- show greeting
        show_greeting

# -- check args
        check_args

# -- create config
        custom_config

# -- run validation
        ${p_bin_dir}/s9_premigration_prepare.sh 
        signal $?

# -- run live migration upgrade/install
  if [[ ${l_signal_flag} = 2 ]]
   then
        ${p_bin_dir}/s9_premigration_install.sh 
        signal $? 
  fi

# -- run disk main
     ${p_bin_dir}/s9_osdisk.sh ${l_be_disk_reuse}
     signal $?

# -- set success variable
     set_var 0 

}

#################################
#Main shell execution starts here
#################################


pre_note

Print_MSG START ${p_script_name}

if [[ -f ${p_d_env_file} ]]
then
    save_env 
fi

clean_up
main_processing
exit 0
