#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               s9_postmigration.sh
## Application Name:     IT S9 Migration Tools
#
## Author:              TY
## Date Created:        12-Nov-2002
#
## General Description(Purpose):
#       This script should be run after S9 migration and will do
#       OS validation and report the difference between current
#       booting environment and alternate booting environment(s9)
#       It also will sync up the init.d and rc directory from
#       current booting environment to alternate booting environment(s9)
#
## Usage: This script is called from the wrapper
#         Run_S9_migration_process.sh s9_postmigration
#
## Required Parameters:         N/A
## Optional Parameters:         N/A
## Return Codes:
#               0 if successfully run to completion
#               >1 if errors occur
#
## Possible Points of Failure:
#
## Modification History:
#  -------------------------------------------------------------
#  Date         Name                    Comments
#  -------------------------------------------------------------
#  12-NOV-2002  TY                      Initial creation
#  27-NOV-2002  TY 			Use nawk to parse the lucompare
#					output
#  03-DEC-2002 	TY			Consolidated os validation report
#  04-DEC-2002  TY			Fixed missing report to report
#					directory only
#					Added copying log/out to new BE
#					before exit
#  11-DEC-2002  TY			Modified the format of os report
#  12-DEC-2002  TY			Added SunMC module
#  03-JAN-2003  SG			Added module to copy files to ABE
#  07-JAN-2003  TY			Added module to process /var/opt;
#					also rearrange the step sequence
#  09-JAN-2003  TY			Mod to luumount_abe
#  09-JAN-2003  UM			Added function Print_RSP
#  16-JAN-2003  TY			Handle mount in auto_direct
#  21-JAN-2003  TY			Created missing directories at / level
#  27-JAN-2003  TY			Added package mapping lookup
#  28-JAN-2003  TY			Added automate package sync file
#  29-JAN-2003  CS			Rewrite pkg processing
#  30-JAN-2003  CS			Fix cpio issues for varopt; ls issue in /
#  -------------------------------------------------------------
#######################################################################
#
#

l_script_name=`basename $0`
l_log_dir="/var/sadm/system/logs"
l_tmp_dir="/var/tmp"
l_log_file="s9_postmigration.log"
l_pkg_dir="/opt"
l_copyfile_file_master="${l_pkg_dir}/${p_pkg_name}/etc/s9_postmig_file_copy.dat"
p_script_dir="/opt/ITSMs9mig"
p_etc_dir="${p_script_dir}/etc"
l_s_env_file="${p_etc_dir}/set_migration_env"
l_d_env_file="${p_etc_dir}/s9_`hostname`_env"
l_excl_file="${p_etc_dir}/s9_excluded_dir.dat"
l_content_file="/var/sadm/install/contents"
p_DATE="/usr/bin/date +%Y%m%d_%T"

# functions
mount_abe()
{
	p_alt_be_name=$1
	if [ `mount | /usr/bin/grep -wc "${p_alt_be_name}"` -eq 0 ]
	then 
	Print_MSG INFO "Mounting ${p_alt_be_name} Boot Environment...."
 	if [ -f "/usr/sbin/lumount" ]
 	then
     		/usr/sbin/lumount ${p_alt_be_name} /.alt.${p_alt_be_name} > /dev/null
		if [ $? -gt 0 ]
		then
		  Print_MSG ERROR "Unable to mount ${p_alt_be_name}"
		  exit 2
		else
		  Print_MSG INFO "lumount successfully"
		fi
		
 	else
    		Print_MSG ERROR "lumount not found"
    		exit  1
 	fi
	else
	Print_MSG INFO "${p_alt_be_name} Boot Environment already mounted"
	fi
}	

unmount_abe()
{
	p_alt_be_name=$1
	if [ `mount | /usr/bin/grep -wc "${p_alt_be_name}"` -eq 0 ]
	then 
	  Print_MSG INFO "${p_alt_be_name} Boot Environment already unmounted."
	else
 	if [ -f "/usr/sbin/luumount" ]
 	then
 	  Print_MSG INFO "Unmounting ${p_alt_be_name} Booting Environment...."
	  while true
	  do
     	  /usr/sbin/luumount -m /.alt.${p_alt_be_name} 
	  rc=$?
	  if [ $rc -gt 0 ]
	  then
	    Print_MSG ERROR "Unable to unmount ${p_alt_be_name}"
	    echo luumount failed possibly due to BE file system busy
	    echo You have the following options:
	    echo "type <c> to continue; <r> to retry; or <q> to exit. [c/r/q] \c"
	    read ans
            Print_RSP ${ans}
            case $ans in

           	c) echo "You entered <c>, program continue..."
               		return 2;;
           	r) echo "Retrying luumount..."
               		continue;;
           	q) Print_MSG ERROR "Program terminated at user request"
		   echo "Exiting from script due to luumount failure"
              	   echo "Please fix the problem and re-run s9_postmigration"
                 	exit 2;;
		*) echo "Unrecognized keystroke. Will retry by default."
			continue;;
            esac
          else
            Print_MSG INFO luumount successfully.
            break
          fi
	done
       else
     	Print_MSG ERROR "luumount not found"
    	exit  1
  	fi
	fi
	return 0

}	


# this function process content list and collect file into /tmp/pkg_files.lst
process_content_file()
{

f=$1

/usr/bin/nawk '
BEGIN {
LOGDIR="/tmp";
sync_list= LOGDIR "/pkg_files.lst";
}
{
if ( $2 ~ /s|l/ )
        { split($1, arr, "=");
         printf("%s\n", arr[1]) >> sync_list;
        }
else
        { #if (( NF == 7 && $2 ~ /d|x/ ) || ( NF == 10 && $2 ~ /f|e|v/ ))
         printf("%s\n",$1)>> sync_list;
        }
}
END  {;}'  $f

}

diff_pkg()
{
	Print_MSG INFO "Diffing the packages between current BE and $p_alt_be_name..."
        pre_pkg_list="${l_log_dir}/s9_parfacts_pkg.out"
        post_pkg_list="${l_log_dir}/s9_post_parfacts_pkg.out"
	if [ ! -f $pre_pkg_list ]
	then 
		pkginfo | /usr/bin/sort > $pre_pkg_list
	fi

	# make sure the S9BE is mounted
	if [ `mount | /usr/bin/grep -wc "${p_alt_be_name}"` -eq 0 ]
	then
		mount_abe $p_alt_be_name
	fi
	pkginfo -R $l_alt_be_root | /usr/bin/sort > $post_pkg_list

	pre_count=`/usr/bin/wc -l $pre_pkg_list| /usr/bin/nawk '{print $1}'`
	post_count=`/usr/bin/wc -l $post_pkg_list| /usr/bin/nawk '{print $1}'`

        l_prelist_file=/tmp/s9mig_prelist.$$
        l_postlist_file=/tmp/s9mig_postlist.$$

	/usr/bin/egrep -v "^$" $pre_pkg_list | /usr/bin/nawk '{print $2}' | sort >${l_prelist_file}
	/usr/bin/egrep -v "^$" $post_pkg_list | /usr/bin/nawk '{print $2}' | sort >${l_postlist_file}
	#/usr/bin/nawk '{printf "%-15s %s\n" $1 $2;}' $pre_pkg_list | /usr/bin/egrep -v '^$|^=|^[ ]*/|^$' | sort >${l_prelist_file}
	#/usr/bin/nawk '{printf "%-15s %s\n" $1 $2;}' $post_pkg_list| /usr/bin/egrep -v '^$' | sort >${l_postlist_file}
	/usr/bin/comm -23 ${l_prelist_file} ${l_postlist_file} | /usr/bin/egrep -v 'ITSMs9mig' > ${l_log_dir}/s9_missing_pkg.out.tmp

	/usr/bin/rm -f ${l_log_dir}/s9_obsolete_pkg.out
	/usr/bin/rm -f ${l_log_dir}/s9_mapped_pkg.out
	/usr/bin/rm -f ${l_log_dir}/s9_missing_pkg.out

	#Precreated list of pkg maps from old OS to new OS rel
	l_map_dat="${p_etc_dir}/s9_pkg_map.dat"

	#Precreated list of pkgs in OS media or current OS rel
	l_media_dat="${p_etc_dir}/s${cur_os}_os_pkg_list.dat"

	#/usr/bin/cat ${l_log_dir}/s9_missing_pkg.out.tmp | while read a pkg_name desc
	for l_dpkg in `/usr/bin/cat ${l_log_dir}/s9_missing_pkg.out.tmp`
	do
	  #check the pkg known mapping - o or m tag
	  l_map_line=`/usr/bin/grep "^[omn][ 	][ 	]*${l_dpkg}[ 	]*" ${l_map_dat} 2>&1 | /usr/bin/head -1`
          l_map_tag=`echo "${l_map_line}" | /usr/bin/cut -f1`
          l_dpkg_long="`/usr/bin/nawk -v \"pkgname=${l_dpkg}\" '{if($2==pkgname) {print $0; exit;}}' ${pre_pkg_list}`"
	  case "${l_map_tag}" in
	   'm') #found mapping defined
		l_map_pkg=`echo "${l_map_line}" | /usr/bin/nawk '{print $3}'`
		/usr/bin/grep -w "${l_map_pkg}" ${l_postlist_file} >/dev/null 2>&1
		if [[ $? -eq 0 ]]
		then
		  printf "[Mapped_Installed] [S9 = %-10s] %s\n" "${l_map_pkg}" "${l_dpkg_long}" >>${l_log_dir}/s9_mapped_pkg.out
		else
		  printf "[Mapped_Not_Installed] [S9 = %-10s] %s\n" "${l_map_pkg}" "${l_dpkg_long}" >>${l_log_dir}/s9_mapped_pkg.out
		fi
		;;
	   'n') #defined as known pkg not required to be installed in S9
		echo "[Not_Installed] ${l_dpkg_long}" >>${l_log_dir}/s9_obsolete_pkg.out
		;;
	   'o') #defined as known obsolete in S9
		echo "[Obsolete] ${l_dpkg_long}" >>${l_log_dir}/s9_obsolete_pkg.out
		;;
	     *) #no m or o found; look if this pkg in from known Solaris media of current OS
		/usr/bin/nawk '{print $2}' ${l_media_dat} | grep -w ${l_dpkg} >/dev/null 2>&1
		if [[ $? -eq 0 ]]
		then
		  #Found in current OS CD list; Does not qualify for automatic transfer
		  #Look for similar pkg in S9 media list
		  /usr/bin/nawk '{print $2}' ${p_etc_dir}/s9_os_pkg_list.dat 2>/dev/null | grep -w ${l_dpkg} >/dev/null 2>&1
		  if [[ $? -eq 0 ]]
		  then
		    #Found in S9 media list - SA my install if they want to, at later time
		    echo "[You_May_Install] ${l_dpkg_long}" >>${l_log_dir}/s9_obsolete_pkg.out
		  else
		    #Not found in S9 media list - Assume as discontinued pkg
		    echo "[Discontinued] ${l_dpkg_long}" >>${l_log_dir}/s9_obsolete_pkg.out
		  fi
		else
		  #Now - assume this pkg qualifies for auto transfer of pkg from current BE
		  echo "[Auto_Move] ${l_dpkg_long}" >>${l_log_dir}/s9_missing_pkg.out
		fi
		;;
	  esac
	done

	/usr/bin/rm -f ${l_prelist_file} ${l_postlist_file}
	/usr/bin/rm -f ${l_log_dir}/s9_missing_pkg.out.tmp

	echo
	echo "Current booting environment package count: $pre_count"
	echo "Alternate booting environment package count: $post_count"
	echo
	echo "THE FOLLOWING PACKAGES ARE NOT IN NEW BOOT ENVIRONMENT [$p_alt_be_name]:"
	echo
	echo "Please note that the package may change name in between OS"
	echo "versions. The list is only showing the packages that exist in the"
	echo "current booting environment which do not exist in the"
	echo "new booting environment (BE)."
	echo
	echo
	if [[ -f ${l_log_dir}/s9_mapped_pkg.out ]]
	then
	  echo "*** PACKAGES WITH IDENTIFIED MAP TO NEW PKG ***"
	  echo
	  echo "These packages are known to have corresponding mapping with"
	  echo "different package name in new OS release."
	  echo " [Mapped_Installed] Mapped pkg already exist in new BE."
	  echo " [Mapped_Not_Installed] Mapped pkg not installed in new BE, install may later."
	  echo
	  echo "==================================================================="
	  /usr/bin/sort ${l_log_dir}/s9_mapped_pkg.out
	  echo "==================================================================="
	  echo
	fi
	if [[ -f ${l_log_dir}/s9_obsolete_pkg.out ]]
	then
	  echo
	  echo "*** PACKAGES NOT IN NEW OS RELEASE or IDENTIFIED AS OBSOLETE ***"
	  echo
	  echo "Best effort analysis done to identify obsolete or discontinued pkgs."
	  echo "These packages may not be available in Solaris 9 release or replaced"
	  echo "with a different package name (mapping unknown)."
	  echo " [Obsolete] Pkg known as obsolete in new OS."
	  echo " [Discontinued] Pkg that do not exist in Solaris 9 standard OS media."
	  echo " [Not_Installed] Pkg purposefully not installed in new OS image."
	  echo
	  echo "==================================================================="
	  /usr/bin/sort ${l_log_dir}/s9_obsolete_pkg.out
	  echo "==================================================================="
	  echo
	fi
	echo
	echo "*** PACKAGES IDENTIFIED AS VALID FOR AUTO MOVE FROM CURRENT TO NEW BE ***"
	echo
	echo "Best effort attempted to transfer identified packages (if any)"
	echo "from Current to New boot environment. See below progress."
	echo " [Auto_Move] Marked for attempting package transfer from old to new BE."
	echo
	echo "==================================================================="
	[ -f ${l_log_dir}/s9_missing_pkg.out ] && /usr/bin/sort ${l_log_dir}/s9_missing_pkg.out
	echo "==================================================================="
	echo

	#Now, assume pkgnames in s9_missing_pkg.out are real valid for transfer
        if [ -f ${l_log_dir}/s9_missing_pkg.out ]
        then
	    Print_MSG INFO "Attempting to transfer identified packages from current to new BE ..."
	    for l_mpkg in `/usr/bin/grep '^\[Auto_Move\]' ${l_log_dir}/s9_missing_pkg.out | /usr/bin/nawk '{print $3}'`
	    do
		echo "\nINFO: Working on Package: ${l_mpkg} ..."
		${p_script_dir}/bin/s9_mvpkg.sh ${l_mpkg}
	    done
        fi

	Print_MSG INFO "Package diff complete."
}

show_greeting()
{
	Print_MSG INFO "POST UPGRADE SCRIPT WILL DO THE FOLLOWING:"
 	echo " step 1: Mount Alternate Booting Environment"	
	echo " step 2: Show packages diff"
	echo " step 3: SunMC config file sync up"
	echo " step 4: Copy /var/opt files"
	echo " step 5: Copy special files"
	echo " step 6: Syncing the rc files"
	echo " step 7: Validate the OS and prepare the reports"
	echo " step 8: Running custom post processing script"
	echo " step 9: Unmount Alternate Booting Environment"
	echo " step 10: Final message"
}

parse_lu_cmp()
{

/usr/bin/nawk '
BEGIN {
LOGDIR="/var/sadm/system/logs";
missing_file= LOGDIR "/s9_missing_file.report";
diff_file= LOGDIR "/s9_diff_listing.report";
symbolic_flag=0;
get_file_name=0;
}
{
if ( $0 == "" ) { getline;}
if ( symbolic_flag == 1 )
  {
      getline;
      symbolic_flag=0;
      get_file_name=1;
  }
  else
  {
     if ( get_file_name==1 )
     {
	split($3, arr, ":");
         printf("DIFF\t%s\t%s\n", arr[6], arr[1]) >> diff_file;
         get_file_name=0;
     } 
  }
}
/Symbolic links/ { symbolic_flag=1} 
/Sizes differ/||/Checksums differ/ { get_file_name=1} 
/does not exist/ { printf("%s\n", $3) >> missing_file} 
/is not linked to/ { printf("DIFF\tSYMLINK\t%s\n", $3) >> diff_file} 
END  {;}'  $l_lucmp_out_file

}

generate_os_report()
{	
#
#awk script used for filtering files of a pkg
#For this awk script, stdin: grep -w pkgname /var/sadm/install/contents
#/app/smcadm/TLSsmcf/Tools_AM f none 0755 root other 3201 30454 1031044823 TLSsmcf
#
l_awk_pkg_files='
{
    if($2=="l" || $2=="s") {
        #link or symbolic link entry, print out first component
        split($1,pname,"=");
        print pname[1];
    }
    else {
        #print out path/file component
        print $1;
    }
}
'
#
	# first, eliminate the unwanted files in the reports
	# excluding files from /etc/rc, /usr/include, /usr/dt, /usr/lib, in $l_excl_file
	#
	/usr/bin/egrep -v "`/usr/bin/sed -e 's/^[ 	]*/\[ 	\]\*/' -e 's/\+/\\\+/' ${l_excl_file}`" $missing_rep |/usr/bin/sort > ${missing_rep}.tmp
	/usr/bin/egrep -v "`/usr/bin/sed -e 's/^[ 	]*/\[ 	\]\*/' -e 's/\+/\\\+/' ${l_excl_file}`" $diff_rep |/usr/bin/sort > ${diff_rep}.tmp

	# Then, remove all the obsolete package related files	
	to_be_sync_f=/tmp/pkg_files.lst
	to_be_removed_f=/tmp/to_be_removed.lst
	/usr/bin/rm -f $to_be_sync_f
	/usr/bin/rm -f $to_be_removed_f

	for l_pkgname in `/usr/bin/cat ${l_log_dir}/s9_obsolete_pkg.out | /usr/bin/nawk '{print $3}'`
	do
          #For each pkg get file list; filter file type; filter only local fs paths
          /usr/bin/grep -w "${l_pkgname}" ${l_content_file} \
	   | /usr/bin/grep -v '^/usr ' \
           | /usr/bin/nawk "${l_awk_pkg_files}" \
           | /usr/bin/egrep -v -e "
            `/usr/sbin/mount -p \
             | /usr/bin/nawk '{if($4==\"ufs\" || $4==\"vxfs\" || $4==\"lofs\") print $3;}' \
             | /usr/bin/egrep -v '^/$|^/var$|^/opt$|^/usr$' 
            `
            " >>$to_be_sync_f
	done

	/usr/bin/sort -u $to_be_sync_f > $to_be_removed_f

	/usr/bin/comm -23 ${missing_rep}.tmp ${to_be_removed_f} > ${missing_rep}.tmp2

	/usr/bin/mv ${missing_rep}.tmp2 ${missing_rep}.tmp 

	/usr/bin/rm -f $to_be_sync_f $to_be_removed_f

	# further, report only top directory if all the files missing under
	/usr/bin/nawk '
BEGIN {
old="";
}
{
     if ( old == "" || length(old) > length($0) )
        {
        printf("%s\n", $0)
        old=$0
        }
     else
     {
     if ( substr($0, 1, length(old)) != old )
     {
        printf("%s\n", $0)
        old=$0
     }
     }
}
END  {;}'   ${missing_rep}.tmp > $missing_rep

	# Here is the real report
	# starting put comment in the report header
	/usr/bin/cat > ${l_os_val_file_rep} <<EOF
###############################################################################
# REPORT DATE:	`date`
# HOSTNAME:	`hostname`
# THIS REPORT HAS THE FOLLOWING FORMAT:
# <reason>	<type>	<file_name>
# MISSING	FILE	/etc/x
# DIFF		*DIR*	/var/y
# ...
#
# where <reason> could be MISSING or DIFF
#		MISSING		the file_name does not exist in $p_alt_be_name
#		DIFF		the file_name has checksum or size difference
#				between $l_cur_be_name and $p_alt_be_name
#	<type> is one of the following types similar to the type in lucompare
#	     	SYMLINK	 	symbolic link
#		FIFO  		FIFO file
#		CHRSPC		character special
#		BLKSPC		block special
#		*DIR*  		directory
#		FILE		regular file
#		UNKNOW		unknown file type
#	
#
###############################################################################
#
EOF
	# comment and line before the missing section listing
	echo "# This section is for MISSING files/directories:" >> ${l_os_val_file_rep}
	echo "#==========================================================" >> ${l_os_val_file_rep}
	# another round to put missing listing into s9_os_validation_file.report
	# with the same format as the diff report
	/usr/bin/cat ${missing_rep} |while read line
	do
       	 [ -p $line ] && echo "MISSING\tFIFO\t$line" >>${l_os_val_file_rep}
       	 [ -b $line ] && echo "MISSING\tBLKSPC\t$line" >>${l_os_val_file_rep}
       	 [ -c $line ] && echo "MISSING\tCHRSPC\t$line" >>${l_os_val_file_rep}
       	 if  [ -h $line ]
       	 then
       	         echo "MISSING\tSYMLINK\t$line" >>${l_os_val_file_rep}
       	 else
       	 [ -d $line ] && echo "MISSING\t*DIR*\t$line" >>${l_os_val_file_rep}
       	 [ -f $line ] && echo "MISSING\tFILE\t$line" >>${l_os_val_file_rep}
       	 fi
	done
	

	# comment and line before the diff section listing
	echo "#"  >>${l_os_val_file_rep}
	echo "# This section is for DIFF files/directories listing:" >>${l_os_val_file_rep}
	echo "#==========================================================" >> ${l_os_val_file_rep}
	# put diff_rep into s9_os_validation_file.report
	/usr/bin/cat ${diff_rep}.tmp |sed 's/REGFIL/FILE/' >> ${l_os_val_file_rep}

	# final cleanup of all the temp files
	/usr/bin/rm -f $diff_rep $missing_rep ${diff_rep}.tmp ${missing_rep}.tmp

}


validate_os()
{
        source_ls_f="${TEMP}/${l_cur_be_name}.lst"
	target_ls_f="${TEMP}/${p_alt_be_name}.lst"
	top_missing_f="${TEMP}/missing_f_tmp"


	Print_MSG INFO "Syncing up the / level entries ..."
	
	/usr/bin/rm -f $missing_rep $diff_rep $top_missing_f
	/usr/bin/touch $top_missing_f

        #entries in / root
        l_alt_be_root_pattern="`echo ${l_alt_be_root} | sed -e 's/\///'`"
        l_root_items=""
        for l_item in `/usr/bin/ls -a1 / | /usr/bin/grep -v "${l_alt_be_root_pattern}"`
        do
            /usr/bin/ls ${l_alt_be_root}/${l_item} >/dev/null 2>&1
            [ $? -ne 0 ] && l_root_items="/${l_item}\n${l_root_items}"
        done
        l_root_items="`echo ${l_root_items} | /usr/bin/grep -v '^$'`"
        if [ ! -z "${l_root_items}" ] 
        then
            echo "${l_root_items}" | /usr/bin/cpio -pvdm ${l_alt_be_root}
            [ $? -ne 0 ] && Print_MSG WARNING "Check for cpio errors above, if any!"
        else
            Print_MSG INFO "No root level items to sync! [${l_root_items}]"
        fi
        sed 's/^\(.*\)stty\(.*\)sane/#COMMENTED OUT BY ITSMs9mig# #\1stty\2sane/' ${l_alt_be_root}/.login > ${l_alt_be_root}/.login.$$ && \
        mv ${l_alt_be_root}/.login.$$ ${l_alt_be_root}/.login 

	Print_MSG INFO "Syncing up / level entries completed."

	l_final_ex_file="${TEMP}/s9mig_exclude_file.dat"
	l_final_lu_cmp_file="${TEMP}/s9mig_lu_compare.dat"
	l_lucmp_out_file="${TEMP}/s9mig_lu_compare.out"
	
	# clean up from previous runs
	/usr/bin/rm -f $l_final_ex_file $l_final_lu_cmp_file

        /usr/bin/sort -u "${l_excl_file}" | /usr/bin/egrep -v '^$|^[	]*#' >${l_final_ex_file}
        mount | /usr/bin/nawk '{print $1}' | /usr/bin/egrep -v "^/$|^/var$|^/home$|^/usr$|^/opt$'" >>${l_final_ex_file}
	echo "$l_alt_be_root"  >> $l_final_ex_file
	echo "$l_alt_be_root/var"  >> $l_final_ex_file

	# auto_direct consideration - create dirs
	if [ -f /etc/auto_direct ]
	then
          for l_mpt in `/usr/bin/cat /etc/auto_direct \
                | /usr/bin/egrep -v "^$|^[	]*#" \
                | /usr/bin/grep "^/" \
                | /usr/bin/nawk '{print $1}'`
          do
              [ ! -d ${l_alt_be_root}${l_mpt} ] && /usr/bin/mkdir -p ${l_alt_be_root}${l_mpt}
              echo "${l_mpt}" >>${l_final_ex_file}
          done
	fi

        #get input list lucompare, from / - except l_final_ex_file entries, /usr and /var
        /usr/bin/find /* /.?* -prune -print \
            | /usr/bin/egrep -v '/\.$|/\..$' \
            | /usr/bin/egrep -v "`/usr/bin/sed -e 's/^[ 	]*/\^/' -e 's/[ 	]*$/\$/' -e 's/\+/\\\+/' ${l_final_ex_file}`" \
            | /usr/bin/egrep -v "^/usr$|^/var$" \
            | /usr/bin/sort -u >${l_final_lu_cmp_file}

        #get input list lucompare, from /usr /var - except l_final_ex_file entries 
        /usr/bin/find /usr/* /usr/.?* /var/* /var/.?* -prune -print \
            | /usr/bin/egrep -v '/\.$|/\..$' \
            | /usr/bin/egrep -v "`/usr/bin/sed -e 's/^[ 	]*/\^/' -e 's/[ 	]*$/\$/' -e 's/\+/\\\+/' ${l_final_ex_file}`" \
            | /usr/bin/sort -u >>${l_final_lu_cmp_file}


	# before running lucompare, we need to unmount
	unmount_abe $p_alt_be_name

	if  [ $? -gt 0 ]
	then
	  Print_MSG ERROR "luumount failure will result in lu_compare failure"
	  echo "Exiting; please fix the luumount errors and re-run s9_postmigration."
	  exit 2
	else 
	  Print_MSG INFO  "Running lucompare command ...."
	  echo "The output of the lucompare is in $l_lucmp_out_file"
	  lucompare -i $l_final_lu_cmp_file -o $l_lucmp_out_file $p_alt_be_name
	fi

	Print_MSG INFO "lucompare completed."

	#       Parse thru the $l_lucmp_out_file
	Print_MSG INFO  "Parsing $l_lucmp_out_file to generate reports..."
	
	parse_lu_cmp 

	Print_MSG INFO "Parsing completed."
	
	#/usr/bin/egrep "^/etc/init.d|^/etc/rc"  $missing_rep > $missing_rc
        Print_MSG INFO "Generating OS validation report..."

	generate_os_report

	Print_MSG INFO "OS validation reports generated."
}

sync_rc()
{
	# before running lucompare, we need to unmount
	unmount_abe $p_alt_be_name
	
	l_cmp_file="/tmp/lu_cmp.dat"
	echo "/etc" > $l_cmp_file

	if  [ $? -gt 0 ]
	then
	  Print_MSG ERROR "luumount failure will result in lu_compare failure"
	  echo "Exiting; please fix the luumount errors and re-run s9_postmigration."
	  exit 2
	else 
	  Print_MSG INFO  "Running lucompare command for rc directories...."
	  #echo "The output of the lucompare is in $l_lucmp_out_file"
	  lucompare -i $l_cmp_file -o $l_lucmp_out_file $p_alt_be_name
	fi

	Print_MSG INFO "lucompare completed."

	#       Parse thru the $l_lucmp_out_file
	#Print_MSG INFO  "Parsing $l_lucmp_out_file to generate reports..."
	
	parse_lu_cmp 

	#Print_MSG INFO "Parsing completed."

	mv $l_lucmp_out_file $l_lucmp_out_file.rc	
	
	if [ -f $missing_rep ]
	then
	# mount ABE to sync missing rc files
	mount_abe $p_alt_be_name
	
	/usr/bin/egrep "^/etc/init.d|^/etc/rc"  $missing_rep > $missing_rc
        Print_MSG INFO "Checking rc diff ...."

	rc_missing_f="$TEMP/s9_missing_rc_tmp"
	[ -f $rc_missing_f ] && /usr/bin/rm -f $rc_missing_f

	/usr/bin/cat $missing_rc |while read f
	do
 	  b=`echo $f|/usr/bin/nawk -F/ '{print $2}'`
	  c=`echo $f|/usr/bin/nawk -F/ '{print $3}'`
	  d=`echo $f|/usr/bin/nawk -F/ '{print $4}'`	
	  if [ $c = "init.d" ]
	  then
	    module=$d
	  else 	
       	    module=`echo $d |cut -c4-18`
	  fi
	  # ignore all nfs rc files
	  if [ `echo $module | grep "nfs." | wc -l` -gt 0 ]
	  then
	    continue
	  else
  	    if [ `/usr/bin/ls $l_alt_be_root/$b/$c/ | /usr/bin/grep $module | /usr/bin/wc -l` -eq 0 ]
	    then
	      echo ${l_cur_be_root}$b/$c/$d >> $rc_missing_f
	    fi
	  fi
	done

	if [ -f $rc_missing_f ]
	then
	  Print_MSG INFO "Syncing up /etc/init.d and /etc/rc..."
	  /usr/bin/cat $rc_missing_f | /usr/bin/cpio -pmdv $l_alt_be_root
	  fi
	/usr/bin/rm -f $missing_rc $rc_missing_f

	fi
}

sunmc_stuff()
{
	/usr/bin/rm -f /tmp/s9_disable_sunmc.sh /tmp/s9_enable_sunmc.sh

	if  [ -f /var/opt/SUNWsymon/cfg/domain-config.x ] 
	then
	  Print_MSG INFO SunMC is installed/configured in current booting environment.
	  Print_MSG INFO SunMC domain-config.x being copied over to S9BE.
	  cp -p /var/opt/SUNWsymon/cfg/domain-config.x $l_alt_be_root/var/opt/SUNWsymon/cfg/domain-config.x
	else
	  Print_MSG INFO SunMC is not installed/configured in current booting environment.
	  # rename the rc in rcx.d/[SK]*es_agent and init.d/init.es_agent
	  #		     rcx.d/[SK]*sunmc
	  /usr/bin/find $l_alt_be_root/etc \( -name '*es_agent' -o -name '*sunmc' \) -print > /tmp/sunmc.$$
	  if [ `/usr/bin/wc /tmp/sunmc.$$ |/usr/bin/nawk '{print $1}'` -gt 0 ]
	  then
	  Print_MSG INFO SunMC RC files will be disabled in S9BE....
	  for i in `/usr/bin/cat /tmp/sunmc.$$` 
	  do
	    d=`/usr/bin/dirname $i`
	    new_fname=`/usr/bin/basename $i | /usr/bin/tr "[A-Z]" "[a-z]"`
	    if [ $new_fname != "init.es_agent" ]
	    then
	      echo /usr/bin/mv $i ${d}/${new_fname} >> /tmp/s9_disable_sunmc.sh
	      echo /usr/bin/mv ${d}/${new_fname} $i | /usr/bin/sed 's/\/.alt.S9BE//g' >> /tmp/s9_enable_sunmc.sh
	    fi
	  done
	  /usr/bin/rm -f /tmp/sunmc.$$

	  Print_MSG INFO Disabling SunMC RC in S9BE...
	  sh /tmp/s9_disable_sunmc.sh
	  echo The server will need to run the following commands to enable SunMC after boot up S9 and have SunMC properly set up if needed.
	  cat /tmp/s9_enable_sunmc.sh

	 else
	  Print_MSG INFO No SunMC RC files found in S9BE.
	  Print_MSG INFO Please run SunMC installer to install/setup after boot up S9.
	 fi
	fi

	# Update cst.pref in alt_boot_be
        if  [ -f /var/opt/SUNWcst/cst.pref ]
        then
          Print_MSG INFO Transfer SUNWcst cst.pref file...
          cp -p /var/opt/SUNWcst/cst.pref $l_alt_be_root/var/opt/SUNWcst/cst.pref
        fi


}

varopt_stuff()
{
	Print_MSG INFO "Transferring valid directories from : /var/opt ..."
        /usr/bin/find $(/usr/bin/ls -1d /var/opt/* /var/opt/.?* \
            | /usr/bin/egrep -v '\.$|\.\.$' \
            | /usr/bin/egrep -v "`/usr/bin/ls -a1 ${l_alt_be_root}/var/opt | /usr/bin/egrep -v '\.$|\.\.$'`" \
            | /usr/bin/egrep -v "STORtools|SUNWcst|SUNWsymon") -mount -local -print 2>/dev/null \
            | /usr/bin/cpio -pdum ${l_alt_be_root}
        [ $? -ne 0 ] && Print_MSG WARNING "Check for cpio errors above, if any!"
}
	
copy_special_files()
{
	cp ${l_copyfile_file_master} ${l_copyfile_file_master}.$$
	l_copyfile_file="${l_copyfile_file_master}.$$"

	/bin/ls /var/spool/cron/crontabs/* |egrep -v 'adm|lp|root|sys|uucp' >> ${l_copyfile_file}

	for l_file in `/usr/bin/cat ${l_copyfile_file} | /usr/bin/egrep -v '^#|^$' `
	do
   	   echo "    Processing ${l_file}  ..."
   	   if [ -f ${l_file} ]
   	   then
      	      #Regular file to be copied.
      	      if [ -f ${l_alt_be_root}/${l_file} -a `dirname ${l_file}` != "/var/spool/cron/crontabs" ]
      	      then
          	 /usr/bin/cp -p ${l_alt_be_root}/${l_file} ${l_alt_be_root}/${l_file}.${p_alt_be_name}
      	      fi
      	      echo ${l_file} | /usr/bin/cpio -pdum ${l_alt_be_root}
   	   elif [ -d ${l_file} ]
           then
      	      /usr/bin/find ${l_file} -mount -local -print | /usr/bin/cpio -pdum ${l_alt_be_root}
   	   fi
	done

	/usr/bin/mv ${l_copyfile_file} ${l_tmp_dir}

        if [[ -s /etc/defaultdomain ]]
        then
           [[ ! -d "${l_alt_be_root}/var/yp/binding/`cat /etc/defaultdomain`" ]] && \
              /usr/bin/mkdir ${l_alt_be_root}/var/yp/binding/`cat /etc/defaultdomain`
        fi
} 

custom_script()
{
	Print_MSG INFO "CUSTOM SCRIPT LOCATION in $p_flash_loc"
	echo "\nLooking for ${p_postmig_custom_file}..."
	if [ -f ${p_flash_loc}/${p_postmig_custom_file} ]
	then
	  echo "\nCustom script data file found and invoking..."
	  echo "***************  DISCLAIMER:  ****************"
	  echo "THIS CUSTOM SCRIPT WILL BE RUNNING AT USER'S RISK."

  	  if [ `mount | /usr/bin/grep -wc "${p_alt_be_name}"` -eq 0 ]
       	  then
        	mount_abe $p_alt_be_name
       	  fi
	  /usr/bin/egrep -v '^$|^[    ]*#' ${p_flash_loc}/${p_postmig_custom_file} | while read line
	  do  
	    arg1=`echo $line |/usr/bin/nawk '{print $1}'`
	    if [ -x $arg1 ]
	    then		
	      echo "\n$p_dash_line"
  	      echo "[`${p_DATE}`] BEGIN CUSTOM SCRIPT: ${line} "
	      eval "$line" 
	      rc=$?
	      echo "\nCUSTOM SCRIPT RETURN CODE: $rc"
	      echo "[`${p_DATE}`] END CUSTOM SCRIPT: ${line}"
	      echo "$p_dash_line\n"
	    else
	      Print_MSG ERROR "$arg1 not executable, skipping"
	    fi
	  done
	else
	  Print_MSG INFO "No custom scripts to be invoked."
	fi
}
	

post_note()
{
	Print_MSG INFO "ATTENTION!! ATTENTION !!"
	echo "*** FOR OS VALIDATION, WE HAVE GENERATED TWO REPORTS: ***"
	echo "	Packages processing: ${l_os_val_pkg_rep}"
	echo "	File processing    : ${l_os_val_file_rep}"
	Print_MSG INFO "*** PLEASE REVIEW THE REPORT AND ACTION ACCORDINGLY ***"
 	echo "Please refer to S9 Migration Process Guide document" 
 	echo "for instructions on proceeding to remaining steps."
	echo 
}

set_flag()
{
	l_flag=$1
	if  grep p_postmig_flag ${l_d_env_file} > /dev/null 2>&1 
	then
		/usr/bin/sed "/p_postmig_flag/s/[YN]/$l_flag/" ${l_d_env_file} > ${l_d_env_file}.tmp
		/usr/bin/mv ${l_d_env_file}.tmp ${l_d_env_file}
	else
		echo "p_postmig_flag=\"$l_flag\"; export p_postmig_flag" >>  ${l_d_env_file}
	fi

}


# main

if [[ -f ${l_s_env_file} ]]
then
    . ${l_s_env_file}
else
    echo "\n------------------------------------------------------------------------"
    echo "[`${p_DATE}`] ERROR: ${l_s_env_file} does not exist, exiting"
    exit 1
fi

if [[ -f ${l_d_env_file} ]]
then
    . ${l_d_env_file}
else
    echo "\n------------------------------------------------------------------------"
    echo "[`${p_DATE}`] ERROR: Run s9_premigration & s9_migration before running    "
    echo "`basename $l_script_name .sh` , exiting"
    exit 1
fi

if [[ "${p_mig_flag}" = "N" || "${p_mig_flag}" = "" ]]
then
	Print_MSG ERROR "Cannot run $l_script_name due to s9_migration.sh not completed"
	exit 1
fi

if [ "$p_postmig_flag" = "Y" ]
then
	Print_MSG ERROR "$l_script_name was run successfully already"
	exit 1
fi


SCRIPT_DIR=$p_script_dir/bin
TEMP=/tmp
p_alt_be_name="${p_alt_be_name:-S9BE}"
cur_os=`/usr/bin/uname -a | /usr/bin/nawk '{print $3}' | /usr/bin/nawk -F. '{print $2}'`
l_cur_be_name="S${cur_os}BE" 
l_cur_be_root=/
l_alt_be_root=/.alt.${p_alt_be_name}

missing_rep=${l_log_dir}/s9_missing_file.report
diff_rep=${l_log_dir}/s9_diff_listing.report
l_lucmp_out_file="${TEMP}/s9mig_lu_compare.out"
l_os_val_file_rep=${l_log_dir}/s9_os_validation_file.report
l_os_val_pkg_rep=${l_log_dir}/s9_os_validation_pkg.report
missing_rc=${l_log_dir}/s9_missing_rc.report
step_ct=0

LU_DIR=${l_cur_be_root}/lu

Print_MSG START ${l_script_name}

#Step - 0 INFO
l_step_name="$step_ct GREETING"
Print_MSG BEGIN ${l_step_name}
show_greeting
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

#Step - 1 Mount ABE
l_step_name="$step_ct  MOUNT_ABE"
Print_MSG BEGIN ${l_step_name}
mount_abe $p_alt_be_name
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

#Step - 2 Check Package Diff
l_step_name="$step_ct  CHECK_PACKAGE_DIFF"
Print_MSG BEGIN ${l_step_name}
diff_pkg 2>&1 | /usr/bin/tee ${l_os_val_pkg_rep}
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1` 

# SunMC module
#Step - 3 SunMC CONFIG SYNC
l_step_name="$step_ct  SUNMC_CONFIG_SYNC"
Print_MSG BEGIN ${l_step_name}
sunmc_stuff
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

# varopt module: copies /var/opt contents
#Step - 4 VAROPT SYNC
l_step_name="$step_ct  VAR_OPT"
Print_MSG BEGIN ${l_step_name}
varopt_stuff
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

#Step - 5  Copy special files
l_step_name="$step_ct COPY_SPECIAL_FILES"
Print_MSG BEGIN ${l_step_name}
copy_special_files
Print_MSG INFO "Following crontabs are NOT merged: root adm sys lp uucp"
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`
	
#Step - 6 RC FILES SYNC
l_step_name="$step_ct  RC_SYNC"
Print_MSG BEGIN ${l_step_name}
sync_rc
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

#Step - 7 OS VALIDATION
l_step_name="$step_ct  OS_VALIDATION"
Print_MSG BEGIN ${l_step_name}
validate_os
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

#Step - 8 CUSTOM_POST_PROCESSING_SCRIPT
l_step_name="$step_ct  CUSTOM_POST_PROCESSING_SCRIPT"
Print_MSG BEGIN ${l_step_name}
custom_script
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`


#Step - 9 UMOUNT ABE
l_step_name="$step_ct  UMOUNT_ABE"
Print_MSG BEGIN ${l_step_name}
unmount_abe $p_alt_be_name
Print_MSG END ${l_step_name}
step_ct=`expr $step_ct + 1`

#Step - 10 LAST NOTE
l_step_name="$step_ct  POST_UPGRADE_MESSAGE"
Print_MSG BEGIN ${l_step_name}
post_note
Print_MSG END ${l_step_name}

Print_MSG FINISH "Successful ${l_script_name}"

mount_abe $p_alt_be_name > /dev/null	
cp -p ${l_log_dir}/s9_* ${l_alt_be_root}${l_log_dir}/
unmount_abe $p_alt_be_name > /dev/null
set_flag "Y"

exit 0

