#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               s9_parfacts.sh
## Application Name:     IT S9 Migration Tools
#
## Author:        RP
## Date Created:  31-JUL-1997
#
## General Description (Purpose):
#	This script collects all the system info and save into an output
#	file
#
## Usage:       This script is called part of s9_premigration_prepare.sh
#		s9_parfacts.sh 
#
## Required Parameters:   NONE
## Optional Parameters:   N/A
## Return Codes:          0 or 1
#
## Possible Points of Failure: require root or superuser access
#			       command will fail if not root user
#
## Modification History:
#  -------------------------------------------------------------
#  Date           Name          Comments
#  -------------------------------------------------------------
#
#  07-31-1997     RP            Initial Creation
#  02-24-1998	  RP		Modified to run from trusted host
#  12-10-1999     RP		Adjusted format
#  10-29-2002     CH		Adjusted for upgrade process
#######################################################################

USAGE="Usage: `basename $0`"
# -----------------------------------------------------------------
#                Initialize defaults, report headers 
# -----------------------------------------------------------------
DESTDIR="/var/sadm/system/logs"
CATCALL="/bin/cat"
HOSTNAME=`/usr/bin/uname -n`
DOMAIN=`/usr/bin/cat /etc/defaultdomain | /usr/bin/cut -f2 -d '.'`
PAR_TIME=`date '+%m/%d/20%y at %H:%M:%S'` # format mm/dd/yy at hh:mm:ss

initialize()
{
 # system commands to be executed:  if no operands, please specify ""  
 PARFACT_COMMAND[0]="/usr/bin/hostname" 	; PARFACT_OPERAND[0]=""
 PARFACT_COMMAND[1]="/usr/bin/uname"		; PARFACT_OPERAND[1]="-a"
 PARFACT_COMMAND[2]="/usr/sbin/sysdef"		; PARFACT_OPERAND[2]=""
 PARFACT_COMMAND[3]="${CATCALL}"		; PARFACT_OPERAND[3]="/etc/system"
 PARFACT_COMMAND[4]="/usr/bin/showrev"		; PARFACT_OPERAND[4]="-p"
 PARFACT_COMMAND[5]="/bin/pkginfo";   PARFACT_OPERAND[5]="" ; PARFACT_LOGFILE[5]="${DESTDIR}/s9_parfacts_pkg.out"
 PARFACT_COMMAND[6]="/usr/sbin/psrinfo"		; PARFACT_OPERAND[6]=""
 PARFACT_COMMAND[7]="/usr/bin/mpstat"		; PARFACT_OPERAND[7]=""
 PARFACT_COMMAND[8]="/usr/sbin/swap"		; PARFACT_OPERAND[8]="-l"
 PARFACT_COMMAND[9]="/bin/ipcs"		        ; PARFACT_OPERAND[9]="-a"
 PARFACT_COMMAND[10]="${CATCALL}"		; PARFACT_OPERAND[10]="/etc/passwd"
 PARFACT_COMMAND[11]="${CATCALL}"		; PARFACT_OPERAND[11]="/etc/group"
 PARFACT_COMMAND[12]="${CATCALL}"		; PARFACT_OPERAND[12]="/etc/services"
 PARFACT_COMMAND[13]="/bin/df"			; PARFACT_OPERAND[13]="-kl"
 PARFACT_COMMAND[14]="${CATCALL}"		; PARFACT_OPERAND[14]="/etc/vfstab"
 PARFACT_COMMAND[15]="${CATCALL}"		; PARFACT_OPERAND[15]="/etc/dfs/dfstab"
 PARFACT_COMMAND[16]="${CATCALL}"		; PARFACT_OPERAND[16]="/etc/auto_direct"
 PARFACT_COMMAND[17]="/usr/opt/SUNWmd/sbin/metastat"	; PARFACT_OPERAND[17]=""
 PARFACT_COMMAND[18]="/usr/sbin/vxprint"	; PARFACT_OPERAND[18]=""
 PARFACT_COMMAND[19]="/usr/bin/ls"	; PARFACT_OPERAND[19]="/var/spool/cron/crontabs"
 PARFACT_COMMAND[20]="/usr/sbin/dmesg"          ; PARFACT_OPERAND[20]=""
 PARFACT_COMMAND[21]="/usr/platform/`/usr/bin/uname -i`/sbin/prtdiag"; PARFACT_OPERAND[21]="-v"
 PARFACT_COMMAND[22]="/usr/bin/ps"                  ; PARFACT_OPERAND[22]="-ef | sort"

 /bin/rm -f ${DESTDIR}/s9_parfacts*.out 2>/dev/null
}
# -----------------------------------------------------------------
par_fact()
{
 let a=0
 while [ -n "${PARFACT_COMMAND[$a]}"  ]    # process while non-null command
 do
 LOGFILE="${PARFACT_LOGFILE[$a]}" 

 if [[ ${LOGFILE} = "" ]]
  then
  LOGFILE="${DESTDIR}/s9_parfacts.out"  # /tmp collection file for each host
  fi
   if [ -a "${PARFACT_COMMAND[$a]}"  ]
    then  
     echo "===================================================" >> "$LOGFILE"
     echo "          ${PARFACT_COMMAND[$a]}" "${PARFACT_OPERAND[$a]}" >> "$LOGFILE"
     echo "===================================================" >> "$LOGFILE"
     if [ -n "${PARFACT_OPERAND[$a]}" ]
      then
       "${PARFACT_COMMAND[$a]}" "${PARFACT_OPERAND[$a]}" >> "$LOGFILE" 2>/dev/null
      else
       "${PARFACT_COMMAND[$a]}" >> "$LOGFILE" 2>/dev/null
     fi
    # echo "===================================================" >> "$LOGFILE"
    fi
   let a=a+1                      # increment subscript counter
  done
 #mv "$LOGFILE" "$DESTDIR"/PARFACT."$HOSTNAME"."$DOMAIN" >/dev/null 2>&1
time_stamp
}

time_stamp()
{
 echo "\n========================================================" >> "$LOGFILE"
 echo "System Information for "$HOSTNAME" - "$PAR_TIME"" >> "$LOGFILE"
 echo "========================================================" >> "$LOGFILE"
}
# --------------
# Main routines
# --------------
main()
{
 initialize
 par_fact 
 exit
}
# ----------------------
# Call to main routines 
# ----------------------
main
