#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               s9_osdisk.sh
## Application Name:     IT S9 Migration Tools
#
## Author:       BG
## Date Created: 14-NOV-2002
#
## General Description(Purpose): This script will examine system to 
#  find info about the O/S disk. If the O/S disk is mirrored via 
#  Veritas Volume Manager it will call function to break mirror, 
#  after user confirmation and use that disk for S9 migration.
#  If O/S disk is unmirrored it will prompt user for disk to use 
#
## Usage: This script is called part of s9_premigration.sh
#	  s9_osdisk.sh {OS_DISK}
#
## Required Parameters: N/A
## Optional Parameters: N/A
## Return Codes:    0 or 1
#
## Possible Points of Failure:
#
## Modification History:
#  -------------------------------------------------------------
#  Date         Name                     Comments    
#  -------------------------------------------------------------
#  23-JAN-2003  UM	                 Fix the Process_md function
#                                        1. Remove "sort -u" to maintain
#                                           order.
#                                        2. Added a check to make sure
#                                           same physical disk is not used 
#                                           for 2 submirrors.
#  09-JAN-2003  BG                       Moved ReRun disk selection.
#  09-JAN-2003  UM                       Added function Print_RSP
#  08-JAN-2003  BG                       Add O/S SDS Checking
#  23-DEC-2002  UM                       Added reference to Check_Cbe
#                                        in few places
#  14-NOV-2002  BG                       Initial Creation
#######################################################################


# Initialize Variables used within script

. /opt/${p_pkg_name}/etc/set_migration_env        # Global var/functions
. ${p_etc_dir}/s9_chk_partitions.kl           # Disk functions

PATH=${p_bin_dir}:/bin:/usr/sbin:/etc/vx/bin:/usr/opt/SUNWmd/sbin export PATH

Exit_Prog()
{
  l_rc=$1
  [[ -z "l_rc" ]] && l_rc=1
  /usr/bin/rm -f $l_dflist $l_md_rootfile
  Print_MSG FINISH 
  exit $l_rc
}
  

# Include server specific environment file variables
Include_File()
{ 
  if [ -f ${1} ]
  then
      . ${1}
  else
      Print_MSG ERROR ${1} does not exist
      Exit_Prog 1
  fi
}

Remove_Disk_Refs()
{
  /usr/bin/sed -e '/p_alt_be_s.=/d' \
      -e '/p_alt_be_disk=/d' \
      -e '/p_alt_be_.*_size=/d'   \
      -e '/ Slice Info for /d'   \
      -e '/p_alt_be_disksize=/d' \
      -e '/p_alt_be_.*_flag=/d' \
      -e '/p_alt_be_.*_tag=/d'  ${p_d_env_file} > /tmp/p_alt_be_disk_tmp.$$ && \
  /usr/bin/mv /tmp/p_alt_be_disk_tmp.$$ ${p_d_env_file}
}

Set_Disk_Var()
{
  Print_MSG BEGIN "Setting Disk variable in ${p_d_env_file}"

  Remove_Disk_Refs

  echo "p_alt_be_disk=\"${l_disk}\" ; export p_alt_be_disk" >> ${p_d_env_file}

  Print_MSG END "Setting Disk variable in ${p_d_env_file}"

  Print_MSG BEGIN "Basic disk validations"
    Validate_Disk
    l_rc=$?
  Print_MSG END "Basic disk validations"

  if [[ $l_rc -ne 0 ]]
  then
     Remove_Disk_Refs
     Exit_Prog $l_rc
  fi
}

Process_vxvm()
{
  l_VM=VxVM
  l_volname=`echo $l_devname | /usr/bin/awk -F/ '{print $NF}'`
  l_dg=`echo $l_devname | /usr/bin/awk -F/ '{print $5}'`

  [[ $l_dg = $l_volname ]] && export l_dg=rootdg

  l_rdevs=`/usr/sbin/vxprint -htqg $l_dg $l_volname | /usr/bin/grep '^sd' | /usr/bin/awk '{print $8}' | /usr/bin/sort -u`
  l_ndevs=`/usr/sbin/vxprint -g $l_dg $l_volname | /usr/bin/grep ^p | /usr/bin/grep -v LOGONLY | /usr/bin/wc -l \
  | /usr/bin/awk '{print $1}'`

  if [[ $l_ndevs -gt 1 ]]
  then
     export l_mirrored=YES
     if [[ "$MNTPOINT" = "/" ]]
     then
        l_disk2break=`/usr/sbin/vxprint -htqg $l_dg $l_volname | /usr/bin/grep ^sd | /usr/bin/sort -k 3 \
         | /usr/bin/tail -1 | /usr/bin/awk '{print $8}'`
     fi
  else
     export l_mirrored=NO
  fi
}

Process_md()
{
   l_VM=SDS
   l_volname=`echo $l_devname | /usr/bin/awk -F/ '{print $NF}'`
   l_rdevs=""
   metastat $l_volname > /tmp/${l_volname}.metastat.$$
   /usr/bin/sed -n -e 's/: Submirror/ Submirror/p' \
          -e '/c.*t.*d.*s[0-7]/p' /tmp/${l_volname}.metastat.$$ | \
          /usr/bin/sed -e '/Submirror/N; s/\n//' > /tmp/${l_volname}.metainfo

   # Use temp files to make sure we do not have more than two devices
   /usr/bin/cp /dev/null /tmp/l_md_devices.$$

   while read l_submirror l_junk l_junk l_mirror l_device l_junk l_junk l_state
   do 
      if [[ "$l_mirror" != "$l_volname" ]]
      then
         Print_MSG ERROR "Mismatch from metastat for $l_submirror's parent and volume $l_volname" 
         return 1
      fi

      if [[ "$l_state" != "Okay" ]]
      then
         Print_MSG ERROR "$l_device state is not Okay. Actual $l_state. Please fix and re-run."
         return 1
      fi

      l_tdev=`echo $l_device | /usr/bin/awk '{print substr($0,0,length($0)-2)}'`

      echo $l_tdev >> /tmp/l_md_devices.$$
   done < /tmp/${l_volname}.metainfo

   l_err_flag="N"
   for l_cnt in `/usr/bin/sort /tmp/l_md_devices.$$|/usr/bin/uniq -c|/usr/bin/awk '{print $1}'`
   do
      if [ ${l_cnt} -gt 1 ]
      then
          l_err_flag="Y"
      fi
   done

   l_ndevs=`/usr/bin/wc -l /tmp/l_md_devices.$$ | /usr/bin/awk '{print $1}'`
   l_rdevs=`/usr/bin/cat /tmp/l_md_devices.$$`

   /usr/bin/cat /tmp/l_md_devices.$$ > $l_md_rootfile && /usr/bin/rm -f /tmp/l_md_devices.$$

   case $l_ndevs in 
     1) l_mirrored=NO ;;
     2) if [ "${l_err_flag}" = "Y" ] ;
        then
            Print_MSG ERROR "$l_volname contains unsupported number of submirrors=$l_ndevs" ;
            exit 1;
        else
            l_mirrored=YES ;
        fi;;
     *) Print_MSG ERROR "$l_volname contains unsupported number of submirrors=$l_ndevs" ; return 1 ;;
   esac

   /usr/bin/rm -f /tmp/${l_volname}.metastat.$$ /tmp/${l_volname}.metainfo
}

Process_dsk()
{
   l_VM=None
   l_mirrored=NO
   l_rdevs=`echo $l_devname | /usr/bin/awk -F/ '{print $NF}' | /usr/bin/sed 's/s.$//'` 
}

Process_did()
{
   l_VM=None
   RMIRRORED=NO
   DIDNAME=`echo $DEVNAME | /usr/bin/awk -F/ '{print $NF}'` 
   DIDINFO=`didadm -L $DIDNAME | /usr/bin/awk '{print $2}'`
   DIDHOST=`echo $DIDINFO | /usr/bin/awk -F: '{print $1}'`
   DIDDEV=`echo $DIDINFO | /usr/bin/awk -F: '{print $2}' | /usr/bin/awk -F/ '{print $NF}'`
   if [[ "$DIDHOST" = "`uname -n`" ]]
   then
      l_rdevs=$DIDDEV
   else
      l_rdevs="Global SunCluster mount from $DIDINFO"
   fi

   Print_MSG ERROR "DID device encountered.. Not support in Version 1"
   Exit_Prog 1
}


Process_unknown()
{
   l_VM=Unknown
   RMIRRORED=Unknown
   l_rdevs=Unknown
}

Check_ReRun()
{
   let l_mdiskfound=0
   if [[ "$l_md_mirrored" = "1" || "$l_vx_mirrored" = "1" ]]
   then
      for l_mdisk in $l_disklist
      do
         if [[ "$l_mdisk" = "${l_prev_disk}" ]]
         then
            let l_mdiskfound=1
            break
         fi
      done
   fi
   return $l_mdiskfound
}

Select_Disk()
{
   l_selected=FALSE
   l_default=cXtXdX
   Print_MSG BEGIN "Selecting disk to use." 

   if [[ ! -z ${l_prev_disk} ]]
   then
      Check_ReRun
      Check_RC=$?
   fi

   if [[ "$Check_RC" = "0" ]]
   then
      echo "NOTE:  The Pre-Migration Module was previously executed on this system."
      echo "       Setting default selection to previously recorded ${l_prev_disk}\n"
      l_default=${l_prev_disk}
   fi
      
   while [[ "$l_selected" = "FALSE" ]]
   do

      echo "Please enter disk to use for the Solaris9 O/S (<${l_default}>, or <q> to quit)? \c"
      read l_disk
      Print_RSP ${l_disk}

      if [[ "$l_default" != "cXtXdX" && "$l_disk" = "" ]]
      then
         l_disk=$l_prev_disk
      fi

      if [[ "$l_disk" = "q" ]]
      then
         Print_MSG WARNING  "User requesting no disk to be selected, references removed"
         Print_MSG END "Selecting disk to use." 
         return 1
      fi

      if [[ ! -a "/dev/rdsk/${l_disk}s2" ]]
      then
         if [[ "$l_disk" = "" ]]
         then
            Print_MSG WARNING  "Input not recognized"
         else
            Print_MSG WARNING "/dev/rdsk/${l_disk}s2 does not exist"
         fi
      else
         echo "Please confirm that ${l_disk} will be used <default=no>? \c"
         read l_response
         Print_RSP ${l_response}

         if [[ "$l_response" != "y" && "$l_response" != "yes" && \
               "$l_response" != "Y" && "$l_response" != "YES" ]]
         then
            echo "Do you wish to select a different disk <default=no>? \c"
            read  l_response2
            Print_RSP ${l_response2}
            if [[ "$l_response2" != "y" && "$l_response2" != "yes" && \
                  "$l_response2" != "Y" && "$l_response2" != "YES" ]]
            then
               Print_MSG WARNING  "User requesting no disk to be selected, references removed"
               Print_MSG END "Selecting disk to use." 
               return 1
            fi
         else
            l_selected=TRUE
            Set_Disk_Var
            Gather_VTOC_Info Y
            l_rc=$?
            [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc
            Verify_Slices
            l_rc=$?
            if [ $l_rc -eq 0 -a $l_error -eq 1 ]
            then
                Check_Cbe
                l_rc=$?
                [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc
            else
                if [[ $l_rc -ne 0 ]]
                then
                    Exit_Prog $l_rc
                fi
            fi
         fi
      fi
        
   done


   Print_MSG END "Selecting disk to use." 
   Exit_Prog 0
}

Print_Data()
{
   let USED=$used/1000
   printf "%-30s %6dMB  %-7s   %-5s " $MNTPOINT $USED "$l_VM" "$l_mirrored"
   echo "$l_rdevs" | tr '\012' ' ' 
   echo ""
}

Process_Line()
{
   l_type=`echo $l_devname | /usr/bin/awk -F/ '{print $3}'`
   case $l_type in
     dsk) Process_dsk ;;
      vx) Process_vxvm ;;
      md) Process_md  ;;
     did) Process_did ;;
       *) Process_unknown ;;
   esac
  Print_Data
}

# MAIN
Print_MSG START 

#BEGIN Initialize Variables.
  l_rmirrored=1
  l_dflist=/tmp/dflist.$$ ; /usr/bin/rm -f $l_dflist
  l_log_file="s9_disk.log"
  l_prev_disk=${1} 
  l_md_rootfile=/tmp/md_devices.$$ export l_md_rootfile
  l_md_mirrored=0
  l_vx_mirrored=0
  Include_File ${p_d_env_file}
  Include_File ${p_etc_dir}/s9_break_mirror.kl
#END Initialize Variables.

# Make sure this file is empty. To be used if we have Metadevices
  /usr/bin/cp /dev/null $l_md_rootfile

Print_MSG BEGIN "Scan mountpoints for disk type/mirroring"
  /usr/sbin/df -kl | /usr/bin/grep '^/dev/' | /usr/bin/sort > $l_dflist

  printf "%-30s %8s %7s %8s %s\n" "Filesystem" "Used  " "Vol-MGR" "Mirrored"  "Device(s)"

  while read l_devname l_junk used l_junk l_junk MNTPOINT
  do 
     case "$MNTPOINT" in
        /|/opt|/var|/usr|/home) 
            Process_Line ;
            if [[ "$l_mirrored" = "NO" ]]
            then
               let l_rmirrored="l_rmirrored&0"
            else
               let l_rmirrored="l_rmirrored&1"
            fi ;;
        *)  ;;
     esac
  done < $l_dflist
Print_MSG END "Scan mountpoints for disk type/mirroring"

if [[ "$l_rmirrored" -eq 0 ]]
then
   Select_Disk 
   l_rc=$? 
   [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc
else
   if  [[ "$l_type" = "vx" ]] 
   then
      export l_vx_mirrored=1
      Break_Mirror_VX $l_disk2break
      l_rc=$?
      case "$l_rc" in 
        0) Set_Disk_Var;
           Gather_VTOC_Info Y;l_rc=$?;
           [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc;
           Check_Cbe;l_rc=$?
           [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc;;
        1) Print_MSG ERROR "Fatal error occured in Break_Mirror_VX" ; Exit_Prog 1 ;;
        2) Print_MSG INFO "User chose not to break the mirror and select a disk" ;
           Print_MSG END "Breaking the Veritas Mirror" ;
           Select_Disk ; l_rc=$? ; [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc ;;
        *) Print_MSG ERROR "Could not break mirror.  Error code RC($l_rc) from Break_Mirror_VX" ; Exit_Prog $l_rc ;;
      esac
   elif [[ "$l_type" = "md" ]]
   then
      export l_md_mirrored=1
      if [[ "`/usr/bin/wc -l $l_md_rootfile | /usr/bin/awk '{print $1}'`" -gt 2 ]]
      then
         Print_MSG ERROR "More than 2 devices found for O/S mirroring.  Please detach manually and re-run"
         Exit_Prog 1
      fi
      l_disk2break=`/usr/bin/tail -1 $l_md_rootfile`
      l_disklist=`/usr/bin/cat $l_md_rootfile` export l_disklist
      Break_Mirror_MD $l_disk2break
      l_rc=$?
      case "$l_rc" in 
        0) Set_Disk_Var;
           Gather_VTOC_Info Y;l_rc=$?;
           [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc;
           Check_Cbe;l_rc=$?
           [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc;;
        1) Print_MSG ERROR "Fatal error occured in Break_Mirror_MD" ; Exit_Prog 1 ;;
        2) Print_MSG INFO "User chose not to break the mirror and select a disk" ;
           Print_MSG END "Breaking the SDS Mirror" ;
           Select_Disk ; l_rc=$? ; [[ $l_rc -ne 0 ]] && Exit_Prog $l_rc ;;
        *) Print_MSG ERROR "Could not break mirror. Error code RC($l_rc) from Break_Mirror_MD" ; Exit_Prog $l_rc ;;
      esac
   else
      Print_MSG ERROR "O/S reports disk mirrored. Unknown Volume manager"
   fi
fi
echo "------------------------------------------------------------------------------"
   
Exit_Prog 0
