#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
## Source:               s9_mvpkg.sh
## Application Name:     IT S9 Migration Tools
#
## Author:              CS
## Date Created:        28-Jan-2003
#
## General Description(Purpose):
#             Move pkg contents and pkg definition for a given pkg
#             from current boot environment to alternate boot environment.
#
#             Module used in IT S9 Migration Process tool kit
#
#
## Usage:
#       s9_mvpkg.sh <pkgname>
#
## Required Parameters:         pkgname (existing in Current Boot Environment)
## Optional Parameters:         N/A
## Return Codes:
#               0 if successfully run to completion
#               >1 if errors occur
#
## Possible Points of Failure:
#
## Modification History:
#  -------------------------------------------------------------
#  Date         Name                     Comments
#  -------------------------------------------------------------
#  28-Jan-2003  CS		      Initial Creation
#  -------------------------------------------------------------
#######################################################################
#

l_pkgname=${1:-NONE}

p_alt_be_name="${p_alt_be_name:-S9BE}"

l_pkg_dir="/var/sadm/pkg"
l_contents_file="/var/sadm/install/contents"

l_altbe_root="/.alt.${p_alt_be_name}"

l_source_contents="${l_contents_file}"
l_target_contents="${l_altbe_root}${l_contents_file}"

l_this_script="`/usr/bin/basename $0`"

#
#awk script used for filtering files of a pkg
#For this awk script, stdin: grep -w pkgname /var/sadm/install/contents
#/app/smcadm/TLSsmcf/Tools_AM f none 0755 root other 3201 30454 1031044823 TLSsmcf
#
l_awk_pkg_files='
{
    if(NF > 10) next;	#Path in more than this pkg - skip
    if($2=="l" || $2=="s") {
        #link or symbolic link entry, print out first component
        split($1,pname,"=");
        print pname[1];
    }
    else {
        #print out path/file component
        print $1;
    }
}
'
#


#main

if [[ $# -ne 1 || -z "${l_pkgname}" ]]
then
    echo "ERROR: ${l_this_script}: Package name not supplied!"
    exit 1
fi

if [[ ! -f ${l_target_contents} ]]
then
    echo "ERROR: ${l_this_script}: Can't access pkg contents file in alternate boot environment!"
    exit 1
fi

/usr/bin/pkginfo -q ${l_pkgname}
if [[ $? -ne 0 ]]
then
    echo "WARNING: ${l_this_script}: No such package [${l_pkgname}] in current boot environment!"
    exit 1
fi

if [[ -f ${l_altbe_root}${l_pkg_dir}/${l_pkgname}/pkginfo ]]
then
    echo "WARNING: ${l_this_script}: ${l_pkgname} pkg definition already exists in ${p_alt_be_name}, skipping!"
    exit 1
fi

echo "\tTransferring pkg files for ${l_pkgname} ..."
#For each pkg get file list; filter file type; filter only local fs paths & cpio
/usr/bin/grep -w "${l_pkgname}" ${l_source_contents} \
 | /usr/bin/nawk "${l_awk_pkg_files}" \
 | /usr/bin/egrep -v -e "
`/usr/sbin/mount -p \
 | /usr/bin/nawk '{if($4==\"ufs\" || $4==\"vxfs\" || $4==\"lofs\") print $3;}' \
 | /usr/bin/egrep -v '^/$|^/var$|^/opt$|^/usr$' 
`
" \
 | /usr/bin/cpio -pdum ${l_altbe_root}

#Transfer pkg definition dir from current BE OS to new BE
echo "\tTransferring pkg definition for ${l_pkgname} ..."
/usr/bin/find ${l_pkg_dir}/${l_pkgname} -print | cpio -pdum ${l_altbe_root}
echo "\tTransferring "contents" data for ${l_pkgname} ..."
/usr/bin/grep -w "${l_pkgname:-Nothing to copy}" ${l_source_contents} >>${l_target_contents}
echo "\tPackage transfer completed for ${l_pkgname}. Review any ERRORs above."

