#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
#
## Source:               cleanup_to_restart.sh
## Application Name:     IT S9 Migration Tools
#
## Author:              SG
## Date Created:        09-Jan-2003
#
## General Description(Purpose):
#	This script maybe run at anytime in the S9 Migration to reset
#	the environment back to a clean restart point.
#
#	NB: 
#	It will *NOT* remirror any disk-mirroring broken via the migration
#	process.
#	It will *NOT* remove the Package ITSMs9mig
#
## Usage:
#       cleanup_to_restart.sh
#
## Required Parameters:         N/A
## Optional Parameters:         N/A
## Return Codes:
#               0 if successfully run to completion
#               >1 if errors occur
#
## Possible Points of Failure:
#
## Modification History:
#  -------------------------------------------------------------
#  Date         Name                    Comments
#  -------------------------------------------------------------
#  09-JAN-2003  SG			Initial Creation
#
#######################################################################


l_pkg_dir="/opt/ITSMs9mig"
l_etc_dir="${l_pkg_dir}/etc"
l_bin_dir="${l_pkg_dir}/bin"
l_log_dir="/var/sadm/system/logs"
l_tmp_dir="/var/tmp"
l_date="/usr/bin/date +%Y%m%d_%T"

printf "This script will delete \n"
printf "\t 1. Alternate Boot Environement\n"
printf "\t 2. LU Software\n"
printf "Do you want to continue <default no>"
read l_ans
l_ans=`echo ${l_ans}|tr "[a-z]" "[A-Z]"`
if [[ "${l_ans}" = "Y" || "${l_ans}" = "YES" ]]
then 
    :
else
   if [[ "${l_ans}" = "NO" || "${l_ans}" = "" ]]
   then
       echo "Terminating cleanup"
       exit 0
   else
       echo "Terminating cleanup"
       exit 0
   fi
fi

echo "\n***WARNING*** This script does NOT re-mirror any disk mirrors broken in previous S9 Migrations"
sleep 2

#Verify user

l_user=`/usr/xpg4/bin/id -un`

if [ "${l_user}" != "root" ]
then
   echo "INFO  : Current user is ${l_user}\n"
   echo "ERROR : This script runs only as root , exiting"
   exit 1
fi

l_os_rel=`uname -r`

if [ "${l_os_rel}" = "5.6" ]
then
   l_list_patches="\
        111664-01 \
        111938-01 \
        "
fi
if [ "${l_os_rel}" = "5.7" ]
then
   l_list_patches="\
        111666-01 \
        111939-01 \
        108029-03 \
        "
fi
if [ "${l_os_rel}" = "5.8" ]
then
   l_list_patches="\
        111098-01 \
        109318-31 \
        108808-42 \
        111879-01 \
        "
fi

#Remove Boot environment if it exists

/usr/sbin/lustatus S9BE > /dev/null 2>&1

if [ $? -eq 0 ]
then
   /usr/sbin/lumount S9BE > /dev/null 2>&1

   if [ $? -ne 0 ]
   then
	  /usr/sbin/fuser -ck /.alt.S9BE
	  /usr/sbin/luumount S9BE > /dev/null 2>&1
   else
	  /usr/sbin/luumount S9BE > /dev/null 2>&1
   fi

   if [ $? -eq 0 ]
   then
      /usr/sbin/ludelete S9BE
   fi
fi

#Rename lutab file 

if [ -f "/etc/lutab" ]
then
   /bin/mv /etc/lutab /etc/lutabO > /dev/null 2>&1
   if [ $? -ne 0 ]
   then
       echo "WARNING : Failed moving lutab"
   fi
else
   echo "INFO : /etc/lutab not found"
fi

#Remove lu packages

/bin/pkginfo SUNWluu > /dev/null 2>&1

if [ $? -eq 0 ]
then
    /usr/sbin/pkgrm -n SUNWluu
else
    echo "INFO : package SUNWluu not installed"
fi

/bin/pkginfo SUNWlur > /dev/null 2>&1

if [ $? -eq 0 ]
then
    /usr/sbin/pkgrm -n SUNWlur
else
    echo "INFO : package SUNWlur not installed"
fi

#Remove patches

for l_ptch in `echo ${l_list_patches}`
do
  /usr/sbin/patchrm ${l_ptch} > /dev/null 2>&1
  if [ $? -ne 0 ]
  then
     echo "INFO : patch ${l_ptch} is not installed"
  fi
done

# Move dynamic config file

/bin/mv ${l_pkg_dir}/etc/s9_`hostname`_env ${l_tmp_dir}/s9_`hostname`_env.`${l_date}` >/dev/null 2>&1

# Remove temporary files

/bin/rm /tmp/RUNS9* >/dev/null 2>&1

exit 0

#End Cleanup
