#!/bin/ksh
#
#######################################################################
# Copyright (c) 1997-2004 Sun Microsystems, Inc. All Rights Reserved.
#
# SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
# THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
# TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
# PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
# ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
# DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
#
# 
## Source:               Run_S9_migration_process.sh
## Application Name:     IT S9 Migration Tools
#
## Author:               UM
## Date Created:         16-NOV-2002
#
## General Description (Purpose):
#     This script is wrapper for three steps of s9 migration process.
#     It will make basic checks and log the output of step being
#     called, as well as stdout. It will also send log output as an
#     email for the purposes any central logging. You must edit
#     email address in this script appropriately before using.
#
## Usage:             Run_S9_migration_process.sh <name of the module>
#                     i.e Run_S9_migration_process.sh s9_premigration
#
## Required Parameters:  <name of the module>
## Optional Parameters:  N/A
## Return Codes:         0 or 1
#
## Possible Points of Failure: Passing non-valid script as a parameter
#  will fail this wrapper script
#
## Modification History:
#  -------------------------------------------------------------
#  Date         Name                     Comments    
#  -------------------------------------------------------------
#  16-NOV-02    UM                       Initial Creation
#  12-DEC-02    UM                       Added email capability
#  08-JAN-02    UM                       Added the tr to l_host and l_domain
#  29-JAN-03    UM                       Added code to fold s9_migration log file
#######################################################################


l_pkg_dir="/opt/ITSMs9mig"
l_etc_dir="${l_pkg_dir}/etc"
l_bin_dir="${l_pkg_dir}/bin"
l_log_dir="/var/sadm/system/logs"
l_host="`/usr/bin/uname -n | tr "[A-Z]" "[a-z]"`"
l_domain="`/usr/bin/domainname | nawk -F'.' '{print $2}' | tr [:upper:] [:lower:]`"
l_d_env_file="s9_${l_host}_env"

PATH=$PATH:${l_bin_dir}:${l_etc_dir}; export PATH

if [ ! $# -eq 1 ]
then
    echo "USAGE : `basename $0 .sh` <migration module name>"
    exit 0
fi


l_arg1=$1

case "$l_arg1" in
     s9_premigration) l_script_name="$l_arg1.sh";;
     s9_migration) l_script_name="$l_arg1.sh" ;;
     s9_postmigration) l_script_name="$l_arg1.sh" ;;
     *) echo "\nUSAGE : `basename $0 .sh` <migration module name>" ;
        echo "\nValid Module Choices : ";
        echo "\t\ts9_premigration";
        echo "\t\ts9_migration";
        echo "\t\ts9_postmigration" 
        exit 1;;
esac
       
if [ -f "${l_etc_dir}/set_migration_env" ]
then
    . ${l_etc_dir}/set_migration_env
else
      echo "ERROR: ${l_etc_dir}/set_migration_env not found"
      exit 1
fi

read_env()
{
if [ -f "${l_etc_dir}/${l_d_env_file}" ]
then
   . ${l_etc_dir}/${l_d_env_file}
fi
}

read_status()
{
case "$l_arg1" in
     s9_premigration) l_flag="${p_premig_flag}";;
     s9_migration) l_flag="${p_mig_flag}";;
     s9_postmigration) l_flag="${p_postmig_flag}";;
esac
}

send_email()
{
 read_env
 read_status

 l_log_file=$1

/bin/mail -t ${p_email_id:-"it-s9-support@EMAIL_EDIT_THIS"} <<!EOF!
From: S9mig - ${l_host}.${l_domain} <it-s9-support@EMAIL_EDIT_THIS>
Subject: S9mig|`date -u '+%Y%m%d_%H%M%S_%Z'`|${l_host}|${l_domain}|`hostid`|`uname -r`|${l_arg1}|${l_flag}|`/usr/bin/pkgparam ${p_pkg_name} VERSION`
`cat ${l_log_file}`
!EOF!
}

read_env
read_status

# Run the script.

if [ -x "${l_bin_dir}/${l_script_name}" ]
then
    if [[ ! -z "${l_flag}" && "${l_flag}" = "Y" && "${l_arg1}" != "s9_premigration" ]]
    then
        echo "[`${p_DATE}`] Module ${l_script_name} has already ran sucessfully"
        exit 0
    else
        echo "[`${p_DATE}`] Running Module - ${l_arg1}"
        [[ -f "${l_log_dir}/${l_arg1}.log" ]] && /usr/bin/cp -p ${l_log_dir}/${l_arg1}.log ${l_log_dir}/${l_arg1}.logO
        ${l_bin_dir}/${l_script_name} 2>&1 | tee ${l_log_dir}/${l_arg1}.log
        if [ "${l_arg1}" = "s9_migration" ]
        then
            /usr/bin/cat ${l_log_dir}/${l_arg1}.log | /usr/bin/tr '\r' '\n' \
            | /usr/bin/tr '\b' ' ' > ${l_log_dir}/${l_arg1}.log.tmp
            [ $? -eq 0 ] && /usr/bin/mv ${l_log_dir}/${l_arg1}.log.tmp ${l_log_dir}/${l_arg1}.log
        fi
        send_email "${l_log_dir}/${l_arg1}.log"
    fi
else
    Print_MSG ERROR "${l_arg1} not found"
    exit 1
fi
