// JavaScript Document
// I18N Strings --- begin ---
var strTitle = "Advanced Client Advisor"; 
var strNoRecommendationMsg = "The Advisor does not have a suitable method to recommend.  There are either no solutions that fulfill at least one objective or there are no solutions for your client's platform that do not require additional hardware and software beyond what you have indicated.  Either go back to verify you have made all relevant selections, or consult the Other Solutions list for alternatives.";
var strUnsupportedMsg = "Advanced Client does not support the indicated client platform for the choices you have made. Please go back and edit your choices.";
var strAdvisorRecommendsTitle = "The Advisor Recommends...";
var strUnsupportedClientTitle = "Unsupported Client";
var strClientDescription = "Client Description";
var strObjectives = "Primary Interests and Preferences";
var strRecommendationFulfills = "See below for the list of preferences that the recommended solution fulfills.  A colored star indicates that the solution meets the preference, a grey star indicates that it does not."
var strFutureSolutions = "The Advisor Ranks Other Solutions Requiring Additional Hardware or Software";
var strGoBack = "Go back to modify your inputs.";
var strAllSolutions = "The Advisor Ranks All Supported Solutions";
var strRankText = "If you are willing to acquire additional hardware or software, here is the list of additional backup solutions for the client.  The stars indicate how many preferences are met.";
var strAllSolutionsText = "These solutions use the hardware and software you indicated you have or are willing to purchase. The stars indicate how many objectives are met.";
var strNoObjectives = "Note: No desired objectives were specified, therefore all methods will be considered.";
var strOtherDBMsg = "Advanced Client methods are not available for databases other than those listed, unless the data files are treated as a file system.  \n\nMessage #1";
var strOtherOSMsg = "Advanced Client methods are not available for clients with operating systems other than those listed.\n\nMessage #2";
var strOtherFSMsg = "Advanced Client methods are not available for clients with file systems other than those listed.  \n\nMessage #3";
var strRecommendationStart = "Given your objectives and the software you have (or are willing to purchase), the Advisor recommends ";
var strRecommendationEnd = " as the Advanced Client technology that best suits your stated objectives and the capabilities of the client system.";
var strReadMore = "Read more about this method...";
var strNoDBSpecified = "Please specify the database.  You have indicated that the asset type is a database, but have not checked which type of database.";
var strStartOver = "Start Over";
var strAssetType = "Asset Type:";
var strOS = "Operating System:";
var strDB = "Database:";
var strFS = "File System:";
var strDBAsset = "database"; // keep lower case
var strFSAsset = "file system"; // keep lower case
var snaptypePreference = {F:"Prefer file system snapshot", H:"Prefer hardware snapshot", V:"Prefer volume snapshot",R:"Prefer replication snapshot"};
var inputname = new Array("Solaris", "HP", "AIX", "Windows", "Other OS", "VxFS", "OJFS", "UFS", "NTFS", "NAS", "Other FS",  "Oracle", "DB2", "SQL Server", "Exchange", "other DB", "volume", "raw partition", "Requires EMC", "Requires Hitachi disk", "Requires HP XP disk", "Requires alt client", "Requires 3PC device", "Requires NBU media server", "Requires VxFS", "Requires VxVM", "Requires VxVM FlashSnap", "Requires VVR", "Keep snapshots on the client for instant recovery", "Reduce traffic on the network by using a data mover",  "Utilize special hardware","Use snapshots to perform 'hot' backup to reduce downtime", "wants snap type of FS/HW/Vol/Rep", "<70% allocated (unix)", "<40% allocated (windows)", "GB+ database size w/ <10% change rate", "EMC disk array", "HDS disk array", "HP XP disk array");

var strBrowserNote = "<span class='bodyText'>" + '<br><br><strong> NOTE:</strong> When using Netscape, Mozilla, or any other Gecko-based browser:<br>' + "</span>";
strBrowserNote += "<span class='bodyText'>" +  'to view the links on this page, right click the link and choose \"Open Link in New Window.\"'+ "</span>";
strBrowserNote += "<span class='bodyText'>" +'<br> Doing this avoids a problem using the back button after clicking a link from this page.   '+ "</span>";

// I18N Strings --- end ---

var iSolaris = 0;
var iHP = 1;
var iAIX = 2;
var iWin = 3;
var iOOS = 4;
var iVxFS = 5;
var iOJFS = 6;
var iUFS = 7;
var iNTFS = 8;
var iNAS = 9;
var iOFS = 10;
var iOracle = 11;
var iDB2 = 12;
var iSQLServer = 13;
var iExchange = 14;
var iODB = 15;
var iVol = 16;
var iRaw = 17;
var iLastPlatform = 17;
var iFirstRequirement = 18;
var iEMC = 18;
var iHDS = 19;
var iHPXP = 20;
var iRAlt = 21;
var iR3PC = 22;
var iRMsvr = 23;
var iRVxFS = 24;
var iRVxVM = 25; 
var iRVxVMf = 26; 
var iRVVR = 27; 
var iLastRequirement = 27;
var iFirstObj = 28;
var iPFI = 28;
var iOffhost = 29;
var iHdware = 30;
var iSnap = 31;
var iSnaptype = 32;
var iUalloc = 33;
var iWalloc = 34;
var iDBrate = 35;
var iLastObj = 35;
var iDisplayName = 36;
var iURL = 37;
var iShortName = 38;
var iLast = 38;
var iLastDisplayObj = 32; 
//check browser type
var isIE = navigator.appVersion.indexOf("MSIE")>0;
var isNav = navigator.appVersion.indexOf("Nav")>0;
var ns4 = ((document.layers) ? true:false);
var ns6 = (document.getElementById)? true:false;
var newWindow = "";
	
function analyze(goal) {
	var nChoices = 62;
	var i; 
	var a = new Array(nChoices);

a[0]= new Array(1,1,0,1,0,1,1,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,"V",0,0,0,"Local Backup of Snapshot using vxvm","vxvm-local.html");
a[1]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,"V",0,0,0,"Offhost Media Server Copy of Snapshot using vxvm","vxvm-msc.html");
a[2]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,1,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,"V",0,0,0,"Offhost Data Mover Backup of Snapshot using vxvm","vxvm-datamover.html");
a[3]= new Array(1,1,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,"V",1,1,0,"FlashBackup of Snapshot using vxvm","vxvm-flashbackup.html");
a[4]= new Array(1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,1,"V",1,1,0,"Offhost Media Server FlashBackup of Snapshot using vxvm","vxvm-flashbackup-msc.html");
a[5]= new Array(1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,1,"V",1,1,0,"Offhost Data Mover FlashBackup of Snapshot using vxvm","vxvm-flashbackup-dm.html");
a[6]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,1,"V",1,1,0,"FlashBackup of Snapshot using vxvm","vxvm-flashbackup.html");
a[7]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,1,0,1,"V",1,1,0,"Offhost Media Server FlashBackup of Snapshot using vxvm","vxvm-flashbackup-msc.html");
a[8]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,1,0,1,"V",1,1,0,"Offhost Data Mover FlashBackup of Snapshot using vxvm","vxvm-flashbackup-dm.html");
a[9]= new Array(1,1,0,1,0,1,1,1,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,"V",0,0,0,"Instant Recovery using vxvm","vxvm-PFI.html");
a[10]= new Array(0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"V",0,0,0,"Local Backup of Snapshot using VSP","vsp-local.html");
a[11]= new Array(0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"V",0,1,0,"FlashBackup of Snapshot using VSP","vsp-flashbackup.html");
a[12]= new Array(0,0,0,1,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"V",0,0,0,"Local Backup of Snapshot using VSS","vss-local.html");
a[13]= new Array(0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"V",0,1,0,"FlashBackup of Snapshot using VSS","vss-flashbackup.html");
a[14]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,"H",0,0,0,"Local Backup of Snapshot using BusinessCopy","BusinessCopy-local.html");
a[15]= new Array(1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,1,"H",1,0,0,"FlashBackup of Snapshot using BusinessCopy","BusinessCopy-flashbackup.html");
a[16]= new Array(1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Media Server FlashBackup of Snapshot using BusinessCopy","BusinessCopy-flashbackup-msc.html");
a[17]= new Array(1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Data Mover FlashBackup of Snapshot using BusinessCopy","BusinessCopy-flashbackup-dm.html");
a[18]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,"H",1,0,0,"FlashBackup of Snapshot using BusinessCopy","BusinessCopy-flashbackup.html");
a[19]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Media Server FlashBackup of Snapshot using BusinessCopy","BusinessCopy-flashbackup-msc.html");
a[20]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Data Mover Flash Backup of Snapshot using BusinessCopy","BusinessCopy-flashbackup-dm.html");
a[21]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Media Server Copy of Snapshot using BusinessCopy","BusinessCopy-msc.html");
a[22]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Data Mover Backup of Snapshot using BusinessCopy","BusinessCopy-datamover.html");
a[23]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Alternate Client Backup of Snapshot using BusinessCopy","BusinessCopy-altclient.html");
a[24]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,1,"H",0,0,0,"Local Backup of Snapshot using ShadowImage","ShadowImage-local.html");
a[25]= new Array(1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,"H",1,0,0,"FlashBackup of Snapshot using ShadowImage","ShadowImage-flashbackup.html");
a[26]= new Array(1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Media Server FlashBackup of Snapshot using ShadowImage","ShadowImage-flashbackup-msc.html");
a[27]= new Array(1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Data Mover FlashBackup of Snapshot using ShadowImage","ShadowImage-flashbackup-dm.html");
a[28]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,"H",1,0,0,"FlashBackup of Snapshot using ShadowImage","ShadowImage-flashbackup.html");
a[29]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Media Server FlashBackup of Snapshot using ShadowImage","ShadowImage-flashbackup-msc.html");
a[30]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Data Mover FlashBackup of Snapshot using ShadowImage","ShadowImage-flashbackup-dm.html");
a[31]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,0,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Alternate Client Backup of Snapshot using ShadowImage","ShadowImage-altclient.html");
a[32]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,1,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Media Server Copy of Snapshot using ShadowImage","ShadowImage-msc.html");
a[33]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Data Mover Backup of Snapshot using ShadowImage","ShadowImage-datamover.html");
a[34]= new Array(1,1,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,"H",0,0,0,"Local Backup of Snapshot using TimeFinder","TimeFinder-local.html");
a[35]= new Array(1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,"H",1,0,0,"FlashBackup of Snapshot using TimeFinder","TimeFinder-flashbackup.html");
a[36]= new Array(1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Media Server FlashBackup of Snapshot using TimeFinder","TimeFinder-flashbackup-msc.html");
a[37]= new Array(1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Data Mover FlashBackup of Snapshot using TimeFinder","TimeFinder-flashbackup-dm.html");
a[38]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,1,"H",1,0,0,"FlashBackup of Snapshot using TimeFinder","TimeFinder-flashbackup.html");
a[39]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Media Server FlashBackup of Snapshot using TimeFinder","TimeFinder-flashbackup-msc.html");
a[40]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,0,1,1,1,"H",1,0,0,"Offhost Data Mover FlashBackup of Snapshot using TimeFinder","TimeFinder-flashbackup-dm.html");
a[41]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Media Server Copy of Snapshot using TimeFinder","TimeFinder-msc.html");
a[42]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Data Mover Backup of Snapshot using TimeFinder","TimeFinder-datamover.html");
a[43]= new Array(1,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,1,1,1,"H",0,0,0,"Offhost Alternate Client Backup of Snapshot using TimeFinder","TimeFinder-altclient.html");
a[44]= new Array(1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"F",1,0,0,"FlashBackup of Snapshot using VxFS_Snapshot","VxFS_Snapshot-flashbackup.html");
a[45]= new Array(1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,"F",0,0,0,"Instant Recovery using VxFS_Checkpoint","VxFS_Checkpoint-PFI.html");
a[46]= new Array(1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,"F",0,0,0,"Local Backup of Snapshot using VxFS_Checkpoint","VxFS_Checkpoint-local.html");
a[47]= new Array(1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,0,1,"F",0,0,0,"Offhost Media Server Copy of Snapshot using VxFS_Checkpoint","VxFS_Checkpoint-msc.html");
a[48]= new Array(1,1,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,"F",0,0,0,"Offhost Data Mover Backup of Snapshot using VxFS_Checkpoint","VxFS_Checkpoint-datamover.html");
a[49]= new Array(1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"V",0,0,0,"Local Backup of Snapshot using nbu_snap","nbu_snap-local.html");
a[50]= new Array(1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,"V",1,0,0,"FlashBackup of Snapshot using nbu_snap","nbu_snap-flashbackup.html");
a[51]= new Array(1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,"V",1,0,0,"Offhost Media Server FlashBackup of Snapshot using nbu_snap","nbu_snap-flashbackup-msc.html");
a[52]= new Array(1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,"V",1,0,0,"Offhost Data Mover FlashBackup of Snapshot using nbu_snap","nbu_snap-flashbackup-dm.html");
a[53]= new Array(1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,1,0,1,"V",0,0,0,"Offhost Media Server Copy of Snapshot using nbu_snap","nbu_snap-msc.html");
a[54]= new Array(1,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,1,0,1,"V",0,0,0,"Offhost Data Mover Backup of Snapshot using nbu_snap","nbu_snap-datamover.html");
a[55]= new Array(1,1,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,1,0,1,0,1,"R",0,0,0,"Offhost Alternate Client Backup of Snapshot using VVR","VVR-altclient.html");
a[56]= new Array(1,1,0,0,0,1,1,1,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,1,0,0,0,1,1,1,0,1,"R",0,0,0,"Instant Recovery using VVR","VVR-PFI.html");
a[57]= new Array(1,1,0,1,0,1,1,1,1,0,0,1,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,"V",0,0,0,"Offhost Alternate Client Backup of Snapshot using FlashSnap","FlashSnap-altclient.html");
a[58]= new Array(1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,1,"V",1,1,0,"Offhost Alternate Client FlashBackup of Snapshot using FlashSnap","FlashSnap-flashbackup-alt.html");
a[59]= new Array(0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,1,"V",1,1,0,"Offhost Alternate Client FlashBackup of Snapshot using FlashSnap","FlashSnap-flashbackup-alt.html");
a[60]= new Array(1,1,1,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,"0",0,0,1,"Local Backup using BLI","BLIB-local.html");
a[61]= new Array(1,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,"H",0,0,0,"Offhost Instant Recovery Backup using NAS_Snapshot","NAS-offhost-IR.html");






var headerend = "</head>\n\n<body >\n<table width='90%' border=0 cellpadding=8>\n\n <tr><td width='100' background='images/leftpane-splash.gif'></td><td>";
var headerbegin = "<html><head><title>" + strTitle + "</title><meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>";
var footer = "</td></tr></table></body></html>";

	var OSname = "-";
	var FSname = "-";
	var DBname = "-";
	var Assetname = "-";
	
	var m = new Array(iLast+2);
	for (i=0; i <= iLastObj; i++) {
		m[i] = 0;
	}
	for (i=iLastObj+1; i <= iLast; i++) {
			m[i] = "User inputs";  // for debugging. do not I18n-ize
	}
	m[iSnaptype] = "0";
	
	var reqs = new Array(nChoices);
	var supp = new Array(nChoices);
	var objs = new Array(nChoices);
	for (i=0; i < nChoices; i++) {
		reqs[i] = 1; //Initialize all method choices to meet requirements
		supp[i] = 1; //Initialize all method choices to meet support
		objs[i] = 0; //Initialize all method choices to meet zero objectives
	}
  var len;
	m[iPFI] = (document.FM.prefpfi.checked ? 1 : 0);
	m[iOffhost] = (document.FM.prefdmv.checked? 1 : 0);
	m[iHdware] = (document.FM.prefhw.checked? 1 : 0);
	m[iSnap] = (document.FM.prefsnap.checked? 1 : 0);
	len = document.FM.snapshottype.length;
	for (i=0; i < len; i++) {
		if (document.FM.snapshottype[i].disabled) break;
		if (document.FM.snapshottype[i].checked) {
			m[iSnaptype] = document.FM.snapshottype[i].value;		
		}
	}	
	len = document.FM.os.length;
	for (i=0; i < len; i++) {
	  if (document.FM.os[i].disabled) continue;
		if (document.FM.os[i].checked == false) continue;
		switch (document.FM.os[i].value) {
		 case "solaris" :  m[iSolaris] = 1; OSname = inputname[iSolaris]; break;
		 case "hp" : m[iHP] = 1; OSname = inputname[iHP]; break;
		 case "aix" : m[iAIX] = 1; OSname = inputname[iAIX]; break;
		 case "windows" : m[iWin] = 1; OSname = inputname[iWin]; break;
		 case "other" : // unsupported client OS	
			// An error message displayed
			// when user selected option, but we need to warn again.
			 m[iOOS] = 1; 
			 msg(2); 
			 return false;
		 } 
	}
	len = document.FM.fs.length;
	for (i=0; i < len; i++) {
	  if (document.FM.fs[i].disabled) continue;
		if (document.FM.fs[i].checked == false) continue;
		switch (document.FM.fs[i].value) {
		 case "vxfs" :  m[iVxFS] = 1; FSname = inputname[iVxFS]; break;
		 case "ojfs" : m[iOJFS] = 1; FSname = inputname[iOJFS];  break;
		 case "ufs" : m[iUFS] = 1; FSname = inputname[iUFS];  break;
		 case "ntfs" : m[iNTFS] = 1; FSname = inputname[iNTFS];  break;
		 case "nas" : m[iNAS] = 1; FSname = inputname[iNAS];  break;
		 case "other" : // unsupported client file system	
			// An error message displayed
			// when user selected option, but we need to warn again.
			 m[iOFS] = 1; 
			 msg(3); 
			 return false;
		 } 
	}
	len = document.FM.db.length;
	for (i=0; i < len; i++) {
	  if (document.FM.db[i].disabled) continue;
		if (document.FM.db[i].checked == false) continue;
		switch (document.FM.db[i].value) {
		 case "oracle" :  m[iOracle] = 1; DBname = inputname[iOracle];  break;
		 case "sqlserver" : m[iSQLServer] = 1;  DBname = inputname[iSQLServer];  break;
		 case "db2" : m[iDB2] = 1;  DBname = inputname[iDB2];  break;
		 case "exchange" : m[iExchange] = 1;  DBname = inputname[iExchange];  break;
		 case "other" : // unsupported client database	
			// An error message displayed
			// when user selected option, but we need to warn again.
			 m[iODB] = 1; 
			 msg(1); 
			 return false;
		 } 
	}	
	len = document.FM.assettype.length;
	for (i=0; i < len; i++) {
	  if (document.FM.assettype[i].disabled) continue;
		if (document.FM.assettype[i].checked == false) continue;
		switch (document.FM.assettype[i].value) {
			case "db" : Assetname = strDBAsset;  break;
			case "fs" : Assetname = strFSAsset;  break;
		 	case "lvol" :  m[iVol] = 1; Assetname = inputname[iVol];  break;
		 	case "rawp" : m[iRaw] = 1; Assetname = inputname[iRaw];  break;
		 } 
	}	
	if (Assetname == "database" && DBname == "-") {
		alert(strNoDBSpecified);
		return false;
	}
	
	if (document.FM.hds.checked) m[iHDS] = 1;
	if (document.FM.emc.checked) m[iEMC] = 1;
	if (document.FM.hpxp.checked) m[iHPXP] = 1;
	m[iRVxFS] = m[iVxFS];
	if (document.FM.rvxvm.checked) { m[iRVxVM] = 1; }
	if (document.FM.r3pc.checked) m[iR3PC] = 1;
	if (document.FM.rvxvmf.checked) { m[iRVxVMf] = 1; m[iRVxVMf] = 1; }
	if (document.FM.rvvr.checked) { m[iRVVR] = 1; m[iRVxVMf] = 1; }
	if (document.FM.ralt.checked) m[iRAlt] = 1;
	if (document.FM.rmsvr.checked) m[iRMsvr] = 1;
	if (!document.FM.ualloc.disabled && document.FM.ualloc.checked) m[iUalloc] = 1;
	if (!document.FM.walloc.disabled && document.FM.walloc.checked) m[iWalloc] = 1;
	if (!document.FM.dbchar.disabled && document.FM.dbchar.checked) m[iDBrate] = 1;
	
  var nDesiredObjectives = 0;
	for (i = iFirstObj; i <= iLastObj; i++) {
		if (m[i] != 0 && m[i] != "0") { nDesiredObjectives++; }
  	}
	var nSupportedMethods = 0;
	for (i=0; i < nChoices; i++) {
		reqs[i] = requirementsMet(a[i], m, iFirstRequirement, iLastRequirement);
		supp[i] = supportExists(a[i], m, iSolaris, iLastPlatform);
		nSupportedMethods += supp[i];
		objs[i] = numberObjectivesMet(m, a[i], iFirstObj, iLastObj);
	}
	var str = headerbegin;		
	/*var isIE = navigator.appVersion.indexOf("MSIE")>0;
	var isNav = navigator.appVersion.indexOf("Nav")>0;
	var ns4 = ((document.layers) ? true:false);
	var ns6 = (document.getElementById)? true:false;*/
	if(isIE) ns6=false;

	if (isIE) {
		str += "<link href='style_en_ie.css' rel='stylesheet' type='text/css'>\n";
	} 
	if (isNav || ns4 ||ns6) {	
		str += "<link href='style_en_ns.css' rel='stylesheet' type='text/css'>\n";
	}
	str += "<script language='JavaScript1.2' src='resultgen.js'></script>\n";
	str += "<script language='JavaScript1.2' src='header.js'></script>\n";
  	str += "</head>\n";
	str += writeHeader(1);
  	str += "\n<body bgcolor='#FFFFFF' leftmargin='0' topmargin='0'>\n";
	str += "<table width='90%' border=0 cellpadding=8>\n";
	str += "<tr><td width='100' background='images/leftpane-splash.gif'></td><td>\n";
	
  if (goal == "debug") {
		str += "<table border=0 cellpadding=3>\n";
		str += printKey(m);
		for (var i=0; i < nChoices; i++) {
			str += "\n<tr>" + printArray(a[i]) + "\n";
			str += "<td bgcolor='#FFCCFF'>" + (supp[i] ? "Y" : "-") + "</td>\n";
			str += "<td bgcolor='#FFCCCC'>" + (reqs[i] ? "Y" : "-") + "</td>\n";
			str += "<td bgcolor='#FFCC99'>" + objs[i] + "</td></tr>\n";
		}
		str += "</table>\n";
		str += footer;
		document.write(str);
		document.close();
	  return true;
  }
				
	str += "<script type='text/javascript' src='selection.js'></script>";
	var minObj = (nDesiredObjectives < 1 ? 0 : 1);
	var recommendation = -1;
	for (var obj=nDesiredObjectives; minObj <= obj && recommendation < 0; obj--) {
			for (var i=0; i < nChoices && recommendation < 0; i++) {
				if (obj == objs[i] && supp[i] && reqs[i]) {
					recommendation = i;
				}
			}
	}
	str += "<table><tr><td valign='top'>";
	str += "<span class='questionText'>";
	str += strClientDescription; 
	str += "</span><p></p>";
	str += "<table border='0' cellpadding='3' class='bodyText'>";
	// Show client asset type
	str += "<tr><td nowrap align='right'><strong>";
	str += strAssetType;
	str += "</strong></td><td nowrap>";
	str += Assetname;
	str += "</td></tr>";
	// show client OS			
	str += "<tr><td nowrap align='right'><strong>";
	str += strOS;
	str += "</strong></td><td nowrap>";
	str += OSname;
	str += "</td></tr>";
	str += "</td></tr>";
	// show client FS			
	str += "<tr><td nowrap align='right'><strong>";
	str += strFS;
	str += "</strong></td><td nowrap>";
	str += FSname;
	str += "</td></tr>";
	str += "</td></tr>";
	// show client DB			
	str += "<tr><td nowrap align='right'><strong>";
	str += strDB;
	str += "</strong></td><td nowrap>";
	str += DBname;
	str += "</td></tr>";
	str += "</td></tr></table>";
	str += "</td><td><img src='images/spacer.gif' width='10'></td><td valign='top'>";
	str += "<span class='questionText'>";
	str += strObjectives;
	str += "</span><p></p><ul>";

	for (var i=27; i <= iLastDisplayObj; i++) {
			if (m[i] != 0 && m[i] != "0" && m[i] != "N") { 
				str += "<li class='bodyText'>";
				switch(m[i]) {
					case "F" : 
					case "H" :
					case "V" :
					case "R" :
						str += snaptypePreference[m[i]]; 
						break;
					default :
					str += inputname[i]; 
				}
				str += "</li>";
			}
  	}
		str += "</ul></td></tr>";
		str += "<tr><td colspan='3'>";
		str += "<a href='javascript:history.back()'><img src='images/arrow-ico.gif' border='0'></a> &nbsp;";
		str += "<span class='bodyText'>" + strGoBack + "</span>";
		if(!isIE)
		{
			str += strBrowserNote ; 
		}
		str += "</td></tr></table><p></p>";

 
 if (nSupportedMethods <= 0 ) {
 			str += "<p><span class='questionText'>" + strUnsupportedClientTitle + "</span></p>\n";
			str += "<p class='bodyText'>";
			str += strUnsupportedMsg;
			str += "</p>"; 
 }		
 else {
   if (recommendation < 0) {
 			str += "<p><span class='questionText'>" + strAdvisorRecommendsTitle + "</span></p><p></p>\n";
			str += "<p class='bodyText'>\n";
			str += strNoRecommendationMsg;
			str += "</p>\n";
		}
  	else {
			str += "<p><span class='questionText'>" + strAdvisorRecommendsTitle + "</span></p><p></p>\n";
			str += "<p><center><span class='headlineText'>\n";
			str += a[recommendation][iDisplayName] + "</span></center></p>\n";
			str += "<p><span class='bodyText'>\n";
			str += strRecommendationStart;
			str += "</span class='bodyText'>\n";
			//str += "<a href='methods/" + a[recommendation][iURL] + "'>" + a[recommendation][iDisplayName]+ "</a>\n";
			str += printURL( a[recommendation][iDisplayName],  a[recommendation][iURL]);
			//str += "<a href='' onClick='displayLink('methods/" + a[recommendation][iURL] + "')'>" + a[recommendation][iDisplayName]+ "</a>\n";
			str += "<span class='bodyText'>\n";
			str += strRecommendationEnd + "  ";
			str += "</span class='bodyText'>\n";
			str += printURL( strReadMore,  a[recommendation][iURL]);
			//str += "<a href='methods/" + a[recommendation][iURL] + "'>" + strReadMore + "</a>\n";
			//str += "<a href='methods/" + a[recommendation][iURL] + "'>" + strReadMore + "</a>\n";
			//str += "<a href='' onclick=\"displayLink('methods/" + a[recommendation][iURL] + "')\">" + strReadMore + "</a>\n";
			//Shelleybegin
			str += "</p>";
			str += strRecommendationFulfills;
			str += "<p></p>";

	for (var i=iFirstObj; i <= iLastObj; i++) {
			if (m[i] != 0 && m[i] != "0" && m[i] != "N") { 
				if (objectiveMet(a[recommendation], i)) { 
					str += "<img align='top' src='images/star-ico.gif'>&nbsp;"; 
					} else { 
					str += "<img align='top' src='images/grey-star-ico.gif'>&nbsp;"; 
					}
				switch(m[i]) {
					case "F" : 
					case "H" :
					case "V" :
					case "R" :
						str += snaptypePreference[m[i]]; 
						break;
					default :
					str += inputname[i]; 
				}
				str += "<br>";
			}
  	}
	str += "</span>";
			// shelley end
			str += "<div align=right>";
			str += "<form>";
			str += "<input  class='button' type='button' value='" + strStartOver + "' ";
			str += " onclick='startOver();'";
			str += "</form>";
			str += "</div>";
			str += "<span class='questionText'>" + strAllSolutions + "</span><p></p>";
			str += "<p><span class='bodyText'>" + strAllSolutionsText + "</span></p>";
			if (nDesiredObjectives < 1) {
				str += "<span class='bodyText'>" + strNoObjectives + "</span><p>";
			}
			str += "<p></p><ul>";
			minObj = (recommendation < 0 ? 0 : 1); // Look at all solutions if there is no recommendation solution
			for (var obj=nDesiredObjectives; minObj <= obj; obj--) {
					for (var i=0; i < nChoices; i++) {
							if (obj == objs[i] && supp[i] && 0 < reqs[i]) {
									var path = "methods/" + a[i][iURL];
									str += printURL(a[i][iDisplayName], path) + "&nbsp;";
									var stringObjectiveArray = stringObjectivesMet(m, a[i], iFirstObj, iLastObj);
									for (var n=1; n <= objs[i]; n++) 
									{ 
										 str += "<img align='top' src='images/star-ico.gif'"; 
										 str += " alt=\""+ stringObjectiveArray[n-1] + "\">"; 
									}
									str += "</br>";
							}
					}
			}
			str += "</ul>";
		} // end of else
		// Create the list of methods that fulfill the user's objectives
		str += "<p>&nbsp;</p>";
		str += "<p><span class='questionText'>" + strFutureSolutions + "</span></p><p></p>";
		str += "<p><span class='bodyText'>" + strRankText + "</span></p>";
		str += "<p></p><ul>";
		minObj = (recommendation < 0 ? 0 : 1); // Look at all solutions if there is no recommendation solution
		var printSolutions = false ;
		for (var obj=nDesiredObjectives; minObj <= obj; obj--) {
			for (var i=0; i < nChoices; i++) {
					if (obj == objs[i] && supp[i] && (reqs[i] != 1 || (recommendation < 0 && reqs[i]))) {
						var path = "methods/" + a[i][iURL];
						str += printURL(a[i][iDisplayName], path) + "&nbsp;";
						var stringObjectiveArray = stringObjectivesMet(m, a[i], iFirstObj, iLastObj);
						for (var n=1; n <= objs[i]; n++) { 
							 str += "<img  align='top' src='images/star-ico.gif'"; 
							 str += " alt=\""+ stringObjectiveArray[n-1] + "\">"; 
						}
						str += "<br>";
						printSolutions = true ;
					}
			}
		}
		if(printSolutions == false)
		{
		  str += "</ul>No other solutions are available for the choices you have made.";
		}else
		{
		  str += "</ul>";
		}
	} // end of if (nSupportedMethods <= 0 ) {
	
	str += "<div align=right>";
	str += "<form>";
	str += "<input class='button' type='button' value='" + strStartOver + "' ";
	str += " onclick='startOver();'";
	str += "</form>";
	str += "</div>";
	str += footer;
	document.write(str);
	document.close();
	return false;
}

function printURL(displayName, fname) {
 var occur = fname.indexOf(".html")
 var newDisplayName = fname.substring(0, occur)

 occur = newDisplayName.indexOf("/");
 occur += 1;
 newDisplayName = fname.substring(occur , (newDisplayName.length))

 var s = "<a href='' onclick=\"printPros(\'" + newDisplayName + "\');\" class='methodLink'>" + displayName + "</a>\n";
 return s ;
}

// Returns true if the true values at indices i-j for the method
// are also true in the inputs indices.  A true at method[i]
// implies that the requirement must be met, i.e., the input[i]
// must be true.
function requirementsMet(method, inputs, a, b) {
	for (var i=a; i <= b; i++) {
		if (method[i] == 0) continue; // no need to compare
		if (inputs[i] == 0) return 0;
	}
	return 1;
}

function numberObjectivesMet(reqs, methods, a, b) {
  var matches = 0;
	for (var i=a; i <= b; i++) {
		if (i == iSnaptype) {
		   if (reqs[i] != "0" && reqs[i] == methods[i]) matches++;
			 continue;
		}
		if (reqs[i] == 0) continue; // no need to compare
		if (methods[i]) matches++;
	}
	return matches;
}

function supportExists(method, inputs, a, b) {
	for (var i=a; i <= b; i++) {
		if (inputs[i] == 0) continue; // no need to compare
		if (method[i] == 0) return 0;
	}
	return 1;
}

//add to support floating titles over stars.
function stringObjectivesMet(reqs, methods, a, b) {
	var matchStringArray = new Array(iLastDisplayObj);
	var matchNumber = 0;

	for (var i=a; i <= b; i++) {
		if (i == iSnaptype) {
		   if (reqs[i] != "0" && reqs[i] == methods[i]) {
				//alert("i = " + i);
				matchStringArray[matchNumber] = inputname[i]
				matchNumber++;
				continue;
			}
		}
		if (reqs[i] == 0) continue; // no need to compare
		if (methods[i]){
				matchStringArray[matchNumber] = inputname[i]
			   matchNumber++;
		} ;
	}
	return matchStringArray; 
}

function startOver() {
	self.location="../Advisor.html";
}

function msg(n) {
	switch (n) {
	case 1:    // 'other' DB selected
	alert (strOtherDBMsg);
	break
	case 2: // 'other' OS selected
	alert (strOtherOSMsg); 
	break;
	case 3: // 'other' FS selected
	alert (strOtherFSMsg);
	break;
	}
} 

function objectiveMet(solution, iObj) {
  if (solution[iObj] == 1) { return 1; }
  return 0;

}

// DEBUGGING BEGIN
function printArray(a) {
    var path = "methods/" + a[iURL];
	var s = "<td nowrap>" + printURL(a[iDisplayName], path) + "</td>";
	for (var i=0; i <= iLastObj; i++) {
		s += "<td bgcolor='#FFCC";
		if (0 <= i && i <= iLastPlatform) s+= "FF";
		if (iFirstObj <= i  && i <= iLastObj) s+= "99";
		if (iFirstRequirement <= i  && i <= iLastRequirement) s+= "CC";
		s += "' title='" + inputname[i] + "'>" + a[i] + "</td>";
	}
	return s;
}
//This function checks the browser and
//displays the web page based on 
function displayLink(newLink)
{
	if(!isIE)
	{
		if(newWindow != "" || newWindow != null)
		{
			newWindow.location.href = newLink;
		}else
		{
			newWindow = window.open(newLink, "methodInfo");
		}
	}else
	{
		window.location.href = newLink;
	}
	return true;
}

// For debugging output.  Do not i18n-ize
function printKey(inputs) {
	var s = "<tr>";
	var w = iLastPlatform + 1;
	s+= "<td></td><td bgcolor='#FFCCFF' colspan=" + w + "> Client's Support Profile</td>";
	w = iLastRequirement - iFirstRequirement + 1;
	s+= "<td  bgcolor='#FFCCCC' colspan=" + w + "> Method Requirements</td>";
	w = iLastObj - iFirstObj + 1;
	s+= "<td  bgcolor='#FFCC99' colspan=" + w + "> Objectives</td></tr>";
	s+= "<tr><td align=right><b> User Inputs</b></td>";
	for (var i=0; i <= iLastObj; i++) {
		s += "<td bgcolor='#FFCC";
		if (0 <= i && i <= iLastPlatform) s+= "FF";
		if (iFirstObj <= i && i  <= iLastObj) s+= "99";
		if (iFirstRequirement <= i && i  <= iLastRequirement) s+= "CC";
		s += "'><a href='' onclick='return false' title='" + inputname[i] + "'>" + inputs[i] + "</a></td>";
	}
	s+= "</tr>"
	return s;
}
// DEBUGGING END
// -->