/*==========================================================================;
 *
 * NetDiscover(R) - "MIB Web Publisher (Mib2Web)" component 
 *
 * File 	: NDMib2WebConfig.js
 * Version	: 2.5.1.1
 * Date 	: 2004/03/04
 *
 * Copyright (C) 2002-2004 Pierrick SIMIER.  All Rights Reserved.
 * 
 * The information in this file is confidential and proprietary to
 * Pierrick SIMIER. Unauthorized use or duplication is strictly
 * prohibited.
 * 
 * Business: Supervise Network
 * Web:  www.supervise-network.fr
 * Email: Pierrick.SIMIER@supervise-network.fr
 * 
 * Personal: SNMPLink.org
 * Web:  www.snmplink.org
 * Email: PSIM@snmplink.org
 ***************************************************************************/

if (typeof g_ndLoad != 'undefined')
{
	// --------------
	// --- Path ---
	// --------------
	g_ndImgPath = 'img/'; // Images
	g_ndZipPath = 'zip/'; // Zip - Download


	// -------------------
	// ---			   ---
	// --- OnlineMIB : ---
	// ---			   ---
	// -------------------

	// --- Logo
	g_ndLogoImgFile 					= g_ndImgPath + 'Logo.gif';
	g_ndBGLogoImgFile					= ''; // background image or ''
	g_ndLogoImgWidth					= 90;
	g_ndLogoImgHeight					= 48;
	g_ndLogoXpos						=  2;  // -1:center, 0:left, n:Xpos
	g_ndLogoYpos						= -1;  // -1:center, 0:top,  n:Ypos
	g_ndWidthSpaceAfterLogo 			= 20;
	g_ndLogoImgAlt						=		 "www.bea.com"; // or '';
	g_ndLogoHref						= "http://www.bea.com"; // or ''
	g_ndLogoHrefTarget					= '_top'; // '_blank';

	// --- Splash
	g_nd_bShowSplash					= true;
	g_nd_bSplashImg 					= g_ndImgPath + 'Splash.gif';
	g_nd_bSplashWidth					= 425;
	g_nd_bSplashHeight					= 350;
	g_nd_bSplashAlt 					= "";	// "MIB Web Publisher - www.Supervise-Network.fr";
	g_nd_bSplashHref					= null; // "http://www.Supervise-Network.fr/MIBWebPublisher.html";

	// --- Copyright
	g_ndCopyrightHtml					= 'Copyright &copy; 2003-2004, BEA Systems, Inc. All Rights Reserved. <A href="mailto:docsupport@bea.com?subject=Question Regarding MIB Documentation">Contact e-docs</A>';

	// --- Title
	g_ndOnlineMibWindowsTitleText		= '';
	g_ndOnlineMibOptionalTitleHtml		= '<b>WebLogic Server 8.1 MIB Reference</b>'; // or '';

	// --- Frame Top
	g_ndHeightFrameTop					= g_ndOnlineMibOptionalTitleHtml ? 63 : 46; // Minimum

	// --- Mib Tree Options
	g_ndOnlineMIB_bShowAccess			= true;
	g_ndOnlineMIB_bShowEnum 			= true;

	// --- Colors : Top Frame
	g_ndBGColorFrameTop 				= 'white';
	g_ndBGColorImput					= '#F8F8F8'; // <-BEA-> '#FFF7F1';
	g_ndColorOptionalTitle				= '#003366';
	g_ndColorImputLabel 				= '#666666';  // 'Name' & 'Value'
	g_ndColorImputText					= '#003366'; // <-BEA-> '#FF6600';  // '.iso.org.dod...' & '.1.3.6...'

	// --- Colors : Nav Bar & Tab
	g_ndBGColorFrameNavBar				= '#4876A3';

	g_ndColorActiveTabFace				= 'silver';
	g_ndColorActiveTabHighlight 		= 'white';
	g_ndColorActiveTabDarkShadow		= '#404040';
	g_ndColorActiveTabShadow			= ndMixColor(g_ndColorActiveTabFace, g_ndColorActiveTabDarkShadow); // '#808080';
	g_ndColorActiveTabText				= 'black';

	g_ndColorInactiveTabFace			= '#E8E8E8';
	g_ndColorInactiveTabHighlight		= 'white';
	g_ndColorInactiveTabDarkShadow		= '#606060';
	g_ndColorInactiveTabShadow			= ndMixColor(g_ndColorInactiveTabFace, g_ndColorInactiveTabDarkShadow); // '#A0A0A0';
	g_ndColorInactiveTabTextLink		= 'black';
	g_ndColorInactiveTabTextLinkHover	= '#0000FF'; // <-BEA-> '#FF6600';

	// --- Colors : Dir Tree, Mibs Tree & Mib tree
	g_ndBGColorFrameDirTree 			= 'FFFFF0';
	g_ndBGColorFrameMibsTree			= 'F0FFF0';
	g_ndBGColorFrameMibTree 			= 'white';
	g_ndBGColorFrameMibTreeEmpty		= g_ndBGColorFrameMibTree;
	g_ndBGColorFrameMibFileEmpty		= 'white';	  // use with empty frame else use .css

	g_ndColorSplitter					= g_ndBGColorFrameNavBar; // !!! Not work with Opera
	g_ndColorOptionalRectWithFrame		= 'gray';	  // color or '' for default 3D frame.	Works with IE only
	g_ndColorOptionalRectWithFrameSearchResult = 'black';
	g_ndColorSearchError				= 'Red';
	g_ndBGColorSearchResultDefault		= 'white';

	g_ndScrollbarArrowColor 			= '#4876A3';  // use '' for default color.	Works with IE only
	g_ndScrollbarBaseColor				= 'silver';   // use '' for default color.	Works with IE only
	g_ndScrollbar3dLightColor			= '';		  // use '' for default color.	Works with IE only
	g_ndScrollbarFaceColor				= '';		  // use '' for default color.	Works with IE only
	g_ndScrollbarDarkShadowColor		= '';		  // use '' for default color.	Works with IE only
	g_ndScrollbarHighlightColor 		= '';		  // use '' for default color.	Works with IE only
	g_ndScrollbarShadowColor			= '';		  // use '' for default color.	Works with IE only
	g_ndScrollbarTrackColor 			= '';		  // use '' for default color.	Works with IE only

	g_ndColorTreeText					= 'black'; 
	g_ndColorTreeTextOld				= 'gray';
	g_ndColorTreeLink					= '#003366';
	g_ndColorTreeLinkOld				= ndMixColor(g_ndColorTreeLink, g_ndColorTreeTextOld, 66 /* % : 0..100 */);
	g_ndColorTreeLinkHover				= '#0000FF'; // <-BEA-> '#FF6600';
	g_ndBGColorSelectItem				= '#E0E0FF';

	g_ndColorMenuText					= g_ndColorTreeText;
	g_ndColorMenuTextOld				= g_ndColorTreeTextOld;
	g_ndColorMenuLink					= g_ndColorTreeLink;
	g_ndColorMenuLinkOld				= g_ndColorTreeLinkOld;
	g_ndColorMenuLinkHover				= g_ndColorTreeLinkHover;

	g_ndColorMessage					= g_ndColorTreeText; // 'Downloading...'

	// --- Colors : Bottom Frame
	g_ndBGColorFrameBottom				= g_ndBGColorFrameNavBar;
	g_ndColorCopyrightText				= 'white';
	g_ndColorCopyrightLink				= g_ndColorCopyrightText;
	g_ndColorCopyrightLinkHover 		= '#FFCF00';
	g_ndImgPoweredByInv 				= 1; // 0:Black text, 1:White text

	// --- Colors : Window Legend
	g_ndBGColorWindowLegend 			= '#F8F8F8'; // <-BEA-> '#FFF7F1';

	// --- Colors : Window Download
	g_ndBGColorWindowDownload			= g_ndBGColorWindowLegend;
	g_ndColorDownloadText				= g_ndColorTreeText;
	g_ndColorDownloadTextLink			= g_ndColorTreeLink;
	g_ndColorDownloadTextLinkHover		= g_ndColorTreeLinkHover;
	g_ndWidthWindowDownload 			= 300;
	g_ndHeightWindowDownload			= 100;

	// --- Colors : Window Search
	g_ndBGColorSearchImput				= 'white';
	g_ndColorSearchImputText			= g_ndColorImputText;
	g_ndBGColorWindowSearch 			= g_ndBGColorWindowLegend;
	g_ndColorSearchText 				= g_ndColorTreeText;
	g_ndColorSearchTextLink 			= g_ndColorTreeLink;
	g_ndColorSearchTextLinkHover		= g_ndColorTreeLinkHover;
	g_ndBorderWindowSearch				= 6;
	g_ndWidthWindowSearch				= (ndFR ? 304 : 280) + g_ndBorderWindowSearch*2;
	g_ndHeightWindowSearch				= 265+g_ndBorderWindowSearch*2;

	// --- Font Family
	g_ndStyleFontFamily 				= 'FONT-FAMILY:Microsoft Sans Serif,Tahoma,Arial,Helvetica,Swiss,SunSans-Regular,Sans-Serif,Verdana';
	g_ndStyleFontFamilyMessage			= g_ndStyleFontFamily;
	g_ndStyleFontFamilyDownloadText 	= g_ndStyleFontFamily;
	g_ndStyleFontFamilySearch			= g_ndStyleFontFamily;
	g_ndStyleFontFamilyTitle			= 'FONT-FAMILY:Arial,Geneva,Helvetica';
	g_ndStyleFontFamilyCopyright		= 'FONT-FAMILY:Arial,Geneva,Helvetica';

	// --- Font Size
	g_ndStyleFontSize					= 'FONT-SIZE:11px';
	g_ndStyleFontSizeMessage			= 'FONT-SIZE:14px';
	g_ndStyleFontSizeDownloadText		= g_ndStyleFontSize;
	g_ndStyleFontSizeSearchText 		= g_ndStyleFontSize;
	g_ndStyleFontSizeTitle				= 'FONT-SIZE:15px';
	g_ndStyleFontSizeCopyright			= 'FONT-SIZE:10px';

	// --- Splitter
	g_ndFrameBorder 					= 7; // NS, Mozilla, Phoenix
	g_ndFrameSpacing					= 4; // IE, Opera

	// --- Option
	g_ndOnlineMIB_AutoDownloadMIBsTree	= false;
	g_ndOnlineMIB_bDrawTreeAfterLoad	= true; // false works with IE only


	// ---------------------------------------------------
	// --- 'MIB File'								   ---
	// ---											   ---
	// --- ndMib2Web_DrawMibFileTree() Default Options ---
	// ---------------------------------------------------
	g_ndMib2Web_DrawMibFileTree_bShowAccess  = true;
	g_ndMib2Web_DrawMibFileTree_bShowEnum	 = true;
	g_ndMib2Web_DrawMibFileTree_bTableBorder = false;
	g_ndMib2Web_DrawMibFileTree_rgbBGColor	 = null; // null or RGB Color, Ex : '#F0FFF5'


	// --------------------------------------------
	// --- 'MIB Tree'							---
	// ---										---
	// --- ndMib2Web_DrawTree() Default Options ---
	// --------------------------------------------
	g_ndMib2Web_DrawTree_bShowAccess  = true;
	g_ndMib2Web_DrawTree_bShowEnum	  = true;
	g_ndMib2Web_DrawTree_bTableBorder = true;
	g_ndMib2Web_DrawTree_rgbBGColor   = g_ndBGColorFrameMibTree; // null or RGB Color, Ex : '#F0FFF5'



	// =====================================================================
	// === 
	// === 'OverLib' PopUp Library Support : "OverLib.js"
	// === 
	// =====================================================================

	bUseOverLibPopUp		= true; 	 // use 'OverLib' PopUp Library  
	bNoBreakWithPopUp		= true; // <-BEA-> false;
	bNoWrapWithPopUp		= false;	 // use TRUE with PopUp_WIDTH = null;

	// PopUp with 'MIB Tree'
	// ---------------------

	PopUp_WIDTH 			= 350;		 // value or null; 

	// Popup Caption Font & Color
	PopUp_CAPTIONFONT		= 'Verdana,Arial,Helvetica';
	PopUp_CAPTIONSIZE		= 10;
	PopUp_CAPTIONSIZEUNIT	= 'px';
	PopUp_CAPTIONWEIGHT 	= 'bold';	 // "normal", "bold", "bolder", "lighter", ect.
	PopUp_CAPTIONSTYLE		= 'normal';  // "normal" or "italic"
	PopUp_CAPTIONDECORATION = 'none';	 // "none", "underline", "line-through" or "blink"
	PopUp_CAPCOLOR			= 'white';
	PopUp_BGCOLOR			= '#4876A3'; // <-BEA-> '#FF6600';

	// Popup Text Font & Color
	PopUp_TEXTFONT			= PopUp_CAPTIONFONT;
	PopUp_TEXTSIZE			= PopUp_CAPTIONSIZE;
	PopUp_TEXTSIZEUNIT		= PopUp_CAPTIONSIZEUNIT;
	PopUp_TEXTWEIGHT		= 'normal'; // "normal", "bold", "bolder", "lighter", ect.
	PopUp_TEXTSTYLE 		= 'normal'; // "normal" or "italic"
	PopUp_TEXTDECORATION	= 'none';	// "none", "underline", "line-through" or "blink"
	PopUp_FGCOLOR			= '#EEF3F8'; // <-BEA-> '#FFF7F1';
	PopUp_TEXTCOLOR 		= 'black';


	// Menu with 'MIBs Tree'
	// ---------------------

	// Menu Caption Font & Color
	Menu_CAPTIONFONT		= PopUp_CAPTIONFONT;
	Menu_CAPTIONSIZE		= 11;
	Menu_CAPTIONSIZEUNIT	= PopUp_CAPTIONSIZEUNIT;
	Menu_CAPTIONWEIGHT		= PopUp_CAPTIONWEIGHT;
	Menu_CAPTIONSTYLE		= PopUp_CAPTIONSTYLE;
	Menu_CAPTIONDECORATION	= PopUp_CAPTIONDECORATION;
	Menu_CAPCOLOR			= 'white';;
	Menu_BGCOLOR			= 'dodgerblue';

	// Menu Text Font & Color
	Menu_TEXTFONT			= PopUp_TEXTFONT;
	Menu_TEXTSIZE			= PopUp_TEXTSIZE;
	Menu_TEXTSIZEUNIT		= PopUp_TEXTSIZEUNIT;
	Menu_TEXTWEIGHT 		= PopUp_TEXTWEIGHT;
	Menu_TEXTSTYLE			= PopUp_TEXTSTYLE;
	Menu_TEXTDECORATION 	= PopUp_TEXTDECORATION;
	Menu_FGCOLOR			= 'lightgrey';
	Menu_TEXTCOLOR			= 'black';

	Menu_CLOSEFONT			= Menu_CAPTIONFONT;
	Menu_CLOSESIZE			= Menu_CAPTIONSIZE;
	Menu_CLOSESIZEUNIT		= Menu_CAPTIONSIZEUNIT;
	Menu_CLOSEWEIGHT		= 'normal'; // "normal", "bold", "bolder", "lighter", ect.
	Menu_CLOSESTYLE 		= 'normal'; // "normal" or "italic"
	Menu_CLOSEDECORATION	= 'none';	// "none", "underline", "line-through" or "blink"
	Menu_CLOSECOLOR 		= 'white';


	var g_OverLib_StickyMenuFrame = null;

	function OverLib_PlugLibrary(doc)
	{
		// ------------------------------------
		// --- Plug 'OverLib' PopUp Library ---
		// ------------------------------------
		doc.write('<DIV id="overDiv" style="position:absolute; visibility:hidden; z-index:1000;"></DIV>'
				 +'<SCRIPT language="JavaScript" src="js/OverLib.js"></SCRIPT>');
	}

	function OverLib_IsVisible(frame)
	{
		// show overlib.js
		//	- var over
		//	- function showObject(obj)
		if (typeof frame.overlib != 'undefined')
		{
			var obj = frame.over;
			if (frame.ns4) 
				return obj.visibility == "show";
			if (frame.ie4) 
				return obj.visibility == "visible";
			if (frame.ns6) 
				return obj.style.visibility == "visible";
		}
		return false;
	}

	function OverLib_IsPluged(frame)
	{
		return typeof frame.overlib != 'undefined';
	}

	function OverLib_DrawPopUp(frame, caption, msg)
	{
		if (OverLib_IsPluged(frame))
		{
			if (bNoWrapWithPopUp)
				msg = '<TABLE border=0 cellspacing=0 cellpadding=0><TR><TD nowrap>'
					 +'<FONT style="font-family:'    +PopUp_TEXTFONT
								 +';font-size:' 	 +PopUp_TEXTSIZE+PopUp_TEXTSIZEUNIT
								 +';font-weight:'	 +PopUp_TEXTWEIGHT
								 +';font-style:'	 +PopUp_TEXTSTYLE
								 +';text-decoration:'+PopUp_TEXTDECORATION
								 +';color:' 		 +PopUp_TEXTCOLOR
								 +'">'+msg+'</FONT></TD></TR></TABLE>';

			// ----------------------------
			// --- Draw 'OverLib' PopUp ---
			// ----------------------------
			frame.overlib(msg, 
				frame.CAPTION		   , caption, 
				frame.CSSSTYLE,
				frame.WIDTH 		   , PopUp_WIDTH, 
				frame.CAPTIONFONT	   , PopUp_CAPTIONFONT,
				frame.CAPTIONSIZE	   , PopUp_CAPTIONSIZE,
				frame.CAPTIONSIZEUNIT  , PopUp_CAPTIONSIZEUNIT,
				frame.CAPTIONWEIGHT    , PopUp_CAPTIONWEIGHT,
				frame.CAPTIONSTYLE	   , PopUp_CAPTIONSTYLE,
				frame.CAPTIONDECORATION, PopUp_CAPTIONDECORATION,
				frame.CAPCOLOR		   , PopUp_CAPCOLOR,
				frame.BGCOLOR		   , PopUp_BGCOLOR,
				frame.TEXTFONT		   , PopUp_TEXTFONT,
				frame.TEXTSIZE		   , PopUp_TEXTSIZE,
				frame.TEXTSIZEUNIT	   , PopUp_TEXTSIZEUNIT,
				frame.TEXTWEIGHT	   , PopUp_TEXTWEIGHT,
				frame.TEXTSTYLE 	   , PopUp_TEXTSTYLE,
				frame.TEXTDECORATION   , PopUp_TEXTDECORATION,
				frame.FGCOLOR		   , PopUp_FGCOLOR,
				frame.TEXTCOLOR 	   , PopUp_TEXTCOLOR);
		}
	}

	function OverLib_DrawMenu(frame, caption, msg, bSTICKY)
	{
		if (OverLib_IsPluged(frame))
		{
			if (	g_OverLib_StickyMenuFrame
				 && frame.over == null)
				g_OverLib_StickyMenuFrame = null; // <- Reload

			if (	(g_OverLib_StickyMenuFrame == frame)
				 && !bSTICKY
				 && OverLib_IsVisible(frame) )
				 return;

			g_OverLib_StickyMenuFrame = bSTICKY ? frame : null;

			msg = '<TABLE border=0 cellspacing=0 cellpadding=0><TR><TD nowrap>'
				 +'<FONT style="font-family:'    +Menu_TEXTFONT
							+'; font-size:' 	 +Menu_TEXTSIZE+Menu_TEXTSIZEUNIT
							+'; font-weight:'	 +Menu_TEXTWEIGHT
							+'; font-style:'	 +Menu_TEXTSTYLE
							+'; text-decoration:'+Menu_TEXTDECORATION
							+'; color:' 		 +Menu_TEXTCOLOR+'">'
				 +msg
				 +'</FONT></TD></TR></TABLE>';

			// ---------------------------
			// --- Draw 'OverLib' Menu ---
			// ---------------------------
			frame.overlib(msg, 
				frame.CAPTION		   , bSTICKY ? 
			'<TABLE border=0 cellspacing=0 cellpadding=0><TR><TD nowrap>'
			 +'<FONT style="font-family:'    +Menu_CAPTIONFONT
					+'; font-size:' 	 +Menu_CAPTIONSIZE+Menu_CAPTIONSIZEUNIT
					+'; font-weight:'	 +Menu_CAPTIONWEIGHT
					+'; font-style:'	 +Menu_CAPTIONSTYLE
					+'; text-decoration:'+Menu_CAPTIONDECORATION
					+'; color:' 		 +Menu_CAPCOLOR+'">'
			 +'<IMG src="' + g_ndImgPath + 'Menu.gif" border=0 align=absmiddle width=14 height=11 alt="">' + caption + '&nbsp;'
			 +'</FONT></TD></TR></TABLE>'
			: '', 
				frame.CSSSTYLE,
				frame.WIDTH 		   , null, 
				frame.CAPTIONFONT	   , Menu_CAPTIONFONT,
				frame.CAPTIONSIZE	   , Menu_CAPTIONSIZE,
				frame.CAPTIONSIZEUNIT  , Menu_CAPTIONSIZEUNIT,
				frame.CAPTIONWEIGHT    , Menu_CAPTIONWEIGHT,
				frame.CAPTIONSTYLE	   , Menu_CAPTIONSTYLE,
				frame.CAPTIONDECORATION, Menu_CAPTIONDECORATION,
				frame.CAPCOLOR		   , Menu_CAPCOLOR,
				frame.BGCOLOR		   , Menu_BGCOLOR,
				frame.TEXTFONT		   , Menu_TEXTFONT,
				frame.TEXTSIZE		   , Menu_TEXTSIZE,
				frame.TEXTSIZEUNIT	   , Menu_TEXTSIZEUNIT,
				frame.TEXTWEIGHT	   , Menu_TEXTWEIGHT,
				frame.TEXTSTYLE 	   , Menu_TEXTSTYLE,
				frame.TEXTDECORATION   , Menu_TEXTDECORATION,
				frame.FGCOLOR		   , Menu_FGCOLOR,
				frame.TEXTCOLOR 	   , Menu_TEXTCOLOR,
				frame.CLOSEFONT 	   , Menu_CLOSEFONT,
				frame.CLOSESIZE 	   , Menu_CLOSESIZE,
				frame.CLOSESIZEUNIT    , Menu_CLOSESIZEUNIT,
				frame.CLOSEWEIGHT	   , Menu_CLOSEWEIGHT,
				frame.CLOSESTYLE	   , Menu_CLOSESTYLE,
				frame.CLOSEDECORATION  , Menu_CLOSEDECORATION,
				frame.CLOSECOLOR	   , Menu_CLOSECOLOR,
				frame.CLOSETEXT, ndFR ? 'Fermer' : 'Close',
				frame.OFFSETY		   , bSTICKY ? -2 : Menu_CAPTIONSIZE,
				bSTICKY ? frame.STICKY : 0);
		}
	}

	function OverLib_ClearPopUp(frame, bForceClose)
	{
		// -----------------------------
		// --- Clear 'OverLib' PopUp ---
		// -----------------------------
		if (bForceClose || (frame != g_OverLib_StickyMenuFrame))
			if (OverLib_IsPluged(frame))
			{
				if (bForceClose)
					g_OverLib_StickyMenuFrame = null;
				frame.nd(); // first Call
				frame.nd(); // second Call -> Hide Sticky Window
			}
	}


	function PopUp_PlugLibrary(doc)
	{
		if (bUseOverLibPopUp)
			OverLib_PlugLibrary(doc)
	}

	function PopUp_onMouseOver(ndTree, i, frame) 
	{ 
		if (OverLib_IsPluged(frame))
		{
			var ItemTree = nd_ItemTree(ndTree, i);
			var j = nd_ItemTree_GetShortcutObjectId(ItemTree);
			if (j)
				ItemTree = nd_ItemTree(ndTree, j);
			var sDesc = nd_ItemTree_sDesc(ItemTree);
			if (sDesc)
			{
				var name = nd_ItemTree_sName(ItemTree); 
				var msg  = bNoBreakWithPopUp 
							? ndText2HtmlWithoutBR(sDesc)
							: ndText2Html(sDesc);
				OverLib_DrawPopUp(frame, name, msg, false);
			}		
		}
		return false; // Use Default : Display name & value in status bar
	}

	function PopUp_onMouseOut(ndTree, i, frame) 
	{ 
		OverLib_ClearPopUp(frame, false/*bForceClose*/);
		return false; // Use Default : Restore status bar
	}



	// =====================================================================
	// === 
	// === 'OverLib' PopUp with 'Online MIB' & 'MIB File'
	// ===	
	// ===	 -> Init 'g_ndOnlineMibCallBack'
	// ===	
	// =====================================================================

	if (bUseOverLibPopUp)
	{
		g_ndOnlineMibCallBack = new NDClassCallBack();
		
		g_ndOnlineMibCallBack.PlugLibrary = function(doc)
		{
				   PopUp_PlugLibrary(doc);
		}

		g_ndOnlineMibCallBack.onMouseOver = function(ndTree, i, frame) 
		{ 
			return PopUp_onMouseOver(ndTree, i, frame);
		}

		g_ndOnlineMibCallBack.onMouseOut = function(ndTree, i, frame) 
		{ 
			return PopUp_onMouseOut(ndTree, i, frame);
		}

	}



	// =====================================================================
	// === 
	// === CallBack DEMO with 'MIB Tree' only
	// === 
	// =====================================================================

	ndCallBackMibTreeDEMO = new NDClassCallBack();
	
	ndCallBackMibTreeDEMO.PlugLibrary = function(doc)
	{
			   PopUp_PlugLibrary(doc);
	}

	ndCallBackMibTreeDEMO.onMouseOver = function(ndTree, i, frame) 
	{ 
		return PopUp_onMouseOver(ndTree, i, frame);
	}

	ndCallBackMibTreeDEMO.onMouseOut = function(ndTree, i, frame) 
	{ 
		return PopUp_onMouseOut(ndTree, i, frame);
	}

	ndCallBackMibTreeDEMO.onClick = function(ndTree, i, frame) 
	{
		var j = nd_Tree_GetShortcutObjectId(ndTree, i);
		if (j)
			i = j;
		var name = nd_Tree_sName(ndTree, i);
		var oid  = ndOid2NumStringExt(ndTree, i);

		/*
		var sDesc = nd_ItemTree_sDesc(ItemTree);
		var sMsg = name + ' : ' + oid;
		if (sDesc)
			sMsg += '\n\n' + sDesc;
		if (window.clipboardData)
			window.clipboardData.setData('Text', sMsg); // IE 5+ only
		*/

		alert('CallBack DEMO :\n\n' + name + ' : ' + oid ); 

		return false; /*Use Default*/
	}


	// =====================================================================
	// === 
	// === MIBs Tree Menu -> Use PopUp
	// === 
	// =====================================================================

	function ndO_PlugMenuLibrary(doc)
	{
		OverLib_PlugLibrary(doc);

		doc.write(
			  '<style type="text/css">'
			  /* NetDiscover Menu : 'A' */
			+ '.NDMENU { COLOR:'+g_ndColorMenuText+'; '+g_ndStyleFontSize+'; '+g_ndStyleFontFamily+' }'
			+ '.NDMENU A:link	 { COLOR:'+g_ndColorMenuLink+'; TEXT-DECORATION:underline }'
			+ '.NDMENU A:visited { COLOR:'+g_ndColorMenuLink+'; TEXT-DECORATION:none }'
			+ '.NDMENU A:hover	 { COLOR:'+g_ndColorMenuLinkHover+'; TEXT-DECORATION:underline }'
			+ '.NDMENU A:active  {}'
			  /* NetDiscover Menu : 'A' OLD */
			+ '.NDMENUOLD { COLOR:'+g_ndColorMenuTextOld+' }'
			+ '.NDMENUOLD A:link	{ COLOR:'+g_ndColorMenuLinkOld+'; TEXT-DECORATION:underline }'
			+ '.NDMENUOLD A:visited { COLOR:'+g_ndColorMenuLinkOld+'; TEXT-DECORATION:none }'
			+ '.NDMENUOLD A:hover	{ COLOR:'+g_ndColorMenuLinkHover+'; TEXT-DECORATION:underline }'
			+ '.NDMENUOLD A:active	{}'
			+ '</style>');
	}

	function ndO_OpenMenu(frame /*xframeMIBsTree*/, ndMIBsTree, i, bClick /* else bMouseOver */) 
	{ 
		if (OverLib_IsPluged(frame))
		{
			var szCaption = nd_Tree_sName(ndMIBsTree, i);
			var msg = new NDClassBuf;
			msg.write('<SPAN class=NDMENU>');
			var ndDirTree = ndO_GetDirTree();
			var idxModOfMibList = nd_MIBsTree_IdxModOfMibList(ndMIBsTree, i);
			var n = idxModOfMibList.length;
			var bTroncated = n>8 && !bClick;
			if (bTroncated)
				n = 8;
			for (var j=0; j<n; j++)
			{
				var k = parseInt(idxModOfMibList[j]);
				// --- Img of Mod
				var ItemTree = nd_ItemTree(ndDirTree, k);
				var nFA = nd_ItemTree_nFA(ItemTree);
				var a = '<A href="javascript:;" onClick="top.ndOnlineMibDoc.ndO_onMenuClick(' + i + ',' + k + ');" onMouseOver="return top.ndOnlineMibDoc.ndO_onMenuMouseOver(' + k + ');" onMouseOut="return top.ndOnlineMibDoc.ndO_onMenuMouseOut();">'
				var bA = bClick || (n>1);
				if (bA)
					msg.write(a);
				ndImg2(msg, ndN2H(nd_FA_nImg(nFA)), 19);
				if (bA)
					msg.write('</A>');
				// --- Mod Name & File Name
				var bOld = nd_FA_bOld(nFA);
				if (bOld)
					msg.write('<SPAN class=NDMENUOLD>');
				if (bA)
					msg.write(a);
				msg.write(ndFileName2Text(nd_ItemTree_sName(ItemTree)));
				if (!ndO_bOneFileOnly)
				{
					var nParent = nd_i_ItemTree_nParent(k, ItemTree);
					msg.write(' - ' + ndText2Html(ndFileName2Text(nd_Tree_sName(ndDirTree, nParent))));
				}
				if (bA)
					msg.write('</A>');
				if (bOld)
					msg.write('</SPAN>');
				msg.write('<BR>');
			}
			if (bTroncated)
				msg.write('...<BR>');
			msg.write('</SPAN>');
			OverLib_DrawMenu(frame, szCaption, msg.toString(), bClick /*bSTICKY*/);
		}
	}

	function ndO_CloseMenu(frame /*xframeMIBsTree*/, bForceClose) 
	{ 
		OverLib_ClearPopUp(frame, bForceClose);
	}

	g_ndConfigLoad = true;
}
