/*==========================================================================;
 *
 * NetDiscover(R) - "MIB Web Publisher (Mib2Web)" component 
 *
 * File 	: NDMib2Web.js
 * Version	: 2.5.1.2
 * Date 	: 2004/04/13
 *
 * Copyright (C) 2002-2004 Pierrick SIMIER.  All Rights Reserved.
 * 
 * The information in this file is confidential and proprietary to
 * Pierrick SIMIER. Unauthorized use or duplication is strictly
 * prohibited.
 * 
 * Business: Supervise Network
 * Web:  www.supervise-network.fr
 * Email: Pierrick.SIMIER@supervise-network.fr
 * 
 * Personal: SNMPLink.org
 * Web:  www.snmplink.org
 * Email: PSIM@snmplink.org
 * 
 * USE: 
 *	- JavaScript
 *	- Dynamic HTML (DHTML)
 *	- Document Object Model (DOM)
 *
 ***************************************************************************/

//function ASSERT(b) { if (!b) { alert('ASSERT'); breakpoint(); } }

// nFA : nFlagA
// nFB : nFlagB
// nL  : nLevel

var nd_bDOM = document.getElementById || document.all;

var nd_bDynamicDrawTree 	= true;
var nd_bDynamicFrameSupport = false;
var nd_bFrameNoSrc			= false;
var nd_bAcceptAchorFocus	= false; // Search & for SetFocus on Visible Imported Object(ex. 'iso'): false with NS: use focus(), true with IE: use location.achor=

var ndIE  = false;
var ndNS  = false;
var ndNS4 = false;
var ndMozilla1_4ab = false;
var ndOpera7_1 = false;
var ndOpera7_2 = false;
var ndOpera = navigator.userAgent.indexOf("Opera") != -1;
var ndSafari =    (navigator.userAgent.indexOf("konqueror") != -1)
               || (navigator.userAgent.indexOf("safari")    != -1);
var ndBrowserVersion = 0;

var ndWin = false;
var ndMac = false;

var ndFR=(	 (	 (typeof(navigator.userLanguage) != 'undefined') // IE
			  && (navigator.userLanguage.substring(0,2).toLowerCase() == "fr") )
		  || (	 (typeof(navigator.language) != 'undefined') // NS & Opera
			  && (navigator.language.substring(0,2).toLowerCase() == "fr") ) );

function ndInit()
{
	if (typeof(window.navigator.platform) != 'undefined')
	{
		var p = window.navigator.platform.toLowerCase();
		if (p.indexOf('win') != -1)  // Win
			ndWin = true;
		else 
		if (p.indexOf('mac') != -1)  // Mac
			ndMac = true;
	}
	if (ndOpera)
	{
		var u = navigator.userAgent;
		var i = u.indexOf("Opera/");
		if (i==-1)
			i = u.indexOf("Opera ");
		if (i!=-1)
			ndBrowserVersion = parseFloat(u.substring(i+6));
		if (ndBrowserVersion >= 7)
		{
			// Opera 7.x
			nd_bFrameNoSrc = false;
			// Opera 7.00b1 
			// Opera 7.00b2 accept 'true' or 'false'
			//
			// Opera 7.01
			// Opera 7.02 
			// Opera 7.10 accept 'false' only 
			//	ELSE ndFrameTitle.document
			//	=>
			//	 Error:
			//	 name: ReferenceError
			//	 message: Security error: attempted to read protected variable
			ndOpera7_2 = ndBrowserVersion >= 7.2;
			if (!ndOpera7_2)
				ndOpera7_1 = ndBrowserVersion >= 7.1;
		}
		nd_bAcceptAchorFocus = true;
	}
	else
	if (ndSafari)
	{
		// --- Apple Safari Browser (DOM Browser)

		nd_bFrameNoSrc       = false; // !!! Not Tested
		nd_bAcceptAchorFocus = true;  // !!! Not Tested
		
		ndBrowserVersion = -1; // Not Use
	}
	else
	switch(navigator.appName)
	{
	case "Microsoft Internet Explorer": 
		{
			ndIE = true; 
			nd_bDynamicFrameSupport = true;
			nd_bFrameNoSrc = false;
			ndBrowserVersion = parseFloat(navigator.appVersion.substring(navigator.appVersion.indexOf("MSIE ")+5));
		}
		break;
	case "Netscape":
		{
			ndNS = true; 
			nd_bAcceptAchorFocus = true;
			ndBrowserVersion = parseFloat(navigator.appVersion);
			if (ndBrowserVersion>=5)
			{
				var u = navigator.userAgent;
				var i = u.indexOf("Netscape6/"); // NS6
				if (i!=-1)
					i += 10;
				else
				{
					i = u.indexOf("Netscape/"); // NS7
					if (i!=-1)
						i += 9;
					else
					{
						// Mozilla/Phoenix
						ndMozilla1_4ab =	(u.indexOf("Mozilla/5.0")!=-1)
										 && (	 (u.indexOf("rv:1.4a) Gecko/")!=-1)
											  || (u.indexOf("rv:1.4b) Gecko/")!=-1) )
					}
				}
				if (i!=-1)
					ndBrowserVersion = parseFloat(u.substring(i));
			}
			ndNS4 = ndBrowserVersion < 5;
			nd_bFrameNoSrc = !ndNS4; // !!! NS4.79 need nd_bFrameNoSrc=false
		}
	}
}

ndInit();

var ndHexA = "0123456789ABCDEF";

function ndN2HH(n) // Num(0..255) to Hex String('00'..'FF')
{
	n = Math.round(n);
	return ndHexA.charAt(n >> 4) + ndHexA.charAt(n & 15);
}

function ndRGBColor(r, g, b)
{
	return '#' + ndN2HH(r) + ndN2HH(g) + ndN2HH(b);
}

function ndH2N(c) // Hex Char('0'..'F') value to Num(1..15)
{
	return ndHexA.indexOf(c.toUpperCase());
}

function ndGetRColor(c)
{
	return ndH2N(c.charAt(1))*16 + ndH2N(c.charAt(2));
}

function ndGetGColor(c)
{
	return ndH2N(c.charAt(3))*16 + ndH2N(c.charAt(4));
}

function ndGetBColor(c)
{
	return ndH2N(c.charAt(5))*16 + ndH2N(c.charAt(6));
}

function ndMixValue(a, b, p /* % : 0..100 */)
{
	return a + ((b-a)*p)/100;
}

function ndMixColor(a, b, p /* % : 0..100 */)
{
	if (a.charAt(0) != '#')  a = ndName2RGBColor(a);
	if (b.charAt(0) != '#')  b = ndName2RGBColor(b);
	if (typeof p == 'undefined')
		p = 50; // %
	return ndRGBColor(ndMixValue(ndGetRColor(a), ndGetRColor(b), p),
					  ndMixValue(ndGetGColor(a), ndGetGColor(b), p),
					  ndMixValue(ndGetBColor(a), ndGetBColor(b), p));
}

var ndColorNames =
  '#F0F8FF aliceblue'
 +'#FAEBD7 antiquewhite'
 +'#00FFFF aqua'
 +'#7FFFD4 aquamarine'
 +'#F0FFFF azure'
 +'#F5F5DC beige'
 +'#FFE4C4 bisque'
 +'#000000 black'
 +'#FFEBCD blanchedalmond'
 +'#0000FF blue'
 +'#8A2BE2 blueviolet'
 +'#A52A2A brown'
 +'#DEB887 burlywood'
 +'#5F9EA0 cadetblue'
 +'#7FFF00 chartreuse'
 +'#D2691E chocolate'
 +'#FF7F50 coral'
 +'#6495ED cornflowerblue'
 +'#FFF8DC cornsilk'
 +'#DC143C crimson'
 +'#00FFFF cyan'
 +'#00008B darkblue'
 +'#008B8B darkcyan'
 +'#B8860B darkgoldenrod'
 +'#A9A9A9 darkgray'
 +'#006400 darkgreen'
 +'#BDB76B darkkhaki'
 +'#8B008B darkmagenta'
 +'#556B2F darkolivegreen'
 +'#FF8C00 darkorange'
 +'#9932CC darkorchid'
 +'#8B0000 darkred'
 +'#E9967A darksalmon'
 +'#8FBC8B darkseagreen'
 +'#483D8B darkslateblue'
 +'#2F4F4F darkslategray'
 +'#00CED1 darkturquoise'
 +'#9400D3 darkviolet'
 +'#FF1493 deeppink'
 +'#00BFFF deepskyblue'
 +'#696969 dimgray'
 +'#1E90FF dodgerblue'
 +'#B22222 firebrick'
 +'#FFFAF0 floralwhite'
 +'#228B22 forestgreen'
 +'#FF00FF fuchsia'
 +'#DCDCDC gainsboro'
 +'#F8F8FF ghostwhite'
 +'#FFD700 gold'
 +'#DAA520 goldenrod'
 +'#808080 gray'
 +'#008000 green'
 +'#ADFF2F greenyellow'
 +'#F0FFF0 honeydew'
 +'#FF69B4 hotpink'
 +'#CD5C5C indianred'
 +'#4B0082 indigo'
 +'#FFFFF0 ivory'
 +'#F0E68C khaki'
 +'#E6E6FA lavender'
 +'#FFF0F5 lavenderblush'
 +'#7CFC00 lawngreen'
 +'#FFFACD lemonchiffon'
 +'#ADD8E6 lightblue'
 +'#F08080 lightcoral'
 +'#E0FFFF lightcyan'
 +'#FAFAD2 lightgoldenrodyellow'
 +'#90EE90 lightgreen'
 +'#D3D3D3 lightgrey'
 +'#FFB6C1 lightpink'
 +'#FFA07A lightsalmon'
 +'#20B2AA lightseagreen'
 +'#87CEFA lightskyblue'
 +'#778899 lightslategray'
 +'#B0C4DE lightsteelblue'
 +'#FFFFE0 lightyellow'
 +'#00FF00 lime'
 +'#32CD32 limegreen'
 +'#FAF0E6 linen'
 +'#FF00FF magenta'
 +'#800000 maroon'
 +'#66CDAA mediumaquamarine'
 +'#0000CD mediumblue'
 +'#BA55D3 mediumorchid'
 +'#9370DB mediumpurple'
 +'#3CB371 mediumseagreen'
 +'#7B68EE mediumslateblue'
 +'#00FA9A mediumspringgreen'
 +'#48D1CC mediumturquoise'
 +'#C71585 mediumvioletred'
 +'#191970 midnightblue'
 +'#F5FFFA mintcream'
 +'#FFE4E1 mistyrose'
 +'#FFE4B5 moccasin'
 +'#FFDEAD navajowhite'
 +'#000080 navy'
 +'#FDF5E6 oldlace'
 +'#808000 olive'
 +'#6B8E23 olivedrab'
 +'#FFA500 orange'
 +'#FF4500 orangered'
 +'#DA70D6 orchid'
 +'#EEE8AA palegoldenrod'
 +'#98FB98 palegreen'
 +'#AFEEEE paleturquoise'
 +'#DB7093 palevioletred'
 +'#FFEFD5 papayawhip'
 +'#FFDAB9 peachpuff'
 +'#CD853F peru'
 +'#FFC0CB pink'
 +'#DDA0DD plum'
 +'#B0E0E6 powderblue'
 +'#800080 purple'
 +'#FF0000 red'
 +'#BC8F8F rosybrown'
 +'#4169E1 royalblue'
 +'#8B4513 saddlebrown'
 +'#FA8072 salmon'
 +'#F4A460 sandybrown'
 +'#2E8B57 seagreen'
 +'#FFF5EE seashell'
 +'#A0522D sienna'
 +'#C0C0C0 silver'
 +'#87CEEB skyblue'
 +'#6A5ACD slateblue'
 +'#708090 slategray'
 +'#FFFAFA snow'
 +'#00FF7F springgreen'
 +'#4682B4 steelblue'
 +'#D2B48C tan'
 +'#008080 teal'
 +'#D8BFD8 thistle'
 +'#FF6347 tomato'
 +'#40E0D0 turquoise'
 +'#EE82EE violet'
 +'#F5DEB3 wheat'
 +'#FFFFFF white'
 +'#F5F5F5 whitesmoke'
 +'#FFFF00 yellow'
 +'#';

function ndName2RGBColor(name)
{
	var i = ndColorNames.indexOf(' '+name+'#');
	if (i!=-1)
		return ndColorNames.substr(i-7, 7);
	alert('ERROR: Invalid color \'' + name+ '\'');
	return '#FF0000'; // red
}

// --------------
// --- Path ---
// --------------
var g_ndImgPath  = 'img/'; // Images
var g_ndZipPath  = 'zip/'; // Zip - Download
var g_ndHtmlPath = 'html/';
var g_ndTreePath = 'tree/';


// -------------------
// ---			   ---
// --- OnlineMIB : ---
// ---			   ---
// -------------------

// --- Logo
var g_ndLogoImgFile 					= g_ndImgPath + 'Logo.gif';
var g_ndBGLogoImgFile					= ''; // background image or ''
var g_ndLogoImgWidth					= 164;
var g_ndLogoImgHeight					= 46;
var g_ndLogoXpos						=  0;  // -1:center, 0:left, n:Xpos
var g_ndLogoYpos						= -1;  // -1:center, 0:top,  n:Ypos
var g_ndWidthSpaceAfterLogo 			= 20;
var g_ndLogoImgAlt						=		 "www.'Your-Site'.com"; // or '';
var g_ndLogoHref						= "http://www.'Your-Site'.com"; // or ''
var g_ndLogoHrefTarget					= '_top'; // '_blank';

// --- Splash
var g_nd_bShowSplash					= true;
var g_nd_bSplashImg 					= g_ndImgPath + 'Splash.gif';
var g_nd_bSplashWidth					= 425;
var g_nd_bSplashHeight					= 350;
var g_nd_bSplashAlt 					= "";	// "MIB Web Publisher - www.Supervise-Network.fr";
var g_nd_bSplashHref					= null; // "http://www.Supervise-Network.fr/MIBWebPublisher.html";

// --- Copyright
var g_ndCopyrightHtml					= 'Copyright &copy; 2003-2004, <I>Your Company.</I> All Rights Reserved. <A href="mailto:xxx@xxx.xxx?subject=Question Regarding MIB Documentation"><I>Your Doc Contact</I></A>';

// --- Title
var g_ndOnlineMibWindowsTitleText		= '';
var g_ndOnlineMibOptionalTitleHtml		= '<b><I>Your Title (Optional)</I></b>'; // or '';

// --- Frame Top
var g_ndHeightFrameTop					= g_ndOnlineMibOptionalTitleHtml ? 63 : 46; // Minimum

// --- Mib Tree Options
var g_ndOnlineMIB_bShowAccess			= true;
var g_ndOnlineMIB_bShowEnum 			= true;

// --- Colors : Top Frame
var g_ndBGColorFrameTop 				= 'white';
var g_ndBGColorImput					= '#FFF7F1';
var g_ndColorOptionalTitle				= '#003366';
var g_ndColorImputLabel 				= '#666666';  // 'Name' & 'Value'
var g_ndColorImputText					= '#FF6600';  // '.iso.org.dod...' & '.1.3.6...'

// --- Colors : Nav Bar & Tab
var g_ndBGColorFrameNavBar				= '#4876A3';

var g_ndColorActiveTabFace				= 'silver';
var g_ndColorActiveTabHighlight 		= 'white';
var g_ndColorActiveTabDarkShadow		= '#404040';
var g_ndColorActiveTabShadow			= ndMixColor(g_ndColorActiveTabFace, g_ndColorActiveTabDarkShadow); // 'gray';
var g_ndColorActiveTabText				= 'black';

var g_ndColorInactiveTabFace			= '#E8E8E8';
var g_ndColorInactiveTabHighlight		= 'white';
var g_ndColorInactiveTabDarkShadow		= '#606060';
var g_ndColorInactiveTabShadow			= ndMixColor(g_ndColorInactiveTabFace, g_ndColorInactiveTabDarkShadow); // '#A0A0A0';
var g_ndColorInactiveTabTextLink		= 'black';
var g_ndColorInactiveTabTextLinkHover	= '#FF6600';

// --- Colors : Dir Tree, Mibs Tree & Mib tree
var g_ndBGColorFrameDirTree 			= 'FFFFF0';
var g_ndBGColorFrameMibsTree			= 'F0FFF0';
var g_ndBGColorFrameMibTree 			= 'white';
var g_ndBGColorFrameMibTreeEmpty		= g_ndBGColorFrameMibTree;
var g_ndBGColorFrameMibFileEmpty		= 'white';	  // use with empty frame else use .css

var g_ndColorSplitter					= g_ndBGColorFrameNavBar; // !!! Not work with Opera
var g_ndColorOptionalRectWithFrame		= 'gray';	  // color or '' for default 3D frame.	Works with IE only
var g_ndColorOptionalRectWithFrameSearchResult = 'black';
var g_ndColorSearchError				= 'Red';
var g_ndBGColorSearchResultDefault		= 'white';

var g_ndScrollbarArrowColor 			= '#4876A3';  // use '' for default color.	Works with IE only
var g_ndScrollbarBaseColor				= 'silver';   // use '' for default color.	Works with IE only
var g_ndScrollbar3dLightColor			= '';		  // use '' for default color.	Works with IE only
var g_ndScrollbarFaceColor				= '';		  // use '' for default color.	Works with IE only
var g_ndScrollbarDarkShadowColor		= '';		  // use '' for default color.	Works with IE only
var g_ndScrollbarHighlightColor 		= '';		  // use '' for default color.	Works with IE only
var g_ndScrollbarShadowColor			= '';		  // use '' for default color.	Works with IE only
var g_ndScrollbarTrackColor 			= '';		  // use '' for default color.	Works with IE only

var g_ndColorTreeText					= 'black'; 
var g_ndColorTreeTextOld				= 'gray';
var g_ndColorTreeLink					= '#003366';
var g_ndColorTreeLinkOld				= ndMixColor(g_ndColorTreeLink, g_ndColorTreeTextOld, 66 /* % : 0..100 */);
var g_ndColorTreeLinkHover				= '#FF6600';
var g_ndBGColorSelectItem				= '#E0E0FF';

var g_ndColorMenuText					= g_ndColorTreeText;
var g_ndColorMenuTextOld				= g_ndColorTreeTextOld;
var g_ndColorMenuLink					= g_ndColorTreeLink;
var g_ndColorMenuLinkOld				= g_ndColorTreeLinkOld;
var g_ndColorMenuLinkHover				= g_ndColorTreeLinkHover;

var g_ndColorMessage					= g_ndColorTreeText; // 'Downloading...'

// --- Colors : Bottom Frame
var g_ndBGColorFrameBottom				= g_ndBGColorFrameNavBar;
var g_ndColorCopyrightText				= 'white';
var g_ndColorCopyrightLink				= g_ndColorCopyrightText;
var g_ndColorCopyrightLinkHover 		= '#FFCF00';
var g_ndImgPoweredByInv 				= 1; // 0:Black text, 1:White text

// --- Colors : Window Legend
var g_ndBGColorWindowLegend 			= '#FFF7F1';

// --- Colors : Window Download
var g_ndBGColorWindowDownload			= g_ndBGColorWindowLegend;
var g_ndColorDownloadText				= g_ndColorTreeText;
var g_ndColorDownloadTextLink			= g_ndColorTreeLink;
var g_ndColorDownloadTextLinkHover		= g_ndColorTreeLinkHover;
var g_ndWidthWindowDownload 			= 300;
var g_ndHeightWindowDownload			= 100;

// --- Colors : Window Search
var g_ndBGColorSearchImput				= 'white';
var g_ndColorSearchImputText			= g_ndColorImputText;
var g_ndBGColorWindowSearch 			= g_ndBGColorWindowLegend;
var g_ndColorSearchText 				= g_ndColorTreeText;
var g_ndColorSearchTextLink 			= g_ndColorTreeLink;
var g_ndColorSearchTextLinkHover		= g_ndColorTreeLinkHover;
var g_ndBorderWindowSearch				= 6;
var g_ndWidthWindowSearch				= (ndFR ? 304 : 280) + g_ndBorderWindowSearch*2;
var g_ndHeightWindowSearch				= 265+g_ndBorderWindowSearch*2;

// --- Font Family
var g_ndStyleFontFamily 				= 'FONT-FAMILY:Microsoft Sans Serif,Tahoma,Arial,Helvetica,Swiss,SunSans-Regular,Sans-Serif,Verdana';
var g_ndStyleFontFamilyMessage			= g_ndStyleFontFamily;
var g_ndStyleFontFamilyDownloadText 	= g_ndStyleFontFamily;
var g_ndStyleFontFamilySearch			= g_ndStyleFontFamily;
var g_ndStyleFontFamilyTitle			= 'FONT-FAMILY:Arial,Geneva,Helvetica';
var g_ndStyleFontFamilyCopyright		= 'FONT-FAMILY:Arial,Geneva,Helvetica';

// --- Font Size
var g_ndStyleFontSize					= 'FONT-SIZE:11px';
var g_ndStyleFontSizeMessage			= 'FONT-SIZE:14px';
var g_ndStyleFontSizeDownloadText		= g_ndStyleFontSize;
var g_ndStyleFontSizeSearchText 		= g_ndStyleFontSize;
var g_ndStyleFontSizeTitle				= 'FONT-SIZE:15px';
var g_ndStyleFontSizeCopyright			= 'FONT-SIZE:10px';

// --- Splitter
var g_ndFrameBorder 					= 7; // NS, Mozilla, Phoenix
var g_ndFrameSpacing					= 4; // IE, Opera

// --- Option
var g_ndOnlineMIB_AutoDownloadMIBsTree	= false;
var g_ndOnlineMIB_bDrawTreeAfterLoad	= true; // false works with IE only


// ---------------------------------------------------
// --- 'MIB File'								   ---
// ---											   ---
// --- ndMib2Web_DrawMibFileTree() Default Options ---
// ---------------------------------------------------
var g_ndMib2Web_DrawMibFileTree_bShowAccess  = true;
var g_ndMib2Web_DrawMibFileTree_bShowEnum	 = true;
var g_ndMib2Web_DrawMibFileTree_bTableBorder = false;
var g_ndMib2Web_DrawMibFileTree_rgbBGColor	 = null; // null or RGB Color, Ex : '#F0FFF5'


// --------------------------------------------
// --- 'MIB Tree'							---
// ---										---
// --- ndMib2Web_DrawTree() Default Options ---
// --------------------------------------------
var g_ndMib2Web_DrawTree_bShowAccess  = true;
var g_ndMib2Web_DrawTree_bShowEnum	  = true;
var g_ndMib2Web_DrawTree_bTableBorder = true;
var g_ndMib2Web_DrawTree_rgbBGColor   = g_ndBGColorFrameMibTree; // null or RGB Color, Ex : '#F0FFF5'


// ------------------------------------------
// --- 'Online MIB' & 'MIB File' CallBack ---
// ------------------------------------------

var g_ndOnlineMibCallBack = null; // With "Online MIB" & "MIB File" only

var nd_szPleaseWait 		   = ndFR ? 'Veuillez patienter'						  : 'Please Wait';
var nd_szProcessing 		   = ndFR ? 'Traitement...' 							  : 'Processing...';
var nd_szDownloading		   = ndFR ? 'Transfert...'								  : 'Downloading...';
var nd_szDownloadingMIBsTree   = ndFR ? 'Transfert l\'arbre des OIDs...'			  : 'MIBs Tree Downloading...';
var nd_szDownloadingMibTree    = ndFR ? 'Transfert l\'arbre de la MIB...'			  : 'MIB Tree Downloading...';
var nd_szName				   = ndFR ? 'Nom'										  : 'Name';
var nd_szValue				   = ndFR ? 'Valeur'									  : 'Value';
var nd_szDirTreeLabel		   = ndFR ? 'Fichiers'									  : 'Files';
var nd_szMibsTreeLabel		   = ndFR ? 'Arbre' 									  : 'Tree';
var nd_szMibTreeLabel		   = ndFR ? 'MIB'										  : 'MIB';

var nd_szDirTreeStatus		   = ndFR ? 'Arbre des Fichiers et Dossier MIBs'		  : 'MIBs Files/Folders Tree';
var nd_szMibsTreeStatus 	   = ndFR ? 'Arbre des OIDs de l\\\'ensemble des MIBs'	  : 'OIDs Tree of the whole MIBs';
var nd_szMibTreeStatus		   = ndFR ? 'Arbre du fichier MIB'						  : 'MIB Tree of the File';

var nd_szOnLineMIB			   = 'On-Line MIB - '
var nd_szTitleLegend		   = nd_szOnLineMIB + (ndFR ? 'Lgende de l\'Arbre de la MIB' : 'MIB Tree Legend');
var nd_szTitleDownload		   = nd_szOnLineMIB + (ndFR ? 'Tlcharger' 				  : 'Download');
var nd_szTitleSearch		   = nd_szOnLineMIB + (ndFR ? 'Rechercher'					  : 'Search');

// Status
var nd_szPrintMibFile		   = ndFR ? 'Imprime le Fichier MIB...' 				  : 'Print MIB File...';
var nd_szPrintFolders		   = ndFR ? 'Imprime l\'Arbre des Fichiers et Dossiers MIBs...'  : 'Print MIBs Files/Folders Tree...';
var nd_szPrintMibsTree		   = ndFR ? 'Imprime l\'Arbre des MIBs...'				  : 'Print MIBs Tree...';
var nd_szPrintMibTree		   = ndFR ? 'Imprime l\'Arbre de la MIB...' 			  : 'Print MIB Tree...';
var nd_szShowHideFrameRight    = ndFR ? 'Montre/Cache le cadre de droite'			  : 'Show/Hide Right Frame';
var nd_szShowHideFrameLeft	   = ndFR ? 'Montre/Cache le cadre de gauche'			  : 'Show/Hide Left Frame';
var nd_szShowHideFrameTop	   = ndFR ? 'Montre/Cache le cadre du haut et du bas'	  : 'Show/Hide Top and Bottom Frame';
var nd_szCopyName			   = ndFR ? 'Copie le Nom dans le Presse-papiers'		  : 'Copies the Name to the Clipboard';
var nd_szCopyValue			   = ndFR ? 'Copie la Valeur dans le Presse-papiers'	  : 'Copies the Value to the Clipboard';
var nd_szRefresh			   = ndFR ? 'Rafrachir'								  : 'Refresh';
var nd_szLegend 			   = ndFR ? 'Affiche la lgende de l\'Arbre de la MIB...' : 'Display MIB Tree Legend...';
var nd_szSearch 			   = ndFR ? 'Recherche d\'un OID...'					  : 'OID Search...';
var nd_szGotoDirTree		   = ndFR ? 'Aller dans les Fichiers MIBs'				  : 'Go to the MIBs Files';
var nd_szGotoMIBsTree		   = ndFR ? 'Aller dans l\'Arbre des MIBs'				  : 'Go to the MIBs Tree';
var nd_szDownload			   = ndFR ? 'Tlcharger'								  : 'Download';
var nd_szDownload2			   = nd_szDownload + '...';
var nd_szGoto				   = ndFR ? '[-->] Atteindre'							  : '[-->] Go to';
var nd_szSearchButton		   = ndFR ? 'Chercher'									  : '  Find  ';
var nd_szCancelButton		   = ndFR ? ' Annuler ' 								  : 'Cancel';
var nd_szCloseButton		   = ndFR ? ' Fermer '									  : ' Close ';
var nd_szFindWhat			   = ndFR ? 'Recherche :'								  : 'Find what:';
var nd_szIn 				   = ndFR ? 'dans :'									  : 'in:';
var nd_szMatchWord			   = ndFR ? 'Mot entier'								  : 'Match whole word only';
var nd_szMatchCasse 		   = ndFR ? 'Respecter la casse'						  : 'Match case';
var nd_szRegularExpression	   = ndFR ? 'Expression rgulire'						  : 'Regular expression';
var nd_szSearchBegin		   = (ndFR ? 'crivez vos critres de recherche pour commencer.<BR><BR style="FONT-SIZE:6px">Exemple :': 'Enter your search criteria to begin.<BR><BR style="FONT-SIZE:6px">Example:') + '<B><BR>&nbsp;&nbsp;&nbsp;sysDescr<BR>&nbsp;&nbsp;&nbsp;system.1<BR>&nbsp;&nbsp;&nbsp;system.sysDescr<BR>&nbsp;&nbsp;&nbsp;.1.3.6.1.2.1.1.1</B>'
var nd_szSearching			   = ndFR ? 'Recherche...'								  : 'Searching...'
var nd_szSearchNoResult 	   = ndFR ? 'Aucun lment ne correspond aux termes de votre recherche.' : 'No results match your search query.'
var nd_szSearchNoMIBFile	   = ndFR ? 'Aucun lment (Il n\'y a pas de fichier MIB).' 			 : 'No results (No MIB File).'
var nd_szInvalidRegExp		   = ndFR ? 'Expression rgulire invalide.'			  : 'Invalid Regular Expression.';
//var nd_szInvalidExp		   = ndFR ? 'Expression invalide.'						  : 'Invalid Expression.';

// Alt
var nd_szAltPrint			   = ndFR ? 'Imprimer...'								  : 'Print...';
var nd_szAltFrameRight		   = ndFR ? 'Cadre droite'								  : 'Right Frame';
var nd_szAltFrameLeft		   = ndFR ? 'Cadre gauche'								  : 'Left Frame';
var nd_szAltFrameTop		   = ndFR ? 'Cadres haut & bas' 						  : 'Top & Bottom Frames';
var nd_szAltCopy			   = ndFR ? 'Copier'									  : 'Copy';
var nd_szAltRefresh 		   = nd_szRefresh
var nd_szAltLegend			   = ndFR ? 'Lgende...'								  : 'Legend...';
var nd_szAltSearch			   = ndFR ? 'Recherche...'								  : 'Search...';
var nd_szAltGotoDirTree 	   =(ndFR ? 'Aller dans les '							  : 'Go to ') + '&laquo;'+nd_szDirTreeLabel +'&raquo;';
var nd_szAltGotoMIBsTree	   =(ndFR ? 'Aller dans l\''							  : 'Go to ') + '&laquo;'+nd_szMibsTreeLabel+'&raquo;';
var nd_szAltDownload		   = nd_szDownload2

var nd_szTocExpand			   = ndFR ? '[+] Dvelopper'							  : '[+] Expand';
var nd_szTocCollapse		   = ndFR ? '[-] Plier' 								  : '[-] Collapse';


var nd_szMsgErrorBadBrowser
	= ndFR 
		? 'ERREUR : Cette documentation ncessite l\'un des navigateurs Web suivants :\n\n - Microsoft Internet Explorer version 5 ou suprieur,\n - Netscape Navigator version 6 ou suprieur\n - Opera version 7 ou suprieur,\n - Mozilla ou Mozilla Firebird (Phoenix).'
		: 'ERROR : This document requires one of the following Web browsers:\n\n - Microsoft Internet Explorer version 5 or higher,\n - Netscape Navigator version 6 or higher,\n - Opera version 7 or higher,\n - Mozilla or Mozilla Firebird (Phoenix).';


var nd_pPreLoadImgsTab = new Array();

// Internal 'Online MIB' Var

var ndO_szAllMIBs_zip			= 'All-MIBs.zip';
var ndO_szHeightNavBar			= 22;
var ndO_szHeightNavBlankBar 	= 4;
var ndO_szFrameSetHVal			= '0';
var ndO_nNumActiveTab;				// with (ndO_bDynamicFrame || ndO_bIFrame)
var ndO_nSelectedMibTreeOID 	= 0;
var ndO_MIBsTreeDownload_nSelectedMibTreeOID;
var ndO_MIBsTreeDownload_MibTree;
var ndO_bIFrame;
var ndO_bDynamicFrame;
var ndO_bDirTree;
var ndO_bMIBsTree;
var ndO_bOneFileOnly;
var ndO_nOneFileOnlyIndex;
var ndO_nOidInputSize;
var ndO_ndFrameSetHCols;
var ndO_winMibLegend;
var ndO_winDownload;
var ndO_winSearch;
var ndO_bWaitPlugMibFile		= false;
var ndO_bMibTreeLoad			= false;
var ndO_bMIBsTreeLoad			= false;
var ndO_nLastFileIndexDirTree	= 0;
var ndO_nLastFileIcoLanguage	= 0;
var ndO_nLastHtmlFileSize		= 0;
var ndO_nLastZipFileSize		= 0;
var ndO_nMibTreeShowModNum		= 0;
var ndO_szStartWithMibTreeItem	= '';
var ndO_szLastMibFileName		= '';
var ndO_szLastMibPathFileName	= '';
var ndO_FrameOnLoad_nCount;
var ndO_FrameOnLoad_szFinishEval;
// Preload images
var ndO_imgTabMIBTree;
var ndO_imgOpenLegendOver;
var ndO_imgOpenLegendDown;
var ndO_imgSearchOver;
var ndO_imgSearchDown;
var ndO_imgGotoDirTreeOver;
var ndO_imgGotoDirTreeDown;
var ndO_imgGotoMIBsTree;
var ndO_imgGotoMIBsTreeOver;
var ndO_imgGotoMIBsTreeDown;
var ndO_imgDownloadOver;
var ndO_imgDownloadDown;
var ndO_imgFrameRightOver;
var ndO_imgFrameRightDown;
var ndO_imgFrameTopOver;
var ndO_imgFrameTopDown;
var ndO_imgFrameLeftDown;
var ndO_imgFrameLeftOver;
var ndO_imgPrintOver;
var ndO_imgPrintDown;
var ndO_imgClipboardCopyOver;
var ndO_imgClipboardCopyDown;
var ndO_bRefreshButtonOfTab  = new Array(3);
var ndO_szDownloadWindowName;
var ndO_szSearchWindowName;
var ndO_szSeachImputValue	 = '';
var ndO_nSeachRadioValue	 = '';
var ndO_bSeachCheckBox1Value = false;
var ndO_bSeachCheckBox2Value = false;
var ndO_bSeachCheckBox3Value = false;
var ndO_bSeachClear 		 = false;
var ndO_frameSearchResult;
var ndO_formSearch;
var ndO_nMaxSearchResult	 = 256;

var ndO_SearchResult_lastSelectedObjA;
var ndO_nLastMIBsTreeProgressUpdated; // Milliseconde
var ndO_nLastMIBsTreeProgress;		  // %
var ndO_nLastMibTreeProgressUpdated;  // Milliseconde
var ndO_nLastMibTreeProgress;		  // %
var ndO_bFormSearch_WaitMIBsTreeDownload = false;
var ndO_bFormSearch_WaitMibTreeDownload  = false;
var ndO_bMIBsTreeDownloading			 = false;
var ndO_bMibTreeDownloading 			 = false;
//var ndO_imgLegend;


// Var Name | Label   | Num (Tree & Tab) | Tiny Var Name (Minimize memory use)
// ---------|---------|-------------------------------------------------------
// DirTree	| "Files" | 0				 | D
// MIBsTree | "Tree"  | 1				 | T
// MibTree	| "MIB"   | 2				 | M

var ndO_DirTreeName  = 'D';
var ndO_MIBsTreeName = 'T';
var ndO_MibTreeName  = 'M';

var D; // = ndDir  with "On-line MIB"
var T; // = ndTree with "On-line MIB"
var M; // = ndMib  with "On-line MIB"

function ndO_GetDirTree()  { return D; /* eval(ndO_DirTreeName);  */ }
function ndO_GetMIBsTree() { return T; /* eval(ndO_MIBsTreeName); */ }
function ndO_GetMibTree()  { return M; /* eval(ndO_MibTreeName);  */ }



function ndOpenWindow(url, sNameWindow, nMaxUserWidth, nMaxUserHeight, bScrollBars, param)
{ 
	var win;
	var xposition	= 0;
	var yposition	= 0;
	var nMaxWidth	= screen.availWidth  - 11;
	var nMaxHeight	= screen.availHeight - 30;
	var nWidth		= nMaxWidth;
	var nHeight 	= nMaxHeight;

	if (	(typeof nMaxUserWidth != 'undefined')
		 && (nMaxUserWidth != null)
		 && (nWidth > nMaxUserWidth) )
		nWidth = nMaxUserWidth;
	else
		bScrollBars = 1;

	if (	(typeof nMaxUserHeight != 'undefined')
		 && (nMaxUserHeight != null)
		 && (nHeight > nMaxUserHeight) )
		nHeight = nMaxUserHeight;
	else
		bScrollBars = 1;

	if (	(typeof bScrollBars == 'undefined')
		 || (bScrollBars == null) )
		bScrollBars = 0;

	//xposition = (nMaxWidth	- nWidth ) / 2;
	xposition = 3*(nMaxWidth - nWidth ) / 4;
	yposition = (nMaxHeight - nHeight) / 3; 

	args = "width="  + nWidth  + "," 
		 + "height=" + nHeight + "," 
		 + "location=0," 
		 + "menubar=0,"
		 + (((typeof param != 'undefined') && (param.indexOf("resizable") != -1)) ? "" : "resizable,")
		 + "scrollbars" + (bScrollBars ? "," : "=0,")
		 + (((typeof param != 'undefined') && (param.indexOf("status") != -1)) ? "" : "status=0,")
		 + "titlebar=0,"
		 + "toolbar=0,"
		 + "hotkeys,"
		 + "directories=0,"
		 + "copyhistory=0,"
		 + "fullscreen=0,"
		 + "screenX=" + xposition + "," //NN Only
		 + "screenY=" + yposition + "," //NN Only
		 + "left="	  + xposition + "," //IE Only
		 + "top="	  + yposition + 	//IE Only 
((typeof param != 'undefined')
		 ? "," + param
		 : "");
	win = window.open( url, sNameWindow, args ); 
	if (win && !win.closed)
	{
		win.focus();
		if (win.opener == null)
			win.opener = window;
	}
	return win;
} 

function ndLoadImg(szImgFileName)
{
	var img = new Image();
	img.src = szImgFileName;
	return img;
}

function ndLoadGifImg(szImgName)
{
	return ndLoadImg(g_ndImgPath + szImgName + '.gif');
}

function ndPreLoadImgsOfTree(ndTree)
{
	var imgTab = nd_Tree_ImgList(ndTree);
	for (var i=0;i<imgTab.length;i++)
	{
		var name = imgTab[i];
		if (!nd_pPreLoadImgsTab[name]) // <- Adressage associatif des tableaux
			nd_pPreLoadImgsTab[name] = ndLoadGifImg(name);
	}
}

function NDClassBuf() // Buffer : Speed & Debug
{
	this.a = new Array();
	this.write	  = function(s) {if (this.a.length==4096) this.write(this.toString()); this.a[this.a.length]=s;}
	this.toString = function()	{var r=this.a.join(''); delete this.a; this.a = new Array(); return r;}
}

function ndIsBuf(doc /* document or NDClassBuf */)
{
	return typeof(doc.open) == 'undefined';
}

function NDClassCallBack()
{
	this.PlugLibrary = function(doc)			  { }
	this.onClick	 = function(ndTree, i, frame) { return false;/*Use Default */ }
	this.onMouseOver = function(ndTree, i, frame) { return false;/*Use Default : Display name & value in status bar */ }
	this.onMouseOut  = function(ndTree, i, frame) { return false;/*Use Default : Restore status bar */ }
}


function nd_Tree_Type(		  ndTree) { return ndTree[0][0]; }
function nd_Tree_ArrayOfDesc( ndTree) { return ndTree[0][1]; }
function nd_Tree_ImgList(	  ndTree) { return ndTree[0][2].split(':'); }
function nd_Tree_RootOidValue(ndTree) { return ndTree[0][3]; }
function nd_Tree_RootOidName( ndTree) { return ndTree[0][4]; }

function ndO_GetFileSize_AllMIBsZIP() { return ndO_GetDirTree()[0][5]; }
function ndO_GetFileSize_MIBsTreeJS() { return ndO_GetDirTree()[0][6]; }


function nd_ItemTree(ndTree, i) 
{
	var r = ndTree[i].split(':');
	for(var j=r.length; --j;)
		if (r[j].charAt(0) != "'")
			r[j] = parseInt(r[j]);
		else
			r[j] = r[j].substring(1);
	var a = ndTree[0][1];
	if (a && a[i])
		r[r.length] = a[i];
	return r /*ItemTree*/;
}

function nd_ItemTree_sName( 	ItemTree) { return ItemTree[0]; }
function nd_ItemTree_nFA(		ItemTree) { return ItemTree[1]; }
function nd_ItemTree_nFB(		ItemTree) { return ItemTree[2]; }
function nd_ItemTree_nDeltaNext(ItemTree) { return ItemTree[3]; }

function nd_ItemTree_IsLine( ItemTree) { return ItemTree.length > 4; } 
function nd_ItemTree_nLine(  ItemTree) { return ItemTree[4]; } // Object, Type, Mib, Mod
function nd_ItemTree_nSubId( ItemTree) { return ItemTree[5]; } // Object
function nd_ItemTree_sInfo(  ItemTree) { return ItemTree[5]; } // Type

function nd_ItemDirTree_nHtmlFileSize(ItemTree) { return ItemTree[4]; } // with INFODIR_MIB(1)
function nd_ItemDirTree_nZipFileSize( ItemTree) { return ItemTree[5]; } // with INFODIR_MIB(1)

function nd_ItemTree_sDesc(ItemTree)
{
	switch(nd_ItemTree_eInfo(ItemTree))
	{
	case 8:  // INFOMIB_OBJECT(8)
	case 9:  // INFOMIB_OBJECT_TRAP(9)
	case 11: // INFOMIB_TYPE(11)
		return	ItemTree[6];
	}
	return null;
}

function nd_Tree_sName( 	ndTree, i) { var r = ndTree[i]; return r.substring(0, r.indexOf(':')); }
function nd_Tree_nFA(		ndTree, i) { return parseInt(ndTree[i].split(':')[1]); }
function nd_Tree_nFB(		ndTree, i) { return parseInt(ndTree[i].split(':')[2]); }
function nd_Tree_nDeltaNext(ndTree, i) { return parseInt(ndTree[i].split(':')[3]); }
function nd_Tree_nLine( 	ndTree, i) { return parseInt(ndTree[i].split(':')[4]); }
function nd_Tree_nSubId(	ndTree, i) { return parseInt(ndTree[i].split(':')[5]); }
function nd_Tree_sDesc( 	ndTree, i) { var a = ndTree[0][1]; return (a && a[i]) ? a[i] : null; }

function nd_DirTree_nHtmlFileSize(ndDirTree, i) { return parseInt(ndDirTree[i].split(':')[4]); }

function nd_MIBsTree_IdxModOfMibList(ndMIBsTree, i) // with Object
{
	var r;
	for(;(r=ndMIBsTree[i].split(':')).length<7;i--)
		;
	return r[6].substring(1).split(',');
}

// Flag 'A'
function nd_FA_bExpanded(	   nFA) { return  nFA		 & 1; }
function nd_FA_bAlwaysOpen(    nFA) { return (nFA >>  1) & 1; }
function nd_FA_bNextOfParent(  nFA) { return (nFA >>  2) & 1; }
function nd_FA_bChild(		   nFA) { return (nFA >>  3) & 1; }
function nd_FA_bChildEnumInt(  nFA) { return (nFA >>  4) & 1; }
function nd_FA_bOld(		   nFA) { return (nFA >>  5) & 1; }
function nd_FA_eInfo(		   nFA) { return (nFA >>  6) & 15  /*(1<< 4)-1*/; }
function nd_FA_nImg(		   nFA) { return (nFA >> 10) & 1023/*(1<<10)-1*/; }
function nd_FA_eType(		   nFA) { return (nFA >> 20) & 31  /*(1<< 5)-1*/; }
function nd_FA_eAccess( 	   nFA) { return (nFA >> 25) & 15  /*(1<< 4)-1*/; }
function nd_FA_bSpaceForAccess(nFA) { return (nFA >> 29) & 1; }
function nd_FA_bHexValue(	   nFA) { return  nFA >> 30;	  }
function nd_FA_bHiddenImport(  nFA) { return  nFA >> 31;	  }
function nd_FA_bVisibleImport( nFA) { return nd_FA_nImg(nFA) == 0x49; }
function nd_FA_bImport		 ( nFA) { return nd_FA_bHiddenImport(nFA) || nd_FA_bVisibleImport(nFA); }

function nd_FA_bChild_Or_bChildEnumInt(nFA) { return ((nFA >> 3) & 3) != 0; }

// with INFODIR_MIB: eIcoLanguage <- eType
function nd_FA_eIcoLanguage(   nFA) { return nd_FA_eType(nFA); }

// Flag 'B'
function nd_FB_bOidParent(	   nFB) { return nFB  & 1; }
function nd_FB_nDeltaParent(   nFB) { return nFB >> 1; }


function nd_ItemTree_eInfo( 	  ItemTree) { return nd_FA_eInfo(		nd_ItemTree_nFA(ItemTree)); }
function nd_ItemTree_eType( 	  ItemTree) { return nd_FA_eType(		nd_ItemTree_nFA(ItemTree)); }
function nd_ItemTree_bAlwaysOpen( ItemTree) { return nd_FA_bAlwaysOpen( nd_ItemTree_nFA(ItemTree)); }
function nd_ItemTree_nDeltaParent(ItemTree) { return nd_FB_nDeltaParent(nd_ItemTree_nFB(ItemTree)); }

function nd_Tree_eInfo( 	  ndTree, i) { return nd_FA_eInfo(		 nd_Tree_nFA(ndTree, i)); }
function nd_Tree_eType( 	  ndTree, i) { return nd_FA_eType(		 nd_Tree_nFA(ndTree, i)); }
function nd_Tree_bAlwaysOpen( ndTree, i) { return nd_FA_bAlwaysOpen( nd_Tree_nFA(ndTree, i)); }
function nd_Tree_nDeltaParent(ndTree, i) { return nd_FB_nDeltaParent(nd_Tree_nFB(ndTree, i)); }

function nd_i_ItemTree_nParent(i, ItemTree) 
{
	var nDeltaParent = nd_FB_nDeltaParent(nd_ItemTree_nFB(ItemTree));
	return nDeltaParent ? i - nDeltaParent : 0; 
}

function nd_Tree_nParent(ndTree, i) 
{
	var nDeltaParent = nd_FB_nDeltaParent(nd_Tree_nFB(ndTree, i));
	return nDeltaParent ? i - nDeltaParent : 0; 
}

function nd_Tree_nNext(  ndTree, i) { return i + nd_Tree_nDeltaNext(ndTree, i); }

function nd_ItemTree_GetShortcutObjectId(ItemTree) 
{ 
	return (nd_ItemTree_eInfo(ItemTree)==13/*INFOMIB_SHORTCUT_OBJECT(13)*/)
		   ? nd_ItemTree_nLine(ItemTree)/* ID of Object */
		   : 0;
}

function nd_Tree_GetShortcutObjectId(ndTree, i) 
{ 
	return nd_ItemTree_GetShortcutObjectId(nd_ItemTree(ndTree,i));
}

function ndGetElement(doc, sID)
{
	return doc.getElementById ? doc.getElementById(sID) : doc.all(sID);
}

function ndGetIMG(doc, ndTreeName, n)
{
	return doc.images['ndIMG' + ndTreeName + n];
}

function ndGetDIV(doc, ndTreeName, n)
{
	return ndGetElement(doc, 'ndDIV' + ndTreeName + n);
}

function ndGetA(doc, ndTreeName, nItem)
{
	return ndGetElement(doc, ndTreeName + ':' + nItem);
}

function ndDIV2Num(oDIV, ndTreeName)
{
	return oDIV.id.substring(5 /* 'ndIMG'.length */ + ndTreeName.length);
}

function ndGetElementsByTag(obj, sTagName)
{
	return obj.getElementsByTagName ? obj.getElementsByTagName(sTagName) : obj.all.tags(sTagName);
}

function ndDisplay(obj, bDisplay)
{
	obj.style.display = bDisplay ? 'block' : 'none';
}

function ndIsDisplay(obj)
{
	return obj.style.display != 'none';
}

function ndStrReplaceChar(s, p, c)
{
	return s.substring(0, p) + c + s.substring(p+1);
}

function ndDynamicTreeInsert(_ndD, _oDiv, _i, _ndTreeName, _nOpenItem, _bExpandItem)
{
	var _iNoClickWith = eval('i_nd_iNoClickWith' + _ndTreeName);
	var _bShowAccess  = eval('i_nd_bShowAccess'  + _ndTreeName);
	var _bShowEnum	  = eval('i_nd_bShowEnum'	 + _ndTreeName);
	var _bTableBorder = eval('i_nd_bTableBorder' + _ndTreeName);
	var _ndTree = eval(_ndTreeName);

	var b = new NDClassBuf;
	ndSubDrawTree(
		_ndTreeName,
		_ndTree,
		_iNoClickWith,
		0/*bCollapse*/,
		_bShowAccess,
		_bShowEnum,
		_bTableBorder,
		_nOpenItem,
		_bExpandItem,
		_i + 1,
		b);
	ndInsertHTML(_oDiv, b.toString());
}

function ndInsertHTML(o, t)
{
	if (typeof (o.innerHTML) != 'undefined')
		o.innerHTML = t;
	else
	if (typeof (o.insertAdjacentHTML) != 'undefined')
		o.insertAdjacentHTML('beforeEnd', t)
	else
	{
		// NS
		var range = o.ownerDocument.createRange();
		range.setStartBefore(o);
		o.appendChild(range.createContextualFragment(t));	
	}

	if (ndMozilla1_4ab) // Remove BUG
	{
		// --- Reload Img with Mozilla 1.4a & 1.4b
		var a = ndGetElementsByTag(o, 'IMG');
		for (var i=0;i<a.length;i++)
		{
			var o = a[i];
			o.src = o.src; // Force Reload
		}
	}
}

function nd_onClickContinue()
{
	return false; // !!! ELSE NS stop document/images downloading
}

function nd_onMouseOverRet() 
{
	return true;
}

function nd_onMouseOutRet() 
{
	return true;
}

function ndU(_ndA, _ndD) // onClick  Toc Expand
{
	if (typeof _ndD == 'undefined')
		_ndD = document;
	_ndA = _ndA.id.split(':');
	var _ndTreeName = _ndA[0];
	if (eval('typeof(i_ndCallBack' + _ndTreeName + ')') == 'undefined')
		return nd_onClickContinue(); // Reload -> Ignore

	if (ndIsOnlineMIBsTree(eval(_ndTreeName)))
		ndO_MIBsTreeCloseMenu(true/*bForceClose*/); // Hide Menu

	var i = parseInt(_ndA[1]);
	ndE2(_ndTreeName, _ndD, i);
	return nd_onClickContinue();
}

function ndHideAllDIV(doc, ndTreeName, obj)
{
	var a = ndGetElementsByTag(obj, 'DIV');
	for (var i=0;i<a.length;i++)
	{
		var oDIV = a[i];
		if (ndIsDisplay(oDIV))
		{
			ndDisplay(oDIV, false);
			var j = ndGetIMG(doc, ndTreeName, ndDIV2Num(oDIV, ndTreeName));
			j.src = ndStrReplaceChar(j.src, j.src.length-5 /* 'Xp.gif'.length */ , 'p');
		}
	}
}

function ndE2(_ndTreeName, _ndD, _i)
{
	var _oDIV = ndGetDIV(_ndD, _ndTreeName, _i);
	var _bDisplay = !ndIsDisplay(_oDIV);
	ndDisplay(_oDIV, _bDisplay);
	var _img = ndGetIMG(_ndD, _ndTreeName, _i);
	_img.src = ndStrReplaceChar(_img.src, _img.src.length-5 /* 'p.gif'.length */ , _bDisplay ? 'm' : 'p');
	if (!_bDisplay)
		ndHideAllDIV(_ndD, _ndTreeName, _oDIV);
	else
	{
		if (nd_bDynamicDrawTree && !_oDIV.firstChild)
			ndDynamicTreeInsert(_ndD, _oDIV, _i, _ndTreeName, 0 /*nOpenItem*/, false /*bExpandItem*/);
		// --- AutoOpen Mib Module
		var _s = ndDIV2Num(_oDIV, _ndTreeName);
		var _ndTree = eval(_ndTreeName);
		var nFA = nd_Tree_nFA(_ndTree, parseInt(_s));
		var eInfo = nd_FA_eInfo(nFA);
		if (eInfo == 7) // INFOMIB_MOD(7)
		{
			var a = ndGetElementsByTag(_oDIV, 'DIV');
			for (var i=0;i<a.length;i++)
			{
				var oDIV2 = a[i];
				if (!ndIsDisplay(oDIV2))
				{
					var s = ndDIV2Num(oDIV2, _ndTreeName);
					var nFA = nd_Tree_nFA(_ndTree, parseInt(s));
					var bExpanded = nd_FA_bExpanded(nFA);
					if (bExpanded)
					{
						ndDisplay(oDIV2, true);
						var j = ndGetIMG(_ndD, _ndTreeName, s);
						j.src = ndStrReplaceChar(j.src, j.src.length-5 /* 'Xp.gif'.length */ , 'm');
					}
				}
			}
		}
	}
	status = _bDisplay ? nd_szTocCollapse : nd_szTocExpand;
}

function ndV(_ndA, _ndD) // onMouseOver [+] or [-]
{
	if (typeof _ndD == 'undefined')
		_ndD = document;
	_ndA = _ndA.id.split(':');
	var _ndTreeName = _ndA[0];
//	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[1]);

	var oDIV = ndGetDIV(_ndD, _ndTreeName, i);
	var bDisplay = !ndIsDisplay(oDIV);
	status = bDisplay ? nd_szTocExpand : nd_szTocCollapse;
	return nd_onMouseOverRet();
}

function ndW(_ndA, _ndD) // onMouseOut [+] or [-]
{
/*
	if (typeof _ndD == 'undefined')
		_ndD = document;
	_ndA = _ndA.id.split(':');
	var _ndTreeName = _ndA[0];
	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[1]);
*/
	status = defaultStatus;
	return nd_onMouseOutRet();
}

function ndOidExt(ndTree, i)
{
	var eType = nd_Tree_eType(ndTree, i);
	return (eType == 8 /*Var*/)
		   ? ' (.0)'
		   : ( (eType == 11 /*VarOfTab*/)
			   ? ' (.*)'
			   : '' );
}

function ndOid2NumString2(ndTree, i) // Recursive : OID to String : Ex .1.3.6
{
	var ItemTree = nd_ItemTree(ndTree, i);
	var nFB = nd_ItemTree_nFB(ItemTree);
	var bOidParent = nd_FB_bOidParent(nFB);
	return (bOidParent 
		   ? ndOid2NumString2(ndTree, /*nParent*/ i - nd_FB_nDeltaParent(nFB)) 
		   : nd_Tree_RootOidValue(ndTree)
		   ) + '.' + nd_ItemTree_nSubId(ItemTree);
}

function ndOid2NumString(ndTree, i)
{
	var ItemTree = nd_ItemTree(ndTree, i);
	var nSubId = nd_ItemTree_nSubId(ItemTree);
	var eType = nd_ItemTree_eType(ItemTree);
	if (eType >= 13 )
		nSubId = '[' + nSubId + ']';
	var nFB = nd_ItemTree_nFB(ItemTree);
	var bOidParent = nd_FB_bOidParent(nFB);
	return (bOidParent 
		   ? ndOid2NumString2(ndTree, /*nParent*/ i - nd_FB_nDeltaParent(nFB)) 
		   : nd_Tree_RootOidValue(ndTree)
		   ) + '.' + nSubId;
}

function ndOid2NameString2(ndTree, i) // Recursive : OID to String : Ex .iso.org.dod
{
	var ItemTree = nd_ItemTree(ndTree, i);
	var sName = nd_ItemTree_sName(ItemTree);
	var nFB = nd_ItemTree_nFB(ItemTree);
	var bOidParent = nd_FB_bOidParent(nFB);
	return (bOidParent 
		   ? ndOid2NameString2(ndTree, /*nParent*/ i - nd_FB_nDeltaParent(nFB)) 
		   : nd_Tree_RootOidName(ndTree)
		   ) + '.' + ((sName=='') ? nd_ItemTree_nSubId(ItemTree) : sName);
}

function ndOid2NameString(ndTree, i)
{
	var ItemTree = nd_ItemTree(ndTree, i);
	var sName = nd_ItemTree_sName(ItemTree);
	var eType = nd_ItemTree_eType(ItemTree);
	if (eType >= 13 )
		sName = '[' + sName + ']';
	var nFB = nd_ItemTree_nFB(ItemTree);
	var bOidParent = nd_FB_bOidParent(nFB);
	return (bOidParent 
		   ? ndOid2NameString2(ndTree, /*nParent*/ i - nd_FB_nDeltaParent(nFB)) 
		   : nd_Tree_RootOidName(ndTree)) 
		   + '.' + ((sName=='') ? nd_ItemTree_nSubId(ItemTree) : sName);
}

function ndOid2NumStringExt(ndTree, i)
{
	return ndOid2NumString(ndTree, i) + ndOidExt(ndTree, i);
}

function ndOid2NameStringExt(ndTree, i)
{
	return ndOid2NameString(ndTree, i) + ndOidExt(ndTree, i);
}

function ndGetPathAndFileOfMib(ndTree, i) // Recursive
{
	var ItemTree = nd_ItemTree(ndTree, i);
	var nParent = nd_i_ItemTree_nParent(i, ItemTree);
	return (nParent ? ndGetPathAndFileOfMib(ndTree, nParent) + '/' : '') + nd_ItemTree_sName(ItemTree);
}

function ndGetUrlPathAndFileOfMib(ndTree, i)
{
	var s = ndGetPathAndFileOfMib(ndTree, i);
	// --- Replace		  "%" -> "%25"
	s = s.replace(/%/g,  "%25");

	if (!ndOpera) // !!! else Opera 7.10 & 7.23: "Could not open file" : BUG
	{
		// --- Replace		  "" -> "%A6"
		s = s.replace(//g,  "%A6");
		// --- Replace		  "" -> "%A7"
		s = s.replace(//g,  "%A7");
	}
	return s;
}

function ndN2H(n) // RECURSIF  -  Convert Num(0..255..2047..) to Hex String('0'..'FF'..'FFF'..)
{
	var h = n >> 4;
	return (h ? ndN2H(h) : '') + ndHexA.charAt(n & 15);
}

function ndY(_ndA, _ndF) // onMouseOver
{
	if (typeof _ndF == 'undefined')
		_ndF = self;
	if (_ndA.id)
		_ndA = _ndA.id;
	_ndA = _ndA.split(':');
	var _ndTreeName = _ndA[0];
	if (eval('typeof(i_ndCallBack' + _ndTreeName + ')') == 'undefined')
		return nd_onMouseOverRet(); // Reload -> Ignore
	var _ndCallBack = eval('i_ndCallBack' + _ndTreeName);
	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[1]);
	if (_ndCallBack != null)
		if (_ndCallBack.onMouseOver(_ndTree, i, _ndF))
			return nd_onMouseOverRet();

	var ItemTree = nd_ItemTree(_ndTree, i);
	var nShortcutObjectId = nd_ItemTree_GetShortcutObjectId(ItemTree);
	if (nShortcutObjectId)
	{
		i = nShortcutObjectId;
		ItemTree = nd_ItemTree(_ndTree, i);
	}

	if (ndIsOnlineMIBsTree(_ndTree))
	{
		var xframeMIBsTree = ndO_GetXFrameNavTree(1/*nNumTab*/);
		var idxModOfMibList = nd_MIBsTree_IdxModOfMibList(_ndTree, i);
		if (idxModOfMibList != "")
			ndO_OpenMenu(xframeMIBsTree, _ndTree /*ndMIBsTree*/, i, false/*bClick*/);
	}
	var eInfo = nd_ItemTree_eInfo(ItemTree);
	var sName = nd_ItemTree_sName(ItemTree);
	var oid = '';
	var bEnum;
	switch(eInfo)
	{
	case 0: // INFODIR_DIR(0)
		sName = ndDirName2Text(sName);
		break;
	case 1: // INFODIR_MIB(1)
	case 6: // INFOMIB_MIB(6)
		sName = ndFileName2Text(sName);
		break;
	case 11: // INFOMIB_TYPE(11)
		{
			var sInfo = nd_ItemTree_sInfo(ItemTree);
			if (sInfo)
				sName += '	' + sInfo;
		}		
		break;
	case 8: // INFOMIB_OBJECT(8)
	case 9: // INFOMIB_OBJECT_TRAP(9)
		oid = ndOid2NumStringExt(_ndTree, i); 
		bEnum = false;
		break;
	case 10: // INFOMIB_ENUM(10)
		oid = nd_ItemTree_nSubId(ItemTree);
		bEnum = true;
		break;
	}
	if (oid != '')
	{
		/*
			var form = ndFrameTitle.document.ndOidForm;
			form.ndOidName.value = (bEnum ? sName : ndOid2NameStringExt(_ndTree, i));
			form.ndOidValue.value = oid;
		*/
		sName += (bEnum ? '(' + oid + ')' : ((sName=='') ? '' : ' : ') + oid );
	}
	status = sName;
	return nd_onMouseOverRet();
}

function ndZ(_ndA, _ndF) // onMouseOut
{
	if (typeof _ndF == 'undefined')
		_ndF = self;
	if (_ndA.id)
		_ndA = _ndA.id;
	_ndA = _ndA.split(':');
	var _ndTreeName = _ndA[0];
	if (eval('typeof(i_ndCallBack' + _ndTreeName + ')') == 'undefined')
		return nd_onMouseOutRet(); // Reload -> Ignore
	var _ndCallBack = eval('i_ndCallBack' + _ndTreeName);
	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[1]);
	if (_ndCallBack != null)
		if (_ndCallBack.onMouseOut(_ndTree, i, _ndF))
			return nd_onMouseOutRet();

	if (ndIsOnlineMIBsTree(_ndTree))
		ndO_MIBsTreeCloseMenu(false/*bForceClose*/);

	status = defaultStatus;
	return nd_onMouseOutRet();
}

function ndO_GetFramesetRowOfNavBar()
{
	return ''+(ndO_szHeightNavBar+ndO_szHeightNavBlankBar)+',';
}

function ndO_GetFramesetRowOfDynamicFrame(nNumTab)
{
	return (ndO_bDirTree  ? ( (nNumTab==0) ? '*,' : '0,') : '') 
		 + (ndO_bMIBsTree ? ( (nNumTab==1) ? '*,' : '0,') : '') 
		 +					( (nNumTab==2) ? '*'  : '0' );
}

function ndO_FrameFmtRootRow(bShowTop)
{
	return (bShowTop ? '' + g_ndHeightFrameTop + ',*,18' : '0,*,0');
}

function ndGetPathAndFile(strURL)
{
	var nPos = strURL.lastIndexOf('#');
	return (nPos!=-1) ? strURL.substring(0,nPos) : strURL;
}

function ndGetPath(strURL)
{
	return strURL.substring(0, strURL.lastIndexOf('/')+1 );
}

function ndGetFile(strURL)
{
	strURL = strURL.substring(strURL.lastIndexOf('/')+1 );
	var nPos = strURL.lastIndexOf('#');
	return (nPos!=-1) ? strURL.substring(0,nPos) : strURL;
}

function ndX(_ndA, _ndF) // onClick
{
	if (typeof _ndF == 'undefined')
		_ndF = self;
	if (_ndA.id)
		_ndA = _ndA.id;
	_ndA = _ndA.split(':');
	var _ndTreeName = _ndA[0];
	if (eval('typeof(i_ndCallBack' + _ndTreeName + ')') == 'undefined')
		return nd_onClickContinue(); // Reload -> Ignore

	var _ndCallBack = eval('i_ndCallBack' + _ndTreeName);
	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[1]);
	if (_ndCallBack != null)
		if (_ndCallBack.onClick(_ndTree, i, _ndF))
			return nd_onClickContinue();

	if (ndIsOnlineMIB())
	{
		if (_ndTreeName == ndO_DirTreeName)
			ndO_szStartWithMibTreeItem = ''; // Reset

		ndSelectItemTree(_ndF.document, _ndTreeName, i);
	}

	if (!ndIsMibTreeOnly(_ndTree))
		ndC2(_ndTree, i);
	return nd_onClickContinue();
}

function ndIsMibTreeWithOneModOnly(ndTree)
{
	if (	(ndTree.length > 3) // Ignore Empty Module
		 && (nd_Tree_eInfo(ndTree, 1) == 6/*INFOMIB_MIB(6)*/)
		 && (nd_Tree_eInfo(ndTree, 2) == 7/*INFOMIB_MOD(7)*/) )
	{
		for(var i=3; i<ndTree.length; i++)
			if (nd_Tree_eInfo(ndTree, i) == 7/*INFOMIB_MOD(7)*/)
				return false;
		return true;
	}
	return false;
}

function ndSetWindowTitle(szText)
{
	if (document.title != szText)
		document.title = szText;
}
		 
function ndO_ShowFrameRight()
{
	if (ndO_bDynamicFrame)
	{
		// NOT WORK : var ndFrameSetH = ndGetElement(document, 'ndFrameSetH'); // Netscape 7.0
		var t = ndFrameSetH.cols.split(',');
		if (t[1] == 0)
			ndFrameSetH.cols = t[0] + ',' + ndO_szFrameSetHVal;
	}
}

function ndFileSize2String(nSize)
{
	// Like Windows Folder Properties:
	//	123 KB
	//	12.3 KB
	//	1.23 KB
	if		(nSize<=999) return nSize.toString() + ' bytes';
	var u;
	if		(nSize<=999*1024)	   { u = ' KB'; nSize /= 1024; }
	else if (nSize<=999*1024*1024) { u = ' MB'; nSize /= 1024*1024; }
	else						   { u = ' GB'; nSize /= 1024*1024*1024; }
	var a = Math.floor(nSize);
	if (nSize>99)
		return a + u;
	if (nSize>9)
	{
		nSize = (nSize - a) * 10;
		var b = Math.floor(nSize);
		return a.toString() + (ndFR ? ',' : '.') + b.toString() + u;
	}
	else
	{
		nSize = (nSize - a) * 10;
		var b = Math.floor(nSize);
		nSize = (nSize - b) * 10;
		var c = Math.floor(nSize);
		return a.toString() + (ndFR ? ',' : '.') + b.toString() + c.toString() + u;
	}
}

function ndO_MibTreeDownloadMsg(nProgress)
{
	var milliseconde = (new Date()).getTime();
	if (!nProgress)
	{
		var s = ndFileSize2String(ndO_nLastHtmlFileSize)
		var msg = nd_FmtProgressBarMsg(s);
		ndO_InitDocumentColorAndMsg(ndO_GetDocumentNavTree2(), g_ndBGColorFrameMibTree, msg);

		ndO_nLastMibTreeProgress = 0;

		// --- Form Search
		if (	ndO_winSearch && !ndO_winSearch.closed
			 && ndO_bFormSearch_WaitMibTreeDownload )
			ndO_InitSearchResultMibTreeDownloadingMsg(s);
		
		ndO_nLastMibTreeProgressUpdated = milliseconde;
	}
	else
	{
		if ( (milliseconde - ndO_nLastMibTreeProgressUpdated) > 250 )
		{
			var doc = ndO_GetDocumentNavTree2();
			var ndProgress = ndGetElement(doc, 'ndProgress')
			if (ndProgress)
			{	
				ndInsertHTML(ndProgress, nProgress);

				// --- Form Search
				if (	ndO_winSearch && !ndO_winSearch.closed
					 && ndO_bFormSearch_WaitMibTreeDownload )
				{	
					ndProgress = ndGetElement(ndO_frameSearchResult.document, 'ndProgressMibTree')
					if (ndProgress)
						ndInsertHTML(ndProgress, nProgress);
				}
				var ndProgressBar = ndGetElement(doc, 'ndProgressBar')
				if (ndProgressBar)
					ndInsertHTML(ndProgressBar, nd_FmtProgressBar(nProgress));

				ndO_nLastMibTreeProgress = nProgress;
				ndO_nLastMibTreeProgressUpdated = milliseconde;
			}
		}
	}
}

var nd_nHeightProgressBar	= 14; // Not include External & Internal Border
var nd_rgbColorProgressBar		 = "#81AAF2"; // "skyblue";
var nd_rgbColorProgressBarBorder = "#ABABAB"; // "lightgrey";

function nd_FmtProgressBar(i)
{
	// !!! Opera BUG 7.21 : % not work !!!
	var unit = ndOpera ? ''/*px*/ : '%';

	return	'<TABLE cellSpacing=0 cellPadding=0 border=0 width="85%">'
		   +  '<TR>'
		   +   '<TD rowspan=5 bgcolor='+nd_rgbColorProgressBarBorder+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +   '<TD colspan=4 bgcolor='+nd_rgbColorProgressBarBorder+' width=100%><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +   '<TD rowspan=5 bgcolor='+nd_rgbColorProgressBarBorder+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +  '</TR>'
		   +  '<TR>'
		   +   '<TD rowspan=3><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +   '<TD colspan=2 width=100%><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +   '<TD rowspan=3><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +  '</TR>'
		   +  '<TR width="100%">'
		   +   '<TD bgcolor='+nd_rgbColorProgressBar+' width="'+     i +unit+'" height='+nd_nHeightProgressBar+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=0 height=0></TD>'
		   +   '<TD 								   width="'+(100-i)+unit+'" height='+nd_nHeightProgressBar+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=0 height=0></TD>'
		   +  '</TR>'
		   +  '<TR>'
		   +   '<TD colspan=2 width=100%><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +  '</TR>'
		   +  '<TR>'
		   +   '<TD colspan=4 bgcolor='+nd_rgbColorProgressBarBorder+' width=100%><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +  '</TR>'
		   +'</TABLE>';
}

function nd_FmtProgressBarMsg(s)
{
	return '<TABLE cellSpacing=0 cellPadding=0 border=0 width="100%">'
		 +	'<TR><TD align=middle><B><FONT style="COLOR:'+g_ndColorMessage+'; '+g_ndStyleFontSizeMessage+'; '+g_ndStyleFontFamilyMessage+'">' + nd_szDownloading + ' (' + s + ') - <SPAN id=ndProgress>0</SPAN>%</B></FONT></TD></TR>'
		 +	'<TR><TD height=4><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD></TR>'
		 +	'<TR><TD align=middle width="100%"><SPAN id=ndProgressBar>'+nd_FmtProgressBar(0)+'</SPAN></TD></TR>'
		 +	'<TR><TD height=4><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD></TR>'
		 +	'<TR><TD align=middle><FONT style="COLOR:'+g_ndColorMessage+'; '+g_ndStyleFontSizeMessage+'; '+g_ndStyleFontFamilyMessage+'">'+nd_szPleaseWait+'</FONT></TD></TR>'
		 + '</TABLE>';
}

function ndO_GetMIBsTreeDataFile()
{
	return g_ndTreePath + 
		   ((ndO_nOneFileOnlyIndex == 1) // OnLineMIB of a File ONLY
		    ? nd_Tree_sName(ndO_GetDirTree(), ndO_nOneFileOnlyIndex) + '(MIBsTreeData).html'
			: 'MIBsTreeData.html'); // OnLineMIB of a Dir
}

function ndO_MIBsTreeDownloadMsg(nProgress)
{
	var milliseconde = (new Date()).getTime();
	if (!nProgress)
	{
		ndO_bMIBsTreeDownloading = true;

		var doc = ndDocBegin(ndO_GetDocumentNavTree1());
		ndO_WriteFrameBorderStyle(doc);
		ndDocBody(doc, g_ndBGColorFrameMibsTree, 0, ' onLoad="top.ndOnlineMibDoc.ndO_onLoadMIBsTreeDocument()"');
		var nFileSize_MIBsTreeJS = ndO_GetFileSize_MIBsTreeJS();
		var s = ndFileSize2String(nFileSize_MIBsTreeJS)
		var msg = nd_FmtProgressBarMsg(s);
		var file = ndO_GetMIBsTreeDataFile();
		doc.write(
			'<IFRAME src="' + file + '" name="ndIFrameMIBsTree" id="ndIFrameMIBsTree" border=0px width=0% height=0% marginwidth=0 marginheight=0 hspace=0 vspace=0 frameborder=0 scrolling=auto></IFRAME>'
		   +'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
		   +'<TR>'
		   +'<TD vAlign=middle align=middle>' + msg + '</TD>'
		   +'</TR>'
		   +'</TABLE>');
		ndDocEnd(doc);

		ndO_nLastMIBsTreeProgress = 0;

		// --- Form Search
		if (	ndO_winSearch && !ndO_winSearch.closed
			 && ndO_bFormSearch_WaitMIBsTreeDownload )
			ndO_InitSearchResultMIBsTreeDownloadingMsg(s);

		ndO_nLastMIBsTreeProgressUpdated = milliseconde;
	}
	else
	{
		if ( (milliseconde - ndO_nLastMIBsTreeProgressUpdated) > 250 )
		{
			var doc = ndO_GetDocumentNavTree1();
			var ndProgress = ndGetElement(doc, 'ndProgress')
			if (ndProgress)
			{	
				ndInsertHTML(ndProgress, nProgress);

				// --- Form Search
				if (	ndO_winSearch && !ndO_winSearch.closed
					 && ndO_bFormSearch_WaitMIBsTreeDownload )
				{	
					ndProgress = ndGetElement(ndO_frameSearchResult.document, 'ndProgressMIBsTree')
					if (ndProgress)
						ndInsertHTML(ndProgress, nProgress);
				}
				var ndProgressBar = ndGetElement(doc, 'ndProgressBar')
				if (ndProgressBar)
					ndInsertHTML(ndProgressBar, nd_FmtProgressBar(nProgress));

				ndO_nLastMIBsTreeProgress = nProgress;
				ndO_nLastMIBsTreeProgressUpdated = milliseconde;
			}
		}
	}
}

function ndO_MIBsTreeCloseMenu(bForceClose)
{
	var xframeMIBsTree = ndO_GetXFrameNavTree(1/*nNumTab*/);
	ndO_CloseMenu(xframeMIBsTree, bForceClose);
}

function ndO_onMenuClick(i, j)
{
	ndO_MIBsTreeCloseMenu(true/*bForceClose*/); // Hide Menu

	var ndMIBsTree = ndO_GetMIBsTree();
	ndO_szStartWithMibTreeItem = nd_Tree_sName(ndMIBsTree, i);
	ndC2(ndO_GetDirTree(), j, 0/*nLine*/);

	return nd_onClickContinue();
}

function ndO_onMenuMouseOver(nIndexMod)
{
	var ndDirTree = ndO_GetDirTree();
	var nIndexMib = nd_Tree_nParent(ndDirTree, nIndexMod);
	status = ndGetPathAndFileOfMib(ndDirTree, nIndexMib);
	return nd_onMouseOverRet();
}

function ndO_onMenuMouseOut()
{
	status = defaultStatus;
	return nd_onMouseOutRet();
}

function ndO_PlugMenuLibrary(doc)
{
	// NDMib2WebConfig.js overide this function
}

function ndO_OpenMenu(xframeMIBsTree, ndMIBsTree, i, bClick /* else bMouseOver */) 
{
	// NDMib2WebConfig.js overide this function
}

function ndO_CloseMenu(xframeMIBsTree, bForceClose) 
{
	// NDMib2WebConfig.js overide this function
}

function ndC2(ndTree, i, nLine) 
{
	// !!! location.href : write-only with Opera 6.05
	// !!!	-> use location.toString()
	var ItemTree = nd_ItemTree(ndTree, i);
	var nFA = nd_ItemTree_nFA(ItemTree);
	var eInfo = nd_FA_eInfo(nFA);

	var nShortcutObjectId = nd_ItemTree_GetShortcutObjectId(ItemTree);
	if (nShortcutObjectId)
	{
		i = nShortcutObjectId;
		ItemTree = nd_ItemTree(ndTree, i);
		nFA = nd_ItemTree_nFA(ItemTree);
		eInfo = nd_FA_eInfo(nFA);
	}

	var bOnlineMIB = ndIsOnlineMIB();
	if (bOnlineMIB && (ndTree != ndO_GetMIBsTree()) )
		ndO_ShowFrameRight();

	if (ndIsOnlineDirTree(ndTree))
	{
		ndO_nMibTreeShowModNum = 0;
		if ((typeof nLine == 'undefined') || (nLine==-1))
			nLine = '';
		if (	(eInfo == 3/*INFODIR_MOD_OF_DIR(3)*/)
			 || (eInfo == 2/*INFODIR_MOD_OF_FILE(2)*/) )
		{
			var nParent = nd_i_ItemTree_nParent(i, ItemTree);
			if (eInfo == 3/*INFODIR_MOD_OF_DIR(3)*/)
				nParent/*nFil*/ = nd_Tree_nParent(ndTree, i = nParent/*nModOfFil*/);
			if (nLine == '')
			{
				nLine = nd_ItemTree_nLine(ItemTree);
				ndO_nMibTreeShowModNum = i - nParent;
/*
				// --- MIBsTree Click  ->  Open <DirTree - Fil - Mod>
				if (	ndO_bDirTree
					 && ndO_bMIBsTree
					 && ndO_bMIBsTreeLoad
					 && ndO_szStartWithMibTreeItem)
				{
					var doc = ndO_GetDocumentNavTree0();
					// --- Close All DirTree
				//	ndHideAllDIV(doc, ndO_DirTreeName, doc/*obj* /);
					var objA = ndO_ExpandItem(doc, ndO_DirTreeName, i);
					// --- 'Mod' Select & Focus 
					ndSelectAndFocusItemTree(objA, doc, ndO_DirTreeName, i);
				}
*/
			}
			i = nParent;
			ItemTree = nd_ItemTree(ndTree, i);
			nFA = nd_ItemTree_nFA(ItemTree);
		}

		ndO_nLastFileIndexDirTree = i;
		ndO_nLastFileIcoLanguage = nd_FA_eIcoLanguage(nFA);
		ndO_nLastHtmlFileSize = nd_ItemDirTree_nHtmlFileSize(ItemTree);
		ndO_nLastZipFileSize = nd_ItemDirTree_nZipFileSize(ItemTree);
		ndO_szLastMibFileName = ndText2Html(ndFileName2Text(nd_ItemTree_sName(ItemTree)));
		var newMibPathFileName = g_ndHtmlPath + ndGetUrlPathAndFileOfMib(ndTree, i);
		var bNewFile = ndO_szLastMibPathFileName != newMibPathFileName;
		var oldHref;
		if (bNewFile)
		{
			// --- Clear
			ndO_ClearSearchResultOfMibTree();
			if (ndO_GetMibTree())
				eval(ndO_MibTreeName + ' = null');
			ndO_bMibTreeDownloading = true;

			// --- Window Title
			if (ndO_bOneFileOnly && (g_ndOnlineMibWindowsTitleText == ''))
				ndSetWindowTitle(ndO_szLastMibFileName);

			ndO_szLastMibPathFileName = newMibPathFileName;
			// Disable 'Refresh' Button
			ndO_bRefreshButtonOfTab[2] = false;
			ndO_DrawNavBarFile_FileNameTab();
			ndO_MibTreeDownloadMsg(0);
			ndO_bWaitPlugMibFile = true;
			ndO_bMibTreeLoad = false;
			if (ndNS)
				oldHref = ndFrameContentFile.document.location.toString();
		}
		else
		if (ndO_bMibTreeLoad)
		{
			if (ndO_nMibTreeShowModNum)
			{
				// --- Open Module
				var i = ndO_GetMibFileModuleNum2Index(ndO_nMibTreeShowModNum);
				var doc = ndO_GetDocumentNavTree2();
				var objA = ndGetA(doc, ndO_MibTreeName, i);
				if (objA)
				{
					// --- Expand 'MibTree - Mib'
					var oDIV = ndGetDIV(doc, ndO_MibTreeName, 1);
					if (oDIV)
					{
						if (!ndIsDisplay(oDIV))
							ndE2(ndO_MibTreeName, doc, 1); // Toc Expand
						// --- Expand 'MibTree - Mod'
						oDIV = ndGetDIV(doc, ndO_MibTreeName, i);
						if (oDIV)
							if (!ndIsDisplay(oDIV))
								ndE2(ndO_MibTreeName, doc, i); // Toc Expand
					}
					if (ndO_szStartWithMibTreeItem)
					{
						var ndMibTree = ndO_GetMibTree();
						i /*nOpenItem*/ = ndO_NameWithModNum2Indice(ndMibTree, ndO_szStartWithMibTreeItem, ndO_nMibTreeShowModNum);
						nLine = nd_Tree_nLine(ndMibTree, i);
						objA = ndO_ExpandItem(doc, ndO_MibTreeName, i);
						ndO_szStartWithMibTreeItem = ''; // Reset
					}
					// --- 'MibTree - Mod' Select & Focus 
					ndSelectAndFocusItemTree(objA, doc, ndO_MibTreeName, i);
				}
				ndO_nMibTreeShowModNum = 0; // Reset
			}
			else
			if (eInfo == 1/*INFODIR_MIB(1)*/)
			{
				var doc = ndO_GetDocumentNavTree2();
				var objA = ndGetA(doc, ndO_MibTreeName, 1);
				if (objA)
				{
					// --- Expand 'MibTree - Mib'
					var oDIV = ndGetDIV(doc, ndO_MibTreeName, 1);
					if (oDIV)
					{
						if (ndIsDisplay(oDIV))
							ndE2(ndO_MibTreeName, doc, 1); // Toc Close
						ndE2(ndO_MibTreeName, doc, 1); // Toc Expand
						if (ndIsMibTreeWithOneModOnly(ndO_GetMibTree()))
						{
							var oDIV = ndGetDIV(doc, ndO_MibTreeName, 2);
							if (oDIV)
								ndE2(ndO_MibTreeName, doc, 2); // Toc Expand
						}
					}
					// --- 'Mib' Select & Focus 
					ndSelectAndFocusItemTree(objA, doc, ndO_MibTreeName, 1);
				}
			}
		}

		if (ndO_bDynamicFrame || ndO_bIFrame)
			ndO_ActiveTab(2/*Tab2_MibFile*/, false);
		else
			ndO_RefreshNavBarTree_SimpleTab(2/*Tab2_MibFile*/); // Hide Refresh Button

		var szNewLocation = ndO_szLastMibPathFileName + '.html#' + nLine;
	  //ndFrameContentFile.document.location.href = szNewLocation;
	  //ndFrameContentFile.document.open(szNewLocation,"_self","",true);
		ndFrameContentFile.document.location.replace(szNewLocation); // ??? IE6.0SP1 BUG : with same href and another anchor -> add history
		if (bNewFile && ndNS)
		{
			// --- !!! NS6.2 Bug after 'Reload' (No bug with NS7.0PR1)
			// --- ----------------------------
			// --- NS6.2 not reset 'ndFrameContentFile.document.location.href'
			// --- => force 'reload' if previous href == new href
			if (	(oldHref.indexOf(ndO_szLastMibPathFileName + '.html#') != -1)
				 && (ndGetPathAndFile(oldHref) == ndGetPathAndFile(ndFrameContentFile.document.location.toString())) )
			{
				// --- Force : RELOAD
				ndFrameContentFile.document.location.reload();
			}
		}
		else
		if (!bNewFile && !ndO_bMibTreeLoad && !ndIE)
		{
			// --- Remove Bug with non IE browser 
			// ->
			// --- Force : RELOAD
			ndFrameContentFile.document.location.reload();
		}
	}
	else
	{
		if (bOnlineMIB) 
			switch(eInfo)
			{
			case 8: // INFOMIB_OBJECT(8)
			case 9: // INFOMIB_OBJECT_TRAP(9)
				ndO_UpdateOidForm(ndTree, i);
			}

		if (ndIsOnlineMIBsTree(ndTree))
		{
			var xframeMIBsTree = ndO_GetXFrameNavTree(1/*nNumTab*/);

			var idxModOfMibList = nd_MIBsTree_IdxModOfMibList(ndTree, i);
			if (idxModOfMibList != "") // Empty -> Hidden Import with Var of Trap & Notification
			{
				if (idxModOfMibList.length>1)
					ndO_OpenMenu(xframeMIBsTree, ndTree /*ndMIBsTree*/, i, true/*bClick*/);
				else
					ndO_onMenuClick(i, parseInt(idxModOfMibList[0]));
			}
		}	
		else
		{
			var doc = bOnlineMIB ? ndFrameContentFile.document : document;
			var nLine = (!bOnlineMIB && (eInfo == 6/*INFOMIB_MIB(6)*/)) 
						? 0
						: ( nd_ItemTree_IsLine(ItemTree)
							? nd_ItemTree_nLine(ItemTree) 
							: ''); // !!!!!!!!!!!!!!!! or 0
			var szNewLocation = ndGetPathAndFile(doc.location.toString()) + '#' + nLine;
			// !!! BUG : Not work with Opera 6.05 (location.href only work with an other filename)
		  //doc.location.href = szNewLocation;
		  //doc.location.hash = '#' + nLine;
		  //doc.open(szNewLocation,"_self","",true);
			if (ndOpera7_1 || ndOpera7_2)
			{
				// --- BUG Opera 7.10 & 7.23: 'replace()' function reload the file
				if (ndOpera7_1)
					doc.location.assign(szNewLocation);
				else
					// --- BUG Opera 7.23: 'assign()' function reload the file
					doc.location.hash = '#' + nLine;
			}
			else
				doc.location.replace(szNewLocation); // ??? IE6.0SP1 BUG : with same href and another anchor -> add history
		}
	}
}

function ndO_UpdateOidForm(ndTree, i)
{
	var form = ndFrameTitle.document.ndOidForm;
	form.ndOidName.value  = ndOid2NameStringExt(ndTree, i);
	form.ndOidValue.value = ndOid2NumStringExt( ndTree, i);
}

function ndImg(b, t, w)
{
	b.write('<IMG src="' + g_ndImgPath + t + '.gif" align=absmiddle width=' + w + ' height=16 alt="">');
}

function ndImg2(b, t, w)
{
	b.write('<IMG src="' + g_ndImgPath + t + '.gif" align=absmiddle width=' + w + ' height=16 alt="" border=0>');
}

function ndName2Text(s, bDir)
{
	for(;;)
	{
		switch(s.charAt(0))
		{
		case '=': if (bDir) break;
		case '%':
		case '~':
		case '!':
			s = s.substring(1);
			continue;
		}
		break;
	}
	// --- Replace "" -> "/"
	s = s.replace(//g, "/"); 
	// --- Replace "" -> "\"
	s = s.replace(//g, "\\");
	return s;	
}

function ndFileName2Text(s) { return ndName2Text(s, false); }
function ndDirName2Text(s)	{ return ndName2Text(s, true); }

function ndText2Html(s)
{
	// --- Replace "&" -> "&amp;"
	s = s.replace( /&/g,  "&amp;");
	if (s.indexOf("  ") != -1)
	{
		// --- Replace "  " -> "&nbsp;&nbsp;"
		s = s.replace(/  /g, "&nbsp;&nbsp;"); 
		// --- Replace "&nbsp; " -> "&nbsp;&nbsp;"
		s = s.replace(/&nbsp; /g, "&nbsp;&nbsp;"); 
	}
	// --- Replace "<"	-> "&lt;"
	s = s.replace( /</g,   "&lt;");
	// --- Replace ">"	-> "&gt;"
	s = s.replace( />/g,   "&gt;");
	// --- Replace "\n" -> "<BR>"
	s = s.replace( /\n/g,  "<BR>");
	return s;
}

function ndText2HtmlWithoutBR(s)
{
	// --- Replace "\n" -> " "
	s = s.replace( /\n/g,  " ");
	if (s.indexOf("  ") != -1)
	{
		// --- Replace "   " -> " "
		s = s.replace(/   /g, " "); 
		// --- Replace "  " -> " "
		s = s.replace(/  /g, " "); 
	}
	// --- Replace "&" -> "&amp;"
	s = s.replace( /&/g,  "&amp;");
	// --- Replace "<"	-> "&lt;"
	s = s.replace( /</g,   "&lt;");
	// --- Replace ">"	-> "&gt;"
	s = s.replace( />/g,   "&gt;");
	return s;
}

function ndIsOnlineMIB()
{
	return top && top.ndOnlineMibDoc;
}

function ndIsOnlineDirTree(ndTree)
{
	return nd_Tree_Type(ndTree) == 0;
}

function ndIsOnlineMIBsTree(ndTree)
{
	return nd_Tree_Type(ndTree) == 4;
}

function ndIsOnlineMibFile(ndTree)
{
	return nd_Tree_Type(ndTree) == 1;
}

function ndIsMibFileOnly(ndTree)
{
	return nd_Tree_Type(ndTree) == 2;
}

function ndIsMibTreeOnly(ndTree)
{
	return nd_Tree_Type(ndTree) == 3;
}

function ndName2Indice(ndTree, name)
{
	for (var i=1;i<ndTree.length;i++)
		if (nd_Tree_sName(ndTree, i) == name)
			return i;
	return 0;
}

function ndO_NameWithModNum2Indice(ndTree, name, modNum)
{
	var e=0;
	for (var i=ndO_GetMibFileModuleNum2Index(modNum)+1;i<ndTree.length;i++)
	{
		var ItemTree = nd_ItemTree(ndTree, i);
		if (nd_ItemTree_sName(ItemTree) == name)
		{
			var eInfo = nd_ItemTree_eInfo(ItemTree);
			if (eInfo != 10/*INFOMIB_ENUM(10)*/)
				return i;
			else
			if (!e)
				e = i;
		}
	}
	return e;
}

function ndLine2Indice(ndTree, line)
{
	for (var i=1;i<ndTree.length;i++)
		if (nd_Tree_nLine(ndTree, i) == line)
			return i;
	return 0;
}

function ndO_onLoadTree(doc, ndTreeName, nOpenItem)
{
	if (eval('typeof(i_nd_iNoClickWith' + ndTreeName + ')') == 'undefined')
		return; // Reload -> Ignore
	
	if (ndIsOnlineMIB())
	{
		if (ndTreeName == ndO_MibTreeName ) ndO_bMibTreeLoad  = true;
		else
		if (ndTreeName == ndO_MIBsTreeName) ndO_bMIBsTreeLoad = true;
	}

	if (nOpenItem)
	{
		if (ndTreeName != ndO_MIBsTreeName)
			ndTreeClickItem(ndTreeName, nOpenItem);
		ndTreeSetFocusItem(doc, ndTreeName, nOpenItem); // Selected Item
	}
	else
		ndTreeSetFocusItem(doc, ndTreeName, 1); // Selected Mib
}

function ndTreeSetFocusItem(_doc, _ndTreeName, _nItem)
{
	var _objA = ndGetA(_doc, _ndTreeName, _nItem);
	if (!_objA)
	{
		var _ndTree = eval(_ndTreeName);
		var ItemTree = nd_ItemTree(_ndTree, _nItem);
		var eInfo = nd_ItemTree_eInfo(ItemTree);
		if (eInfo == 10/*INFOMIB_ENUM(10)*/)
		{
			// --- !bShowEnum -> SetFocus(parent)
			_nItem = nd_i_ItemTree_nParent(_nItem, ItemTree); // Get Parent of Enum
			_objA = ndGetA(_doc, _ndTreeName, _nItem);
		}
	}
	if (_objA)
		ndSelectAndFocusItemTree(_objA, _doc, _ndTreeName, _nItem)
}

function ndTreeClickItem(_ndTreeName, _nItem)
{
	// --- Click
	var _ndTree = eval(_ndTreeName);
	var ItemTree = nd_ItemTree(_ndTree, _nItem);
	var eInfo = nd_ItemTree_eInfo(ItemTree);
	var nLine = nd_ItemTree_nLine(ItemTree);
	var _iNoClickWith = eval('i_nd_iNoClickWith' + _ndTreeName);
	if (ndTreeIsClickWith(eInfo, _iNoClickWith, nLine))
		ndC2(_ndTree, _nItem, nLine);
}

function ndSubDynamicTreeGetLeftSide(ndTree, i, stateACC, stateBAR) // RECURSIF
{
	var ItemTree	 = nd_ItemTree(ndTree, i);
	var nDeltaParent = nd_ItemTree_nDeltaParent(ItemTree);
	var nL = nDeltaParent
				? ndSubDynamicTreeGetLeftSide(ndTree, /*nParent*/i-nDeltaParent, stateACC, stateBAR) // RECURSIF
				: 0;
	var nFA 	 = nd_ItemTree_nFA(ItemTree);
	stateACC[nL] = nd_FA_bSpaceForAccess(nFA);
	stateBAR[nL] = nd_FA_bNextOfParent(nFA);
	return nL + 1;
}

function ndDynamicTreeGetLeftSide(ndTree, i, stateACC, stateBAR)
{
	var nDeltaParent = nd_Tree_nDeltaParent(ndTree, i);
	return nDeltaParent
			? ndSubDynamicTreeGetLeftSide(ndTree, /*nParent*/i-nDeltaParent, stateACC, stateBAR)
			: 0;
}

function ndSubGetParentItems(ndTree, i, openITEM) // RECURSIF
{
	var nDeltaParent = nd_Tree_nDeltaParent(ndTree, i);
	var nL = nDeltaParent
				? ndSubGetParentItems(ndTree, /*nParent*/i-nDeltaParent, openITEM) // RECURSIF
				: 0;
	openITEM[nL] = i;
	return nL + 1;
}

function ndGetParentItems(ndTree, i /*nOpenItem*/, openITEM)
{
	var nDeltaParent = nd_Tree_nDeltaParent(ndTree, i);
	return nDeltaParent
			? ndSubGetParentItems(ndTree, /*nParent*/i-nDeltaParent, openITEM)
			: 0;
}

function ndTreeIsClickWith(eInfo, _iNoClickWith, nLine)
{
	return (	((eInfo== 8/*INFOMIB_OBJECT(8)*/		  ) && (	(	 !(_iNoClickWith &	16/*Object	   (bit4: 16)*/) &&  nLine) 
																 || (	 !(_iNoClickWith & 128/*ImportOID  (bit7:128)*/) && !nLine)))
			 || ((eInfo==10/*INFOMIB_ENUM(10)*/ 		  ) && (	(	 !(_iNoClickWith &	 8/*Enum	   (bit3:  8)*/) &&  nLine)
																 || (	 !(_iNoClickWith &	64/*ImportEnum (bit6: 64)*/) && !nLine)))
			 || ((eInfo== 9/*INFOMIB_OBJECT_TRAP(9)*/	  ) &&			 !(_iNoClickWith &	32/*ObjectTrap (bit5: 32)*/))
			 || ((eInfo==13/*INFOMIB_SHORTCUT_OBJECT(13)*/) &&			 !(_iNoClickWith & 256/*ShortcutObj(bit8:256)*/))
			 || ((eInfo==14/*INFOMIB_UNKNOWN_VAR(14)*/	  ) &&			 !(_iNoClickWith & 512/*ShortcutObj(bit9:512)*/))
			 || ((eInfo==11/*INFOMIB_TYPE(11)*/ 		  ) &&			 !(_iNoClickWith &	 4/*Type	   (bit2:  4)*/))
			 || ((eInfo== 6/*INFOMIB_MIB(6)*/			  ) &&			 !(_iNoClickWith &	 1/*MibFile    (bit0:  1)*/))
			 || ((eInfo== 7/*INFOMIB_MOD(7)*/			  ) &&			 !(_iNoClickWith &	 2/*MibModule  (bit1:  2)*/))
			 || ( eInfo== 1/*INFODIR_MIB(1)*/			  )
			 || ( eInfo== 2/*INFODIR_MOD_OF_FILE(2)*/	  )
			 || ( eInfo== 3/*INFODIR_MOD_OF_DIR(3)*/	  ) )
}

function nd_ItemTree_GetShortcutVisibleObjectId(ndTree, ItemTree)
{
	var nShortcutObjectId = nd_ItemTree_GetShortcutObjectId(ItemTree);
	if (nShortcutObjectId)
	{
		var ItemTree2 = nd_ItemTree(ndTree, nShortcutObjectId);
		if (nd_ItemTree_nLine(ItemTree2, nShortcutObjectId))
		{
			var nFA = nd_ItemTree_nFA(ItemTree2);
			if (!nd_FA_bHiddenImport(nFA))
				return nShortcutObjectId;
		}
	}
	return 0;
}

function ndSubDrawTree(
	ndTreeName,
	ndTree,
	iNoClickWith,
	bCollapse,
	bShowAccess,
	bShowEnum,
	bTableBorder,
	nOpenItem,
	bExpandItem,
	i,
	b)
{
	var stateBAR = new Array(128); // true if '|'
	var stateDIV = new Array(128); // true if '<DIV>'
	var stateACC = new Array(128); // true if Space for Access
	var openITEM = new Array(128); // index of open items 

	var nL = 0;
	var nLevelStart = 0;
	var nLevelOpen = 0;
	var nExpandOpenItem = 0;
	var bFirstRootItem = i==1;
	if (!bFirstRootItem)
		nL = nLevelStart = ndDynamicTreeGetLeftSide(ndTree, i, stateACC, stateBAR);

	if (nOpenItem)
	{
		if (bExpandItem)
			nExpandOpenItem = nOpenItem;
		nLevelOpen = ndGetParentItems(ndTree, nOpenItem, openITEM);
	}
	var bSpanOld = false;
	for (;i<ndTree.length;i++)
	{
		var ItemTree = nd_ItemTree(ndTree, i);
		var nFA = nd_ItemTree_nFA(ItemTree);
		if (nd_FA_bHiddenImport(nFA))
		{
			// --- Ignore "Hidden Import"
			// --- "Hidden Import" is used with variable of Trap & Notification only
			i = nd_Tree_nNext(ndTree, i) - 1;
			continue;
		}

		var eInfo = nd_FA_eInfo(nFA);
		if (!bShowEnum && (eInfo == 10/*INFOMIB_ENUM(10)*/))
			continue; // Ignore Enum

		var bOpenItem = ((nL < nLevelOpen) && (openITEM[nL] == i)) || (nExpandOpenItem == i);
		var bExpanded = ((i==1) && bCollapse) ? false : (nd_FA_bExpanded(nFA) || bOpenItem);
		var bAlwaysOpen 	= nd_FA_bAlwaysOpen(nFA);
		var bNextOfParent	= nd_FA_bNextOfParent(nFA);
		var bSpaceForAccess = nd_FA_bSpaceForAccess(nFA);
		var bChild			= nd_FA_bChild(nFA);

		if (!bChild && bShowEnum && nd_FA_bChildEnumInt(nFA) )
			bChild = true;
		if (!nd_bDOM)
		{
			b.write('&nbsp;');
			bAlwaysOpen = bExpanded = true;
		}
		// --- Left Side
		for (var j=0; j<nL; j++)
		{
			var width = stateACC[j] ? 23 : 19;
			if (stateBAR[j])
				ndImg(b, stateACC[j] ? '7' : '5', width);
			else
			{
				while(((j+1)<nL) && !stateBAR[j+1])
					width += stateACC[++j] ? 23 : 19;
				b.write('<IMG src="' + g_ndImgPath + '0.gif" align=absmiddle height=16 width=' + width	+ ' alt="">');
			}
		}
		// --- Toc
		var img = bFirstRootItem
				  ? (bNextOfParent ? '4' : '3') 
				  : (bNextOfParent ? '2' : '1');
		bFirstRootItem = false;
		if (!bChild || bAlwaysOpen)
			ndImg(b, img, 19);
		else
			b.write('<A id="' + ndTreeName + ':' + i + ':" onClick="return ndU(this)" onMouseOver="return ndV(this)" onMouseOut="return ndW(this)" HREF="javascript:;"><IMG src="' + g_ndImgPath + img + (bExpanded ? 'm' : 'p') + '.gif" align=absmiddle width=19 height=16 border=0 id=ndIMG' + ndTreeName + i + ' alt=""></A>');
		// --- Access
		if (bShowAccess && bSpaceForAccess)
		{
			var eAccess = nd_FA_eAccess(nFA);
			var eType	= nd_FA_eType(nFA);
			ndImg(b, (eAccess && (eType !=9 /*Table*/) && (eType !=10 /*Entry*/) ) 
					 ? ndN2H(10 + eAccess -1 + (eType == 11 /*VarOfTab*/ ? 6 : 0))
					 : '6', 4);
		}
		// --- Img
		img = ndN2H(nd_FA_nImg(nFA));
		var nShortcutVisibleObjectId = nd_ItemTree_GetShortcutVisibleObjectId(ndTree, ItemTree);
		if (!nShortcutVisibleObjectId)
		{
			if (nd_ItemTree_eInfo(ItemTree) == 3 /* INFODIR_MOD_OF_DIR(3)*/)
				nShortcutVisibleObjectId = i - nd_Tree_nDeltaParent(ndTree, i);
		}
		if (nShortcutVisibleObjectId)
			b.write('<A id="ndSHO:' + ndTreeName + ':' + nShortcutVisibleObjectId + '" onClick="return ndR(this)" onMouseOver="return ndS(this)" onMouseOut="return ndT(this)" HREF="javascript:;"><IMG src="' + g_ndImgPath + img + '.gif" align=absmiddle width=19 height=16 border=0 alt=""></A>');
		else
			ndImg(b, img, 19);
	  
		// --- Name
		var sName = nd_ItemTree_sName(ItemTree);
		var t; // Temp
		switch(eInfo)
		{
		case 8: // INFOMIB_OBJECT(8)
			{
				var nSubId = nd_ItemTree_nSubId(ItemTree);
				//var bHexValue = nd_FA_bHexValue(nFA);
				t = sName + ((sName=='') ? '(' : ' (' ) + nSubId + ')';
			}
			break;
		case 9: // INFOMIB_OBJECT_TRAP(9)
			{
				var nSubId = nd_ItemTree_nSubId(ItemTree);
				//var bHexValue = nd_FA_bHexValue(nFA);
				t = sName + ' [' + nSubId + ']';
			}
			break;
		case 10: // INFOMIB_ENUM(10)
			{
				var nSubId = nd_ItemTree_nSubId(ItemTree);
				//var bHexValue = nd_FA_bHexValue(nFA);
				t = nSubId + ' : ' + sName;  
			}
			break;
		case 0: // INFODIR_DIR(0)
			t = ndText2Html(ndDirName2Text(sName));
			break;
		case 1: // INFODIR_MIB(1)
		case 6: // INFOMIB_MIB(6)
			t = ndText2Html(ndFileName2Text(sName));
			break;
		case 3: // INFODIR_MOD_OF_DIR(3)
			{
				var nModOfFil = nd_i_ItemTree_nParent(i, ItemTree);
				var nFil	  = nd_Tree_nParent(ndTree, nModOfFil);
				var sNameParent = nd_Tree_sName(ndTree, nFil);
				t = sName + ' - ' + ndText2Html(ndFileName2Text(sNameParent));
			}
			break;
		case 13: // INFOMIB_SHORTCUT_OBJECT(13) 
			{
				var nObject = nd_ItemTree_GetShortcutObjectId(ItemTree);
				t = nd_Tree_sName(ndTree, nObject);
			}
			break;
		case 11: // INFOMIB_TYPE(11)
			{
				var sInfo = nd_ItemTree_sInfo(ItemTree);
				if (sInfo)
				{
					t = sName + '&nbsp;&nbsp;' + ndText2Html(sInfo);  
					break;
				}
			}
		default:
			t = sName;
		}
		// --- Href
		if (ndTreeIsClickWith(eInfo, iNoClickWith, nd_ItemTree_nLine(ItemTree)))
		{
			if (ndNS4)
			{
				var th = '\''+ndTreeName + ':' + i + '\'';
				t = '<A ' + 
					((iNoClickWith & 32768) ? '' : 'onClick="return ndX('+th+')" ' ) +
					'onMouseOver="return ndY('+th+')" onMouseOut="return ndZ('+th+')" href="javascript:;">' + t + '</A>';
			}
			else
				t = '<A id="' + ndTreeName + ':' + i +
					((iNoClickWith & 32768) ? '' : '" href="javascript:;" onClick="return ndX(this)') +
					'" onMouseOver="return ndY(this)" onMouseOut="return ndZ(this)">' + t + '</A>';
		}
		else
		if (nd_FA_bVisibleImport(nFA))
		{
			// [*ABC*] : Focus with Import Object (ex: 'iso')
			if (nd_bAcceptAchorFocus)
				t = '<SPAN class=' + (nd_FA_bOld(nFA) ? 'NDD' : 'NDC') + '><A name="' + ndTreeName + ':' + i + '" id="' + ndTreeName + ':' + i + '">' + t + '</A></SPAN>';
			else
				t = '<A name="' + ndTreeName + ':' + i + 'A"></A><SPAN id="' + ndTreeName + ':' + i + '">' + t + '</SPAN>';
		}

		if (nd_FA_bOld(nFA))
		{
			if (!bSpanOld)
			{
				t = '<SPAN class=NDB>' + t;
				bSpanOld = true;
			}
		}
		else
			if (bSpanOld)
			{
				t = '</SPAN>' + t;
				bSpanOld = false;
			}
		b.write(t + (bTableBorder ? '&nbsp;<BR>' : '<BR>'));
		// --- Div
		if (bChild)
		{
			if (!bAlwaysOpen)
			{
				if (nd_bDOM)
				{
					if (bSpanOld) // else BUG with NS
					{
						b.write('</SPAN>');
						bSpanOld = false;
					}
					b.write('<DIV nowrap id=ndDIV' + ndTreeName + i + 
							(bExpanded 
							? '>' 
							: ' style="display:none">'));
				}
				stateDIV[nL] = 1;
			}
			stateACC[nL  ] = bSpaceForAccess;
			stateBAR[nL++] = bNextOfParent;
			stateDIV[nL  ] = 0;
			if (bExpanded || !nd_bDynamicDrawTree || bOpenItem)
				continue;
			i = nd_Tree_nNext(ndTree, i) - 1;
			bNextOfParent = false;
		}
		if (!bNextOfParent)
		{
			for(;;)
			{
				if (nL == nLevelStart)
				{
					// --- End
					if (bSpanOld)
						b.write('</SPAN>');
					return;
				}
				if (stateDIV[--nL])
				{
					if (nd_bDOM)
					{
						if (bSpanOld) // else BUG with NS
						{
							b.write('</SPAN>');
							bSpanOld = false;
						}
						b.write('</DIV>');
					}
					stateDIV[nL] = 0;
				}
				if (stateBAR[nL])
					break;
			}
		}
	}
}


function ndDrawTree(
	_doc,
	_ndTreeName, 
	_ndCallBack,
	_iNoClickWith,
	_bCallPlugLibrary,
	_bCollapse,
	_bShowAccess,
	_bShowEnum,
	_bTableBorder,
	_rgbBGColor,
	_nOpenItem,
	_bExpandItem)
{
	if (!nd_bDOM)
		_bShowEnum = false;
	
	var _ndTree = eval(_ndTreeName);

	eval('i_ndCallBack' 	 + _ndTreeName + ' = _ndCallBack');   // Store _ndCallBack	 in global var
	eval('i_nd_iNoClickWith' + _ndTreeName + ' = _iNoClickWith'); // Store _iNoClickWith in global var
	eval('i_nd_bShowAccess'  + _ndTreeName + ' = _bShowAccess');  // Store _bShowAccess  in global var
	eval('i_nd_bShowEnum'	 + _ndTreeName + ' = _bShowEnum');	  // Store _bShowEnum	 in global var
	eval('i_nd_bTableBorder' + _ndTreeName + ' = _bTableBorder'); // Store _bTableBorder in global var
	// Reset SelectItem
	eval('i_nd_iSelectItem'  + _ndTreeName + ' = 0;'); 

	ndPreLoadImgsOfTree(_ndTree);

	var bIsBuf = ndIsBuf(_doc);
	var d = bIsBuf ? _doc.doc : _doc;
	var b = bIsBuf ? _doc : new NDClassBuf;

	if (d != document)
		if (top.ndOnlineMibDoc) // !!! <SCRIPT... : failed with NS4
		{
			b.write(
				'<SCRIPT language=JavaScript1.2>'
			   +'if (typeof(ndR) == \'undefined\')'
			   +'{'
			   +'	function ndR(o) { return top.ndOnlineMibDoc.ndR(o, document); }\n'
			   +'	function ndS(o) { return top.ndOnlineMibDoc.ndS(o, document); }\n'
			   +'	function ndT(o) { return top.ndOnlineMibDoc.ndT(o, document); }\n'
			   +'	function ndU(o) { return top.ndOnlineMibDoc.ndU(o, document); }\n'
			   +'	function ndV(o) { return top.ndOnlineMibDoc.ndV(o, document); }\n'
			   +'	function ndW(o) { return top.ndOnlineMibDoc.ndW(o, document); }\n'
			   +'	function ndX(o) { return top.ndOnlineMibDoc.ndX(o, self); }\n'
			   +'	function ndY(o) { return top.ndOnlineMibDoc.ndY(o, self); }\n'
			   +'	function ndZ(o) { return top.ndOnlineMibDoc.ndZ(o, self); }\n'
			   +'}'
			   +'</SCRIPT>');
		}

	if (_ndCallBack && _bCallPlugLibrary)
		_ndCallBack.PlugLibrary(b);

	b.write('<TABLE'
				+ ( _rgbBGColor
					? ' bgcolor=' + _rgbBGColor 
					: '')
				+ (_bTableBorder
					? (nd_bDOM
						? ' style="BORDER:black 1px solid"'
						: ' border=1')
					: '')
				+ ' cellPadding=0 cellSpacing=0><TR><TD class=NDA nowrap>');

	ndSubDrawTree(
		_ndTreeName,
		_ndTree,
		_iNoClickWith,
		_bCollapse,
		_bShowAccess,
		_bShowEnum,
		_bTableBorder,
		_nOpenItem,
		_bExpandItem,
		1, // i
		b);
	b.write('</TD></TR></TABLE>');
	if (!bIsBuf)
		_doc.write(b.toString());
}

function ndO_IsSupportFrameRectColor()
{
	// --- IE only, else BUG or not supported
	return (ndIE) && (g_ndColorOptionalRectWithFrame!='');
}

function ndO_WriteFrameBorderStyle(doc)
{
	doc.write(
		  '<style type="text/css">'
		+ 'BODY { margin:2px; overflow-y:auto; overflow-x:auto; '
				+ (ndO_IsSupportFrameRectColor()
				  ? 'border:'+g_ndColorOptionalRectWithFrame+' 1px solid; '
				  : '')
		+ '}'
		+ '</style>');
}

function nd_WriteStyleTree(doc)
{
	doc.write(
		  '<style type="text/css">'
		  /* NetDiscover MIB Tree : 'A' */
		+ '.NDA { COLOR:'+g_ndColorTreeText+'; '+g_ndStyleFontSize+'; '+g_ndStyleFontFamily+' }'
		+ '.NDA A:link	  { COLOR:'+g_ndColorTreeLink+'; TEXT-DECORATION:none }'
		+ '.NDA A:visited { COLOR:'+g_ndColorTreeLink+'; TEXT-DECORATION:none }'
		+ '.NDA A:hover   { COLOR:'+g_ndColorTreeLinkHover+'; TEXT-DECORATION:underline }'
		+ '.NDA A:active  {}'
		  /* NetDiscover MIB Tree : 'A' OLD */
		+ '.NDB { COLOR:'+g_ndColorTreeTextOld+' }'
		+ '.NDB A:link	  { COLOR:'+g_ndColorTreeLinkOld+'; TEXT-DECORATION:none }'
		+ '.NDB A:visited { COLOR:'+g_ndColorTreeLinkOld+'; TEXT-DECORATION:none }'
		+ '.NDB A:hover   { COLOR:'+g_ndColorTreeLinkHover+'; TEXT-DECORATION:underline }'
		+ '.NDB A:active  {}'

 +(nd_bAcceptAchorFocus
   ?''
		+ '.NDC { COLOR:'+g_ndColorTreeText+' }'
		+ '.NDC A:link	  { COLOR:'+g_ndColorTreeText+'; TEXT-DECORATION:none }'
		+ '.NDC A:visited { COLOR:'+g_ndColorTreeText+'; TEXT-DECORATION:none }'
		+ '.NDC A:hover   { COLOR:'+g_ndColorTreeText+'; TEXT-DECORATION:none }'
		+ '.NDC A:active  { COLOR:'+g_ndColorTreeText+'; TEXT-DECORATION:none }'

		+ '.NDD { COLOR:'+g_ndColorTreeTextOld+' }'
		+ '.NDD A:link	  { COLOR:'+g_ndColorTreeTextOld+'; TEXT-DECORATION:none }'
		+ '.NDD A:visited { COLOR:'+g_ndColorTreeTextOld+'; TEXT-DECORATION:none }'
		+ '.NDD A:hover   { COLOR:'+g_ndColorTreeTextOld+'; TEXT-DECORATION:none }'
		+ '.NDD A:active  { COLOR:'+g_ndColorTreeTextOld+'; TEXT-DECORATION:none }'
   :''
  )
		+ '</style>');
}

function ndO_WriteStylePoweredBy(doc)
{
	doc.write(
		  '<style type="text/css">'
		+ '.NDA { COLOR:'+g_ndColorCopyrightText+'; '+g_ndStyleFontSizeCopyright+'; '+g_ndStyleFontFamilyCopyright+' }'
		+ '.NDA A:link	  { COLOR:'+g_ndColorCopyrightLink+'; }'
		+ '.NDA A:visited { COLOR:'+g_ndColorCopyrightLink+'; }'
		+ '.NDA A:hover   { COLOR:'+g_ndColorCopyrightLinkHover+'; }'
		+ '.NDA A:active  {}'
		+ '</style>');
}

function ndO_WriteStyleNav(doc)
{
	doc.write(
		  '<style type="text/css">'
		+ 'A:link	 { COLOR:'+g_ndColorInactiveTabTextLink+'; TEXT-DECORATION:none }'
		+ 'A:visited { COLOR:'+g_ndColorInactiveTabTextLink+'; TEXT-DECORATION:none }'
		+ 'A:hover	 { COLOR:'+g_ndColorInactiveTabTextLinkHover+'; TEXT-DECORATION:none; }'
		+ 'A:active  {}'
		+ '.NDTabActive   { COLOR:'+g_ndColorActiveTabText+'; '+g_ndStyleFontSize+'; '+g_ndStyleFontFamily+'; BACKGROUND-COLOR:' + g_ndColorActiveTabFace + '; FONT-WEIGHT:bold; }'
		+ '.NDTabInactive { COLOR:'+g_ndColorActiveTabText+'; '+g_ndStyleFontSize+'; '+g_ndStyleFontFamily+'; BACKGROUND-COLOR:' + g_ndColorInactiveTabFace + ' }'
		+ '</style>');
}

function ndO_WriteStyleFrameTitle(doc)
{
	doc.write(
		  '<style type="text/css">'
		+ '.NDInput { COLOR:'+g_ndColorImputText+'; '+g_ndStyleFontSize+'; '+g_ndStyleFontFamily+'; BACKGROUND-COLOR:' + g_ndBGColorImput + ' }'
		+ '.NDText	{ COLOR:'+g_ndColorImputLabel +'; '+g_ndStyleFontSize+'; '+g_ndStyleFontFamily+' }'
		+ '.NDTitle { COLOR:'+g_ndColorOptionalTitle+'; '+g_ndStyleFontSizeTitle+'; '+g_ndStyleFontFamilyTitle+' }'
		+ '</style>');
}

function ndDocBegin(doc /* document */, strBegin/*optional*/)
{
	if (typeof strBegin == 'undefined')
		strBegin = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD>';
	var ndBuf = new NDClassBuf;
	ndBuf.write(strBegin);
	ndBuf.doc = doc;
	return ndBuf;
}

function ndDocEnd(doc /* NDClassBuf */, strEnd/*optional*/)
{
	if (typeof strEnd == 'undefined')
		strEnd = '</BODY></HTML>';
	doc.write(strEnd);
	var ndBuf = doc;
	var d = ndBuf.doc;
	var s = ndBuf.toString();
	d.open("text/html", "replace");
	d.write(s);
	d.close();
}

function ndGetScrollBarStyle()
{
	var s = '';
	if (g_ndScrollbarArrowColor)
		s += 'SCROLLBAR-ARROW-COLOR:'	   + g_ndScrollbarArrowColor	  + ';';
	if (g_ndScrollbarBaseColor)
		s += 'SCROLLBAR-BASE-COLOR:'	   + g_ndScrollbarBaseColor 	  + ';';
	if (g_ndScrollbar3dLightColor)
		s += 'SCROLLBAR-3DLIGHT-COLOR:'    + g_ndScrollbar3dLightColor	  + ';';
	if (g_ndScrollbarFaceColor)
		s += 'SCROLLBAR-FACE-COLOR:'	   + g_ndScrollbarFaceColor 	  + ';';
	if (g_ndScrollbarDarkShadowColor)
		s += 'SCROLLBAR-DARKSHADOW-COLOR:' + g_ndScrollbarDarkShadowColor + ';';
	if (g_ndScrollbarHighlightColor)
		s += 'SCROLLBAR-HIGHLIGHT-COLOR:'  + g_ndScrollbarHighlightColor  + ';';
	if (g_ndScrollbarShadowColor)
		s += 'SCROLLBAR-SHADOW-COLOR:'	   + g_ndScrollbarShadowColor	  + ';';
	if (g_ndScrollbarTrackColor)
		s += 'SCROLLBAR-TRACK-COLOR:'	   + g_ndScrollbarTrackColor	  + ';';
	return s;
}

function ndUseScrollBarColor()
{
	return (	ndIE 
			 && (	 (g_ndScrollbarArrowColor	   != '') 
				  || (g_ndScrollbarBaseColor	   != '') 
				  || (g_ndScrollbar3dLightColor    != '') 
				  || (g_ndScrollbarFaceColor	   != '') 
				  || (g_ndScrollbarDarkShadowColor != '') 
				  || (g_ndScrollbarHighlightColor  != '') 
				  || (g_ndScrollbarShadowColor	   != '') 
				  || (g_ndScrollbarTrackColor	   != '') ) );
}

function ndDocBodyWithScrollBarColor(doc, rgb, margin, addOn)
{
	if (ndUseScrollBarColor())
	{
		if (typeof addOn == 'undefined')
			addOn = '';
		addOn += ' style="' + ndGetScrollBarStyle() + '"';
	}
	ndDocBody(doc, rgb, margin, addOn);
}

function ndDocBody(doc, rgb, margin, addOn)
{
	if (typeof margin == 'undefined')
		margin = 0;
	if (typeof addOn == 'undefined')
		addOn = '';
	else
	if (addOn != '')
		addOn = ' ' + addOn;
	doc.write('</HEAD><BODY bgColor=' + rgb + ' text=black topMargin='+margin+' leftMargin='+margin+' marginWidth='+margin+' marginHeight='+margin+addOn+'>');
}

function ndO_GetBGColorOfTree(nNumTree)
{
	switch(nNumTree)
	{
	case 0: return g_ndBGColorFrameDirTree;
	case 1: return g_ndBGColorFrameMibsTree;
	default:return g_ndBGColorFrameMibTree;
	}
}

function ndO_GetDocumentNavTree(nNumTree)
{
	switch(nNumTree)
	{
	case 0: return ndO_GetDocumentNavTree0();
	case 1: return ndO_GetDocumentNavTree1();
	default:return ndO_GetDocumentNavTree2();
	}
}

function ndO_GetTreeName(nNumTree)
{
	switch(nNumTree)
	{
	case 0: return ndO_DirTreeName;
	case 1: return ndO_MIBsTreeName;
	default:return ndO_MibTreeName;
	}
}

function ndO_DrawTree(_nNumTree, _nOpenItem, _bExpandItem)
{
	var _ndTreeName = ndO_GetTreeName(_nNumTree);
	var _ndTree = eval(_ndTreeName);

	var def = defaultStatus
	defaultStatus = nd_szProcessing;
	var doc = ndDocBegin(ndO_GetDocumentNavTree(_nNumTree));
	nd_WriteStyleTree(doc);
	ndO_WriteFrameBorderStyle(doc);
	ndDocBodyWithScrollBarColor(doc, 
		ndO_GetBGColorOfTree(_nNumTree),
		2,
		'onLoad="top.ndOnlineMibDoc.ndO_onLoadTree(document, \'' + _ndTreeName + '\', '+_nOpenItem+')"');
	if (_nNumTree==1)
		ndO_PlugMenuLibrary(doc);
	var _ndCallBack = null;
	if (_nNumTree==2)
		_ndCallBack = g_ndOnlineMibCallBack;
	ndDrawTree(doc, _ndTreeName, _ndCallBack, 64+128 /*iNoClickWith : ImportEnum(bit6:64), ImportOID(bit7:128)*/, true /*bCallPlugLibrary*/, false /*bCollapse*/, g_ndOnlineMIB_bShowAccess, g_ndOnlineMIB_bShowEnum, false /*_bTableBorder*/, null /*_rgbBGColor*/, _nOpenItem, _bExpandItem);
	ndDocEnd(doc);
	defaultStatus = def;
}

function ndO_DrawTreeAndRefreshTab(nNumTree, nOpenItem, bExpandItem)
{
	ndO_DrawTree(nNumTree, nOpenItem, bExpandItem);
	if (!ndO_bRefreshButtonOfTab[nNumTree])
	{
		// Enable 'Refresh' Button
		ndO_bRefreshButtonOfTab[nNumTree] = true;
		if (ndO_bDynamicFrame || ndO_bIFrame)
		{
			if (nNumTree == ndO_nNumActiveTab)
				ndO_RefreshNavBarTree_MultiTab(nNumTree/*nNumTab*/);
		}
		else
			ndO_RefreshNavBarTree_SimpleTab(nNumTree/*nNumTab*/);
	}
	if (nNumTree==2) // MibTree
	{
		ndO_bMibTreeDownloading = false;
		// --- Form Search
		if (	ndO_winSearch && !ndO_winSearch.closed
			 && ndO_bFormSearch_WaitMibTreeDownload )
		{
			ndO_bFormSearch_WaitMibTreeDownload = false;
			ndO_BeginStartSearch();
		}
	}
}

function ndO_InitDocumentAndDrawNumTree(nNumTree, nOpenItem, bExpandItem)
{
	if (ndO_bRefreshButtonOfTab[nNumTree])
	{
		// Disable 'Refresh' Button
		ndO_bRefreshButtonOfTab[nNumTree] = false;
		if (ndO_bDynamicFrame || ndO_bIFrame)
		{
			if (nNumTree == ndO_nNumActiveTab)
				ndO_RefreshNavBarTree_MultiTab(nNumTree/*nNumTab*/);
		}
		else
			ndO_RefreshNavBarTree_SimpleTab(nNumTree/*nNumTab*/);
	}

	ndO_InitDocumentColorAndWaitMsg(ndO_GetDocumentNavTree(nNumTree), ndO_GetBGColorOfTree(nNumTree), nd_szProcessing);
	// use setTimeout else szProcessing not display
	setTimeout('ndO_DrawTreeAndRefreshTab('+nNumTree+', '+nOpenItem+', '+bExpandItem+')', 0);
}

function ndMib2Web_WriteStyle()
{
	nd_WriteStyleTree(document);
}

function ndMib2Web_DrawMibFileTree(
	ndTreeName, 
	bShowAccess,  // DEFAULT : g_ndMib2Web_DrawMibFileTree_bShowAccess
	bShowEnum,	  // DEFAULT : g_ndMib2Web_DrawMibFileTree_bShowEnum
	bTableBorder, // DEFAULT : g_ndMib2Web_DrawMibFileTree_bTableBorder
	rgbBGColor)   // DEFAULT : g_ndMib2Web_DrawMibFileTree_rgbBGColor
{
	if (typeof bShowAccess	== 'undefined')  bShowAccess  = g_ndMib2Web_DrawMibFileTree_bShowAccess;
	if (typeof bShowEnum	== 'undefined')  bShowEnum	  = g_ndMib2Web_DrawMibFileTree_bShowEnum;
	if (typeof bTableBorder == 'undefined')  bTableBorder = g_ndMib2Web_DrawMibFileTree_bTableBorder;
	if (typeof rgbBGColor	== 'undefined')  rgbBGColor   = g_ndMib2Web_DrawMibFileTree_rgbBGColor;

	var def = defaultStatus;
	defaultStatus = nd_szProcessing;
	var _ndCallBack = g_ndOnlineMibCallBack;
	ndDrawTree(document, ndTreeName, _ndCallBack, 64+128 /*iNoClickWith : ImportEnum(bit6:64), ImportOID(bit7:128)*/, true /*bCallPlugLibrary*/, false /*bCollapse*/, bShowAccess, bShowEnum, bTableBorder, rgbBGColor, 0 /*nOpenItem*/, false /*bExpandItem*/);
	defaultStatus = def;
}

function ndMib2Web_DrawMibFileTreeStep(
	step,
	ndTreeName, 
	bShowAccess,
	bShowEnum,
	bTableBorder,
	rgbBGColor)
{
	if (ndMIBFileCanDrawImmediately())
	{
		if (step == 1)
			ndMib2Web_DrawMibFileTree(
				ndTreeName,
				bShowAccess,
				bShowEnum,
				bTableBorder,
				rgbBGColor);
	}
	else
	{
		// --- Netscape, Mozilla/Phoenix ...
		var _ndCallBack = g_ndOnlineMibCallBack;
		if (step == 1)
		{
			_ndCallBack.PlugLibrary(document);
			document.write('<SPAN id=ndMibFileTreeSpan><FONT style="COLOR:'+g_ndColorMessage+'; '+g_ndStyleFontSizeMessage+'; '+g_ndStyleFontFamilyMessage+'"><B>' + nd_szDownloading + '</B><BR>' + nd_szPleaseWait + '</FONT></SPAN>');
		}
		else
		{
			// --- function ndMib2Web_DrawMibFileTree()
			// =>
			if (typeof bShowAccess	== 'undefined')  bShowAccess  = g_ndMib2Web_DrawMibFileTree_bShowAccess;
			if (typeof bShowEnum	== 'undefined')  bShowEnum	  = g_ndMib2Web_DrawMibFileTree_bShowEnum;
			if (typeof bTableBorder == 'undefined')  bTableBorder = g_ndMib2Web_DrawMibFileTree_bTableBorder;
			if (typeof rgbBGColor	== 'undefined')  rgbBGColor   = g_ndMib2Web_DrawMibFileTree_rgbBGColor;

			var def = defaultStatus;
			defaultStatus = nd_szProcessing;

			var b = new NDClassBuf;
			ndDrawTree(/*document*/ b, ndTreeName, _ndCallBack, 64+128 /*iNoClickWith : ImportEnum(bit6:64), ImportOID(bit7:128)*/, false /*bCallPlugLibrary*/, false /*bCollapse*/, bShowAccess, bShowEnum, bTableBorder, rgbBGColor, 0 /*nOpenItem*/, false /*bExpandItem*/);
			ndInsertHTML(ndGetElement(document, 'ndMibFileTreeSpan'), b.toString());
			defaultStatus = def;
		}
	}
}

function ndMib2Web_DrawTree(
	ndTreeName, 
	ndCallBack, 	  // DEFAULT : new NDClassCallBack();
	iNoClickWith,	  // DEFAULT : 255 - MibFile(bit0:1), MibModule(bit1:2), Type(bit2:4), Enum(bit3:8), Object(bit4:16), ObjectTrap(bit5:32), ImportEnum(bit6:64), ImportOID(bit7:128), DisableClick[MouveOver & MouseOut Only](bit16:65536),
	bCallPlugLibrary, // DEFAULT : true; 
	bCollapse,		  // DEFAULT : false
	bShowAccess,	  // DEFAULT : g_ndMib2Web_DrawTree_bShowAccess
	bShowEnum,		  // DEFAULT : g_ndMib2Web_DrawTree_bShowEnum
	bTableBorder,	  // DEFAULT : g_ndMib2Web_DrawTree_bTableBorder
	rgbBGColor) 	  // DEFAULT : g_ndMib2Web_DrawTree_rgbBGColor
{
	if (typeof ndCallBack		== 'undefined')  ndCallBack 	  = new NDClassCallBack();
	if (typeof iNoClickWith 	== 'undefined')  iNoClickWith	  = 255; // No Click
	if (typeof bCallPlugLibrary == 'undefined')  bCallPlugLibrary = true;
	if (typeof bCollapse		== 'undefined')  bCollapse		  = false;
	if (typeof bShowAccess		== 'undefined')  bShowAccess	  = g_ndMib2Web_DrawTree_bShowAccess;
	if (typeof bShowEnum		== 'undefined')  bShowEnum		  = g_ndMib2Web_DrawTree_bShowEnum;
	if (typeof bTableBorder 	== 'undefined')  bTableBorder	  = g_ndMib2Web_DrawTree_bTableBorder;
	if (typeof rgbBGColor		== 'undefined')  rgbBGColor 	  = g_ndMib2Web_DrawTree_rgbBGColor;

	var def = defaultStatus;
	defaultStatus = nd_szProcessing;
	ndDrawTree(document, ndTreeName, ndCallBack, iNoClickWith, bCallPlugLibrary, bCollapse, bShowAccess, bShowEnum, bTableBorder, rgbBGColor, 0 /*nOpenItem*/, false /*bExpandItem*/);
	defaultStatus = def;
}

function ndFrameSrc()
{
	return nd_bFrameNoSrc ? '' : 'src="' + g_ndImgPath + '0.gif" ';
}

function ndO_onUnload()
{
	if (typeof ndO_winMibLegend != 'undefined')
	{
		if (ndO_winMibLegend && !ndO_winMibLegend.closed)
			ndO_winMibLegend.close();
	}
	if (typeof ndO_winDownload != 'undefined')
	{
		if (ndO_winDownload && !ndO_winDownload.closed)
			ndO_winDownload.close();
	}
	if (typeof ndO_winSearch != 'undefined')
	{
		if (ndO_winSearch && !ndO_winSearch.closed)
			ndO_winSearch.close();
	}
}

function ndO_WriteFrameSet(doc)
{
	var szFrameBorder = ndO_IsSupportFrameRectColor() ? 'no' : 'yes';
	var szRowOfNavBar = ndO_GetFramesetRowOfNavBar();
	doc.write(
		'<FRAMESET id="ndFrameSetRoot" name="ndFrameSetRoot" rows="' + ndO_FrameFmtRootRow(true) + '" border=0 frameSpacing='+(ndOpera?1:0)+' frameBorder=no onUnload="ndO_onUnload()" onLoad="ndO_onLoadFrameSet()">'
	   +' <FRAME ' + ndFrameSrc() + 'id="ndFrameTitle" name="ndFrameTitle" marginWidth=0 marginHeight=0 frameBorder=no scrolling=no>'
	   +' <FRAMESET id="ndFrameSetH" name="ndFrameSetH" cols="'+ndO_ndFrameSetHCols+',*" border='+g_ndFrameBorder+' frameSpacing='+g_ndFrameSpacing+' frameBorder=yes borderColor='+g_ndColorSplitter+'>'
+(ndO_bIFrame
 ?''
	   +'  <FRAMESET id="ndFrameSetNav" name="ndFrameSetNav" rows="' + szRowOfNavBar + '*" border=0 frameSpacing=0 frameBorder=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavBar"	name="ndFrameNavBar"   marginWidth=0 marginHeight=0 frameBorder=no scrolling=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavTree"	name="ndFrameNavTree"  marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=no>'
	   +'  </FRAMESET>'
 :''
  +(ndO_bDynamicFrame
   ?''
	   +'  <FRAMESET id="ndFrameSetNav" name="ndFrameSetNav" rows="' + szRowOfNavBar + ndO_GetFramesetRowOfDynamicFrame(ndO_nNumActiveTab) + '" border=0 frameSpacing=0 frameBorder=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavBar"	name="ndFrameNavBar"   marginWidth=0 marginHeight=0 frameBorder=no scrolling=no>'
	 +(ndO_bDirTree
	 ?''
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavTree0" name="ndFrameNavTree0" marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=auto>'
	 :''
	 )
	 +(ndO_bMIBsTree
	 ?''
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavTree1" name="ndFrameNavTree1" marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=auto>'
	 :''
	 )
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavTree2" name="ndFrameNavTree2" marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=auto>'
	   +'  </FRAMESET>'
   :'' 
	+(ndO_bDirTree
	 ?''
	   +'  <FRAMESET rows="' + szRowOfNavBar + '*" border=0 frameSpacing=0 frameBorder=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavBar0"	 name="ndFrameNavBar0"	 marginWidth=0 marginHeight=0 frameBorder=no scrolling=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavTree0"  name="ndFrameNavTree0"  marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=auto>'
	   +'  </FRAMESET>'
	 :'' 
	 )
	   +'  <FRAMESET rows="' + szRowOfNavBar + '*" border=0 frameSpacing=0 frameBorder=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavBar2"	 name="ndFrameNavBar2"	 marginWidth=0 marginHeight=0 frameBorder=no scrolling=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameNavTree2"  name="ndFrameNavTree2"  marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=auto>'
	   +'  </FRAMESET>'
   )
 )
	   +'  <FRAMESET rows="' + szRowOfNavBar + '*" border=0 frameSpacing=0 frameBorder=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameContentBar"	name="ndFrameContentBar"   marginWidth=0 marginHeight=0 frameBorder=no scrolling=no>'
	   +'	<FRAME ' + ndFrameSrc() + 'id="ndFrameContentFile"	name="ndFrameContentFile"  marginWidth=0 marginHeight=0 frameBorder='+szFrameBorder+' scrolling=auto>'
	   +'  </FRAMESET>'
	   +' </FRAMESET>'
	   +' <FRAME ' + ndFrameSrc() + 'id="ndFramePoweredBy" name="ndFramePoweredBy" marginWidth=0 marginHeight=0 frameBorder=no scrolling=no noResize>'
	   +'</FRAMESET>'
	   +'</HTML>');
}

function ndNavTabLeft(bActiveTab, h /*Highlight Color*/)
{
	// Face
	var f = bActiveTab 
			? g_ndColorActiveTabFace 
			: g_ndColorInactiveTabFace;
	return ''
	   +'<TABLE cellSpacing=0 cellPadding=0 border=0>'
	   +  '<TR>'
	   +   '<TD colSpan=2><IMG src="' + g_ndImgPath + '0.gif" border=0 width=2 height=1></TD>'
	   +  '</TR>'
	   +  '<TR>'
	   +   '<TD><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
	   +   '<TD bgcolor='+h+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
	   +  '</TR>'
	   +  '<TR>'
	   +   '<TD bgcolor='+h+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height='+(bActiveTab?17:15)+'></TD>'
	   +   '<TD bgcolor='+f+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height='+(bActiveTab?17:15)+'></TD>'
	   +  '</TR>'
	   +'</TABLE>';
}

function ndNavTabRight(bActiveTab)
{
	// Shadow
	var s = bActiveTab 
			? g_ndColorActiveTabShadow
			: g_ndColorInactiveTabShadow;
	// DarkShadow
	var d = bActiveTab 
			? g_ndColorActiveTabDarkShadow
			: g_ndColorInactiveTabDarkShadow;
	return ''
	   +'<TABLE cellSpacing=0 cellPadding=0 border=0>'
	   +  '<TR>'
	   +   '<TD colSpan=2><IMG src="' + g_ndImgPath + '0.gif" border=0 width=2 height=1></TD>'
	   +  '</TR>'
	   +  '<TR>'
	   +   '<TD bgcolor='+d+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
	   +   '<TD><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
	   +  '</TR>'
	   +  '<TR>'
	   +   '<TD bgcolor='+s+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height='+(bActiveTab?17:15)+'></TD>'
	   +   '<TD bgcolor='+d+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height='+(bActiveTab?17:15)+'></TD>'
	   +  '</TR>'
	   +'</TABLE>';
}

function ndNavTab(txt, sta, widthImg, heightImg, img, bActiveTab, nNumTab, bFirstTab)
{
	var h = bActiveTab 
			? g_ndColorActiveTabHighlight
			: g_ndColorInactiveTabHighlight;
	return ''
	   +'<TABLE cellSpacing=0 cellPadding=0 border=0>'
	   +  '<TR>'
	   +   (bFirstTab ? '<TD rowSpan=2><IMG src="' + g_ndImgPath + '0.gif" border=0 width=2 height=1></TD>' : '')
	   +   '<TD vAlign=top align=right rowSpan=2>'+ndNavTabLeft(bActiveTab, h)+'</TD>'
	   +   '<TD vAlign=bottom height=1 bgcolor='+h+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
	   +   '<TD vAlign=top align=left rowSpan=2>'+ndNavTabRight(bActiveTab)+'</TD>'
	   +  '</TR>'
	   +  '<TR>'
	   +   '<TD nowrap class=' + (bActiveTab ? 'NDTabActive' : 'NDTabInactive') + ' align=middle>'
			 + (bActiveTab ? '' : '<A href="javascript:;" onClick="return parent.ndO_onClickActiveTab(' + nNumTab + ', true);" onMouseOver="return parent.nd_onMouseOver_SetStatus(\'' + sta + '\');" onMouseOut="parent.nd_onMouseOut_SetDefaultStatus();">')
			 + '&nbsp;<IMG src="' + g_ndImgPath + img + '.gif" border=0 width='+widthImg+' height='+heightImg+' align=top>&nbsp;'
			 + txt + '&nbsp;'
			 + (bActiveTab ? '' : '</A>')
			 + '</TD>'
	   +  '</TR>'
	   +'</TABLE>';
}

function nd_onMouseOver_SetStatus(msg)
{
	status = msg;
	return nd_onMouseOverRet();
}

function nd_onMouseOut_SetDefaultStatus()
{
	status = defaultStatus;
	return nd_onMouseOutRet();
}

function ndO_GetXFrameNavTree(nNumTab)
{
	switch(nNumTab)
	{
	case 0:  return ndO_bIFrame ? ndWindowIFrameNavTree0 : ndFrameNavTree0;
	case 1:  return ndO_bIFrame ? ndWindowIFrameNavTree1 : ndFrameNavTree1;
	default: return ndO_bIFrame ? ndWindowIFrameNavTree2 : ndFrameNavTree2;
	}
}

function ndO_PrintFrame(frame)
{
	frame.focus();
	frame.print();
}

function ndO_DrawNavBarTree_MultiTab(bMibTree, nNumTab, bAdd_onLoad)
{
	ndO_SubDrawNavBarTree_MultiTab(
		ndFrameNavBar, 
		ndO_bDirTree,	// bTab0_DirTree 
		ndO_bMIBsTree,	// bTab1_MIBsTree, 
		bMibTree,		// bTab2_MibTree, 
		nNumTab,
		bAdd_onLoad);
}

function ndO_RefreshNavBarTree_MultiTab(nNumTab)
{
	ndO_DrawNavBarTree_MultiTab(ndO_szLastMibPathFileName!='', nNumTab, false /*bAdd_onLoad*/);
}

function ndO_RefreshNavBarTree_SimpleTab(nNumTab)
{
	ndO_DrawNavBarTree_SimpleTab(eval("ndFrameNavBar"+nNumTab), nNumTab);
}

function ndO_ActiveTab(nNumTab, bUser)
{
	if (ndO_nNumActiveTab == 1/*Tab1_MIBsTree*/)
		ndO_MIBsTreeCloseMenu(true/*bForceClose*/); // Hide Menu

	if (ndO_nNumActiveTab != nNumTab)
	{
		ndO_nNumActiveTab = nNumTab;
		ndO_RefreshNavBarTree_MultiTab(nNumTab);

		if (ndO_bIFrame)
		{
			if (ndO_bDirTree)
				ndIFrameNavTree0.style.width = (nNumTab==0) ? '100%' : '0%';

			if (ndO_bMIBsTree)
				ndIFrameNavTree1.style.width = (nNumTab==1) ? '100%' : '0%';

				ndIFrameNavTree2.style.width = (nNumTab==2) ? '100%' : '0%';
		}
		else
			ndFrameSetNav.rows = ndO_GetFramesetRowOfNavBar() + ndO_GetFramesetRowOfDynamicFrame(nNumTab);

		if (bUser)
		{
			var frame = ndO_GetXFrameNavTree(nNumTab);
			frame.focus();
		}
	}
}

function ndO_onClickActiveTab(nNumTab, bUser)
{
	ndO_ActiveTab(nNumTab, bUser);
	return nd_onClickContinue();
}

function ndO_RenameImgBtn(img, name)
{
	var s = img.src;
	var l = s.length;
	var i = 4; 
	if (l>8)
		switch(s.substr(l-8))
		{
		case 'Over.gif':
		case 'Down.gif':
			i = 8;
		}
	var n = s.substr(0, l-i) + name;
	if (n!=s)
		img.src = n;
}

function ndO_BtnMouseOver(img, msg)
{
	ndO_RenameImgBtn(img, 'Over.gif')
	status = msg;
	return nd_onMouseOverRet();
}

function ndO_BtnMouseDown(img)
{
	ndO_RenameImgBtn(img, 'Down.gif')
	status = defaultStatus;
	return true;
}

function ndO_BtnMouseOut(img)
{
	ndO_RenameImgBtn(img, '.gif')
	status = defaultStatus;
	return nd_onMouseOutRet();
}

function ndO_PrintFileMouseOver(img)
{
	return ndO_BtnMouseOver(img, nd_szPrintMibFile);
}

function ndO_PrintMouseOver(img, nNumTab)
{
	if (typeof nNumTab == 'undefined')
		nNumTab = ndO_nNumActiveTab;
	var msg;
	switch(nNumTab)
	{
	case 0:  msg = nd_szPrintFolders;  break;
	case 1:  msg = nd_szPrintMibsTree; break;
	default: msg = nd_szPrintMibTree;
	}
	return ndO_BtnMouseOver(img, msg);
}

function ndO_PrintFileClick(img)
{
	ndO_PrintFrame(ndFrameContentFile);
	return nd_onClickContinue();
}

function ndO_PrintTreeClick(img, nNumTab)
{
	if (typeof nNumTab == 'undefined')
		nNumTab = ndO_nNumActiveTab;
	var frame = ndO_GetXFrameNavTree(nNumTab);
	ndO_PrintFrame(frame);
	return nd_onClickContinue();
}

function ndO_BtnFrameLeftClick(img)
{
	var t = ndFrameSetH.cols.split(',');
	var cols;
	if (t[0] != 0)
	{
		ndO_szFrameSetHVal = '' + t[0];
		cols = '0';
	}
	else
		cols = ndO_szFrameSetHVal;
	cols += ',' + t[1];
	ndFrameSetH.cols = cols;
	return nd_onClickContinue();
}

function ndO_BtnFrameRightClick(img)
{
	var t = ndFrameSetH.cols.split(',');
	var cols;
	if (t[1] != 0)
	{
		ndO_szFrameSetHVal = '' + t[1];
		cols = '0';
	}
	else
		cols = ndO_szFrameSetHVal;
	cols = t[0] + ',' + cols;
	ndFrameSetH.cols = cols;
	return nd_onClickContinue();
}

function ndO_BtnFrameTopClick(img)
{
	var bShowTop = ndFrameSetRoot.rows.split(',')[0] == '0';
	ndFrameSetRoot.rows = ndO_FrameFmtRootRow(bShowTop);
	return nd_onClickContinue();
}

function ndO_BtnCopyClick(img, input)
{
	window.clipboardData.setData('Text', input.value); // IE 5+ only
	return nd_onClickContinue();
}

function ndO_BtnLegendClick(img)
{
	if (ndO_winMibLegend && !ndO_winMibLegend.closed)
		ndO_winMibLegend.focus();
	else
	{
		var win = ndOpenWindow("", "ndMibLegend", 480, 444, false, "dependent,resizable=0")
		if (win && !win.closed)
		{
			ndO_winMibLegend = win;
			var doc = ndDocBegin(win.document);
			doc.write('<TITLE>' + nd_szTitleLegend + '</TITLE>');
			ndDocBody(doc, g_ndBGColorWindowLegend);
			doc.write(
				'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
			   +'<TR>'
			   +'<TD vAlign=middle align=middle><A href="javascript:close()"><IMG width=480 height=444 src="' + g_ndImgPath + 'Legend.gif" border=0 alt=""></A></TD>'
			   +'</TR>'
			   +'</TABLE>');
			ndDocEnd(doc);
		}
	}
	return nd_onClickContinue();
}

function ndO_BtnSearchClick(img)
{
	ndO_bFormSearch_WaitMIBsTreeDownload = false;
	ndO_bFormSearch_WaitMibTreeDownload  = false;

	if (ndO_winSearch && !ndO_winSearch.closed)
		ndO_winSearch.focus();
	else
	{
		if (!ndO_szSearchWindowName)
		{
			var milliseconde = (new Date()).getTime();
			ndO_szSearchWindowName = "ndSearch" + milliseconde;
		}
		var win = ndOpenWindow("", ndO_szSearchWindowName, g_ndWidthWindowSearch, g_ndHeightWindowSearch, false, "dependent")
		if (win && !win.closed)
		{
			if (ndO_nSeachRadioValue === '')
				ndO_nSeachRadioValue = ndO_nNumActiveTab;
/*		ndO_bMibTreeLoad  = true;
		ndO_bMIBsTreeLoad = true;
*/
			ndO_frameSearchResult = null;

			ndO_winSearch = win;
			var doc = ndDocBegin(win.document);

			doc.write(
				'<TITLE>' + nd_szTitleSearch + '</TITLE>'
			   +'</HEAD>'
				+ '<style type="text/css">'
				+ '.NDInput  { COLOR:'+g_ndColorSearchImputText+'; '+g_ndStyleFontSizeSearchText+'; '+g_ndStyleFontFamilySearch+'; BACKGROUND-COLOR:' + g_ndBGColorSearchImput + ' }'
				+ '.NDButton { '+g_ndStyleFontSizeSearchText+'; '+g_ndStyleFontFamilySearch+'; }'
				+ 'TD		 { COLOR:'+g_ndColorSearchText+'; '+g_ndStyleFontSizeSearchText+'; '+g_ndStyleFontFamilySearch+'}'
				+ '</style>');
			ndDocBody(doc, g_ndBGColorWindowSearch, g_ndBorderWindowSearch, 
				'onLoad="if (top.opener.top.ndOnlineMibDoc) top.opener.top.ndOnlineMibDoc.ndO_onLoadSearch(document.forms[0], ndFrameResult)"'
			   +'onUnload="if (top.opener && !top.opener.closed && top.opener.top.ndOnlineMibDoc) top.opener.top.ndOnlineMibDoc.ndO_onUnloadSearch(document.forms[0])"');
			doc.write(
				'<TABLE width="100%" height="100%" cellSpacing=0 cellPadding=0 border=0>'
			   +'<TR><TD vAlign=top align=middle>'
				  +'<TABLE cellSpacing=0 cellPadding=0 border=0>'
				   +'<TR>'
					+'<TD nowrap>'
					  +nd_szFindWhat+'&nbsp;'
					+'</TD>'
					+'<TD>'
					 +'<FORM action="javascript:top.opener.top.ndOnlineMibDoc.ndO_ActionFormSearch(document.forms[0], self);">'
					 +'<INPUT class=NDInput disabled=true type="text" name="Imput" value="" size="30" maxlength="2048">&nbsp;'
					+'</TD>'
					+'<TD>'
					 +'<INPUT class=NDButton disabled=true type="BUTTON" name="ButtonSearch" value="'+nd_szSearchButton+'" onClick="return top.opener.top.ndOnlineMibDoc.ndO_onClickSearch(document.forms[0], self);">'
					+'</TD>'
				   +'</TR>'
		+((ndO_bDirTree || ndO_bMIBsTree)
		?''
				   +'<TR><TD height=2><TD></TR>'
				   +'<TR>'
					+'<TD nowrap align=right>'
					 +nd_szIn+'&nbsp;'
					+'</TD>'
					+'<TD>'
					 +'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
					  +'<TR>'
			+(ndO_bDirTree
			?''
					   +'<TD align=middle>'
					   +'<INPUT type="RADIO" disabled=true name="Radio" id="Radio1"><IMG src="' + g_ndImgPath + 'TabFolder.gif" align=absmiddle width=14 height=14 alt="">'
					   +'</TD>'
			:'' 
			)
			+(ndO_bMIBsTree
			?''
					   +'<TD align=middle>'
						+'<INPUT type="RADIO" disabled=true name="Radio" id="Radio2"><IMG src="' + g_ndImgPath + 'TabMIBsTree.gif" align=absmiddle width=14 height=14 alt="">'
					   +'</TD>'
			:'' 
			)
					   +'<TD align=middle>'
						+'<INPUT type="RADIO" disabled=true name="Radio" id="Radio3"><IMG src="' + g_ndImgPath + 'TabMIBTree.gif" align=absmiddle width=16 height=16 alt="">'
					   +'</TD>'
					   +'<TD>&nbsp;</TD>'
					  +'</TR>'
					 +'</TABLE>'
					+'</TD>'
				   +'</TR>'
		:'' 
		)
				   +'<TR><TD height=4><TD></TR>'
				   +'<TR>'
					+'<TD align=right><INPUT disabled=true type="CHECKBOX" name="CheckBox1"></TD>'
					+'<TD nowrap>'+nd_szMatchWord+'</TD>'
					+'<TD vAlign=bottom align=middle rowspan=3>'
					+'<INPUT class=NDButton type="BUTTON" name="ButtonCancel" value="'+nd_szCancelButton+'" onClick="return top.opener.top.ndOnlineMibDoc.ndO_onClickCancelSearch(top);">'
					+'</TD>'
				   +'</TR>'
				   +'<TR>'
					+'<TD align=right><INPUT disabled=true type="CHECKBOX" name="CheckBox2"></TD>'
					+'<TD nowrap>'+nd_szMatchCasse+'</TD>'
				   +'</TR>'
				   +'<TR>'
					+'<TD align=right><INPUT disabled=true type="CHECKBOX" name="CheckBox3" onClick="return top.opener.top.ndOnlineMibDoc.ndO_onClickRegularExpression(document.forms[0])"></TD>'
					+'<TD nowrap>'+nd_szRegularExpression+'</TD>'
				   +'</TR>'
				  +'</TABLE>'
			   +'</TD></TR>'
			   +'<TR><TD height=6>'
			   +'</TD></TR>'
			   +'<TR><TD width="100%" height="100%">'
				   +'<TABLE width="100%" height="100%" cellSpacing=0 cellPadding=0 style="BORDER:black 1px solid">'
				   +'<TR><TD>'
						+'<IFRAME ' + ndFrameSrc() + 'name="ndFrameResult" id="ndFrameResult" border=0px width="100%" height="100%" marginwidth=0 marginheight=0 hspace=0 vspace=0 frameborder=0 scrolling=auto></IFRAME>'
				   +'</TD></TR>'
				   +'</TABLE>'
			   +'</TD></TR>'
			   +'</TABLE>'
			   +(ndOpera || ndIE ? '' : '<NOBR></FORM>')
			   +'</HTML>');
			ndDocEnd(doc);
		}
	}
	return nd_onClickContinue();
}

function ndO_onClickCancelSearch(window)
{
//	ndO_bFormSearch_WaitMIBsTreeDownload = false;
//	ndO_bFormSearch_WaitMibTreeDownload  = false;
//	ndO_winSearch = false;
//	ndO_formSearch = null;

	window.close();
	return nd_onClickContinue();
}


function ndO_onClickRegularExpression(form)
{
	var bChecked = form.CheckBox3.checked;
	if (bChecked)
	{
		ndO_bSeachCheckBox1Value = form.CheckBox1.checked;
		form.CheckBox1.checked = false;
	}
	else
	{
		form.CheckBox1.checked = ndO_bSeachCheckBox1Value;
	}
	form.CheckBox1.disabled = bChecked;
	return true; // Don't stop
}

function ndO_onLoadSearch(form, frameResult)
{
	ndO_frameSearchResult = frameResult;

	if (!form.Imput.value)
		form.Imput.value = ndO_szSeachImputValue;

	switch(ndO_nSeachRadioValue)
	{
	case '': break;
	case  0/*  DirTree */: if (form.Radio1) form.Radio1.checked = true; break;
	case  1/*  MIBsTree*/: if (form.Radio2) form.Radio2.checked = true; break;
	default/*2 MibTree */: if (form.Radio3) form.Radio3.checked = true; 
	}

	if (!ndO_bSeachCheckBox3Value)
	{
		form.CheckBox1.disabled = false;
		form.CheckBox1.checked = ndO_bSeachCheckBox1Value;
	}

	form.CheckBox2.checked = ndO_bSeachCheckBox2Value;
	form.CheckBox3.checked = ndO_bSeachCheckBox3Value;

	ndO_InitSearchResultMsg(nd_szSearchBegin, g_ndBGColorSearchResultDefault);

	form.ButtonSearch.disabled = false;
	form.Imput.disabled = false;
	if (form.Radio1) form.Radio1.disabled = false;
	if (form.Radio2) form.Radio2.disabled = false;
	if (form.Radio3) form.Radio3.disabled = false;
	form.CheckBox2.disabled = false;
	form.CheckBox3.disabled = false;

	form.Imput.focus();
}

function ndO_onUnloadSearch(form)
{
	ndO_ReadSearchForm(form);
}

function ndO_ReadSearchForm(form)
{
	ndO_bSeachClear = false;
	ndO_szSeachImputValue = form.Imput.value;
	ndO_bSeachCheckBox2Value = form.CheckBox2.checked;
	ndO_bSeachCheckBox3Value = form.CheckBox3.checked;
	if (!ndO_bSeachCheckBox3Value)
		ndO_bSeachCheckBox1Value = form.CheckBox1.checked;
	if (form.Radio1 && form.Radio1.checked) ndO_nSeachRadioValue = 0;/*DirTree*/  else
	if (form.Radio2 && form.Radio2.checked) ndO_nSeachRadioValue = 1;/*MIBsTree*/ else
											ndO_nSeachRadioValue = 2;/*MibTree*/
}

function ndO_ActionFormSearch(form, window)
{
	ndO_onClickSearch(form, window);
	return ; // <- Empty
}

function ndO_onClickSearch(form, window)
{
	ndO_ReadSearchForm(form);
	if (!ndO_szSeachImputValue)
	{
		ndO_InitSearchResultMsg(nd_szSearchBegin, g_ndBGColorSearchResultDefault);
		form.Imput.focus();
	}
	else
	{
		if (ndO_bSeachCheckBox3Value)
		{
			try
			{
				if (	(ndO_nSeachRadioValue!=0)
					 && (ndO_szSeachImputValue.indexOf('.')!=-1) )
				{
					var a = ndO_szSeachImputValue.split('.');
					for(var i=0; i<a.length; i++)
						if (a[i])
							new RegExp(a[i]);
				}
				else
					new RegExp(ndO_szSeachImputValue);
			}
			catch(error)
			{
				// error.name	 --> 'RegExpError'
				// error.message --> 'Unexpected quantifier'
				ndO_InitSearchResultMsg(nd_szInvalidRegExp, g_ndBGColorSearchResultDefault, g_ndColorSearchError);
				form.Imput.focus();
				return nd_onClickContinue();
			}
		}
/*
		if (	(ndO_nSeachRadioValue!=0)
			 && !ndO_bSeachCheckBox3Value) // !Regular expression
		{
			if (ndO_szSeachImputValue.indexOf('..')!=-1)
			{
				ndO_InitSearchResultMsg(nd_szInvalidExp, g_ndBGColorSearchResultDefault, g_ndColorSearchError);
				form.Imput.focus();
				return nd_onClickContinue();
			}
		}
*/
		ndO_formSearch = form;

		if (	(ndO_nSeachRadioValue==1) // MIBsTree
			 && !ndO_GetMIBsTree())
		{
			ndO_bFormSearch_WaitMIBsTreeDownload = true;
			if (!ndO_bMIBsTreeDownloading)
			{
				// --- Start - Downloading
				ndO_StartMIBsTreeDownload()
			}
			else
			{
				// --- Downloading in progress
				ndO_InitSearchResultMIBsTreeDownloadingMsg();
			}
			return nd_onClickContinue();
		}

		if (ndO_nSeachRadioValue==2) // MibTree
		{
			if (ndO_bMibTreeDownloading)
			{
				// --- Downloading in progress
				ndO_bFormSearch_WaitMibTreeDownload = true;
				ndO_InitSearchResultMibTreeDownloadingMsg();
				return nd_onClickContinue();
			}
			if (!ndO_GetMibTree())
			{
				// --- No MIB
				ndO_InitSearchResultMsg(nd_szSearchNoMIBFile, g_ndBGColorSearchResultDefault);
				return nd_onClickContinue();
			}
		}
		ndO_BeginStartSearch();
	}
	return nd_onClickContinue();
}

function ndO_BeginStartSearch()
{
	ndO_formSearch.ButtonCancel.value = nd_szCloseButton;
	ndO_formSearch.ButtonSearch.disabled  =
	ndO_formSearch.ButtonCancel.disabled  =
	ndO_formSearch.Imput.disabled		  = true;
	if (ndO_formSearch.CheckBox1)
		ndO_formSearch.CheckBox1.disabled = true;
	if (ndO_formSearch.CheckBox2)
		ndO_formSearch.CheckBox2.disabled = true;
	if (ndO_formSearch.CheckBox3)
		ndO_formSearch.CheckBox3.disabled = true;
	if (ndO_formSearch.Radio1)
		ndO_formSearch.Radio1.disabled	  = true;
	if (ndO_formSearch.Radio2)
		ndO_formSearch.Radio2.disabled	  = true;
	if (ndO_formSearch.Radio3)
		ndO_formSearch.Radio3.disabled	  = true;

	ndO_InitSearchResultMsg(nd_szSearching + '<BR>' + nd_szPleaseWait, ndO_GetBGColorOfTree(ndO_nSeachRadioValue));
	setTimeout('ndO_StartSearch()', 0);
}

function ndO_ClearSearchResultOfMibTree()
{
	if (	 ndO_winSearch 
		 && !ndO_winSearch.closed
		 && (ndO_nSeachRadioValue==2) // MibTree
		 && !ndO_bSeachClear)
	{
		ndO_bSeachClear = true;
		ndO_bFormSearch_WaitMibTreeDownload = false;
		ndO_InitSearchResultMsg("", g_ndBGColorSearchResultDefault);
	}
}

function ndO_InitSearchResultMsg(msg, BGcolor, TXTColor)
{
	var doc = ndDocBegin(ndO_frameSearchResult.document);
	doc.write(
		  '<style type="text/css">'
		+ 'BODY { margin:2px; overflow-y:auto; overflow-x:auto; }'
		+ 'TD		 { COLOR:'+g_ndColorSearchText+'; '+g_ndStyleFontSizeSearchText+'; '+g_ndStyleFontFamilySearch+'}'
		+ '</style>');
	ndDocBody(doc, BGcolor);
	if (msg)
	{
		if (TXTColor)
			msg = '<FONT style="COLOR:'+TXTColor+'">' + msg + '</FONT>';
		doc.write(
			'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
		   +'<TR>'
		   +'<TD vAlign=top align=top>' + msg + '</TD>'
		   +'</TR>'
		   +'</TABLE>');
	}
	ndDocEnd(doc);
}

function ndO_CanSearchInDirTree(a) // DirTree Item
{ 
	var eInfo = nd_FA_eInfo(parseInt(a[1]));
	return	  ( eInfo== 1/*INFODIR_MIB(1)*/)
		   || ( eInfo== 2/*INFODIR_MOD_OF_FILE(2)*/);
}

function ndO_CanSearchInMIBsTree(a) // MIBsTree Item
{ 
	if (!a[0]) // Shortcut
		return false; 
	var nFA = parseInt(a[1]);
	var eInfo = nd_FA_eInfo(nFA);
	return	  (eInfo!=14/*INFOMIB_UNKNOWN_VAR(14)*/)
		   && !nd_FA_bHiddenImport(nFA);
}

function ndO_CanSearchInMibTree(a) // MibTree Item
{ 
	var nFA = parseInt(a[1]);
	var eInfo = nd_FA_eInfo(nFA);
	return	  (    (eInfo==8/*INFOMIB_OBJECT(8)*/)
				|| (eInfo==9/*INFOMIB_OBJECT_TRAP(9)*/)
				|| (eInfo==7/*INFOMIB_MOD(7)*/)
				|| (eInfo==11/*INFOMIB_TYPE(11)*/) )
		   && !nd_FA_bHiddenImport(nFA);
}

function ndO_CanSearch_VisibleObj(a) // MIBsTree or MibTree Item
{ 
	var nFA = parseInt(a[1]);
	var eInfo = nd_FA_eInfo(nFA);
	return	  (    (eInfo==8/*INFOMIB_OBJECT(8)*/)
				|| (eInfo==9/*INFOMIB_OBJECT_TRAP(9)*/) )
		   && !nd_FA_bHiddenImport(nFA);
}

function ndO_AddResult(r, i)
{
	if (r.length > ndO_nMaxSearchResult)
		return true; // Too Much Item
	r[r.length] = i;
	return false;
}

function ndO_SearchResult(t, f, r, s, bMatchWholeWordOnly, bMatchCase, bRegularExpression)
{
	var n = t.length;
	if (bRegularExpression)
		for(var i=1;i<n;i++)
		{
			var a = t[i].split(':');
			if (s(a) && f.test(a[0]) )
				if (ndO_AddResult(r, i)) return true; // Too Much Item
		}
	else
		if (bMatchWholeWordOnly)
		{
			if (bMatchCase)
				for(var i=1;i<n;i++)
				{
					var a = t[i].split(':');
					if ((a[0] == f) && s(a))
						if (ndO_AddResult(r, i)) return true; // Too Much Item
				}
			else
				for(var i=1;i<n;i++)
				{
					var a = t[i].split(':');
					if ((a[0].toLowerCase() == f) && s(a))
						if (ndO_AddResult(r, i)) return true; // Too Much Item
				}
		}
		else
			if (bMatchCase)
				for(var i=1;i<n;i++)
				{
					var a = t[i].split(':');
					if ((a[0].indexOf(f)!=-1) && s(a))
						if (ndO_AddResult(r, i)) return true; // Too Much Item
				}
			else
				for(var i=1;i<n;i++)
				{
					var a = t[i].split(':');
					if ((a[0].toLowerCase().indexOf(f)!=-1) && s(a))
						if (ndO_AddResult(r, i)) return true; // Too Much Item
				}
	return false;
}

function ndO_SubSearch_Find(t/*ndTree*/, i/*First*/, b/*Number*/, f/*FindString*/, r/*Result*/, bMatchWholeWordOnly, bMatchCase, bRegularExpression)
{
	for(;;)
	{
		var ItemTree = nd_ItemTree(t, i);
		var nFA = nd_ItemTree_nFA(ItemTree);
		if (b)
		{
			if (nd_ItemTree_nSubId(ItemTree) == f)
				r[r.length] = i;
		}
		else
		{
			var eInfo = nd_FA_eInfo(nFA);
			if (	(	 (eInfo==8/*INFOMIB_OBJECT(8)	  */)
					  || (eInfo==9/*INFOMIB_OBJECT_TRAP(9)*/) )
				 && !nd_FA_bHiddenImport(nFA))
			{
				var s = nd_ItemTree_sName(ItemTree);
				if (bRegularExpression)
				{
					if (f.test(s))
						r[r.length] = i;
					else
					{
						s = nd_ItemTree_nSubId(ItemTree).toString();
						if (f.test(s))
							r[r.length] = i;
					}
				}
				else
					if (bMatchWholeWordOnly)
					{
						if (bMatchCase)
						{
							if (s == f)
								r[r.length] = i;
						}
						else
							if (s.toLowerCase() == f)
								r[r.length] = i;
					}
					else
						if (bMatchCase)
						{
							if (f && s.indexOf(f)!=-1)
								r[r.length] = i;
						}
						else
							if (f && s.toLowerCase().indexOf(f)!=-1)
								r[r.length] = i;
			}
		}
		// Next
		if (!nd_FA_bNextOfParent(nFA))
			break;
		i += nd_ItemTree_nDeltaNext(ItemTree);
	}
}

function nd0_IsUnsignedInt(s)
{
	for(var i=0;i<s.length;i++)
	{
		var c = s.charAt(i);
		if ((c > '9') || (c < '0'))
			return false;
	}
	return i!=0;
}


function ndO_StartSearch()
{
	var r = new Array(); // Result
	var t;
	var s;
	switch(ndO_nSeachRadioValue)
	{
	case 0: // Dir Tree
		t = ndO_GetDirTree();
		s = ndO_CanSearchInDirTree;
		break;
	case 1: // MIBs Tree
		t = ndO_GetMIBsTree();
		s = ndO_CanSearchInMIBsTree;
		break;
	default: //2: Mib Tree
		t = ndO_GetMibTree();
		s = ndO_CanSearchInMibTree;
	}
	var bTooMuchItem = false;
	if (t)
	{
		if (	(ndO_nSeachRadioValue!=0) // != Dir Tree
			 && (ndO_szSeachImputValue.indexOf('.')!=-1) )
		{
			var a=ndO_szSeachImputValue;
			var bRoot = a.charAt(0)=='.';
			// Remove first '.'
			if(bRoot)
				a = a.substring(1);
			// Remove last '.'
			if (a.length && a.charAt(a.length-1) == '.')
				a = a.substring(0, a.length-1);
			a = a.split('.');
			for(var i=0; i<a.length; i++)
			{
				var b = nd0_IsUnsignedInt(a[i]); 
				var f = b ? parseInt(a[i]) : a[i];
				if (ndO_bSeachCheckBox3Value) // Regular expression
				{
					var p = f;
					//if (ndO_bSeachCheckBox1Value) // Match whole word only
					//	p = "^" + p + "$";
					var m = ndO_bSeachCheckBox2Value // Match case
							? "g" 
							: "gi"
					f = new RegExp().compile(p, m);
				}
				else
					if (!ndO_bSeachCheckBox2Value && !b) // !Match case
						f = f.toLowerCase();

				var r2 = new Array();
				if (!r.length)
				{
					// --- Start From Root Item
					if (ndO_nSeachRadioValue == 1) 
						// MIBs Tree
						ndO_SubSearch_Find(t, 1, b, f, r2, ndO_bSeachCheckBox1Value, ndO_bSeachCheckBox2Value, ndO_bSeachCheckBox3Value);
					else
					{
						// Mib Tree
						if (t.length>3)
						{
							for(var j=2;;)
							{
								var ItemTree = nd_ItemTree(t, j);
								var nFA = nd_ItemTree_nFA(ItemTree);
								//ASSERT(nd_ItemTree_eInfo(ItemTree) == 7/*INFOMIB_MOD(7)*/)
								if (nd_FA_bChild(nFA))
								{
									var k = j+1;
									var ItemTree2 = nd_ItemTree(t, k);
									if (nd_ItemTree_eInfo(ItemTree2) != 8/*INFOMIB_OBJECT(8)*/)
									{
										//ASSERT(nd_ItemTree_eInfo(ItemTree2) == 12/*INFOMIB_LABEL(12)*/)
										var nFA2 = nd_ItemTree_nFA(ItemTree2);
										if (nd_FA_bNextOfParent(nFA2))
										{
											k += nd_ItemTree_nDeltaNext(ItemTree2);
											//ASSERT(nd_Tree_eInfo(t, k) == 8/*INFOMIB_OBJECT(8)*/)
										}
										else
											k = 0;
									}
									if (k)
										ndO_SubSearch_Find(t, k, b, f, r2, ndO_bSeachCheckBox1Value, ndO_bSeachCheckBox2Value, ndO_bSeachCheckBox3Value);
								}
								// Next
								if (!nd_FA_bNextOfParent(nFA))
									break;
								j += nd_ItemTree_nDeltaNext(ItemTree);
							}
						}
					}
					if (r2.length==0)
						bTooMuchItem = ndO_SearchResult(t, f, r2, ndO_CanSearch_VisibleObj, ndO_bSeachCheckBox1Value, ndO_bSeachCheckBox2Value, ndO_bSeachCheckBox3Value);
				}
				else
				{
					for(var j=0; j<r.length; j++)
					{
						var k = r[j];
						var nFA = nd_Tree_nFA(t, k);
						var bChild = nd_FA_bChild(nFA);
						if (bChild)
							ndO_SubSearch_Find(t, k+1, b, f, r2, ndO_bSeachCheckBox1Value, ndO_bSeachCheckBox2Value, ndO_bSeachCheckBox3Value);
					}
				}
				r = r2;
				if (!r.length)
					break;
			}
		}
		else
		{
			var f;
			if (ndO_bSeachCheckBox3Value) // Regular expression
			{
				var p = ndO_szSeachImputValue;
				//if (ndO_bSeachCheckBox1Value) // Match whole word only
				//	p = "^" + p + "$";
				var m = ndO_bSeachCheckBox2Value // Match case
						? "g" 
						: "gi"
				f = new RegExp().compile(p, m);
			}
			else
			{
				f = ndO_bSeachCheckBox2Value // Match case
					? ndO_szSeachImputValue
					: ndO_szSeachImputValue.toLowerCase()
			}
			bTooMuchItem = ndO_SearchResult(t, f, r, s, ndO_bSeachCheckBox1Value, ndO_bSeachCheckBox2Value, ndO_bSeachCheckBox3Value);
		}
	}
	var rgbBGColor = ndO_GetBGColorOfTree(ndO_nSeachRadioValue);
	n = r.length;
	if (n)
	{
		var doc = ndDocBegin(ndO_frameSearchResult.document);
		doc.write(
			  '<style type="text/css">'
			+ 'BODY { margin:2px; overflow-y:auto; overflow-x:auto; }'
			+ 'A:link	 { COLOR:'+g_ndColorSearchTextLink+'; TEXT-DECORATION:underline }'
			+ 'A:visited { COLOR:'+g_ndColorSearchTextLink+'; TEXT-DECORATION:underline }'
			+ 'A:hover	 { COLOR:'+g_ndColorSearchTextLinkHover+'; TEXT-DECORATION:underline; }'
			+ 'A:active  {}'
			+ 'TD		 { COLOR:'+g_ndColorSearchText+'; '+g_ndStyleFontSizeSearchText+'; '+g_ndStyleFontFamilySearch+'}'
			+ '</style>');
		ndDocBody(doc, rgbBGColor);
		//g_ndOnlineMibCallBack.PlugLibrary(doc);
		doc.write('<TABLE cellSpacing=0 cellPadding=0 border=0>');
		if (n > ndO_nMaxSearchResult)
			n = ndO_nMaxSearchResult;
		for(var i=0;i<n;i++)
		{
			var j = r[i];
			var ItemTree = nd_ItemTree(t, j);
			var nFA = nd_ItemTree_nFA(ItemTree);
			doc.write('<TR><TD NOWRAP>');
			ndImg2(doc, ndN2H(nd_FA_nImg(nFA)), 19);
			doc.write('<A href="javascript:;"'
					 +' onClick="return top.opener.top.ndOnlineMibDoc.ndO_onClickSearchResultItem(this,' + ndO_nSeachRadioValue + ',' + j + ',self);"'
					 +' onMouseOver="return top.opener.top.ndOnlineMibDoc.ndO_onMouseOverSearchResultItem(' + ndO_nSeachRadioValue + ',' + j + ',self);"'
					 +' onMouseOut="return top.opener.top.ndOnlineMibDoc.ndO_onMouseOutSearchResultItem(' + ndO_nSeachRadioValue + ',' + j + ',self);">');
			doc.write(nd_ItemTree_sName(ItemTree)+'</A></TD></TR>');
		}
		if (bTooMuchItem || (r.length!=n) )
			doc.write('<TR><TD>...</TD></TR>');
		doc.write('</TABLE>');
		ndDocEnd(doc);
	}
	else
		ndO_InitSearchResultMsg(nd_szSearchNoResult, rgbBGColor);

	if (ndO_winSearch && !ndO_winSearch.closed)
	{	
		ndO_formSearch.ButtonSearch.disabled  =
		ndO_formSearch.ButtonCancel.disabled  =
		ndO_formSearch.Imput.disabled		  = false;
		if (ndO_formSearch.CheckBox1 && !ndO_bSeachCheckBox3Value)
			ndO_formSearch.CheckBox1.disabled = false;
		if (ndO_formSearch.CheckBox2)
			ndO_formSearch.CheckBox2.disabled = false;
		if (ndO_formSearch.CheckBox3)
			ndO_formSearch.CheckBox3.disabled = false;
		if (ndO_formSearch.Radio1)
			ndO_formSearch.Radio1.disabled	  = false;
		if (ndO_formSearch.Radio2)
			ndO_formSearch.Radio2.disabled	  = false;
		if (ndO_formSearch.Radio3)
			ndO_formSearch.Radio3.disabled	  = false;

		ndO_winSearch.focus();
		ndO_formSearch.Imput.focus();
	}
	ndO_SearchResult_lastSelectedObjA = null;
}

function ndO_onClickSearchResultItem(objA, _nNumTree, _i, _frame)
{
	// Update Selection
	if (ndO_SearchResult_lastSelectedObjA)
		ndO_SearchResult_lastSelectedObjA.style.backgroundColor = 'transparent';
	objA.style.backgroundColor = g_ndBGColorSelectItem;
	ndO_SearchResult_lastSelectedObjA = objA;

	var _ndTreeName = ndO_GetTreeName(_nNumTree);
	var _ndTree = eval(_ndTreeName);

	switch(nd_Tree_eInfo(_ndTree, _i))
	{
	case 8: // INFOMIB_OBJECT(8)
	case 9: // INFOMIB_OBJECT_TRAP(9)
		ndO_UpdateOidForm(_ndTree, _i);
	}
	
	// --- Expand Item
	var doc = ndO_GetDocumentNavTree(_nNumTree);
	var objA = ndO_ExpandItem(doc, _ndTreeName, _i);

	// --- Select & Focus 
	ndSelectAndFocusItemTree(objA, doc, _ndTreeName, _i);

	if (ndO_bDynamicFrame || ndO_bIFrame)
		ndO_ActiveTab(_nNumTree, true /*bUser*/);

	if (ndO_winSearch && !ndO_winSearch.closed)
		ndO_winSearch.focus();

	// Select
	if (_nNumTree==2)// Mib Tree
	{
		// --- Show item in File
		ndTreeClickItem(_ndTreeName, _i);
	}
	return nd_onClickContinue();
}

function ndO_onMouseOverSearchResultItem(_nTree, _i, _frame)
{
	//g_ndOnlineMibCallBack.onMouseOver(eval(ndO_GetTreeName(_nTree)), _i, _frame);
	return nd_onMouseOverRet();
}

function ndO_onMouseOutSearchResultItem(_nTree, _i, _frame)
{
	//g_ndOnlineMibCallBack.onMouseOut(eval(ndO_GetTreeName(_nTree)), _i, _frame);
	return nd_onMouseOutRet();
}

function nd_IsSupportOidAndNotObjectType(eType)
{
	return	  (    (eType>=2/*ObjectIdentifier*/) 
				&& (eType<=7/*ObjectGroup*/) ) 
		   || (eType==12/*NotificationGroup*/);
}

function nd_IsCompatibleType(eTypeA, eTypeB)
{
	return	  (eTypeA == eTypeB)
		   || (    nd_IsSupportOidAndNotObjectType(eTypeA)
				&& nd_IsSupportOidAndNotObjectType(eTypeB) );
}

function nd_IsSameOID( // RECURSIF
	ndTree1, nItem1,
	ndTree2, nItem2)
{
	var ItemTree1 = nd_ItemTree(ndTree1, nItem1);
	var ItemTree2 = nd_ItemTree(ndTree2, nItem2);
	//ASSERT(nd_ItemTree_eInfo(ItemTree1) == 8/*INFOMIB_OBJECT(8)*/);
	//ASSERT(nd_ItemTree_eInfo(ItemTree2) == 8/*INFOMIB_OBJECT(8)*/);
	// Cmp nSubId
	if (   nd_ItemTree_nSubId(ItemTree1) 
		!= nd_ItemTree_nSubId(ItemTree2) )
		return false
	var nFB1 = nd_ItemTree_nFA(ItemTree1);
	var nFB2 = nd_ItemTree_nFA(ItemTree2);
	var bOidParent	= nd_FB_bOidParent(nFB1);
	if (bOidParent != nd_FB_bOidParent(nFB2))
		return false;
	if (!bOidParent)
		return true;
	return nd_IsSameOID( // RECURSIF
		ndTree1, nItem1 - nd_FB_nDeltaParent(nFB1),
		ndTree2, nItem2 - nd_FB_nDeltaParent(nFB2))
}

function nd_IsSameVariables(
	ndTree1, nItem1, ItemTree1, 
	ndTree2, nItem2, ItemTree2)
{
	// nCountVar = nDeltaNext-1
	var n  = nd_ItemTree_nDeltaNext(ItemTree1);
	if (n != nd_ItemTree_nDeltaNext(ItemTree2))
		return false;
	while(--n)
	{
		var ItemTreeV1 = nd_ItemTree(ndTree1, ++nItem1);
		var ItemTreeV2 = nd_ItemTree(ndTree2, ++nItem2);
		var eInfo1	= nd_ItemTree_eInfo(ItemTreeV1);
		var eInfo2	= nd_ItemTree_eInfo(ItemTreeV2);
		// --- Comparaison en fonction de l'OID des variables plutt que le nom de la variable
		if (	(eInfo1 == 14/*INFOMIB_UNKNOWN_VAR(14)*/)
			 || (eInfo2 == 14/*INFOMIB_UNKNOWN_VAR(14)*/) )
		{
			// Cmp Name <- One unknown variable
			//ASSERT( (nd_ItemTree_eInfo(ItemTreeV1)==13/*INFOMIB_SHORTCUT_OBJECT(13)*/) || (nd_ItemTree_eInfo(ItemTreeV2)==13/*INFOMIB_SHORTCUT_OBJECT(13)*/) );
			var sName1 = ((eInfo1 == 14/*INFOMIB_UNKNOWN_VAR(14)*/)
						  ? nd_ItemTree_sName(ItemTreeV1)
						  : nd_Tree_sName(ndTree1, nd_ItemTree_nLine(ItemTreeV1)/* ID of Object */) );
			var sName2 = ((eInfo2 == 14/*INFOMIB_UNKNOWN_VAR(14)*/)
						  ? nd_ItemTree_sName(ItemTreeV2)
						  : nd_Tree_sName(ndTree2, nd_ItemTree_nLine(ItemTreeV2)/* ID of Object */) );
			if (sName1 == sName2)
				 continue;
		}
		else
		{
			// Cmp OID
			//ASSERT(nd_ItemTree_eInfo(ItemTreeV1)==13/*INFOMIB_SHORTCUT_OBJECT(13)*/);
			//ASSERT(nd_ItemTree_eInfo(ItemTreeV2)==13/*INFOMIB_SHORTCUT_OBJECT(13)*/);
			if (nd_IsSameOID(
					ndTree1, nd_ItemTree_nLine(ItemTreeV1)/* ID of Object */, 
					ndTree2, nd_ItemTree_nLine(ItemTreeV2)/* ID of Object */))
				continue;
		}
		return false;
	}
	return true;
}

function nMibTreeOidId2MIBsTreeOidId(ndMIBsTree, ndMibTree, nItem) // RECURSIF
{
	var ItemTree = nd_ItemTree(ndMibTree, nItem);
	var nFB = nd_ItemTree_nFB(ItemTree);
	var nItem2 = nd_FB_bOidParent(nFB)
			? nMibTreeOidId2MIBsTreeOidId(ndMIBsTree, ndMibTree, nItem - nd_FB_nDeltaParent(nFB)) // RECURSIF
			: 0;
	if (nItem2<0)
		return -1;
	var sName  = nd_ItemTree_sName(ItemTree);
	var nSubId = nd_ItemTree_nSubId(ItemTree);
	var nFA    = nd_ItemTree_nFA(ItemTree);
	var eInfo  = nd_FA_eInfo(nFA);
	var eType  = nd_FA_eType(nFA);
	nItem2++; // First Child
	for(;;)
	{
		var ItemTree2 = nd_ItemTree(ndMIBsTree, nItem2);
		var nFA2 = nd_ItemTree_nFA(ItemTree2);
		if (nd_ItemTree_sName(ItemTree2) == sName)
			if (nd_ItemTree_nSubId(ItemTree2) == nSubId)
				if (nd_FA_eInfo(nFA2) == eInfo)
					if (eInfo == 9/*INFOMIB_OBJECT_TRAP(9)*/)
					{
						if (nd_IsSameVariables(
								ndMibTree,	nItem,	ItemTree, 
								ndMIBsTree, nItem2, ItemTree2))
							return nItem2;
					}
					else
					{
						//ASSERT(eInfo == 8/*INFOMIB_OBJECT(8)*/);
						if (nd_IsCompatibleType(nd_FA_eType(nFA2), eType))
							return nItem2;
					}
		if (!nd_FA_bNextOfParent(nFA2))
			return -1;
		nItem2 += nd_ItemTree_nDeltaNext(ItemTree2);
	}
}

function ndO_BtnGotoDirTreeClick(img)
{
	ndO_ActiveTab(0/*Tab0_DirTree*/, true /*bUser*/);

	// --- Get Selected Item
	var i = 0;
	if (eval('typeof(i_nd_iSelectItem' + ndO_MibTreeName + ')') != 'undefined')
		i = eval('i_nd_iSelectItem' + ndO_MibTreeName);
	var c = 0;
	if (i > 1/*MibTree - Fil*/) 
	{
		// --- Find 'MibTree - Mod'
		var ndMibTree = ndO_GetMibTree();
		for(;;)
		{
			var ItemTree = nd_ItemTree(ndMibTree, i);
			if (nd_ItemTree_eInfo(ItemTree) == 7/*INFOMIB_MOD(7)*/)
			{
				//ASSERT((i-nd_ItemTree_nDeltaParent(ItemTree)) == 1); // parent -> 'MibTree - Fil'
				// --- Calculate Num Mod of File: c
				for(var j=1+1/*First Mod*/;;)
				{
					//ASSERT(nd_Tree_eInfo(ndMibTree,j) == 7/*INFOMIB_MOD(7)*/);
					//ASSERT((j-nd_Tree_nDeltaParent(ndMibTree,j)) == 1); // parent -> 'MibTree - Fil'
					c++;
					if (j==i)
						break;
					j = nd_Tree_nNext(ndMibTree, j);
				}
				break;
			}
			i -= nd_ItemTree_nDeltaParent(ItemTree);
		}
	}
	// c : Num Mod of File

	i = ndO_nLastFileIndexDirTree + c;
	var doc = ndO_GetDocumentNavTree0();
	// --- Close All DirTree
//	ndHideAllDIV(doc, ndO_DirTreeName, doc/*obj* /);
	var objA = ndO_ExpandItem(doc, ndO_DirTreeName, i);
	// --- 'Mod' Select & Focus 
	ndSelectAndFocusItemTree(objA, doc, ndO_DirTreeName, i);
	return nd_onClickContinue();
}

function ndO_BtnGotoMIBsTreeClick(img)
{
	ndO_ActiveTab(1/*Tab1_MIBsTree*/, true /*bUser*/)
	if (ndO_bMIBsTreeLoad)
	{
		var ndMIBsTree = ndO_GetMIBsTree();
		var nItem2 = nMibTreeOidId2MIBsTreeOidId(ndMIBsTree, ndO_GetMibTree(), ndO_nSelectedMibTreeOID);
		if (nItem2>0)
		{
			var doc = ndO_GetDocumentNavTree1()
			var objA = ndO_ExpandItem(doc, ndO_MIBsTreeName, nItem2);
			// --- 'MIBsTree - Object' Select & Focus 
			ndSelectAndFocusItemTree(objA, doc, ndO_MIBsTreeName, nItem2);
		}
		return;
	}
	// --- Init Global Var -> ndO_onLoadMIBsTreeDocument()
	ndO_MIBsTreeDownload_MibTree = ndO_GetMibTree();
	ndO_MIBsTreeDownload_nSelectedMibTreeOID = ndO_nSelectedMibTreeOID;
	return nd_onClickContinue();
}

function ndO_BtnRefreshClick(img, nNumTab)
{
	if (typeof nNumTab == 'undefined')
		nNumTab = ndO_nNumActiveTab;
	ndO_InitDocumentAndDrawNumTree(nNumTab, 0 /*nOpenItem*/, false /*bExpandItem*/);
	return nd_onClickContinue();
}

function ndO_ZipMibPathFile()
{
	return g_ndZipPath + ndO_szLastMibPathFileName.substring(g_ndHtmlPath.length) + '.zip'
}

function ndO_BtnDownloadClick(img)
{
	if (!ndO_szDownloadWindowName)
	{
		var milliseconde = (new Date()).getTime();
		ndO_szDownloadWindowName = "ndDownload" + milliseconde;
	}
	var win = ndOpenWindow("", ndO_szDownloadWindowName, g_ndWidthWindowDownload, g_ndHeightWindowDownload, false, "dependent")
	if (win && !win.closed)
	{
		ndO_winDownload = win;
		var doc = ndDocBegin(win.document);
		doc.write('<TITLE>' + nd_szTitleDownload + '</TITLE>');
		doc.write(
			  '<style type="text/css">'
			+ '.NDButton { '+g_ndStyleFontSizeSearchText+'; '+g_ndStyleFontFamilySearch+'; }'
			+ 'A:link	 { COLOR:'+g_ndColorDownloadTextLink+'; TEXT-DECORATION:underline }'
			+ 'A:visited { COLOR:'+g_ndColorDownloadTextLink+'; TEXT-DECORATION:underline }'
			+ 'A:hover	 { COLOR:'+g_ndColorDownloadTextLinkHover+'; TEXT-DECORATION:underline; }'
			+ 'A:active  {}'
			+ 'TD		 { COLOR:'+g_ndColorDownloadText+'; '+g_ndStyleFontSizeDownloadText+'; '+g_ndStyleFontFamilyDownloadText+'}'
			+ '</style>');
		ndDocBody(doc, g_ndBGColorWindowDownload, 2);
		// Z FileName.mib.zip - xxx.Ko
		// Z All-MIBs.zip - xxx Mo
		//		[Close]
		var h1 = ndO_ZipMibPathFile();
		var h2 = g_ndZipPath + ndO_szAllMIBs_zip;
		var nZipFileSizeAllMIBs = ndO_GetFileSize_AllMIBsZIP();
		doc.write(
			// Opera		: ''			  else 'vAlign=middle' not work
			// Netscape 7.0 : '<FORM><NOBR>'  else Netscape add <BR> with FORM
			((ndOpera || ndIE) ? '' : '<FORM><NOBR>')
		   +'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
		   +'<TR><TD vAlign=middle align=middle>'
			  +'<TABLE cellSpacing=0 cellPadding=0 border=0>'
				+'<TR><TD><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=6></TD></TR>'
				+'<TR><TD NOWRAP><A href="' + h1 + '"><IMG src="' + g_ndImgPath + 'ZipIcon.gif" border=0 width=16 height=16 alt="" align=absmiddle></A> <A href="' + h1 + '">' + ndO_szLastMibFileName + '.zip</A> - ' + ndFileSize2String(ndO_nLastZipFileSize) + '</TD></TR>'
				+'<TR><TD><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=8></TD></TR>'
				+'<TR><TD NOWRAP><A href="' + h2 + '"><IMG src="' + g_ndImgPath + 'ZipIcon.gif" border=0 width=16 height=16 alt="" align=absmiddle></A> <A href="' + h2 + '">' + ndO_szAllMIBs_zip + '</A> - ' + ndFileSize2String(nZipFileSizeAllMIBs) + '</TD></TR>'
				+'<TR><TD><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=14></TD></TR>'
				+'<TR><TD align=middle><INPUT class=NDButton type="BUTTON" value="'+nd_szCloseButton+'" onClick="top.close(); return top.opener.top.ndOnlineMibDoc.nd_onClickContinue();"></TD></TR>'
			   +'</TABLE>'
		   +'</TD></TR>'
		   +'</TABLE>'
		   +((ndOpera || ndIE) ? '' : '<NOBR></FORM>')
			);
		ndDocEnd(doc);
	}
	return nd_onClickContinue();
}

function ndWriteBar(doc, szTableOfBar)
{
	doc.write(''
	  +'<TABLE cellSpacing=0 cellPadding=0 border=0 width="100%" height="100%">'
	  +  '<TR>'
	  +   '<TD vAlign=bottom>'
		   +szTableOfBar
	  +   '</TD>'
	  +  '</TR>'
	  +  '<TR>'
	  +   '<TD vAlign=bottom height='+ndO_szHeightNavBlankBar+'>'
		   +'<TABLE cellSpacing=0 cellPadding=0 border=0 width="100%">'
		   +  '<TR>'
		   +   '<TD bgcolor='+g_ndBGColorFrameNavBar+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +   '<TD bgcolor='+g_ndColorActiveTabFace+' width="100%"><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +   '<TD bgcolor='+g_ndBGColorFrameNavBar+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +  '</TR>'
		   +  '<TR>'
		   +  '<TD colspan=3 bgcolor='+g_ndColorActiveTabFace+' width="100%" height='+(ndO_szHeightNavBlankBar-1)+'><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD>'
		   +  '</TR>'
		   +'</TABLE>'
	  +   '</TD>'
	  +  '</TR>'
	  +'</TABLE>');
}

function ndO_SubDrawNavBarTree_MultiTab(
	frame, 
	bTab0_DirTree, 
	bTab1_MIBsTree, 
	bTab2_MibTree, 
	nTabActivate,
	bAdd_onLoad)
{
	var doc = ndDocBegin(frame.document);
	ndO_WriteStyleNav(doc);
	//Not Use : ndDocBody_WithFrameOnLoad(doc, g_ndBGColorFrameNavBar, bAdd_onLoad);
	// ->
	ndDocBody(doc, g_ndBGColorFrameNavBar, bAdd_onLoad);
	var nTab = bTab0_DirTree + bTab1_MIBsTree + bTab2_MibTree;
	ndWriteBar(doc, ''
	  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%" width="100%">'
	  +  '<TR>'
+((nTab>1)
  ?''
	  +   '<TD vAlign=bottom>'
		  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%">'
		  +  '<TR>'
  :'' 
 )
		  +(bTab0_DirTree
			?				   '<TD vAlign=bottom>'+ndNavTab(nd_szDirTreeLabel , nd_szDirTreeStatus,  14, 14, 'TabFolder'  , nTabActivate==0, 0, true)+'</TD>'
			 +(bTab1_MIBsTree ?'<TD vAlign=bottom>'+ndNavTab(nd_szMibsTreeLabel, nd_szMibsTreeStatus, 14, 14, 'TabMIBsTree', nTabActivate==1, 1, !bTab0_DirTree)+'</TD>':'')
			 +(bTab2_MibTree  ?'<TD vAlign=bottom>'+ndNavTab(nd_szMibTreeLabel , nd_szMibTreeStatus,  16, 16, 'TabMIBTree' , nTabActivate==2, 2, !bTab0_DirTree && !bTab1_MIBsTree)+'</TD>':'')
			: (bTab2_MibTree  ?'<TD vAlign=bottom>'+ndNavTab(nd_szMibTreeLabel , nd_szMibTreeStatus,  16, 16, 'TabMIBTree' , nTabActivate==2, 2, true) +'</TD>':'')
			 +(bTab1_MIBsTree ?'<TD vAlign=bottom>'+ndNavTab(nd_szMibsTreeLabel, nd_szMibsTreeStatus, 14, 14, 'TabMIBsTree', nTabActivate==1, 1, !bTab2_MibTree)+'</TD>':'')
		   )
+((nTab>1)
  ?''
		  +  '</TR>'
		  +'</TABLE>'
	  +   '</TD>'
  :'' 
 )
	  +   '<TD width=1 vAlign=bottom align=right>'
		  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%">'
		  +  '<TR>'
+(ndO_bRefreshButtonOfTab[nTabActivate]
  ?''
	+((bTab0_DirTree && (nTabActivate==2))
	?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnGotoDirTreeClick(ndNavGotoDirTree);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavGotoDirTree, parent.nd_szGotoDirTree);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavGotoDirTree);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavGotoDirTree);"><IMG name="ndNavGotoDirTree" src="' + g_ndImgPath + 'GotoDirTree.gif" border=0 width=24 height=22 alt="'+nd_szAltGotoDirTree+'"></A></TD>'
	:'' 
	)
	+((bTab1_MIBsTree && (nTabActivate==2))
	?''
		+(ndO_nSelectedMibTreeOID
		?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnGotoMIBsTreeClick(ndNavGotoMIBsTree);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavGotoMIBsTree, parent.nd_szGotoMIBsTree);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavGotoMIBsTree);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavGotoMIBsTree);"><IMG name="ndNavGotoMIBsTree" src="' + g_ndImgPath + 'GotoMIBsTree.gif" border=0 width=24 height=22 alt="'+nd_szAltGotoMIBsTree+'"></A></TD>'
		:'' 
		  +   '<TD width=1 vAlign=bottom onMouseOver="return parent.nd_onMouseOver_SetStatus(parent.nd_szGotoMIBsTree);" onMouseOut="parent.nd_onMouseOut_SetDefaultStatus();"><IMG src="' + g_ndImgPath + 'GotoMIBsTreeDisable.gif" width=24 height=22 alt="'+nd_szAltGotoMIBsTree+'"></TD>'
		)
	:'' 
	)
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnRefreshClick(ndNavRefresh);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavRefresh, parent.nd_szRefresh);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavRefresh);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavRefresh);"><IMG name="ndNavRefresh" src="' + g_ndImgPath + 'Refresh.gif" border=0 width=24 height=22 alt="'+nd_szAltRefresh+'"></A></TD>'
  :'' 
 )
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnSearchClick(ndNavSearch);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavSearch, parent.nd_szSearch);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavSearch);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavSearch);"><IMG name="ndNavSearch" src="' + g_ndImgPath + 'Search.gif" border=0 width=24 height=22 alt="'+nd_szAltSearch+'"></A></TD>'
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnLegendClick(ndNavLegend);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavLegend, parent.nd_szLegend);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavLegend);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavLegend);"><IMG name="ndNavLegend" src="' + g_ndImgPath + 'OpenLegend.gif" border=0 width=24 height=22 alt="'+nd_szAltLegend+'"></A></TD>'
+(ndO_bDynamicFrame
  ?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnFrameRightClick(ndNavFrameRight);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavFrameRight,parent.nd_szShowHideFrameRight);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavFrameRight);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavFrameRight);"><IMG name="ndNavFrameRight" src="' + g_ndImgPath + 'FrameRight.gif" border=0 width=24 height=22 alt="'+nd_szAltFrameRight+'"></A></TD>'
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnFrameTopClick(ndNavFrameTop);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavFrameTop,parent.nd_szShowHideFrameTop);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavFrameTop);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavFrameTop);"><IMG name="ndNavFrameTop" src="' + g_ndImgPath + 'FrameTop.gif" border=0 width=24 height=22 alt="'+nd_szAltFrameTop+'"></A></TD>'
  :'' 
 )
+(ndOpera // Opera 7.10 & 7.23: bad print
  ?''
  :'' 
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_PrintTreeClick(ndNavPrint);" onMouseOver="return parent.ndO_PrintMouseOver(ndNavPrint);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavPrint);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavPrint);"><IMG name="ndNavPrint" src="' + g_ndImgPath + 'Print.gif" border=0 width=24 height=22 alt="'+nd_szAltPrint+'"></A></TD>'
 )
		  +  '</TR>'
		  +'</TABLE>'
	  +   '</TD>'
	  +  '</TR>'
	  +'</TABLE>');
	ndDocEnd(doc);
}

function ndO_DrawNavBarTree_SimpleTab(frame, nNumTab)
{
	var img;
	var wh;
	var txt;
	var sta;
	switch(nNumTab)
	{
	case 0:  img='TabFolder';	wh=14; txt=nd_szDirTreeLabel;  sta=nd_szDirTreeStatus;	break;
	case 1:  img='TabMIBsTree'; wh=14; txt=nd_szMibsTreeLabel; sta=nd_szMibsTreeStatus; break;
	default: img='TabMIBTree';	wh=16; txt=nd_szMibTreeLabel;  sta=nd_szMibTreeStatus;
	}
	var doc = ndDocBegin(frame.document);
	ndO_WriteStyleNav(doc);
	//Not Use : ndDocBody_WithFrameOnLoad(doc, g_ndBGColorFrameNavBar);
	// ->
	ndDocBody(doc, g_ndBGColorFrameNavBar);
	ndWriteBar(doc, ''
	  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%" width="100%">'
	  +  '<TR>'
	  +   '<TD vAlign=bottom>'
		  + 	ndNavTab(txt, sta, wh, wh, img, true, nNumTab, true)
	  +   '</TD>'
	  +   '<TD width=1 vAlign=bottom align=right>'
		  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%">'
		  +  '<TR>'
+(ndO_bRefreshButtonOfTab[nNumTab]
  ?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnRefreshClick(ndNavRefresh, ' + nNumTab + ');" onMouseOver="return parent.ndO_BtnMouseOver(ndNavRefresh, parent.nd_szRefresh);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavRefresh);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavRefresh);"><IMG name="ndNavRefresh" src="' + g_ndImgPath + 'Refresh.gif" border=0 width=24 height=22 alt="'+nd_szAltRefresh+'"></A></TD>'
  :'' 
 )
+((nNumTab!=0)
  ?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnSearchClick(ndNavSearch);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavSearch, parent.nd_szSearch);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavSearch);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavSearch);"><IMG name="ndNavSearch" src="' + g_ndImgPath + 'Search.gif" border=0 width=24 height=22 alt="'+nd_szAltSearch+'"></A></TD>'
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnLegendClick(ndNavLegend);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavLegend, parent.nd_szLegend);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavLegend);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavLegend);"><IMG name="ndNavLegend" src="' + g_ndImgPath + 'OpenLegend.gif" border=0 width=24 height=22></A></TD>'
  :'' 
 )
+(ndOpera // Opera 7.10 & 7.23: bad print
  ?''
  :'' 
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_PrintTreeClick(ndNavPrint, ' + nNumTab + ');" onMouseOver="return parent.ndO_PrintMouseOver(ndNavPrint, ' + nNumTab + ');" onMouseOut="return parent.ndO_BtnMouseOut(ndNavPrint);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavPrint);"><IMG name="ndNavPrint" src="' + g_ndImgPath + 'Print.gif" border=0 width=24 height=22 alt="'+nd_szAltPrint+'"></A></TD>'
 )
		  +  '</TR>'
		  +'</TABLE>'
	  +   '</TD>'
	  +  '</TR>'
	  +'</TABLE>');
	ndDocEnd(doc);
}

function ndO_DrawNavBarFile_FileNameTab()
{
	var doc = ndDocBegin(ndFrameContentBar.document);
	ndO_WriteStyleNav(doc);
	ndDocBody(doc, g_ndBGColorFrameNavBar);
	ndWriteBar(doc, 
		(ndO_szLastMibPathFileName=='')
		? ''
		: ''
	  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%" width="100%">'
	  +  '<TR>'
	  +   '<TD vAlign=bottom>'
		  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%">'
		  +  '<TR>'
		  +   '<TD vAlign=bottom>'
		  + 	ndNavTab(ndO_szLastMibFileName, '',15, 15, 'Fil'+ndO_nLastFileIcoLanguage, true, 0, true)
		  +   '</TD>'
		  +  '</TR>'
		  +'</TABLE>'
	  +   '</TD>'
	  +   '<TD width=1 vAlign=bottom align=right>'
		  +'<TABLE cellSpacing=0 cellPadding=0 border=0 height="100%">'
		  +  '<TR>'
+((ndO_GetFileSize_AllMIBsZIP()!=0)
   ?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnDownloadClick(ndNavDownload);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavDownload, parent.nd_szDownload2);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavDownload);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavDownload);"><IMG name="ndNavDownload" src="' + g_ndImgPath + 'Download.gif" border=0 width=24 height=22 alt="'+nd_szAltDownload+'"></A></TD>'
   :('' 
		  +   '<TD width=1 vAlign=bottom><A href="' + ndO_ZipMibPathFile() + '" onMouseOver="return parent.ndO_BtnMouseOver(ndNavDownload, parent.ndO_szLastMibFileName + \'.zip (\'+parent.ndFileSize2String(parent.ndO_nLastZipFileSize)+\')\');" onMouseOut="return parent.ndO_BtnMouseOut(ndNavDownload);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavDownload);"><IMG name="ndNavDownload" src="' + g_ndImgPath + 'Download.gif" border=0 width=24 height=22 alt="'+ndO_szLastMibFileName + '.zip ('+ndFileSize2String(ndO_nLastZipFileSize)+')"></A></TD>'
 )
)
+(ndO_bDynamicFrame
  ?''
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnFrameLeftClick(ndNavFrameLeft);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavFrameLeft,parent.nd_szShowHideFrameLeft);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavFrameLeft);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavFrameLeft);"><IMG name="ndNavFrameLeft" src="' + g_ndImgPath + 'FrameLeft.gif" border=0 width=24 height=22 alt="'+nd_szAltFrameLeft+'"></A></TD>'
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_BtnFrameTopClick(ndNavFrameTop);" onMouseOver="return parent.ndO_BtnMouseOver(ndNavFrameTop,parent.nd_szShowHideFrameTop);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavFrameTop);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavFrameTop);"><IMG name="ndNavFrameTop" src="' + g_ndImgPath + 'FrameTop.gif" border=0 width=24 height=22 alt="'+nd_szAltFrameTop+'"></A></TD>'
  :'' 
 )
+(ndOpera // Opera 7.10 & 7.23: bad print
  ?''
  :'' 
		  +   '<TD width=1 vAlign=bottom><A href="javascript:;" onClick="return parent.ndO_PrintFileClick(ndNavPrint);" onMouseOver="return parent.ndO_PrintFileMouseOver(ndNavPrint);" onMouseOut="return parent.ndO_BtnMouseOut(ndNavPrint);" onMouseDown="return parent.ndO_BtnMouseDown(ndNavPrint);"><IMG name="ndNavPrint" src="' + g_ndImgPath + 'Print.gif" border=0 width=24 height=22 alt="'+nd_szAltPrint+'"></A></TD>'
 )
		  +  '</TR>'
		  +'</TABLE>'
	  +   '</TD>'
	  +  '</TR>'
	  +'</TABLE>');
	ndDocEnd(doc);
}

function ndO_InitFrameColor(frame, color)
{
	var doc = ndDocBegin(frame.document);
	ndDocBody(doc, color);
	ndDocEnd(doc);
}

function ndO_InitDocumentColor(document, color)
{
	ndO_InitDocumentColorAndMsg(document, color, '')
}

function ndO_InitDocumentColorAndMsg(document, color, msg)
{
	var doc = ndDocBegin(document);
	ndO_WriteFrameBorderStyle(doc);
	ndDocBody(doc, color);
	if (msg)
		doc.write(
			'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
		   +'<TR>'
		   +'<TD vAlign=middle align=middle><FONT style="COLOR:'+g_ndColorMessage+'; '+g_ndStyleFontSizeMessage+'; '+g_ndStyleFontFamilyMessage+'">' + msg + '</FONT></TD>'
		   +'</TR>'
		   +'</TABLE>');
	ndDocEnd(doc);
}

function ndO_InitDocumentColorAndWaitMsg(document, color, msg)
{
	if (msg)
		msg = '<B>' + msg + '</B><BR>' + nd_szPleaseWait;
	ndO_InitDocumentColorAndMsg(document, color, msg)
}

function ndO_FrameContentFile_onLoad()
{
	ndO_Frame_onLoad();
	setTimeout('ndO_HideSplash()', 8000);
}

function ndO_DrawContentFile(bShowSplash)
{
	var doc = ndDocBegin(ndFrameContentFile.document);
	ndO_WriteFrameBorderStyle(doc);
	if (bShowSplash)
		ndO_FrameOnLoad_nCount++;
	ndDocBodyWithScrollBarColor(
		doc, 
		g_ndBGColorFrameMibFileEmpty, 
		0,
		bShowSplash
		? 'onLoad="top.ndOnlineMibDoc.ndO_FrameContentFile_onLoad()"'
		: '');
	if (bShowSplash && g_nd_bShowSplash)
		doc.write(
			'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
		   +'<TR>'
		   +'<TD vAlign=middle align=middle>'
+(g_nd_bSplashHref
 ?''
		   +'<A href="'+g_nd_bSplashHref+'" target=_blank>'
 :'')
		   +'<IMG width='+g_nd_bSplashWidth+' height='+g_nd_bSplashHeight+' src="'+g_nd_bSplashImg+'" border=0 alt="'+g_nd_bSplashAlt+'">'
+(g_nd_bSplashHref
 ?''
		   +'</A>'
 :'')
		   +'</TD>'
		   +'</TR>'
		   +'</TABLE>');
	ndDocEnd(doc);
}

function ndO_onLoadFrameSet()
{
	if (g_ndOnlineMibWindowsTitleText != '')
		ndSetWindowTitle(g_ndOnlineMibWindowsTitleText);

	ndO_FrameOnLoad_Init();

	// ---------------------------------
	// --- Write FrameTitle document ---
	// ---------------------------------
	var doc = ndDocBegin(ndFrameTitle.document);
	ndO_WriteStyleFrameTitle(doc);
	ndDocBody_WithFrameOnLoad(doc, g_ndBGColorFrameTop);
	doc.write(
		'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0'
+ ((g_ndBGLogoImgFile!='')
	? ' background="' + g_ndBGLogoImgFile + '">'
	: '>'
  )
	   + '<FORM name=ndOidForm>'
	   +   '<TR>'
+ ((g_ndLogoXpos>0)
	? '<TD><IMG src="' + g_ndImgPath + '0.gif" border=0 width="'+g_ndLogoXpos+'" height=1></TD>'
	: ''
  )
	   +	'<TD width="100%"'
			  + ((g_ndLogoYpos>=0) ? ' vAlign="top"' : ' vAlign="middle"' )
			  + ((g_ndLogoXpos>=0) ? ' align="left"' : ' align="middle"' )
			  + '">'
+ ((g_ndLogoHref != '')
	? '<A href="'+g_ndLogoHref+'"' + (g_ndLogoHrefTarget!='' ? 'target="'+g_ndLogoHrefTarget+'"' : '' ) + '>'
	: ''
  )
+ ((g_ndLogoYpos>0)
	? '<IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height="'+g_ndLogoYpos+'"><BR>'
	: ''
  )
	   +		'<IMG width='+g_ndLogoImgWidth+' height='+g_ndLogoImgHeight+' src="' + g_ndLogoImgFile + '" border=0 alt="'+g_ndLogoImgAlt+'">'
+ ((g_ndLogoHref != '')
	? '</A></TD>'
	: '</TD>'
  )
	   +	'<TD vAlign=middle align=right>'
	   +	 '<TABLE border=0 cellPadding=0 cellSpacing=0>'
	   +	   ((g_ndOnlineMibOptionalTitleHtml != '') 
				? '<TR><TD class=NDText><IMG src="' + g_ndImgPath + '0.gif" border=0 width=1 height=1></TD><TD nowrap class=NDTitle id=ndOnlineMibTitle>'+g_ndOnlineMibOptionalTitleHtml+'</TD></TR>'
				: '')
	   +	   '<TR>'
	   +		'<TD nowrap class=NDText align=right>' + nd_szName + ' :&nbsp;</TD><TD><INPUT class=NDInput maxLength=1024 size='+ ndO_nOidInputSize +' name=ndOidName></TD>'
+(ndIE
  ?''
		  + 	'<TD vAlign=top><A href="javascript:;" onClick="return parent.ndO_BtnCopyClick(ndCopyOidName,ndOidName);" onMouseOver="return parent.ndO_BtnMouseOver(ndCopyOidName,parent.nd_szCopyName);" onMouseOut="return parent.ndO_BtnMouseOut(ndCopyOidName);" onMouseDown="return parent.ndO_BtnMouseDown(ndCopyOidName);"><IMG name=ndCopyOidName src="' + g_ndImgPath + 'ClipboardCopy.gif" width=19 height=19 border=0 alt="'+nd_szAltCopy+'"></A></TD>'
  :'' 
	   +		'<TD class=NDText>&nbsp;</TD>'
 )
	   +	   '</TR>'
	   +	   '<TR>'
	   +		'<TD nowrap class=NDText align=right>' + nd_szValue + ' :&nbsp;</TD><TD><INPUT class=NDInput maxLength=2048 size='+ ndO_nOidInputSize +' name=ndOidValue></TD>'
+(ndIE
  ?''
		  + 	'<TD vAlign=top><A href="javascript:;" onClick="return parent.ndO_BtnCopyClick(ndCopyOidValue,ndOidValue);" onMouseOver="return parent.ndO_BtnMouseOver(ndCopyOidValue,parent.nd_szCopyValue);" onMouseOut="return parent.ndO_BtnMouseOut(ndCopyOidValue);" onMouseDown="return parent.ndO_BtnMouseDown(ndCopyOidValue);"><IMG name=ndCopyOidValue src="' + g_ndImgPath + 'ClipboardCopy.gif" width=19 height=19 border=0 alt="'+nd_szAltCopy+'"></A></TD>'
  :'' 
	   +		'<TD class=NDText>&nbsp;</TD>'
 )
	   +	   '</TR>'
	   +	 '</TABLE>'
	   +	'</TD>'
	   +   '</TR>'
	   + '</FORM>'
	   +'</TABLE>');
	ndDocEnd(doc);

	// --------------------
	// --- Draw Nav Bar ---
	// --------------------
	if (ndO_bDynamicFrame || ndO_bIFrame)
	{
		ndO_DrawNavBarTree_MultiTab(!ndO_bDirTree/*bMibTree*/, ndO_nNumActiveTab, true /*bAdd_onLoad*/);
	}
	else
	{
		if (ndO_bDirTree)
			ndO_DrawNavBarTree_SimpleTab(ndFrameNavBar0, 0);
		if (ndO_bMIBsTree)
			ndO_DrawNavBarTree_SimpleTab(ndFrameNavBar1, 1);
		ndO_DrawNavBarTree_SimpleTab(ndFrameNavBar2, 2);
	}

	ndO_DrawNavBarFile_FileNameTab();
	
	var a='';
	var b='';
	if (document.location.hash)
	{
		a = document.location.hash.substring(1);
		//document.location.hash = '';
		var n = a.indexOf(':');
		if (n != -1)
		{
			b = a.substring(n+1);
			a = a.substring(0, n);
		}
	}
	var nOpenItem = 0;
	if (ndO_bDirTree)
	{
		if (a != '')
		{
			var n = parseInt(a);
			var ndD = ndO_GetDirTree();
			if (!isNaN(n) && (n>0) && (n<ndD.length))
			{
				var eInfo = nd_Tree_eInfo(ndD, n);
				if (	( eInfo== 1/*INFODIR_MIB(1)*/		 )
					 || ( eInfo== 2/*INFODIR_MOD_OF_FILE(2)*/)
					 || ( eInfo== 3/*INFODIR_MOD_OF_DIR(3)*/ ) )
				{
					nOpenItem = n;
					ndO_szStartWithMibTreeItem = b;
				}
			}
		}
	}

	// ---------------------------------------
	// --- Write FrameContentFile document ---
	// ---------------------------------------
	ndO_DrawContentFile(ndO_bDirTree && !nOpenItem /*bShowSplash*/);

	// -------------------------------------
	// --- Write FramePoweredBy document ---
	// -------------------------------------
	doc = ndDocBegin(ndFramePoweredBy.document);
	ndO_WriteStylePoweredBy(doc);
	ndDocBody_WithFrameOnLoad(doc, g_ndBGColorFrameBottom);
	doc.write(
		'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0>'
	   +'<TR>'
	   +'<TD vAlign=top width=1><A href="http://www.NetDiscover.com/" target=_blank><IMG width=164 height=18 src="' + g_ndImgPath + (g_ndImgPoweredByInv ? 'PoweredByInv.gif' : 'PoweredBy.gif') + '" border=0 alt="Powered by NetDiscover Technology"></A></TD>'
	   +'<TD class=NDA align=middle>' + g_ndCopyrightHtml + '</TD>'
	   +'</TR>'
	   +'</TABLE>');
	ndDocEnd(doc);

	if (ndO_bIFrame)
	{
		// -----------------------------------
		// --- Write FrameNavTree document ---
		// -----------------------------------
		doc = ndDocBegin(ndFrameNavTree.document);
		ndDocBody(
			doc, 
			// BGCOLOR : not visible, but use bgcolor of first visible IFrame
			(ndO_nNumActiveTab == 0) 
			? g_ndBGColorFrameDirTree 
			: ((ndO_nNumActiveTab == 1) 
			  ? g_ndBGColorFrameMibsTree 
			  : g_ndBGColorFrameMibTree
			  ),
			0,
			' onLoad="top.ndOnlineMibDoc.ndO_FrameNavTree_onLoad(\''+a+'\', \''+b+'\', '+nOpenItem+')"');
		doc.write(
			 (ndO_bDirTree
			 ?'<IFRAME ' + ndFrameSrc() + 'name="ndIFrameNavTree0" id="ndIFrameNavTree0" border=0px width='+((ndO_nNumActiveTab==0) ? 100 : 0)+'% height=100% marginwidth=0 marginheight=0 hspace=0 vspace=0 frameborder=0 scrolling=auto></IFRAME>'
			 :''
			 )
			+(ndO_bMIBsTree
			 ?'<IFRAME ' + ndFrameSrc() + 'name="ndIFrameNavTree1" id="ndIFrameNavTree1" border=0px width='+((ndO_nNumActiveTab==1) ? 100 : 0)+'%	height=100% marginwidth=0 marginheight=0 hspace=0 vspace=0 frameborder=0 scrolling=auto></IFRAME>'
			 :''
			 )
			+ '<IFRAME ' + ndFrameSrc() + 'name="ndIFrameNavTree2" id="ndIFrameNavTree2" border=0px width='+((ndO_nNumActiveTab==2) ? 100 : 0)+'%	height=100% marginwidth=0 marginheight=0 hspace=0 vspace=0 frameborder=0 scrolling=auto></IFRAME>');
		ndDocEnd(doc);
	}
	else
	{
		ndOnlineMIB_onLoadFrameSet_Next(a, b, nOpenItem)
	}
}

function ndO_FrameNavTree_onLoad(a, b, nOpenItem)
{
	ndOnlineMIB_onLoadFrameSet_Next(a, b, nOpenItem);
}

function ndO_GetDocumentNavTree0() { return ndO_bIFrame ? ndWindowIFrameNavTree0.document : ndFrameNavTree0.document; }
function ndO_GetDocumentNavTree1() { return ndO_bIFrame ? ndWindowIFrameNavTree1.document : ndFrameNavTree1.document; }
function ndO_GetDocumentNavTree2() { return ndO_bIFrame ? ndWindowIFrameNavTree2.document : ndFrameNavTree2.document; }

function ndOnlineMIB_onLoadFrameSet_Next(a, b, nOpenItem)
{
	eval(ndO_MIBsTreeName + ' = null'); // Clean <- Reload
	eval(ndO_MibTreeName  + ' = null'); // Clean <- Reload

	if (ndO_bIFrame)
	{
		// [window] = ndFrameNavTree.ndIFrameNavTree0
		//	| .document 
		//	| .focus()
		//	| .print()
		//	|
		//	----[IFrame] =				  ndGetElement(ndFrameNavTree.document, 'ndIFrameNavTree0'); 
		//				   or (IE only) : ndFrameNavTree.ndIFrameNavTree0.frameElement;
		/*globale*/ ndIFrameNavTree0	   = ndGetElement(ndFrameNavTree.document, 'ndIFrameNavTree0');
		/*globale*/ ndIFrameNavTree1	   = ndGetElement(ndFrameNavTree.document, 'ndIFrameNavTree1');
		/*globale*/ ndIFrameNavTree2	   = ndGetElement(ndFrameNavTree.document, 'ndIFrameNavTree2');
		/*globale*/ ndWindowIFrameNavTree0 = ndFrameNavTree.ndIFrameNavTree0;
		/*globale*/ ndWindowIFrameNavTree1 = ndFrameNavTree.ndIFrameNavTree1;
		/*globale*/ ndWindowIFrameNavTree2 = ndFrameNavTree.ndIFrameNavTree2;
	}

	// !!! BUG Opera : dont use variable to store 'ndFrameNavTree0.document' & 'ndFrameNavTree0.document'
	// !!! -----------
	// !!!	 var doc = frame.document
	// !!!	 doc.open("text/html", "replace");
	// !!!	 ...
	// !!!	 doc.close();
	// !!!
	// !!!	->	doc != ndFrameNavTree2.document
	// 
	// !!! => use ndO_GetDocumentNavTree 1 2 3()

	if (ndO_bDirTree)
	{
		// ------------------------------
		// --- Write DirTree document ---
		// ------------------------------
		ndO_InitDocumentColorAndWaitMsg(ndO_GetDocumentNavTree0(), g_ndBGColorFrameDirTree, nd_szDownloading);
		if (!(ndO_bDynamicFrame || ndO_bIFrame))
		{
			// ------------------------------
			// --- Write MibTree document ---
			// ------------------------------
			ndO_InitDocumentColor(ndO_GetDocumentNavTree2(), g_ndBGColorFrameMibTreeEmpty);
		}
	}
	else
	{
		// INFO ndO_bOneFileOnly: true

		// ------------------------------
		// --- Write MibTree document ---
		// ------------------------------
		ndO_nLastHtmlFileSize = nd_DirTree_nHtmlFileSize(ndO_GetDirTree(), ndO_nOneFileOnlyIndex);
		ndO_MibTreeDownloadMsg(0); // use ndO_GetDocumentNavTree2()
	}

	if (ndO_bMIBsTree)
	{
		// -------------------------------
		// --- Write MIBsTree document ---
		// -------------------------------
		
		if (	g_ndOnlineMIB_AutoDownloadMIBsTree
			 || (window.location.protocol == "file:")
			 || (ndO_GetFileSize_MIBsTreeJS() < 30*1024) ) // < 30 Ko
			ndO_StartMIBsTreeDownload();
		else
			ndO_MIBsTreePreDownloadMsg();
	}

	// --- Draw Tree when onLoad all Frames
	if (ndO_bDirTree)
	{
		ndO_FrameOnLoad_szFinishEval = 
			'ndO_InitDocumentAndDrawNumTree(0, '+nOpenItem+', true /*bExpandItem*/)';
	}
	else
	{
		// INFO ndO_bOneFileOnly: true

		var line = -1;
		if (a != '')
		{
			var n = parseInt(a);
			var l = (!isNaN(n) && (n==ndO_nOneFileOnlyIndex)) ? b : a;
			if (l != '')
			{
				ndO_szStartWithMibTreeItem = l;
				var line = parseInt(l);
				if (isNaN(line))
					line = -1;
			}
		}
		ndO_FrameOnLoad_szFinishEval = 'ndC2(ndO_GetDirTree(), ndO_nOneFileOnlyIndex, ' + line + ')';
	}
	ndO_FrameOnLoad_CanCallFinish();
}

function ndO_MIBsTreePreDownloadMsg()
{
	var doc = ndDocBegin(ndO_GetDocumentNavTree1());
	ndO_WriteFrameBorderStyle(doc);
	ndDocBody_WithFrameOnLoad(doc, g_ndBGColorFrameMibsTree);
	var nFileSize_MIBsTreeJS = ndO_GetFileSize_MIBsTreeJS();
	var msg = 'MIBs Tree: <B>' + ndFileSize2String(nFileSize_MIBsTreeJS) + '</B>';
	doc.write(
		'<TABLE height="100%" width="100%" cellSpacing=0 cellPadding=0 border=0><FORM><TR>'
	   +'<TD vAlign=middle align=middle><FONT style="COLOR:'+g_ndColorMessage+'; '+g_ndStyleFontSizeMessage+'; '+g_ndStyleFontFamilyMessage+'">' + msg + '<BR><FONT style="FONT-SIZE:6px"><BR></FONT><INPUT type="BUTTON" value="'+nd_szDownload+'" onClick="top.ndOnlineMibDoc.ndO_StartMIBsTreeDownload()"></FONT></TD>'
	   +'</TR></FORM></TABLE>'
	   );
	ndDocEnd(doc);
}

function ndO_StartMIBsTreeDownload()
{
	ndO_MIBsTreeDownloadMsg(0);
}

function ndO_InitSearchResultMIBsTreeDownloadingMsg(s)
{
	if (!s)
	{
		var nFileSize_MIBsTreeJS = ndO_GetFileSize_MIBsTreeJS();
		s = ndFileSize2String(nFileSize_MIBsTreeJS)
	}
	ndO_InitSearchResultMsg(nd_szDownloadingMIBsTree + ' (' + s + ') - <B><SPAN id=ndProgressMIBsTree>'+ndO_nLastMIBsTreeProgress+'</SPAN>%</B><BR>' + nd_szPleaseWait, ndO_GetBGColorOfTree(ndO_nSeachRadioValue));
}

function ndO_InitSearchResultMibTreeDownloadingMsg(s)
{
	if (!s)
		s = ndFileSize2String(ndO_nLastHtmlFileSize)
	ndO_InitSearchResultMsg(nd_szDownloadingMibTree + ' (' + s + ') - <B><SPAN id=ndProgressMibTree>'+ndO_nLastMibTreeProgress+'</SPAN>%</B><BR>' + nd_szPleaseWait, ndO_GetBGColorOfTree(ndO_nSeachRadioValue));
}

function ndO_StoreMIBsTree(_ndMIBsTree)
{
	// --- Store Tree
	eval(ndO_MIBsTreeName + ' = _ndMIBsTree;');
}

function ndO_onLoadMIBsTreeDocument()
{
	ndO_bMIBsTreeDownloading = false;

	if (!ndO_GetMIBsTree())
	{
		var file = ndO_GetMIBsTreeDataFile();
		var msg = ndFR
				  ? 'ERREUR : Impossible de charger le fichier "' + file + '".'
				  : 'ERROR: Unable to load "' + file + '" file.';
		if (	ndO_winSearch && !ndO_winSearch.closed
			 && ndO_bFormSearch_WaitMIBsTreeDownload )
		{
			ndO_InitSearchResultMsg(msg, ndO_GetBGColorOfTree(ndO_nSeachRadioValue), g_ndColorSearchError);
			ndO_winSearch.focus();
		}
		else
			alert(msg);
		ndO_MIBsTreePreDownloadMsg();
		return;
	}

	// --- Form Search
	if (	ndO_winSearch && !ndO_winSearch.closed
		 && ndO_bFormSearch_WaitMIBsTreeDownload )
	{
		ndO_bFormSearch_WaitMIBsTreeDownload = false;
		ndO_BeginStartSearch();
	}
	// --- Show Tree
	var nOpenItem = 0;
	if (ndO_MIBsTreeDownload_nSelectedMibTreeOID)
	{
		var nItem = nMibTreeOidId2MIBsTreeOidId(ndO_GetMIBsTree(), ndO_MIBsTreeDownload_MibTree, ndO_MIBsTreeDownload_nSelectedMibTreeOID);
		if (nItem>0)
			nOpenItem = nItem;
		// --- Clear Global Var
		ndO_MIBsTreeDownload_nSelectedMibTreeOID = 0;
		ndO_MIBsTreeDownload_MibTree = null; 
	}
	// --- Show Tree
	ndO_InitDocumentAndDrawNumTree(1, nOpenItem, false /*bExpandItem*/);
}

function ndO_HideSplash()
{
	if (ndO_szLastMibPathFileName == '')
	{
		var doc = ndDocBegin(ndFrameContentFile.document);
		ndO_WriteFrameBorderStyle(doc);
		ndDocBody(doc, g_ndBGColorFrameMibFileEmpty);
		ndDocEnd(doc);
	}
}

function ndO_GetMibFileModuleNum2Index(nNumModule)
{
	var n = 0;
	for(var i=1;;i++)
	{
		var eInfo = nd_Tree_eInfo(ndO_GetMibTree(), i);
		if (eInfo == 7/*INFOMIB_MOD(7)*/)
			if (++n == nNumModule)
				break;
	}
	return i;
}

function ndPlugMibFile(_frame, _ndMib)
{
	if (ndO_bWaitPlugMibFile)
	{
		ndO_bWaitPlugMibFile = false;

		if (_ndMib != null)
			eval(ndO_MibTreeName + ' = _ndMib;');

		var nOpenItem = 0;
		var bExpandItem = false;

		if (ndO_nMibTreeShowModNum && ndO_szStartWithMibTreeItem)
		{
			nOpenItem = ndO_NameWithModNum2Indice(ndO_GetMibTree(), ndO_szStartWithMibTreeItem, ndO_nMibTreeShowModNum);
			ndO_nMibTreeShowModNum = 0; // Reset
			ndO_szStartWithMibTreeItem = ''; // Reset
		}
		else
		if (ndO_nMibTreeShowModNum)
		{
			nOpenItem = ndO_GetMibFileModuleNum2Index(ndO_nMibTreeShowModNum);
			bExpandItem = true;
			ndO_nMibTreeShowModNum = 0; // Reset
		}
		else
		if (ndO_szStartWithMibTreeItem)
		{
			var nLine = parseInt(ndO_szStartWithMibTreeItem);
			nOpenItem = (isNaN(nLine) 
							? ndName2Indice 
							: ndLine2Indice)(ndO_GetMibTree(), ndO_szStartWithMibTreeItem);
			ndO_szStartWithMibTreeItem = ''; // Reset
		}
		ndO_InitDocumentAndDrawNumTree(2, nOpenItem, bExpandItem);
	}
	else
	{
		// Reload -> Ignore
	}
}

function ndOnlineMIBCanDrawImmediately()
{
	// ndIE  : return !g_ndOnlineMIB_bDrawTreeAfterLoad
	// ndNS4 : return always true
	// other : return always false
	return (ndIE && !g_ndOnlineMIB_bDrawTreeAfterLoad) || ndNS4;
}

function ndMIBFileCanDrawImmediately()
{
	// ndIE  : return always true // else BUG (load all img - very slow)
	// ndNS4 : return always true
	// other : return always false
	return ndIE || ndNS4;
}

function nd_WriteStyleScrollBarColor(doc)
{
	if (ndUseScrollBarColor())
		doc.write('<STYLE>BODY {' + ndGetScrollBarStyle() + '}</STYLE>');
}

function ndPlugMibFileStep1(_frame, _ndMib)
{
	eval(ndO_MibTreeName + ' = _ndMib;');

	nd_WriteStyleScrollBarColor(_frame.document);
	ndO_WriteFrameBorderStyle(_frame.document);

	if (ndOnlineMIBCanDrawImmediately())
		ndPlugMibFile(_frame, null);
	else
		ndPreLoadImgsOfTree(_ndMib);
}

function ndPlugMibFileStep2(frame)
{
	if (!ndOnlineMIBCanDrawImmediately())
		ndPlugMibFile(frame, null);
}

function ndO_GetOneFileOnlyIndex(ndDir)
{
	var f = 0;
	for (var i=1;i<ndDir.length;i++)
	{
		var eInfo = nd_Tree_eInfo(ndDir, i);
		if (eInfo== 1/*INFODIR_MIB(1)*/)
		{
			if (f) 
				return 0;
			f = i;
		}
	}
	return f;
}

function ndO_FrameOnLoad_Init()
{
	ndO_FrameOnLoad_nCount = 0	+  1/* for ndO_FrameOnLoad_CanCallFinish() */;
	ndO_FrameOnLoad_szFinishEval = null;
}

function ndO_FrameOnLoad_onFinish()
{
	if (ndO_FrameOnLoad_szFinishEval)
	{
		eval(ndO_FrameOnLoad_szFinishEval);
		ndO_FrameOnLoad_szFinishEval = null;
	}
}

function ndO_FrameOnLoad_CanCallFinish()
{
	if (!--ndO_FrameOnLoad_nCount)
		ndO_FrameOnLoad_onFinish();
}

function ndO_Frame_onLoad()
{
	if (!--ndO_FrameOnLoad_nCount)
		ndO_FrameOnLoad_onFinish();
}

function ndDocBody_WithFrameOnLoad(doc, rgb, bAdd_onLoad /* = true */)
{
	if (typeof bAdd_onLoad == 'undefined')
		bAdd_onLoad = true;
	if (bAdd_onLoad)
		ndO_FrameOnLoad_nCount++;
	ndDocBody(doc, rgb, 0, bAdd_onLoad ? 'onLoad="top.ndOnlineMibDoc.ndO_Frame_onLoad()"' : '');
}

function ndO_PreLoadImgs()
{
	// --- Preload 'TabMIBTree' images
	if (ndO_bDirTree && (ndO_bDynamicFrame || ndO_bIFrame))
		ndO_imgTabMIBTree		 = ndLoadGifImg('TabMIBTree');

	// --- Preload xxxOver & xxxDown images
	ndO_imgRefreshOver			 = ndLoadGifImg('RefreshOver');
	ndO_imgRefreshDown			 = ndLoadGifImg('RefreshDown');
	ndO_imgOpenLegendOver		 = ndLoadGifImg('OpenLegendOver');
	ndO_imgOpenLegendDown		 = ndLoadGifImg('OpenLegendDown');
	ndO_imgSearchOver			 = ndLoadGifImg('SearchOver');
	ndO_imgSearchDown			 = ndLoadGifImg('SearchDown');
	ndO_imgGotoDirTreeOver		 = ndLoadGifImg('GotoDirTreeOver');
	ndO_imgGotoDirTreeDown		 = ndLoadGifImg('GotoDirTreeDown');
	ndO_imgGotoMIBsTree 		 = ndLoadGifImg('GotoMIBsTree');
	ndO_imgGotoMIBsTreeOver 	 = ndLoadGifImg('GotoMIBsTreeOver');
	ndO_imgGotoMIBsTreeDown 	 = ndLoadGifImg('GotoMIBsTreeDown');
	ndO_imgDownloadOver 		 = ndLoadGifImg('DownloadOver');
	ndO_imgDownloadDown 		 = ndLoadGifImg('DownloadDown');
	if (ndO_bDynamicFrame)
	{
		ndO_imgFrameRightOver	 = ndLoadGifImg('FrameRightOver');
		ndO_imgFrameRightDown	 = ndLoadGifImg('FrameRightDown');

		ndO_imgFrameTopOver 	 = ndLoadGifImg('FrameTopOver');
		ndO_imgFrameTopDown 	 = ndLoadGifImg('FrameTopDown');

		ndO_imgFrameLeftDown	 = ndLoadGifImg('FrameLeftDown');
		ndO_imgFrameLeftOver	 = ndLoadGifImg('FrameLeftOver');
	}
	ndO_imgPrintOver			 = ndLoadGifImg('PrintOver');
	ndO_imgPrintDown			 = ndLoadGifImg('PrintDown');
	if (ndIE)
	{
		ndO_imgClipboardCopyOver = ndLoadGifImg('ClipboardCopyOver');
		ndO_imgClipboardCopyDown = ndLoadGifImg('ClipboardCopyDown');
	}

//	ndO_imgLegend				 = ndLoadGifImg('Legend');
}

function ndOnlineMIB(ndDir)
{
	if (!ndIsOnlineMibBrowser())
	{
		alert(nd_szMsgErrorBadBrowser);
		return false;
	}

	// Init Var
	eval(ndO_DirTreeName  + ' = ndDir');

	ndO_nOneFileOnlyIndex = ndO_GetOneFileOnlyIndex(ndDir);
	ndO_bOneFileOnly	  = ndO_nOneFileOnlyIndex != 0;
	ndO_bDirTree		  =!ndO_bOneFileOnly;
	ndO_bMIBsTree		  = ndO_GetFileSize_MIBsTreeJS()!=0;
	ndO_bDynamicFrame	  = nd_bDynamicFrameSupport;			// IE only
	ndO_bIFrame 		  = !ndO_bDynamicFrame					// non IE browser
						 && nd_bDOM
						 && (ndO_bDirTree || ndO_bMIBsTree); 

	if (	ndO_bMIBsTree 
		 && !(ndO_bDynamicFrame || ndO_bIFrame) )
		ndO_bMIBsTree = false; // No MIBs Tree without (Dynamic Frame and IFrame)

	ndO_nNumActiveTab = (!ndO_bDirTree)*2 // DirTree(0) or MibTree(2)

	if (!ndIE)
	{
		// --- Remove BUG with Netscape with OnlineMib
		// --- OnlineMib - MIB File Load "/Standards/RFC (Request for Comments)/rfc1213 MIB-II.mib.html"
		// ---	-> top.ndOnlineMibDoc.ndPlugMibFileStep1(self,A)
		// ---	 -> ndPreLoadImgsOfTree(_ndMib);
		// ---	  -> ndLoadGifImg(name)
		// ---	   -> [error] File does not exist: /var/www/html/Mib2Web/Standards/RFC (Request for Comments)/img/14.gif
		// ---		  MUST BE					 : /var/www/html/Mib2Web/Standards/img/14.gif
		// ---		 => add 'root'
		if (g_ndImgPath[0]!='/')
			g_ndImgPath = ndGetPath(document.location.toString()) + g_ndImgPath;
	}
	// Preload Images
	ndO_PreLoadImgs();

	// Update : g_ndHeightFrameTop
	if (g_ndHeightFrameTop < g_ndLogoImgHeight)
		g_ndHeightFrameTop = g_ndLogoImgHeight;

	ndO_nOidInputSize = (screen.availWidth - ((g_ndLogoXpos>0) ? g_ndLogoXpos : 0) - g_ndLogoImgWidth - g_ndWidthSpaceAfterLogo - /*Text*/44 - /*Ico*/(ndIE ? 19 : 0) ) * (ndNS4 ? 171 : (ndIE ? 310 : 316)) / 1600;

	ndO_ndFrameSetHCols = 
		((ndO_bDynamicFrame || ndO_bIFrame || (!ndO_bDirTree && !ndO_bMIBsTree))
		? ( (screen.availWidth < 800)
			? (ndFR ? '58%' : '55%') // 640
			: ( (screen.availWidth < 1024)
				? (ndFR ? '47%' : '44%') // 800
				: ( (screen.availWidth < 1152)
					? '45%' // 1024
					: ( (screen.availWidth < 1280)
						? '44%' // 1152
						: '50%')))) // 1280 & 1600 
		: ( (screen.availWidth < 800)
			? '22%,22%' // 640
			: ( (screen.availWidth < 1024)
				? '20%,20%' // 800
				: ( (screen.availWidth < 1152)
					? '19%,19%' // 1024
					: ( (screen.availWidth < 1280)
						? '22%,22%' // 1152
						: '25%,25%')))) // 1280 & 1600 
		);

	top.ndOnlineMibDoc = self;

	// Write 'FRAMESET'
	ndO_WriteFrameSet(document);
	return true;
}

function ndIsOnlineMibBrowser()
{
	// !!! Opera 6.05  not supported
	// !!! Opera 7.0b1 some BUGs : 'url#label' not supported
	return	nd_bDOM
		 && (	 (ndIE	  && (ndBrowserVersion>=5))    // IE5, IE5.5 & IE6.0
			  || (ndNS	  && (ndBrowserVersion>=5))    // NS6.0, NS7.0, Mozilla, Phoenix
			  || (ndOpera && (ndBrowserVersion>=7))    // Opera 7.x
			  || ndSafari				   // Apple Safari
			);	
}

function ndIsMib2WebBrowser()
{
	return	ndIsOnlineMibBrowser();
}

function ndSelectAndFocusItemTree(objA, doc, ndTreeName, nItem)
{
	ndSelectItemTree(doc, ndTreeName, nItem);
	if (objA.tagName == 'SPAN') // => [*ABC*]
	{
		// Visible Import
		doc.location.hash = objA.id + 'A';
	}
	else
	{
		//ASSERT(objA.tagName == 'A');
		objA.focus();
	}
}

function ndSelectItemTree(_doc, _ndTreeName, _nItem)
{
	var nPrevItem = 0;
	if (eval('typeof(i_nd_iSelectItem' + _ndTreeName + ')') != 'undefined')
		nPrevItem = eval('i_nd_iSelectItem' + _ndTreeName);
	if (nPrevItem == _nItem)
		return;

	if (	ndIsOnlineMIB()
		 && (_ndTreeName == ndO_MibTreeName) )
	{
		var _ndTree = eval(_ndTreeName);
		var eInfo = nd_Tree_eInfo(_ndTree, _nItem);
		
		var nPrevSelectedMibTreeOID = ndO_nSelectedMibTreeOID;
		ndO_nSelectedMibTreeOID = (    (eInfo == 8/*INFOMIB_OBJECT(8)*/)
									|| (eInfo == 9/*INFOMIB_OBJECT_TRAP(9)*/) )
								  ? _nItem 
								  : 0;
		if (eInfo == 13/*INFOMIB_SHORTCUT_OBJECT(13)*/)
		{
			var ItemTree = nd_ItemTree(_ndTree, _nItem);
			var nItem2 = nd_ItemTree_GetShortcutVisibleObjectId(_ndTree, ItemTree);
			if (nItem2 && !nd_FA_bVisibleImport(nd_Tree_nFA(_ndTree, nItem2)))
				ndO_nSelectedMibTreeOID = nItem2;
		}

		if (	(nPrevSelectedMibTreeOID != ndO_nSelectedMibTreeOID)
			 && (	 nPrevSelectedMibTreeOID==0
				  || ndO_nSelectedMibTreeOID==0) )
		{
			// Redraw -> Enable 'GotoMIBsTree' Button
			if (ndO_bDynamicFrame || ndO_bIFrame)
			{
				if (ndO_nNumActiveTab == 2/*Tab2_MibFile*/)
					ndO_RefreshNavBarTree_MultiTab(2/*Tab2_MibFile*/);
			}
			else
				ndO_RefreshNavBarTree_SimpleTab(2/*Tab2_MibFile*/);
		}
	}

	if (!g_ndBGColorSelectItem)
		return;

	var objA;
	if (nPrevItem)
	{
		objA = ndGetA(_doc, _ndTreeName, nPrevItem);
		if (objA)
			objA.style.backgroundColor = 'transparent';
	}
	eval('i_nd_iSelectItem' + _ndTreeName + ' = _nItem;'); // Store _nItem in global var
	objA = ndGetA(_doc, _ndTreeName, _nItem);
	if (objA)
		objA.style.backgroundColor = g_ndBGColorSelectItem;
}

function ndO_ExpandItem(_doc, _ndTreeName, _nItem)
{
	var _ndTree = eval(_ndTreeName);
	var parentITEM = new Array(128); // index of open items 
	var nCountParent = ndGetParentItems(_ndTree, _nItem, parentITEM);

	// --- Display / DynamicTreeInsert Parent
	for(var n=0; n<nCountParent; n++)
	{
		var i = parentITEM[n];
		var bAlwaysOpen = nd_Tree_bAlwaysOpen(_ndTree, i);
		if (!bAlwaysOpen)
		{
			var oDIV = ndGetDIV(_doc, _ndTreeName, i);
			if (oDIV)
			{
				if (nd_bDynamicDrawTree && !oDIV.firstChild)
				{
					ndDynamicTreeInsert(_doc, oDIV, i, _ndTreeName, _nItem /*nOpenItem*/, false /*bExpandItem*/);
					ndDisplay(oDIV, true);
					break;
				}
				if (!ndIsDisplay(oDIV))
					ndDisplay(oDIV, true);
			}
		}
	}
	return ndGetA(_doc, _ndTreeName, _nItem);
}

function ndMibFileLoadProgress(nProgress)
{
	if (ndO_bWaitPlugMibFile)
		ndO_MibTreeDownloadMsg(nProgress);
}

function ndMibsTreeLoadProgress(nProgress)
{
	ndO_MIBsTreeDownloadMsg(nProgress);
}

function ndR(_ndA, _ndD) // onClick Shortcut
{
	if (typeof _ndD == 'undefined')
		_ndD = document;
	_ndA = _ndA.id.split(':');
	var _ndTreeName = _ndA[1];
	if (eval('typeof(i_ndCallBack' + _ndTreeName + ')') == 'undefined')
		return nd_onClickContinue(); // Reload -> Ignore

	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[2]);

	if (ndIsOnlineMIBsTree(eval(_ndTreeName)))
		ndO_MIBsTreeCloseMenu(true/*bForceClose*/); // Hide Menu

	ndO_UpdateOidForm(_ndTree, i);

	var objA = ndO_ExpandItem(_ndD, _ndTreeName, i);
	// --- 'Mod' Select & Focus 
	ndSelectAndFocusItemTree(objA, _ndD, _ndTreeName, i);
	return nd_onClickContinue();
}


function ndS(_ndA, _ndD) // onMouseOver Shortcut
{
	if (typeof _ndD == 'undefined')
		_ndD = document;
	_ndA = _ndA.id.split(':');
	var _ndTreeName = _ndA[1];
//	var _ndTree = eval(_ndTreeName);
	var i = parseInt(_ndA[2]);

	status = nd_szGoto;
	return nd_onMouseOverRet();
}

function ndT(_ndA, _ndD) // onMouseOut Shortcut
{
	status = defaultStatus;
	return nd_onMouseOutRet();
}

var g_ndLoad = true;

