/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Vector;

public class SearchAppletFrame
extends Frame {
    SearchApplet search;
    TextField entryField;
    List foundList;
    TextField status;
    Checkbox caseSensitiveCheckbox;
    boolean caseSensitiveDefault;
    static final int RETURN_KEY = 10;

    public SearchAppletFrame(String string, SearchApplet searchApplet, boolean bl) {
        super(string);
        this.search = searchApplet;
        this.caseSensitiveDefault = bl;
        this.makeGUI();
    }

    public void setFoundStatus(String string) {
        ((TextComponent)this.status).setText(string);
    }

    void makeGUI() {
        this.entryField = new TextField(40);
        Button button = new Button(this.search.getMessage("searchappleframe.list_topics.button"));
        Button button2 = new Button(this.search.getMessage("searchappletframe.cancel.button"));
        Button button3 = new Button(this.search.getMessage("searchappletframe.display.button"));
        this.foundList = new List(15, false);
        this.caseSensitiveCheckbox = new Checkbox(this.search.getMessage("searchappletframe.case_sensitive.checkbox"));
        this.caseSensitiveCheckbox.setState(this.caseSensitiveDefault);
        this.status = new TextField(40);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(4, 1));
        new Panel();
        panel.add(new Label(this.search.getMessage("searchappletframe.type_in_the_keyword_to_find.label")));
        panel.add(this.entryField);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(1, 2));
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(0));
        panel3.add(this.caseSensitiveCheckbox);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(2));
        panel4.add(button);
        panel2.add(panel3);
        panel2.add(panel4);
        panel.add(panel2);
        panel.add(new Label(this.search.getMessage("searchappletframe.select_topic_to_display.label")));
        this.add("North", panel);
        this.add("Center", this.foundList);
        this.foundList.setBackground(Color.white);
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(2, 1));
        panel5.add(this.status);
        Panel panel6 = new Panel();
        panel6.setLayout(new FlowLayout(2));
        panel6.add(button2);
        panel6.add(button3);
        panel5.add(panel6);
        this.add("South", panel5);
        ((Component)this.status).setBackground(Color.lightGray);
        this.status.setEditable(false);
        ((Component)this).setBackground(Color.lightGray);
        this.pack();
    }

    public void addFoundItem(String string) {
        this.foundList.addItem(string);
    }

    public int getFoundItemListCount() {
        return this.foundList.countItems();
    }

    public void updateList(String[] stringArray) {
        this.clearList();
        int n = 0;
        while (n < stringArray.length) {
            this.foundList.addItem(stringArray[n]);
            ++n;
        }
    }

    public void clearList() {
        this.foundList.clear();
    }

    public String getCommand() {
        if (!this.entryField.getText().equals("")) {
            if (!this.caseSensitiveCheckbox.getState()) {
                return this.entryField.getText().toLowerCase();
            }
            return this.entryField.getText();
        }
        return "";
    }

    String[] parseInput() {
        String string = this.getCommand();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (!string.equals("")) {
            if (string.indexOf("+") == -1) {
                vector.addElement(string);
            } else {
                int n2 = 0;
                n2 = 0;
                while (n2 < string.length()) {
                    if (string.charAt(n2) == '+') {
                        vector.addElement(string.substring(n, n2).trim());
                        if (n2 + 1 < string.length()) {
                            n = n2 + 1;
                        }
                    }
                    ++n2;
                }
                if (n < n2) {
                    vector.addElement(string.substring(n, n2).trim());
                }
            }
        }
        if (vector.size() > 0) {
            String[] stringArray = new String[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                stringArray[n3] = ((String)vector.elementAt(n3)).trim();
                ++n3;
            }
            return stringArray;
        }
        return null;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1001: {
                if (event.target instanceof Button) {
                    String string = (String)event.arg;
                    if (string.equals(this.search.getMessage("searchappletframe.cancel.button"))) {
                        if (this.search.searchInProgress()) {
                            this.search.stopSearch();
                        }
                        ((Component)this).setVisible(false);
                        return true;
                    }
                    if (string.equals(this.search.getMessage("searchappleframe.list_topics.button"))) {
                        String[] stringArray = this.parseInput();
                        if (stringArray != null) {
                            boolean bl = this.caseSensitiveCheckbox.getState();
                            this.search.search(stringArray, this.getCommand(), bl);
                        }
                        return true;
                    }
                    if (!string.equals(this.search.getMessage("searchappletframe.display.button"))) break;
                    int n = this.foundList.getSelectedIndex();
                    if (n != -1) {
                        this.search.displayDocument(n);
                    }
                    return true;
                }
                if (event.target instanceof Checkbox) {
                    return true;
                }
                if (event.target.equals(this.foundList)) {
                    String cfr_ignored_0 = (String)event.arg;
                    this.search.displayDocument(this.foundList.getSelectedIndex());
                    break;
                }
            }
            case 401: {
                if (event.key == 10) {
                    String[] stringArray;
                    if (event.target.equals(this.entryField) && (stringArray = this.parseInput()) != null) {
                        this.search.search(stringArray, this.entryField.getText(), this.caseSensitiveCheckbox.getState());
                    }
                    return true;
                }
                return false;
            }
            case 201: {
                if (this.search.searchInProgress()) {
                    this.search.stopSearch();
                }
                ((Component)this).setVisible(false);
                return true;
            }
        }
        return false;
    }
}

