/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class SearchApplet
extends Applet {
    SearchAppletFrame searchFrame;
    String targetFrame = "right_frame";
    String base;
    String[] searchFiles;
    String encoding;
    String filesToBeSearched = "searchFiles.html";
    Vector foundDocumentVector;
    Vector foundVector;
    ResourceBundle bundle;
    boolean parseTags = true;
    boolean useFileIO = false;
    boolean caseSensitiveDefault;
    boolean displayBooleanSearchCount;
    boolean debug;
    boolean searchInProgress;
    HTMLReader reader;
    Search searcher;
    String targetEncoding;
    String fileBase;
    String searchDirectory = "";
    int currentHtmlLength;

    private void initSearchFileList() {
        this.targetEncoding = this.encoding;
        this.setLayout(new BorderLayout());
        this.loadParameters();
        this.base = String.valueOf(this.getCodeBase()) + this.searchDirectory;
        this.loadSearchFilesList();
        if (this.searchFiles.length == 0) {
            if (this.debug) {
                System.out.println("Unable to load files to search list using URL");
                System.out.println(String.valueOf(this.base) + this.filesToBeSearched);
                System.out.println("Orginal URL = " + this.currentHtmlLength);
                try {
                    URL uRL = new URL(String.valueOf(this.base) + this.filesToBeSearched);
                    URLConnection uRLConnection = uRL.openConnection();
                    System.out.println("URL length=" + uRLConnection.getContentLength());
                }
                catch (Exception exception) {}
            }
            try {
                this.useFileIO = true;
                if (this.fileBase == null) {
                    this.fileBase = this.convertURLToLocal(this.base);
                }
            }
            catch (Exception exception) {
                System.out.println("Error gaining File Read access: " + exception);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            this.loadSearchFilesList();
        }
        if (this.debug) {
            System.out.println("html directory=" + this.fileBase);
            this.listFileNames();
        }
    }

    public void init() {
        this.initSearchFileList();
        this.setBackground(Color.white);
        Button button = new Button(this.getMessage("searchapplet.launch.button"));
        this.add("Center", button);
    }

    int convertToChar(String string) {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    String convertURLToLocal(String string) {
        String string2 = "";
        try {
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != '%') {
                    string2 = String.valueOf(string2) + string.charAt(n);
                } else if (n + 2 < string.length()) {
                    char c = (char)this.convertToChar(string.substring(n + 1, n + 3));
                    if (c != '\uffffffff') {
                        string2 = String.valueOf(string2) + c;
                        n += 2;
                    } else {
                        string2 = String.valueOf(string2) + string.charAt(n);
                    }
                }
                ++n;
            }
            if (string2.startsWith("file:") && string2.length() >= 5) {
                string2 = string2.substring(5, string2.length());
            }
            if (string2.charAt(2) == '|') {
                string2 = string2.substring(1);
                string2 = ":" + string2.substring(2);
                string2 = string2.replace('/', '\\');
                if (this.debug) {
                    System.out.println("->" + string2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error resolving URL path: " + string);
        }
        return string2;
    }

    String getMacPath(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '%') {
                string2 = String.valueOf(string2) + string.charAt(n);
            } else if (n + 2 < string.length() && string.charAt(n + 1) == '2' && string.charAt(n + 2) == '0') {
                string2 = String.valueOf(string2) + " ";
                n += 2;
            }
            ++n;
        }
        if (string2.startsWith("file:") && string2.length() >= 5) {
            string2 = string2.substring(5, string2.length());
        }
        if (string2.charAt(2) == '|') {
            string2 = string2.substring(1);
            string2 = ":" + string2.substring(2);
            string2 = string2.replace('/', '\\');
            if (this.debug) {
                System.out.println("->" + string2);
            }
        }
        return string2;
    }

    public String getMessage(String string) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("SearchAppletProperties");
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println("Could not load messages file: " + string);
            }
        }
        String string2 = null;
        try {
            if (this.bundle == null) {
                return "";
            }
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
        string2 = this.bundle.getString(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String getFormattedMessage(String string, String[] stringArray) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("SearchAppletProperties");
            }
            catch (MissingResourceException missingResourceException) {
                this.showStatus("Unable to load resource files");
                System.out.println("Could not load messages file: " + string);
            }
        }
        String string2 = null;
        try {
            if (this.bundle == null) {
                return "";
            }
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
        string2 = this.bundle.getString(string);
        if (string2 == null) {
            return "";
        }
        try {
            return MessageFormat.format(string2, stringArray);
        }
        catch (Exception exception) {
            System.out.println("Error formatting message: " + string);
            return "";
        }
    }

    public Vector getFoundVector() {
        return this.foundVector;
    }

    public void addFoundItem(String string, String string2, String string3) {
        this.searcher.addFoundItem(string, string2, string3);
    }

    public void setSearchInProgress(boolean bl) {
        this.searchInProgress = bl;
    }

    public boolean searchInProgress() {
        return this.searchInProgress;
    }

    public void stopSearch() {
        if (this.searchInProgress) {
            this.searchFrame.setFoundStatus("");
            this.searchFrame.clearList();
            this.searcher.stopSearch();
            this.setSearchInProgress(false);
        }
    }

    void loadParameters() {
        String string = this.getParameter("search_directory");
        if (string != null) {
            this.searchDirectory = string;
            string = null;
        }
        if ((string = this.getParameter("html_encoding")) != null) {
            this.encoding = string;
            string = null;
        }
        if ((string = this.getParameter("html_files_to_be_searched")) != null) {
            this.filesToBeSearched = string;
            string = null;
        }
        if ((string = this.getParameter("target_frame")) != null) {
            this.targetFrame = string;
            string = null;
        }
        if ((string = this.getParameter("parse_tags")) != null) {
            this.parseTags = !string.toLowerCase().equals("false");
            string = null;
        }
        if ((string = this.getParameter("case_sensitive")) != null) {
            this.caseSensitiveDefault = string.toLowerCase().equals("true");
            string = null;
        }
        if ((string = this.getParameter("display_boolean_search_count")) != null) {
            this.displayBooleanSearchCount = string.toLowerCase().equals("true");
            string = null;
        }
        if ((string = this.getParameter("applet_directory")) != null) {
            this.fileBase = String.valueOf(string) + this.searchDirectory;
            string = null;
        }
        if ((string = this.getParameter("debug")) != null) {
            this.debug = string.toLowerCase().equals("true");
            string = null;
        }
    }

    void loadSearchFilesList() {
        this.searchFiles = this.getFileNames();
    }

    public boolean action(Event event, Object object) {
        switch (event.id) {
            case 1001: {
                String string;
                if (!(event.target instanceof Button)) break;
                if (this.searchFrame != null) {
                    this.searchFrame.toFront();
                }
                if (!(string = (String)object).equals(this.getMessage("searchapplet.launch.button"))) break;
                if (this.searchFrame == null) {
                    this.searchFrame = new SearchAppletFrame(this.getMessage("searchappletframe.search.frame_title"), this, this.caseSensitiveDefault);
                }
                ((Component)this.searchFrame).setVisible(true);
                return true;
            }
        }
        return false;
    }

    public synchronized void showSearch() {
        if (this.searchFrame != null) {
            this.searchFrame.toFront();
        }
        if (this.searchFrame == null) {
            this.searchFrame = new SearchAppletFrame(this.getMessage("searchappletframe.search.frame_title"), this, this.caseSensitiveDefault);
        }
        ((Component)this.searchFrame).setVisible(true);
    }

    public synchronized void hideSearch() {
        if (this.searchFrame != null) {
            ((Component)this.searchFrame).setVisible(false);
        }
    }

    public void showStatus(String string) {
        this.getAppletContext().showStatus(string);
    }

    public SearchAppletFrame getSearchFrame() {
        return this.searchFrame;
    }

    public void search(String[] stringArray, String string, boolean bl) {
        this.searchInProgress = true;
        SearchApplet searchApplet = this;
        synchronized (searchApplet) {
            if (this.searchFiles.length == 0) {
                this.useFileIO = false;
                this.initSearchFileList();
            }
        }
        this.searchFrame.clearList();
        this.foundVector = new Vector();
        this.foundDocumentVector = new Vector();
        this.searcher = new Search(this.foundDocumentVector, this.foundVector, stringArray, this.searchFiles, string, bl, this.parseTags, this.displayBooleanSearchCount, this);
        this.searcher.start();
    }

    public void displayDocument(int n) {
        this.displayDocument(((FoundDocument)this.foundDocumentVector.elementAt(n)).getDocument());
    }

    public void displayDocument(String string) {
        URL uRL = null;
        try {
            uRL = new URL(String.valueOf(this.base) + string);
        }
        catch (MalformedURLException malformedURLException) {}
        if (uRL != null) {
            this.getAppletContext().showDocument(uRL, this.targetFrame);
            return;
        }
        System.out.println(String.valueOf(this.base) + string + " to display.");
    }

    public String loadDocument(String string) {
        if (this.useFileIO) {
            return this.getFile(string);
        }
        URL uRL = null;
        try {
            uRL = new URL(String.valueOf(this.base) + string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error loading " + string);
        }
        if (uRL != null) {
            try {
                if (this.reader == null) {
                    this.reader = this.encoding != null ? new HTMLReader(this.encoding) : new HTMLReader();
                }
                return this.reader.getContent(uRL);
            }
            catch (Exception exception) {
                System.out.println("Error Loading " + string);
                exception.printStackTrace();
                return null;
            }
        }
        System.out.println(String.valueOf(this.base) + string);
        return null;
    }

    String[] getFileNames() {
        String[] stringArray = null;
        String string = this.loadDocument(this.filesToBeSearched);
        if (this.debug) {
            System.out.println(String.valueOf(string) + "<-");
        }
        if (string != null) {
            StringTokenizer stringTokenizer = null;
            stringTokenizer = this.useFileIO ? new StringTokenizer(string) : new StringTokenizer(string, "\n");
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken().trim();
                ++n2;
            }
        } else {
            System.out.println(String.valueOf(this.filesToBeSearched) + " contains no data");
        }
        return stringArray;
    }

    void listFileNames() {
        System.out.println(String.valueOf(this.searchFiles.length) + " files loaded.");
        int n = 0;
        while (n < this.searchFiles.length) {
            System.out.println(this.searchFiles[n]);
            ++n;
        }
    }

    String getFile(String string) {
        String string2 = "";
        try {
            PrivilegeManager.enablePrivilege((String)"UniversalFileRead");
            File file = new File(String.valueOf(this.fileBase) + string);
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            InputStreamReader inputStreamReader = null;
            inputStreamReader = this.targetEncoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, this.targetEncoding);
            char[] cArray = new char[n];
            inputStreamReader.read(cArray, 0, n);
            string2 = new String(cArray);
            fileInputStream.close();
            inputStreamReader.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("File encoding error. Check file encoding paramater.");
        }
        catch (Exception exception) {
            System.out.println("Error reading file: " + exception);
            exception.printStackTrace();
        }
        return string2;
    }
}

