//
// interactions.js
// Interaction subroutines for web based training exercises
// Jim Foltz & Leila Toplic, copyright 1999 Netscape Communications
//
//

// variables used

// for matching
var blankName="";
var matchWidth=0;
var boardx=0;
var boardy=0;
var boardsrc="";
var numSelection=0;
var fb = new Array();
var who = new Array();
var choicex = new Array();
var choicey = new Array();
var targetx = new Array();
var targety = new Array();
var choicesrcNormal = new Array();
var choicesrcHighlighted = new Array();
var choice=0;
var offsetx=0;
var offsety=0;
var congrats="";
var sorry="";

// for flow
effectWidth=150;
effects = new Array();
numChoices=0;
cWidth=150;
correct=new Array();
correctEffect=new Array();
fb2 = new Array();
fPrompt = new Array();
sPrompt = new Array();
choice=0;
curStep=0;
info=new Array();
answer=new Array();
numSections=0;
curSection=0;
numAnswers=new Array();
sectionChoices=new Array();

// double up the arrays for multiple sections
for (i=0;i<10;i++) {
	correct[i]=new Array(10);
	correctEffect[i]=new Array(10);
	fb2[i]=new Array(10);
	fPrompt[i]=new Array(10);
	sPrompt[i]=new Array(10);
	info[i]=new Array(10);
}



// routines for matching


// function for setting offset values of all match components - lets you move whole thing easily
function matchOffset(x,y) {
offsetx=x;
offsety=y;
}


// function to set width and name of blank targets
function setBlank(name, w) {
blankName = name;
matchWidth = w;
}

// function defining the x,y coordinates of the background image for doing the matches on
function matchBoard(x,y,src) {
boardx=x+offsetx;
boardy=y+offsety;
boardsrc=src;
}

// function for setting a new selection
//  	choice at initial x,y coordinates choiceX, choiceY
//  	choice source srcNormal, with highlighted version srcHighlighted
// 	target location (where it belongs) at x,y coordinates targetX, targetY
//    If it is evaluated and the wrong answer, feedback to give user wrongFeedback
function newSelection(choiceX, choiceY, srcNormal, srcHighlighted, targetX, targetY) {
// increment number of selections
	numSelection++;
// set the locations of the choices
	choicex[numSelection]=choiceX+offsetx;
	choicey[numSelection]=choiceY+offsety;
// set the sources for this selection
	choicesrcNormal[numSelection]= srcNormal;
	choicesrcHighlighted[numSelection]= srcHighlighted;
// set the target where it belongs
	targetx[numSelection]=targetX+offsetx;
	targety[numSelection]=targetY+offsety;
// set the feedback for this choice
	
}

// function to place a Done/evaluate button at location x,y with button text evalText
function evalButton(x,y,evalText) {
	document.write('<layer name="done" Left='+(x+offsetx)+' top='+(y+offsety)+'><form><input type="button" value="'+evalText+'" onClick="chkanswer();"></form></layer>');
}

// function specifying the feedback window at x,y and width w with initial source src
function feedbackWindow(x,y,w,src) {
	document.write('<layer name="prompt" left='+(x+offsetx)+' top='+(y+offsety)+' width='+w+' src="'+src+'"></layer>');
}




// function specifying the congratulations 100% correct message msg
function congratsMessage(msg) {
congrats=msg;
}

// function specifying the sorry some wrong message msg before feedbacks are given
function sorryMessage(msg) {
sorry=msg;
}


// function to draw to board and all the choices and targets
function drawBoard() {

// draw the base board
document.write('<Layer name="board" WIDTH=800 LEFT=' + boardx + ' TOP=' + boardy + ' src="'+boardsrc+'"></layer>');

// create the target layers and who is in them (no one = 0)
for (i=1;i<numSelection+1;i++) {
document.write('<Layer width='+matchWidth+' name="target'+i+'" LEFT=' + targetx[i]+ ' TOP=' + targety[i] + ' src="'+blankName+'" onMouseOver="choosing('+i+');"></layer>');
who[i]=0;
}

// draw the choices and who is in them (so that at end who[i]=i for all targets)
for (i=1;i<numSelection+1;i++) {
document.write('<Layer width='+matchWidth+' name="choice'+i+'" LEFT=' + choicex[i] + ' TOP=' + choicey[i] + ' src="'+choicesrcNormal[i]+'" onMouseOver="choosing('+(i+numSelection)+');"></></layer>');
who[i+numSelection]=i;
}
// initialize the board to accept clicks
resetcapture();
}

var selected = 0;
var t = 100;
var ct = 200;



function choose(n) {
//alert("layer " + n + " has person " + who[n] + " and the selected layer is " + selected);

// if something selected already
   if (selected > 0) 
   {

//    if they clicked on a blank
      if (who[n] == 0) 
      {

//      fill the blank with an unhighlighted version of who is selected
        unselect(n, who[selected]);

//      put a blank where selected was
   	  setTimeout(blank, t, selected);

//      update the new position 
        who[n] = who[selected];

//      blank out who is at selected
        who[selected] = 0;

//      Set no one selected
        selected = 0;

      } 
      else 
      {

//       else if they clicked on the same selection, do nothing
         if (n == selected) 
         {
         }

//       else they clicked on another selection
         else 
         {

//         highlight the new selection
           select(n, who[n]);

//         unhighlight the previous selection
           setTimeout(unselect, t, selected, who[selected]);

//         update which layer is selected
           selected = n;       
         }
      }
   } 

// else nothing selected
   else 
   {

//    if a non blank
      if (who[n] > 0) 
      {
//       highlight the new selection
         select(n, who[n]);

//       update the selected variable
         selected = n;
      }
   }
}
         



//Figures out where the click occured
function clck(e) {
choose(choice);
}






function chkanswer() {
var n;
var x;
var mv=0;
//if something selected, unselect it
if (selected > 0) {unselect(selected, who[selected]);}

//Loop through all answer choices and move manually - calling choose(), the prefered way, updates layers too fast for DOM on Win

// condition that it is the right answer


for (x=1;x<numSelection+1;x++) {

//    if filled with an answer
	if (who[x] > 0) {

//		if the incorrect answer
if (who[x]!=x) {

//			move back to the first blank on the selection list	
			n = 0;

//			find the first blank
			for (y=numSelection+1;n==0;y++) {
				if (who[y]==0){n=y;}
			}
//  			Move the selection there with time delays and update variables

//			Select it
			setTimeout(select, ct*mv, x, who[x]); selected = x;
			mv++;

//			Move it to blank space
			setTimeout(unselect, ct*mv, n, who[selected]);
			mv++;

//			Put a blank where it was
			setTimeout(blank, ct*mv, selected);who[n] = who[selected];who[selected] = 0;selected = 0;
			mv++;


			}
		}
	}
// Type out the feedback
feedback();
}

// Feedback on wrong answers
function feedback() {

var fbstr="\n";
var wrong=0;
// go through all items on the selection list
 for (x=numSelection+1; x < numSelection*2+1; x++) {

// if a selection contains a character, get feedback on that character
	if (who[x] > 0) {
		wrong++;
	//	fbstr = fbstr + wrong + ") " + fb[who[x]] + "<br><br>";
 		}

	}
// Check if all correct, else set the remediation

if (wrong == 0) {
	fbstr=congrats ;
} else {
	fbstr = sorry + fbstr;
}

// write it out to the prompt layer
document.prompt.document.write(fbstr);
document.prompt.document.close();
}

function resetcapture() {
for (i=1;i<numSelection*2+1;i++) {
	document.layers[i].captureEvents(Event.MOUSEDOWN);
	document.layers[i].onMouseDown=clck; 
}
}


// function to put highlighted w into layer n
function select(n, w) {
  layerupdate(n, choicesrcHighlighted[w]);
}

// function to put unhighlighted w into layer n
function unselect(n, w) {
   layerupdate(n, choicesrcNormal[w]);
}


// function to update layer n with source s
function layerupdate(n, s) {
	eval('document.layers['+n+'].src = s');
}

// function to put a blank in layer n
function blank(n) {
layerupdate(n, blankName);
}

// routines for flow

// function defining a subset choice (src) at x,y that is correct answer for stepanswerOrder
//  with the nickname of the gif effect to show when selected correctly correctEffectName
//  with initial prompt firstPrompt and followup prompt secondPrompt
//  with feedback wrongFeedback when it is not selected in the correct order
function newChoice(x,y,src,answerOrder,correctEffectName,infoStr, firstPrompt,secondPrompt,wrongFeedback) {
// increment number of choices
numChoices++;
// increment number of correct answers
numAnswers[numSections]++;
// set the correct answer
correct[numSections][answerOrder]=numChoices;
// set the correct effectname
correctEffect[numSections][answerOrder]=correctEffectName;
// set the prompts
info[numSections][answerOrder]=infoStr;
fPrompt[numSections][answerOrder]=firstPrompt;
sPrompt[numSections][answerOrder]=secondPrompt;
// set the wrong feedback
fb2[numSections][numChoices]=wrongFeedback;
// write out the choicehidden 
document.write('<LAYER NAME="choice'+numSections+numChoices+'" LEFT='+x+' TOP='+y+' WIDTH='+cWidth+' src="'+src+'" VISIBILITY="hide" onMouseOver="choosing('+numChoices+');"></LAYER>');
}

// function defining a subset choice (src) at x,y the is a distractor/wrong answer,
//   with feedback wrongFeedback given when selected.
function newDistractor(x,y,src,wrongFeedback) {
// increment number of choices
numChoices++;
// set the wrong feedback
fb2[numSections][numChoices]=wrongFeedback;
// write out the choicehidden 
document.write('<LAYER NAME="choice'+numSections+numChoices+'" LEFT='+x+' TOP='+y+' WIDTH='+cWidth+' src="'+src+'" VISIBILITY="hide" onMouseOver="choosing('+numChoices+');"></LAYER>');
}


// function that defines the maximum width of the choices
function effectsWidth(w) {
effectWidth=w;
}

function choiceWidth(w) {
cWidth=w;
}

function showEffect(name) {
	str = 'document.layers["' +name+ '"]';
	eval(str+'.visibility="show"');
// reanimate a gif if necessary
	eval(str+'.src='+str+'.src');
}


// function that defines a nickname (name) for an animated gif (src) located at x,y 
//   that will be activated later 
function newEffect(name,x,y,src) {
	// display the effect, hide it
	document.write('<LAYER NAME="'+name+'" LEFT='+x+' TOP='+y+' WIDTH='+effectWidth+' src="'+src+'" visibility="hide"></LAYER>');
}


// function to make an information box
function infoBox(x,y,w) {
document.write('<LAYER NAME="infobox" LEFT='+x+' TOP='+y+' WIDTH='+w+'></LAYER>');
}



// function to make a prompt box
// function to make an information box
function promptBox(x,y,w) {
document.write('<LAYER NAME="prompt" LEFT='+x+' TOP='+y+' WIDTH='+w+'></LAYER>');
}

// function to begin the interaction
function beginInteraction() {
// finish off any unsaved variables
// save the previous section choices
sectionChoices[numSections]=numChoices;
// set the Current step and choices
curSection=1;
curStep=1;
//show the 1st set of choices and activate
beginSection();
}

function beginSection() {
// display and activate choices
for (i=1;i<sectionChoices[curSection]+1;i++) {
	str="choice"+curSection+i;
	eval('document.layers["'+str+'"].visibility="show"');
	eval('document.layers["'+str+'"].captureEvents(Event.MOUSEDOWN)');
	eval('document.layers["'+str+'"].onMouseDown=evaluate'); 
	}
// set up the initial infobox and first prompt
setupStep(1);
curStep=1;
}

function setupStep(n) {
// setup the info box
dispInfo(info[curSection][n]);
// show the first prompt
dispPrompt(fPrompt[curSection][n]);
}


function dispInfo(str) {
document.infobox.document.write("<b>"+str+"</b>");
document.infobox.document.close();
}

function dispPrompt(str) {
document.prompt.document.write("<b>"+str+"</b>");
document.prompt.document.close();
}

function evaluate(e) {
//alert("choice "+choice+", correct is "+correct[curStep]);
// if this selection was correct
if (choice==correct[curSection][curStep]) {
//     setup the next step if there is one
	if (curStep<numAnswers[curSection]){setupStep(curStep+1);}
//     then lets show the effect
	showEffect(correctEffect[curSection][curStep]);
//     hide this choice
	str="choice"+curSection+choice;
	eval('document.layers["'+str+'"].visibility="hide"');
//    increment curStep
	curStep++;
//     see if we need to move onto the next section
	if (curStep>numAnswers[curSection]) {nextSection();}
	} else {
// otherwise a wrong selection
//   Put in feedback in infobox
	dispInfo(fb2[curSection][choice]);
//   Put up second prompt
	dispPrompt(sPrompt[curSection][curStep]);
	}
return false;
}

function nextSection() {
// hide previous section choices
for (i=1;i<sectionChoices[curSection]+1;i++) {
	str="choice"+curSection+i;
	eval('document.layers["'+str+'"].visibility="hide"');
	}
// show answers for the previous section
str="answer"+curSection;
eval('document.layers["'+str+'"].visibility="show"');
// setup increment for a new section
curSection++;
curStep=1;
// display current section choices
setTimeout(beginSection,100);
}

function newSection(src,x,y) {
// save the previous section choices
sectionChoices[numSections]=numChoices;
// incremnet number of sections
numSections++;
// zero out number of choice
numChoices=0;
// reset the number of answers
numAnswers[numSections]=0;
// write out and hide the answer layer
document.write('<LAYER NAME="answer'+numSections+'" LEFT='+x+' TOP='+y+' WIDTH='+cWidth+' src="'+src+'" VISIBILITY="hide"></LAYER>');
}

// joint functions

// function to keep track of what is about to be chosen
function choosing(n){
choice=n;
}

