#!/bin/sh -x 
#
# THIS SOFTWARE IS PROVIDED BY THE SUN MICROSYSTEMS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL SUN MICROSYSTEMS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

# Developed by Michael Haines - Sun Microsystems Ltd
# 


PATH=/sbin:/bin:/usr/bin:$PATH
export PATH

# takes two arguments, a PROMPT and the default value (Y | N).
# Returns 0 if the user specified "Y", nonzero otherwise.
yes_or_no()
{
        OK=n
        while [ "$OK" = n ]
        do
                echo >/dev/tty
                echo "$1 [$2]: \c" >/dev/tty
                read ans
                if [ "$ans" = "" ]
                then
                        ans=$2
                else
                        if [ "$2" = "y" -o "$2" = "n" ]
                        then
                                case $ans in
                                "Y"|"y"|"YES"|"yes"|"Yes") ans=y;;
                                "N"|"n"|"NO"|"no"|"No") ans=n;;
                                esac
                        fi
                fi
                if [ "$ans" = y -o "$ans" = n ]
                then
                        OK=y
                else
                        echo $ans >/dev/tty
                        echo "Is this correct (y/n) [y] \c" >/dev/tty
                        read OK
                        case $OK in
                        ""|"Y"|"y"|"YES"|"yes"|"Yes") OK=y;;
                        "N"|"n"|"NO"|"no"|"No") OK=n;;
                        esac
                fi
        done
        echo $ans
}


echo ""
echo CURRDATE=`date`
echo HOST=`hostname`
echo DOMAIN=`domainname`

echo ""
echo "i-Planet Directory Server for Solaris rc* configuration program"

OK=`yes_or_no "Would you like to continue with installation?" "y"` 
if [ "$OK" != "y" ] 
then
  exit 0
fi

BASEDIR=/usr/netscape/server4
SLAPDINSTANCENAME=`/usr/bin/hostname`

echo ""
echo "Specify the server root location. This is where the server programs, 
the Administration Server, and the server configuration files are located."
echo ""
echo "To accept the default shown in brackets, press the Enter key."

BASEDIR=`yes_or_no "Installation Location is" $BASEDIR`

echo""
echo "Creating iPlanet rc startup scripts..."

echo "Setting permisssions on iPlanet rc startup scripts..."

echo "Creating link to the iPlanet rc startup scripts..."
echo""

#
# installation is now complete 
# set the rc scripts to start slapd and admin server automatically at boot time
#

cat <<% > /etc/init.d/ns-slapd
#!/sbin/sh
#
#
# Copyright(c) 1997, by Sun Microsystems, Inc.
# All rights reserved.
#
#ident  "@(#)ns-slapd       1.2    19/10/2000 SMI"  
#
# This script will automatically start/stop/restart the 
# i-Planet Directory Server 4.12
#
SLAPDDIR=$BASEDIR/slapd-$SLAPDINSTANCENAME
#BASEDIR=$SLAPDDIR$BASEDIR

case "\$1" in
'start')
	rm -f \$SLAPDDIR/logs/pid
	\$SLAPDDIR/start-slapd > /dev/null 2>&1
	\$BASEDIR/start-admin > /dev/null 2>&1
	echo "Directory services started."
	;;

'stop')
	\$SLAPDDIR/stop-slapd
	\$BASEDIR/stop-admin
	echo "ns-slapd stopped"
	;;

'restart')
	\$SLAPDDIR/restart-slapd
	\$BASEDIR/restart-admin
	echo "ns-slapd restarted"
	;;

*)
        echo "Usage: /etc/init.d/ns-slapd { start | stop | restart }"
        exit 1
        ;;
esac
exit 0

%
chmod +x /etc/init.d/ns-slapd
chgrp sys /etc/init.d/ns-slapd
ln /etc/init.d/ns-slapd /etc/rc2.d/S72ns-slapd
ln /etc/init.d/ns-slapd /etc/rc0.d/K72ns-slapd
