CONNECT TO SAMPLE;

CREATE TABLE "LINEITEM"  (
		  "L_ORDERKEY" INTEGER NOT NULL , 
		  "L_PARTKEY" INTEGER NOT NULL , 
		  "L_SUPPKEY" INTEGER NOT NULL , 
		  "L_LINENUMBER" INTEGER NOT NULL , 
		  "L_QUANTITY" DOUBLE NOT NULL , 
		  "L_EXTENDEDPRICE" DOUBLE NOT NULL , 
		  "L_DISCOUNT" DOUBLE NOT NULL , 
		  "L_TAX" DOUBLE NOT NULL , 
		  "L_RETURNFLAG" CHAR(1) NOT NULL , 
		  "L_LINESTATUS" CHAR(1) NOT NULL ,
		  "L_SHIPDATE" DATE NOT NULL , 
		  "L_COMMITDATE" DATE NOT NULL , 
		  "L_RECEIPTDATE" DATE NOT NULL , 
		  "L_SHIPINSTRUCT" CHAR(25) NOT NULL , 
		  "L_SHIPMODE" CHAR(10) NOT NULL , 
		  "L_COMMENT" VARCHAR(44) NOT NULL )   
		 IN "USERSPACE1" ; 

CREATE UNIQUE INDEX "L_OK_LN" ON "LINEITEM" 
		("L_ORDERKEY" ASC,
		 "L_LINENUMBER" ASC)
		PCTFREE 3 DISALLOW REVERSE SCANS;

CREATE INDEX "L_PK_SK" ON "LINEITEM" 
		("L_PARTKEY" ASC,
		 "L_SUPPKEY" ASC)
		PCTFREE 3 DISALLOW REVERSE SCANS;

IMPORT FROM "Lineitem.ixf" OF IXF 
	COMMITCOUNT 100 
	MESSAGES "/stmm_scripts/import.msg" 
	INSERT INTO LINEITEM;

COMMIT WORK;

CONNECT RESET;

