/*
 *  remove_msg.c - Part of AFD, an automatic file distribution program.
 *  Copyright (c) 1998 - 2006 Deutscher Wetterdienst (DWD),
 *                            Holger Kiehl <Holger.Kiehl@dwd.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "afddefs.h"

DESCR__S_M3
/*
 ** NAME
 **   remove_msg - removes a message from the internal queue of the FD
 **
 ** SYNOPSIS
 **   void remove_msg(int qb_pos)
 **
 ** DESCRIPTION
 **
 ** RETURN VALUES
 **   None.
 **
 ** AUTHOR
 **   H.Kiehl
 **
 ** HISTORY
 **   27.07.1998 H.Kiehl Created
 **   11.08.2000 H.Kiehl Support for retrieving files.
 **   29.09.2006 H.Kiehl Added error_counter handling for FRA.
 **
 */
DESCR__E_M3

#include <string.h>
#include <time.h>
#include "fddefs.h"

/* External global variables. */
extern int                        fra_fd,
                                  *no_msg_queued;
extern struct queue_buf           *qb;
extern struct fileretrieve_status *fra;


/*############################ remove_msg() #############################*/
void
remove_msg(int qb_pos)
{
   if (qb[qb_pos].msg_name[0] == '\0')
   {
      /* Dequeue in FRA. */
      fra[qb[qb_pos].pos].queued = NO;

      if (fra[qb[qb_pos].pos].error_counter > 0)
      {
         lock_region_w(fra_fd,
#ifdef LOCK_DEBUG
                       (char *)&fra[qb[qb_pos].pos].error_counter - (char *)fra, __FILE__, __LINE__);
#else
                       (char *)&fra[qb[qb_pos].pos].error_counter - (char *)fra);
#endif
         fra[qb[qb_pos].pos].error_counter = 0;
         if (fra[qb[qb_pos].pos].dir_flag & DIR_ERROR_SET)
         {
            fra[qb[qb_pos].pos].dir_flag ^= DIR_ERROR_SET;
            SET_DIR_STATUS(fra[qb[qb_pos].pos].dir_flag,
                           fra[qb[qb_pos].pos].dir_status);
         }
         unlock_region(fra_fd,
#ifdef LOCK_DEBUG
                       (char *)&fra[qb[qb_pos].pos].error_counter - (char *)fra, __FILE__, __LINE__);
#else
                       (char *)&fra[qb[qb_pos].pos].error_counter - (char *)fra);
#endif
      }

      /* Calculate the next scan time. */
      if (fra[qb[qb_pos].pos].time_option == YES)
      {
         fra[qb[qb_pos].pos].next_check_time = calc_next_time(&fra[qb[qb_pos].pos].te, time(NULL));
      }
   }
   if (qb_pos != (*no_msg_queued - 1))
   {
      size_t move_size;

      move_size = (*no_msg_queued - 1 - qb_pos) * sizeof(struct queue_buf);
      (void)memmove(&qb[qb_pos], &qb[qb_pos + 1], move_size);
   }
   (*no_msg_queued)--;

   return;
}
