/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.utauthd.WatchIOException;
import auth.utauthd.WatchIOListener;
import java.io.FileDescriptor;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.net.Socket;

public class WatchIORequest
implements Comparable {
    public short mask;
    public WatchIOListener listener;
    private boolean autoRemove;
    public Object arg;
    protected boolean busy = false;
    private FileDescriptor fdObj = null;
    private int fd = -1;
    private long expiryTime = 0L;
    private long timeout = 0L;
    private long unique;
    private static long counter = 0L;
    private static Object lock = new Object();

    private WatchIORequest() {
    }

    public WatchIORequest(Object object, short s, WatchIOListener watchIOListener, boolean bl, Object object2) throws IllegalArgumentException {
        this.fd = -1;
        Object object3 = lock;
        synchronized (object3) {
            this.unique = ++counter;
        }
        try {
            this.fdObj = this.getFileDescriptor(object);
            if (this.fdObj != null) {
                this.fd = this.getFd(this.fdObj);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.toString());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(noSuchFieldException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException.toString());
        }
        if (this.fd == -1) {
            this.fdObj = null;
            throw new IllegalArgumentException("Illegal file object");
        }
        this.mask = (short)(s & 0xFFFFFFC7);
        this.listener = watchIOListener;
        this.autoRemove = bl;
        this.arg = object2;
        this.timeout = -1L;
    }

    public int compareTo(Object object) {
        WatchIORequest watchIORequest = (WatchIORequest)object;
        if (this == watchIORequest) {
            return 0;
        }
        if (this.expiryTime > watchIORequest.expiryTime) {
            return 1;
        }
        if (this.expiryTime < watchIORequest.expiryTime) {
            return -1;
        }
        return this.unique > watchIORequest.unique ? 1 : -1;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    protected long getExpiryTime() {
        return this.expiryTime;
    }

    public int getFd() {
        return this.fd;
    }

    private int getFd(FileDescriptor fileDescriptor) throws NoSuchFieldException, IllegalAccessException {
        if (!fileDescriptor.valid()) {
            return -1;
        }
        Class<?> clazz = fileDescriptor.getClass();
        Field field = clazz.getDeclaredField("fd");
        ((AccessibleObject)field).setAccessible(true);
        int n = (Integer)field.get(fileDescriptor);
        return n;
    }

    public FileDescriptor getFdObj() {
        return this.fdObj;
    }

    private FileDescriptor getFileDescriptor(Object object) throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        FileDescriptor fileDescriptor;
        if (object instanceof Socket || object instanceof ServerSocket) {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField("impl");
            ((AccessibleObject)field).setAccessible(true);
            Object object2 = field.get(object);
            clazz = field.getType();
            field = clazz.getDeclaredField("fd");
            ((AccessibleObject)field).setAccessible(true);
            fileDescriptor = (FileDescriptor)field.get(object2);
        } else if (object instanceof FileDescriptor) {
            fileDescriptor = (FileDescriptor)object;
        } else {
            throw new IllegalArgumentException("Illegal Object type.");
        }
        return fileDescriptor;
    }

    public long getTimeout() {
        return this.timeout;
    }

    protected boolean isActiveAlarm() {
        return this.expiryTime > 0L;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public boolean isExpired(long l) {
        return this.expiryTime != 0L && l >= this.expiryTime;
    }

    protected boolean resetExpiryTime() {
        return this.resetExpiryTime(System.currentTimeMillis());
    }

    protected boolean resetExpiryTime(long l) {
        if (this.timeout <= 0L) {
            this.expiryTime = 0L;
            return false;
        }
        this.expiryTime = l + this.timeout;
        return true;
    }

    public void setTimeout(int n) throws WatchIOException {
        if (this.busy) {
            throw new WatchIOException("busy");
        }
        this.timeout = n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("WatchIORequest[fd=(" + this.fd + ")");
        if (this.fdObj == null) {
            stringWriter.write("null");
        } else {
            stringWriter.write("fd:" + this.fdObj);
        }
        stringWriter.write(", expiry=" + this.expiryTime + ":" + this.unique);
        stringWriter.write(", mask=0x" + Integer.toHexString(0xFFFF & this.mask));
        stringWriter.write(", listener=" + this.listener);
        stringWriter.write(", autoRemove=" + this.autoRemove);
        stringWriter.write(", arg=" + this.arg + "]");
        return stringWriter.getBuffer().toString();
    }
}

