/*
 * Decompiled with CFR 0.152.
 */
package auth.module.TerminalId;

import auth.module.TerminalId.TerminalIdClient;
import auth.sdk.AccessControl;
import auth.sdk.Authentication;
import auth.sdk.AuthenticationClient;
import auth.sdk.Log;
import auth.sdk.ParseOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class TerminalId
implements Authentication {
    private String instanceName;
    private static String version = new String("@(#) TerminalId.java 1.13@(#)");
    private static String name = new String("TerminalId");
    private Hashtable terminals = new Hashtable();
    private Hashtable defaultEntry = null;
    private String sessionType = null;

    private TerminalId() {
        this.instanceName = "--BOGUS--";
        Log.unexpectedError((String)"class TerminalId: BOGUS constructor called");
    }

    private TerminalId(String instanceName, String arg) {
        this.instanceName = instanceName;
        boolean specifiedAccept = false;
        String configFileName = null;
        ParseOptions options = new ParseOptions(arg, "c:s:");
        Enumeration e = options.keys();
        while (e.hasMoreElements()) {
            Character flag = (Character)e.nextElement();
            Object value = options.getValue(flag);
            switch (flag.charValue()) {
                case 'c': {
                    configFileName = (String)value;
                    break;
                }
                case 's': {
                    this.sessionType = (String)value;
                    Log.debug((String)("TerminalId:: parse: " + this.sessionType));
                    break;
                }
                default: {
                    TerminalId.usage(String.valueOf(instanceName) + ": invalid option: '" + flag + "'");
                    break;
                }
            }
        }
        if (configFileName == null) {
            TerminalId.usage(String.valueOf(instanceName) + ": " + "no configuration file specified");
        }
        if (!this.loadConfigFile(configFileName)) {
            Log.configError((String)("TerminalId: invalid configuration file \"" + configFileName + "\""));
            System.exit(1);
        }
        Log.debug((String)("TerminalId: terminals=" + this.terminals));
    }

    private boolean checkTermConfig(Hashtable term) {
        int errors = 0;
        String id = (String)term.get("terminalId");
        if (id == null) {
            Log.configError((String)"TerminalId: missing \"id = name\" parameter");
            return false;
        }
        boolean valid = false;
        Enumeration tp = term.keys();
        while (tp.hasMoreElements()) {
            String key = (String)tp.nextElement();
            String value = (String)term.get(key);
            if (key.equals("terminalId") || key.equals("session")) continue;
            if (key.equals("claim") || key.equals("allow") || key.equals("annotateTokens")) {
                if (value.equals("true") || value.equals("false")) continue;
                ++errors;
                Log.configError((String)"TerminalId: invalid claim parameter");
                continue;
            }
            Log.configError((String)("TerminalId: invalid terminal property: " + key + "=" + value));
            ++errors;
        }
        return errors == 0;
    }

    public static Authentication getAuthenticationObject(String instanceName, String opt) {
        return new TerminalId(instanceName, opt);
    }

    public String getName() {
        return new String(this.instanceName);
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public String getTermProp(String terminalId, String key) {
        String value = null;
        Hashtable props = (Hashtable)this.terminals.get(terminalId);
        if (props != null) {
            value = (String)props.get(key);
            if (value != null) {
                return value;
            }
            props = (Hashtable)this.terminals.get("default");
            if (props == null) {
                Log.unexpectedError((String)"TerminalId: getTermProp(default) returns null");
                return null;
            }
            return (String)props.get(key);
        }
        props = (Hashtable)this.terminals.get("unspecified");
        if (props == null) {
            Log.unexpectedError((String)"TerminalId: getTermProp(unspecified) returns null");
            return null;
        }
        return (String)props.get(key);
    }

    public String getVersion() {
        if (version.equals("%A%")) {
            version = "Development";
        }
        return version;
    }

    public AuthenticationClient isMyTokenType(Hashtable attrib, AccessControl access) {
        String terminalId = (String)attrib.get("sn");
        if (terminalId == null) {
            return null;
        }
        Hashtable terminalInfo = (Hashtable)this.terminals.get(terminalId);
        if (terminalInfo == null) {
            return null;
        }
        String claim = this.getTermProp(terminalId, "claim");
        if (claim == null || !claim.equals("true")) {
            return null;
        }
        String sessionType = this.getTermProp(terminalId, "session");
        if (sessionType == null) {
            sessionType = "default";
        }
        String lname = String.valueOf(this.instanceName.substring(0, this.instanceName.indexOf("."))) + ".xx" + "." + terminalId;
        TerminalIdClient client = new TerminalIdClient(access, this, "pseudo." + terminalId, lname, terminalId);
        if (client == null) {
            return null;
        }
        Log.debug((String)(String.valueOf(this.instanceName) + ": claim " + terminalId));
        return client;
    }

    private boolean loadConfigFile(String filename) {
        File config = new File(filename);
        BufferedReader in = null;
        if (!config.canRead()) {
            return false;
        }
        try {
            in = new BufferedReader(new FileReader(config));
        }
        catch (Exception e) {
            Log.configError((String)("TerminalId.loadConfigFile: " + e + ": " + filename));
            System.exit(1);
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String terminalId;
                line.trim();
                if (line.length() == 0 || line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, " ");
                String word = st.nextToken();
                word.trim();
                Hashtable<String, String> term = null;
                if (word.equals("begin")) {
                    term = this.parse(in);
                } else if (word.startsWith("terminalId")) {
                    term = new Hashtable<String, String>();
                    int i = word.indexOf(46);
                    String tid = line.substring(i + 1);
                    tid.trim();
                    term.put("terminalId", tid);
                } else {
                    Log.configError((String)("TerminalId: invalid word: \"" + word + "\""));
                }
                if (term == null || !this.checkTermConfig(term)) {
                    System.exit(1);
                }
                if (this.terminals.get(terminalId = (String)term.get("terminalId")) != null) {
                    Log.configError((String)("TerminalId: duplicate configuration entry: " + terminalId));
                    System.exit(1);
                }
                this.terminals.put(terminalId, term);
            }
            Hashtable<String, String> dterm = (Hashtable<String, String>)this.terminals.get("default");
            if (dterm == null) {
                dterm = new Hashtable<String, String>();
            }
            if (dterm.get("terminalId") == null) {
                dterm.put("terminalId", "default");
            }
            if (dterm.get("claim") == null) {
                dterm.put("claim", "true");
            }
            if (dterm.get("allow") == null) {
                dterm.put("allow", "true");
            }
            if (dterm.get("session") == null) {
                dterm.put("session", "default");
            }
            if (dterm.get("annotateTokens") == null) {
                dterm.put("annotateTokens", "true");
            }
            this.terminals.put("default", dterm);
            Hashtable<String, String> uterm = (Hashtable<String, String>)this.terminals.get("unspecified");
            if (uterm == null) {
                uterm = new Hashtable<String, String>();
            }
            if (uterm.get("terminalId") == null) {
                uterm.put("terminalId", "unspecified");
            }
            if (uterm.get("claim") == null) {
                uterm.put("claim", "false");
            }
            if (uterm.get("allow") == null) {
                uterm.put("allow", "true");
            }
            if (uterm.get("session") == null) {
                uterm.put("session", "default");
            }
            if (dterm.get("annotateTokens") == null) {
                dterm.put("annotateTokens", "true");
            }
            this.terminals.put("unspecified", uterm);
        }
        catch (Exception e) {
            Log.unexpectedError((String)("TerminalId.loadConfigFile: " + e));
        }
        return true;
    }

    private Hashtable parse(BufferedReader in) {
        Hashtable<String, String> param = new Hashtable<String, String>(3);
        while (true) {
            String line;
            try {
                line = in.readLine();
            }
            catch (Exception exception) {
                return null;
            }
            line.trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (line.equals("end")) break;
            int i = line.indexOf(61);
            if (i <= 0) {
                Log.unexpectedError((String)"TerminalId.parse: invalid parameter");
                return null;
            }
            String key = line;
            key = line.substring(0, i);
            key.trim();
            String value = line.substring(i + 1);
            value.trim();
            param.put(key, value);
            Log.debug((String)("TerminalId.parse: " + key + "=" + value));
        }
        return param;
    }

    private static void usage(String message) {
        Log.configError((String)message);
        Log.configError((String)"TerminalId: usage:  [-s sessionType] -c configFile");
        System.exit(1);
    }
}

